/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.http.impl.cookie;

import org.graylog.shaded.elasticsearch7.org.apache.http.annotation.Contract;
import org.graylog.shaded.elasticsearch7.org.apache.http.annotation.ThreadingBehavior;
import org.graylog.shaded.elasticsearch7.org.apache.http.cookie.ClientCookie;
import org.graylog.shaded.elasticsearch7.org.apache.http.cookie.CommonCookieAttributeHandler;
import org.graylog.shaded.elasticsearch7.org.apache.http.cookie.Cookie;
import org.graylog.shaded.elasticsearch7.org.apache.http.cookie.CookieOrigin;
import org.graylog.shaded.elasticsearch7.org.apache.http.cookie.CookieRestrictionViolationException;
import org.graylog.shaded.elasticsearch7.org.apache.http.cookie.MalformedCookieException;
import org.graylog.shaded.elasticsearch7.org.apache.http.cookie.SetCookie;
import org.graylog.shaded.elasticsearch7.org.apache.http.cookie.SetCookie2;
import org.graylog.shaded.elasticsearch7.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2965VersionAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int version = -1;
        try {
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            version = -1;
        }
        if (version < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        cookie.setVersion(version);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

