// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.12.3
// source: google/cloud/texttospeech/v1beta1/cloud_tts.proto

package texttospeech

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Gender of the voice as described in
// [SSML voice element](https://www.w3.org/TR/speech-synthesis11/#edef_voice).
type SsmlVoiceGender int32

const (
	// An unspecified gender.
	// In VoiceSelectionParams, this means that the client doesn't care which
	// gender the selected voice will have. In the Voice field of
	// ListVoicesResponse, this may mean that the voice doesn't fit any of the
	// other categories in this enum, or that the gender of the voice isn't known.
	SsmlVoiceGender_SSML_VOICE_GENDER_UNSPECIFIED SsmlVoiceGender = 0
	// A male voice.
	SsmlVoiceGender_MALE SsmlVoiceGender = 1
	// A female voice.
	SsmlVoiceGender_FEMALE SsmlVoiceGender = 2
	// A gender-neutral voice. This voice is not yet supported.
	SsmlVoiceGender_NEUTRAL SsmlVoiceGender = 3
)

// Enum value maps for SsmlVoiceGender.
var (
	SsmlVoiceGender_name = map[int32]string{
		0: "SSML_VOICE_GENDER_UNSPECIFIED",
		1: "MALE",
		2: "FEMALE",
		3: "NEUTRAL",
	}
	SsmlVoiceGender_value = map[string]int32{
		"SSML_VOICE_GENDER_UNSPECIFIED": 0,
		"MALE":                          1,
		"FEMALE":                        2,
		"NEUTRAL":                       3,
	}
)

func (x SsmlVoiceGender) Enum() *SsmlVoiceGender {
	p := new(SsmlVoiceGender)
	*p = x
	return p
}

func (x SsmlVoiceGender) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SsmlVoiceGender) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_enumTypes[0].Descriptor()
}

func (SsmlVoiceGender) Type() protoreflect.EnumType {
	return &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_enumTypes[0]
}

func (x SsmlVoiceGender) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SsmlVoiceGender.Descriptor instead.
func (SsmlVoiceGender) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDescGZIP(), []int{0}
}

// Configuration to set up audio encoder. The encoding determines the output
// audio format that we'd like.
type AudioEncoding int32

const (
	// Not specified. Will return result [google.rpc.Code.INVALID_ARGUMENT][].
	AudioEncoding_AUDIO_ENCODING_UNSPECIFIED AudioEncoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	// Audio content returned as LINEAR16 also contains a WAV header.
	AudioEncoding_LINEAR16 AudioEncoding = 1
	// MP3 audio at 32kbps.
	AudioEncoding_MP3 AudioEncoding = 2
	// MP3 at 64kbps.
	AudioEncoding_MP3_64_KBPS AudioEncoding = 4
	// Opus encoded audio wrapped in an ogg container. The result will be a
	// file which can be played natively on Android, and in browsers (at least
	// Chrome and Firefox). The quality of the encoding is considerably higher
	// than MP3 while using approximately the same bitrate.
	AudioEncoding_OGG_OPUS AudioEncoding = 3
	// 8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
	// Audio content returned as MULAW also contains a WAV header.
	AudioEncoding_MULAW AudioEncoding = 5
)

// Enum value maps for AudioEncoding.
var (
	AudioEncoding_name = map[int32]string{
		0: "AUDIO_ENCODING_UNSPECIFIED",
		1: "LINEAR16",
		2: "MP3",
		4: "MP3_64_KBPS",
		3: "OGG_OPUS",
		5: "MULAW",
	}
	AudioEncoding_value = map[string]int32{
		"AUDIO_ENCODING_UNSPECIFIED": 0,
		"LINEAR16":                   1,
		"MP3":                        2,
		"MP3_64_KBPS":                4,
		"OGG_OPUS":                   3,
		"MULAW":                      5,
	}
)

func (x AudioEncoding) Enum() *AudioEncoding {
	p := new(AudioEncoding)
	*p = x
	return p
}

func (x AudioEncoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AudioEncoding) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_enumTypes[1].Descriptor()
}

func (AudioEncoding) Type() protoreflect.EnumType {
	return &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_enumTypes[1]
}

func (x AudioEncoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AudioEncoding.Descriptor instead.
func (AudioEncoding) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDescGZIP(), []int{1}
}

// The type of timepoint information that is returned in the response.
type SynthesizeSpeechRequest_TimepointType int32

const (
	// Not specified. No timepoint information will be returned.
	SynthesizeSpeechRequest_TIMEPOINT_TYPE_UNSPECIFIED SynthesizeSpeechRequest_TimepointType = 0
	// Timepoint information of `<mark>` tags in SSML input will be returned.
	SynthesizeSpeechRequest_SSML_MARK SynthesizeSpeechRequest_TimepointType = 1
)

// Enum value maps for SynthesizeSpeechRequest_TimepointType.
var (
	SynthesizeSpeechRequest_TimepointType_name = map[int32]string{
		0: "TIMEPOINT_TYPE_UNSPECIFIED",
		1: "SSML_MARK",
	}
	SynthesizeSpeechRequest_TimepointType_value = map[string]int32{
		"TIMEPOINT_TYPE_UNSPECIFIED": 0,
		"SSML_MARK":                  1,
	}
)

func (x SynthesizeSpeechRequest_TimepointType) Enum() *SynthesizeSpeechRequest_TimepointType {
	p := new(SynthesizeSpeechRequest_TimepointType)
	*p = x
	return p
}

func (x SynthesizeSpeechRequest_TimepointType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SynthesizeSpeechRequest_TimepointType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_enumTypes[2].Descriptor()
}

func (SynthesizeSpeechRequest_TimepointType) Type() protoreflect.EnumType {
	return &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_enumTypes[2]
}

func (x SynthesizeSpeechRequest_TimepointType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SynthesizeSpeechRequest_TimepointType.Descriptor instead.
func (SynthesizeSpeechRequest_TimepointType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDescGZIP(), []int{3, 0}
}

// The top-level message sent by the client for the `ListVoices` method.
type ListVoicesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Recommended.
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. If
	// specified, the ListVoices call will only return voices that can be used to
	// synthesize this language_code. E.g. when specifying "en-NZ", you will get
	// supported "en-\*" voices; when specifying "no", you will get supported
	// "no-\*" (Norwegian) and "nb-\*" (Norwegian Bokmal) voices; specifying "zh"
	// will also get supported "cmn-\*" voices; specifying "zh-hk" will also get
	// supported "yue-\*" voices.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *ListVoicesRequest) Reset() {
	*x = ListVoicesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVoicesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVoicesRequest) ProtoMessage() {}

func (x *ListVoicesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVoicesRequest.ProtoReflect.Descriptor instead.
func (*ListVoicesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDescGZIP(), []int{0}
}

func (x *ListVoicesRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// The message returned to the client by the `ListVoices` method.
type ListVoicesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of voices.
	Voices []*Voice `protobuf:"bytes,1,rep,name=voices,proto3" json:"voices,omitempty"`
}

func (x *ListVoicesResponse) Reset() {
	*x = ListVoicesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVoicesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVoicesResponse) ProtoMessage() {}

func (x *ListVoicesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVoicesResponse.ProtoReflect.Descriptor instead.
func (*ListVoicesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDescGZIP(), []int{1}
}

func (x *ListVoicesResponse) GetVoices() []*Voice {
	if x != nil {
		return x.Voices
	}
	return nil
}

// Description of a voice supported by the TTS service.
type Voice struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The languages that this voice supports, expressed as
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tags (e.g.
	// "en-US", "es-419", "cmn-tw").
	LanguageCodes []string `protobuf:"bytes,1,rep,name=language_codes,json=languageCodes,proto3" json:"language_codes,omitempty"`
	// The name of this voice.  Each distinct voice has a unique name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The gender of this voice.
	SsmlGender SsmlVoiceGender `protobuf:"varint,3,opt,name=ssml_gender,json=ssmlGender,proto3,enum=google.cloud.texttospeech.v1beta1.SsmlVoiceGender" json:"ssml_gender,omitempty"`
	// The natural sample rate (in hertz) for this voice.
	NaturalSampleRateHertz int32 `protobuf:"varint,4,opt,name=natural_sample_rate_hertz,json=naturalSampleRateHertz,proto3" json:"natural_sample_rate_hertz,omitempty"`
}

func (x *Voice) Reset() {
	*x = Voice{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Voice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Voice) ProtoMessage() {}

func (x *Voice) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Voice.ProtoReflect.Descriptor instead.
func (*Voice) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDescGZIP(), []int{2}
}

func (x *Voice) GetLanguageCodes() []string {
	if x != nil {
		return x.LanguageCodes
	}
	return nil
}

func (x *Voice) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Voice) GetSsmlGender() SsmlVoiceGender {
	if x != nil {
		return x.SsmlGender
	}
	return SsmlVoiceGender_SSML_VOICE_GENDER_UNSPECIFIED
}

func (x *Voice) GetNaturalSampleRateHertz() int32 {
	if x != nil {
		return x.NaturalSampleRateHertz
	}
	return 0
}

// The top-level message sent by the client for the `SynthesizeSpeech` method.
type SynthesizeSpeechRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Synthesizer requires either plain text or SSML as input.
	Input *SynthesisInput `protobuf:"bytes,1,opt,name=input,proto3" json:"input,omitempty"`
	// Required. The desired voice of the synthesized audio.
	Voice *VoiceSelectionParams `protobuf:"bytes,2,opt,name=voice,proto3" json:"voice,omitempty"`
	// Required. The configuration of the synthesized audio.
	AudioConfig *AudioConfig `protobuf:"bytes,3,opt,name=audio_config,json=audioConfig,proto3" json:"audio_config,omitempty"`
	// Whether and what timepoints should be returned in the response.
	EnableTimePointing []SynthesizeSpeechRequest_TimepointType `protobuf:"varint,4,rep,packed,name=enable_time_pointing,json=enableTimePointing,proto3,enum=google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest_TimepointType" json:"enable_time_pointing,omitempty"`
}

func (x *SynthesizeSpeechRequest) Reset() {
	*x = SynthesizeSpeechRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SynthesizeSpeechRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SynthesizeSpeechRequest) ProtoMessage() {}

func (x *SynthesizeSpeechRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SynthesizeSpeechRequest.ProtoReflect.Descriptor instead.
func (*SynthesizeSpeechRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDescGZIP(), []int{3}
}

func (x *SynthesizeSpeechRequest) GetInput() *SynthesisInput {
	if x != nil {
		return x.Input
	}
	return nil
}

func (x *SynthesizeSpeechRequest) GetVoice() *VoiceSelectionParams {
	if x != nil {
		return x.Voice
	}
	return nil
}

func (x *SynthesizeSpeechRequest) GetAudioConfig() *AudioConfig {
	if x != nil {
		return x.AudioConfig
	}
	return nil
}

func (x *SynthesizeSpeechRequest) GetEnableTimePointing() []SynthesizeSpeechRequest_TimepointType {
	if x != nil {
		return x.EnableTimePointing
	}
	return nil
}

// Contains text input to be synthesized. Either `text` or `ssml` must be
// supplied. Supplying both or neither returns
// [google.rpc.Code.INVALID_ARGUMENT][]. The input size is limited to 5000
// characters.
type SynthesisInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The input source, which is either plain text or SSML.
	//
	// Types that are assignable to InputSource:
	//	*SynthesisInput_Text
	//	*SynthesisInput_Ssml
	InputSource isSynthesisInput_InputSource `protobuf_oneof:"input_source"`
}

func (x *SynthesisInput) Reset() {
	*x = SynthesisInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SynthesisInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SynthesisInput) ProtoMessage() {}

func (x *SynthesisInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SynthesisInput.ProtoReflect.Descriptor instead.
func (*SynthesisInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDescGZIP(), []int{4}
}

func (m *SynthesisInput) GetInputSource() isSynthesisInput_InputSource {
	if m != nil {
		return m.InputSource
	}
	return nil
}

func (x *SynthesisInput) GetText() string {
	if x, ok := x.GetInputSource().(*SynthesisInput_Text); ok {
		return x.Text
	}
	return ""
}

func (x *SynthesisInput) GetSsml() string {
	if x, ok := x.GetInputSource().(*SynthesisInput_Ssml); ok {
		return x.Ssml
	}
	return ""
}

type isSynthesisInput_InputSource interface {
	isSynthesisInput_InputSource()
}

type SynthesisInput_Text struct {
	// The raw text to be synthesized.
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

type SynthesisInput_Ssml struct {
	// The SSML document to be synthesized. The SSML document must be valid
	// and well-formed. Otherwise the RPC will fail and return
	// [google.rpc.Code.INVALID_ARGUMENT][]. For more information, see
	// [SSML](https://cloud.google.com/text-to-speech/docs/ssml).
	Ssml string `protobuf:"bytes,2,opt,name=ssml,proto3,oneof"`
}

func (*SynthesisInput_Text) isSynthesisInput_InputSource() {}

func (*SynthesisInput_Ssml) isSynthesisInput_InputSource() {}

// Description of which voice to use for a synthesis request.
type VoiceSelectionParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The language (and potentially also the region) of the voice expressed as a
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag, e.g.
	// "en-US". This should not include a script tag (e.g. use
	// "cmn-cn" rather than "cmn-Hant-cn"), because the script will be inferred
	// from the input provided in the SynthesisInput.  The TTS service
	// will use this parameter to help choose an appropriate voice.  Note that
	// the TTS service may choose a voice with a slightly different language code
	// than the one selected; it may substitute a different region
	// (e.g. using en-US rather than en-CA if there isn't a Canadian voice
	// available), or even a different language, e.g. using "nb" (Norwegian
	// Bokmal) instead of "no" (Norwegian)".
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The name of the voice. If not set, the service will choose a
	// voice based on the other parameters such as language_code and gender.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The preferred gender of the voice. If not set, the service will
	// choose a voice based on the other parameters such as language_code and
	// name. Note that this is only a preference, not requirement; if a
	// voice of the appropriate gender is not available, the synthesizer should
	// substitute a voice with a different gender rather than failing the request.
	SsmlGender SsmlVoiceGender `protobuf:"varint,3,opt,name=ssml_gender,json=ssmlGender,proto3,enum=google.cloud.texttospeech.v1beta1.SsmlVoiceGender" json:"ssml_gender,omitempty"`
}

func (x *VoiceSelectionParams) Reset() {
	*x = VoiceSelectionParams{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VoiceSelectionParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VoiceSelectionParams) ProtoMessage() {}

func (x *VoiceSelectionParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VoiceSelectionParams.ProtoReflect.Descriptor instead.
func (*VoiceSelectionParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDescGZIP(), []int{5}
}

func (x *VoiceSelectionParams) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *VoiceSelectionParams) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VoiceSelectionParams) GetSsmlGender() SsmlVoiceGender {
	if x != nil {
		return x.SsmlGender
	}
	return SsmlVoiceGender_SSML_VOICE_GENDER_UNSPECIFIED
}

// Description of audio data to be synthesized.
type AudioConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The format of the audio byte stream.
	AudioEncoding AudioEncoding `protobuf:"varint,1,opt,name=audio_encoding,json=audioEncoding,proto3,enum=google.cloud.texttospeech.v1beta1.AudioEncoding" json:"audio_encoding,omitempty"`
	// Optional. Input only. Speaking rate/speed, in the range [0.25, 4.0]. 1.0 is
	// the normal native speed supported by the specific voice. 2.0 is twice as
	// fast, and 0.5 is half as fast. If unset(0.0), defaults to the native 1.0
	// speed. Any other values < 0.25 or > 4.0 will return an error.
	SpeakingRate float64 `protobuf:"fixed64,2,opt,name=speaking_rate,json=speakingRate,proto3" json:"speaking_rate,omitempty"`
	// Optional. Input only. Speaking pitch, in the range [-20.0, 20.0]. 20 means
	// increase 20 semitones from the original pitch. -20 means decrease 20
	// semitones from the original pitch.
	Pitch float64 `protobuf:"fixed64,3,opt,name=pitch,proto3" json:"pitch,omitempty"`
	// Optional. Input only. Volume gain (in dB) of the normal native volume
	// supported by the specific voice, in the range [-96.0, 16.0]. If unset, or
	// set to a value of 0.0 (dB), will play at normal native signal amplitude. A
	// value of -6.0 (dB) will play at approximately half the amplitude of the
	// normal native signal amplitude. A value of +6.0 (dB) will play at
	// approximately twice the amplitude of the normal native signal amplitude.
	// Strongly recommend not to exceed +10 (dB) as there's usually no effective
	// increase in loudness for any value greater than that.
	VolumeGainDb float64 `protobuf:"fixed64,4,opt,name=volume_gain_db,json=volumeGainDb,proto3" json:"volume_gain_db,omitempty"`
	// Optional. The synthesis sample rate (in hertz) for this audio. When this is
	// specified in SynthesizeSpeechRequest, if this is different from the voice's
	// natural sample rate, then the synthesizer will honor this request by
	// converting to the desired sample rate (which might result in worse audio
	// quality), unless the specified sample rate is not supported for the
	// encoding chosen, in which case it will fail the request and return
	// [google.rpc.Code.INVALID_ARGUMENT][].
	SampleRateHertz int32 `protobuf:"varint,5,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	// Optional. Input only. An identifier which selects 'audio effects' profiles
	// that are applied on (post synthesized) text to speech. Effects are applied
	// on top of each other in the order they are given. See
	// [audio
	// profiles](https://cloud.google.com/text-to-speech/docs/audio-profiles) for
	// current supported profile ids.
	EffectsProfileId []string `protobuf:"bytes,6,rep,name=effects_profile_id,json=effectsProfileId,proto3" json:"effects_profile_id,omitempty"`
}

func (x *AudioConfig) Reset() {
	*x = AudioConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AudioConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioConfig) ProtoMessage() {}

func (x *AudioConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioConfig.ProtoReflect.Descriptor instead.
func (*AudioConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDescGZIP(), []int{6}
}

func (x *AudioConfig) GetAudioEncoding() AudioEncoding {
	if x != nil {
		return x.AudioEncoding
	}
	return AudioEncoding_AUDIO_ENCODING_UNSPECIFIED
}

func (x *AudioConfig) GetSpeakingRate() float64 {
	if x != nil {
		return x.SpeakingRate
	}
	return 0
}

func (x *AudioConfig) GetPitch() float64 {
	if x != nil {
		return x.Pitch
	}
	return 0
}

func (x *AudioConfig) GetVolumeGainDb() float64 {
	if x != nil {
		return x.VolumeGainDb
	}
	return 0
}

func (x *AudioConfig) GetSampleRateHertz() int32 {
	if x != nil {
		return x.SampleRateHertz
	}
	return 0
}

func (x *AudioConfig) GetEffectsProfileId() []string {
	if x != nil {
		return x.EffectsProfileId
	}
	return nil
}

// The message returned to the client by the `SynthesizeSpeech` method.
type SynthesizeSpeechResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The audio data bytes encoded as specified in the request, including the
	// header for encodings that are wrapped in containers (e.g. MP3, OGG_OPUS).
	// For LINEAR16 audio, we include the WAV header. Note: as
	// with all bytes fields, protobuffers use a pure binary representation,
	// whereas JSON representations use base64.
	AudioContent []byte `protobuf:"bytes,1,opt,name=audio_content,json=audioContent,proto3" json:"audio_content,omitempty"`
	// A link between a position in the original request input and a corresponding
	// time in the output audio. It's only supported via `<mark>` of SSML input.
	Timepoints []*Timepoint `protobuf:"bytes,2,rep,name=timepoints,proto3" json:"timepoints,omitempty"`
	// The audio metadata of `audio_content`.
	AudioConfig *AudioConfig `protobuf:"bytes,4,opt,name=audio_config,json=audioConfig,proto3" json:"audio_config,omitempty"`
}

func (x *SynthesizeSpeechResponse) Reset() {
	*x = SynthesizeSpeechResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SynthesizeSpeechResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SynthesizeSpeechResponse) ProtoMessage() {}

func (x *SynthesizeSpeechResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SynthesizeSpeechResponse.ProtoReflect.Descriptor instead.
func (*SynthesizeSpeechResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDescGZIP(), []int{7}
}

func (x *SynthesizeSpeechResponse) GetAudioContent() []byte {
	if x != nil {
		return x.AudioContent
	}
	return nil
}

func (x *SynthesizeSpeechResponse) GetTimepoints() []*Timepoint {
	if x != nil {
		return x.Timepoints
	}
	return nil
}

func (x *SynthesizeSpeechResponse) GetAudioConfig() *AudioConfig {
	if x != nil {
		return x.AudioConfig
	}
	return nil
}

// This contains a mapping between a certain point in the input text and a
// corresponding time in the output audio.
type Timepoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Timepoint name as received from the client within `<mark>` tag.
	MarkName string `protobuf:"bytes,4,opt,name=mark_name,json=markName,proto3" json:"mark_name,omitempty"`
	// Time offset in seconds from the start of the synthesized audio.
	TimeSeconds float64 `protobuf:"fixed64,3,opt,name=time_seconds,json=timeSeconds,proto3" json:"time_seconds,omitempty"`
}

func (x *Timepoint) Reset() {
	*x = Timepoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Timepoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Timepoint) ProtoMessage() {}

func (x *Timepoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Timepoint.ProtoReflect.Descriptor instead.
func (*Timepoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDescGZIP(), []int{8}
}

func (x *Timepoint) GetMarkName() string {
	if x != nil {
		return x.MarkName
	}
	return ""
}

func (x *Timepoint) GetTimeSeconds() float64 {
	if x != nil {
		return x.TimeSeconds
	}
	return 0
}

var File_google_cloud_texttospeech_v1beta1_cloud_tts_proto protoreflect.FileDescriptor

var file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74,
	0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x74, 0x74, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x3d,
	0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x56, 0x0a,
	0x12, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x06, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x52, 0x06, 0x76,
	0x6f, 0x69, 0x63, 0x65, 0x73, 0x22, 0xd2, 0x01, 0x0a, 0x05, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x12,
	0x25, 0x0a, 0x0e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x53, 0x0a, 0x0b, 0x73, 0x73,
	0x6d, 0x6c, 0x5f, 0x67, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x73, 0x6d, 0x6c, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x47, 0x65, 0x6e,
	0x64, 0x65, 0x72, 0x52, 0x0a, 0x73, 0x73, 0x6d, 0x6c, 0x47, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x12,
	0x39, 0x0a, 0x19, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x61, 0x6c, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x65, 0x72, 0x74, 0x7a, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x16, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x61, 0x6c, 0x53, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x52, 0x61, 0x74, 0x65, 0x48, 0x65, 0x72, 0x74, 0x7a, 0x22, 0xcf, 0x03, 0x0a, 0x17, 0x53,
	0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65,
	0x73, 0x69, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x12, 0x52, 0x0a, 0x05, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x53, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x12, 0x56, 0x0a, 0x0c, 0x61, 0x75, 0x64, 0x69,
	0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65,
	0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x7a, 0x0a, 0x14, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x48,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65,
	0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x53, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x12, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x22, 0x3e, 0x0a, 0x0d,
	0x54, 0x69, 0x6d, 0x65, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a,
	0x1a, 0x54, 0x49, 0x4d, 0x45, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a,
	0x09, 0x53, 0x53, 0x4d, 0x4c, 0x5f, 0x4d, 0x41, 0x52, 0x4b, 0x10, 0x01, 0x22, 0x4c, 0x0a, 0x0e,
	0x53, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x14,
	0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x12, 0x14, 0x0a, 0x04, 0x73, 0x73, 0x6d, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x73, 0x73, 0x6d, 0x6c, 0x42, 0x0e, 0x0a, 0x0c, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xa9, 0x01, 0x0a, 0x14, 0x56,
	0x6f, 0x69, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x53, 0x0a, 0x0b, 0x73, 0x73, 0x6d, 0x6c, 0x5f, 0x67, 0x65, 0x6e, 0x64, 0x65, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x73, 0x6d, 0x6c, 0x56,
	0x6f, 0x69, 0x63, 0x65, 0x47, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x52, 0x0a, 0x73, 0x73, 0x6d, 0x6c,
	0x47, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x22, 0xcb, 0x02, 0x0a, 0x0b, 0x41, 0x75, 0x64, 0x69, 0x6f,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5c, 0x0a, 0x0e, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f,
	0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65,
	0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x45, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x12, 0x2b, 0x0a, 0x0d, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67,
	0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x42, 0x06, 0xe0, 0x41, 0x04,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x52, 0x61, 0x74,
	0x65, 0x12, 0x1c, 0x0a, 0x05, 0x70, 0x69, 0x74, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01,
	0x42, 0x06, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x70, 0x69, 0x74, 0x63, 0x68, 0x12,
	0x2c, 0x0a, 0x0e, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x67, 0x61, 0x69, 0x6e, 0x5f, 0x64,
	0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x42, 0x06, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x01, 0x52,
	0x0c, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x47, 0x61, 0x69, 0x6e, 0x44, 0x62, 0x12, 0x2f, 0x0a,
	0x11, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x65, 0x72,
	0x74, 0x7a, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x73,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x61, 0x74, 0x65, 0x48, 0x65, 0x72, 0x74, 0x7a, 0x12, 0x34,
	0x0a, 0x12, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x04, 0xe0,
	0x41, 0x01, 0x52, 0x10, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x49, 0x64, 0x22, 0xe0, 0x01, 0x0a, 0x18, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x73,
	0x69, 0x7a, 0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x4c, 0x0a, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x73, 0x12, 0x51, 0x0a, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41,
	0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x61, 0x75, 0x64, 0x69,
	0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x4b, 0x0a, 0x09, 0x54, 0x69, 0x6d, 0x65, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x61, 0x72, 0x6b, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x61, 0x72, 0x6b, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0b, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x63,
	0x6f, 0x6e, 0x64, 0x73, 0x2a, 0x57, 0x0a, 0x0f, 0x53, 0x73, 0x6d, 0x6c, 0x56, 0x6f, 0x69, 0x63,
	0x65, 0x47, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x1d, 0x53, 0x53, 0x4d, 0x4c, 0x5f,
	0x56, 0x4f, 0x49, 0x43, 0x45, 0x5f, 0x47, 0x45, 0x4e, 0x44, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4d, 0x41,
	0x4c, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x45, 0x4d, 0x41, 0x4c, 0x45, 0x10, 0x02,
	0x12, 0x0b, 0x0a, 0x07, 0x4e, 0x45, 0x55, 0x54, 0x52, 0x41, 0x4c, 0x10, 0x03, 0x2a, 0x70, 0x0a,
	0x0d, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x1e,
	0x0a, 0x1a, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x5f, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x4c, 0x49, 0x4e, 0x45, 0x41, 0x52, 0x31, 0x36, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03,
	0x4d, 0x50, 0x33, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x50, 0x33, 0x5f, 0x36, 0x34, 0x5f,
	0x4b, 0x42, 0x50, 0x53, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x4f, 0x47, 0x47, 0x5f, 0x4f, 0x50,
	0x55, 0x53, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x55, 0x4c, 0x41, 0x57, 0x10, 0x05, 0x32,
	0xd2, 0x03, 0x0a, 0x0c, 0x54, 0x65, 0x78, 0x74, 0x54, 0x6f, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68,
	0x12, 0xa2, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x12,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f,
	0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x27, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x11, 0x12, 0x0f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x76,
	0x6f, 0x69, 0x63, 0x65, 0x73, 0xda, 0x41, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x12, 0xcb, 0x01, 0x0a, 0x10, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65,
	0x73, 0x69, 0x7a, 0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53,
	0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x79, 0x6e, 0x74, 0x68,
	0x65, 0x73, 0x69, 0x7a, 0x65, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1d, 0x22, 0x18, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x74, 0x65, 0x78, 0x74, 0x3a, 0x73, 0x79, 0x6e, 0x74, 0x68,
	0x65, 0x73, 0x69, 0x7a, 0x65, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x18, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x2c, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x2c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x1a, 0x4f, 0xca, 0x41, 0x1b, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70,
	0x65, 0x65, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x42, 0xfd, 0x01, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f,
	0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x11,
	0x54, 0x65, 0x78, 0x74, 0x54, 0x6f, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x4d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x74, 0x65, 0x78, 0x74, 0x74, 0x6f, 0x73, 0x70, 0x65, 0x65,
	0x63, 0x68, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x54, 0x6f, 0x53, 0x70, 0x65, 0x65, 0x63,
	0x68, 0x2e, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x54, 0x65, 0x78, 0x74, 0x54, 0x6f, 0x53,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x24,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x54,
	0x65, 0x78, 0x74, 0x54, 0x6f, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x3a, 0x3a, 0x56, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDescOnce sync.Once
	file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDescData = file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDesc
)

func file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDescGZIP() []byte {
	file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDescOnce.Do(func() {
		file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDescData)
	})
	return file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDescData
}

var file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_goTypes = []interface{}{
	(SsmlVoiceGender)(0),                       // 0: google.cloud.texttospeech.v1beta1.SsmlVoiceGender
	(AudioEncoding)(0),                         // 1: google.cloud.texttospeech.v1beta1.AudioEncoding
	(SynthesizeSpeechRequest_TimepointType)(0), // 2: google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType
	(*ListVoicesRequest)(nil),                  // 3: google.cloud.texttospeech.v1beta1.ListVoicesRequest
	(*ListVoicesResponse)(nil),                 // 4: google.cloud.texttospeech.v1beta1.ListVoicesResponse
	(*Voice)(nil),                              // 5: google.cloud.texttospeech.v1beta1.Voice
	(*SynthesizeSpeechRequest)(nil),            // 6: google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest
	(*SynthesisInput)(nil),                     // 7: google.cloud.texttospeech.v1beta1.SynthesisInput
	(*VoiceSelectionParams)(nil),               // 8: google.cloud.texttospeech.v1beta1.VoiceSelectionParams
	(*AudioConfig)(nil),                        // 9: google.cloud.texttospeech.v1beta1.AudioConfig
	(*SynthesizeSpeechResponse)(nil),           // 10: google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse
	(*Timepoint)(nil),                          // 11: google.cloud.texttospeech.v1beta1.Timepoint
}
var file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_depIdxs = []int32{
	5,  // 0: google.cloud.texttospeech.v1beta1.ListVoicesResponse.voices:type_name -> google.cloud.texttospeech.v1beta1.Voice
	0,  // 1: google.cloud.texttospeech.v1beta1.Voice.ssml_gender:type_name -> google.cloud.texttospeech.v1beta1.SsmlVoiceGender
	7,  // 2: google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.input:type_name -> google.cloud.texttospeech.v1beta1.SynthesisInput
	8,  // 3: google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.voice:type_name -> google.cloud.texttospeech.v1beta1.VoiceSelectionParams
	9,  // 4: google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.audio_config:type_name -> google.cloud.texttospeech.v1beta1.AudioConfig
	2,  // 5: google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.enable_time_pointing:type_name -> google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType
	0,  // 6: google.cloud.texttospeech.v1beta1.VoiceSelectionParams.ssml_gender:type_name -> google.cloud.texttospeech.v1beta1.SsmlVoiceGender
	1,  // 7: google.cloud.texttospeech.v1beta1.AudioConfig.audio_encoding:type_name -> google.cloud.texttospeech.v1beta1.AudioEncoding
	11, // 8: google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse.timepoints:type_name -> google.cloud.texttospeech.v1beta1.Timepoint
	9,  // 9: google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse.audio_config:type_name -> google.cloud.texttospeech.v1beta1.AudioConfig
	3,  // 10: google.cloud.texttospeech.v1beta1.TextToSpeech.ListVoices:input_type -> google.cloud.texttospeech.v1beta1.ListVoicesRequest
	6,  // 11: google.cloud.texttospeech.v1beta1.TextToSpeech.SynthesizeSpeech:input_type -> google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest
	4,  // 12: google.cloud.texttospeech.v1beta1.TextToSpeech.ListVoices:output_type -> google.cloud.texttospeech.v1beta1.ListVoicesResponse
	10, // 13: google.cloud.texttospeech.v1beta1.TextToSpeech.SynthesizeSpeech:output_type -> google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse
	12, // [12:14] is the sub-list for method output_type
	10, // [10:12] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_init() }
func file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_init() {
	if File_google_cloud_texttospeech_v1beta1_cloud_tts_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVoicesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVoicesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Voice); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SynthesizeSpeechRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SynthesisInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VoiceSelectionParams); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AudioConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SynthesizeSpeechResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Timepoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*SynthesisInput_Text)(nil),
		(*SynthesisInput_Ssml)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_goTypes,
		DependencyIndexes: file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_depIdxs,
		EnumInfos:         file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_enumTypes,
		MessageInfos:      file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_msgTypes,
	}.Build()
	File_google_cloud_texttospeech_v1beta1_cloud_tts_proto = out.File
	file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_rawDesc = nil
	file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_goTypes = nil
	file_google_cloud_texttospeech_v1beta1_cloud_tts_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// TextToSpeechClient is the client API for TextToSpeech service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TextToSpeechClient interface {
	// Returns a list of Voice supported for synthesis.
	ListVoices(ctx context.Context, in *ListVoicesRequest, opts ...grpc.CallOption) (*ListVoicesResponse, error)
	// Synthesizes speech synchronously: receive results after all text input
	// has been processed.
	SynthesizeSpeech(ctx context.Context, in *SynthesizeSpeechRequest, opts ...grpc.CallOption) (*SynthesizeSpeechResponse, error)
}

type textToSpeechClient struct {
	cc grpc.ClientConnInterface
}

func NewTextToSpeechClient(cc grpc.ClientConnInterface) TextToSpeechClient {
	return &textToSpeechClient{cc}
}

func (c *textToSpeechClient) ListVoices(ctx context.Context, in *ListVoicesRequest, opts ...grpc.CallOption) (*ListVoicesResponse, error) {
	out := new(ListVoicesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.texttospeech.v1beta1.TextToSpeech/ListVoices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *textToSpeechClient) SynthesizeSpeech(ctx context.Context, in *SynthesizeSpeechRequest, opts ...grpc.CallOption) (*SynthesizeSpeechResponse, error) {
	out := new(SynthesizeSpeechResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.texttospeech.v1beta1.TextToSpeech/SynthesizeSpeech", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TextToSpeechServer is the server API for TextToSpeech service.
type TextToSpeechServer interface {
	// Returns a list of Voice supported for synthesis.
	ListVoices(context.Context, *ListVoicesRequest) (*ListVoicesResponse, error)
	// Synthesizes speech synchronously: receive results after all text input
	// has been processed.
	SynthesizeSpeech(context.Context, *SynthesizeSpeechRequest) (*SynthesizeSpeechResponse, error)
}

// UnimplementedTextToSpeechServer can be embedded to have forward compatible implementations.
type UnimplementedTextToSpeechServer struct {
}

func (*UnimplementedTextToSpeechServer) ListVoices(context.Context, *ListVoicesRequest) (*ListVoicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVoices not implemented")
}
func (*UnimplementedTextToSpeechServer) SynthesizeSpeech(context.Context, *SynthesizeSpeechRequest) (*SynthesizeSpeechResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SynthesizeSpeech not implemented")
}

func RegisterTextToSpeechServer(s *grpc.Server, srv TextToSpeechServer) {
	s.RegisterService(&_TextToSpeech_serviceDesc, srv)
}

func _TextToSpeech_ListVoices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVoicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TextToSpeechServer).ListVoices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.texttospeech.v1beta1.TextToSpeech/ListVoices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TextToSpeechServer).ListVoices(ctx, req.(*ListVoicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TextToSpeech_SynthesizeSpeech_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SynthesizeSpeechRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TextToSpeechServer).SynthesizeSpeech(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.texttospeech.v1beta1.TextToSpeech/SynthesizeSpeech",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TextToSpeechServer).SynthesizeSpeech(ctx, req.(*SynthesizeSpeechRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TextToSpeech_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.texttospeech.v1beta1.TextToSpeech",
	HandlerType: (*TextToSpeechServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListVoices",
			Handler:    _TextToSpeech_ListVoices_Handler,
		},
		{
			MethodName: "SynthesizeSpeech",
			Handler:    _TextToSpeech_SynthesizeSpeech_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/texttospeech/v1beta1/cloud_tts.proto",
}
