// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package appflowiface provides an interface to enable mocking the Amazon Appflow service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package appflowiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/appflow"
)

// AppflowAPI provides an interface to enable mocking the
// appflow.Appflow service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Appflow.
//    func myFunc(svc appflowiface.AppflowAPI) bool {
//        // Make svc.CreateConnectorProfile request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := appflow.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockAppflowClient struct {
//        appflowiface.AppflowAPI
//    }
//    func (m *mockAppflowClient) CreateConnectorProfile(input *appflow.CreateConnectorProfileInput) (*appflow.CreateConnectorProfileOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockAppflowClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type AppflowAPI interface {
	CreateConnectorProfile(*appflow.CreateConnectorProfileInput) (*appflow.CreateConnectorProfileOutput, error)
	CreateConnectorProfileWithContext(aws.Context, *appflow.CreateConnectorProfileInput, ...request.Option) (*appflow.CreateConnectorProfileOutput, error)
	CreateConnectorProfileRequest(*appflow.CreateConnectorProfileInput) (*request.Request, *appflow.CreateConnectorProfileOutput)

	CreateFlow(*appflow.CreateFlowInput) (*appflow.CreateFlowOutput, error)
	CreateFlowWithContext(aws.Context, *appflow.CreateFlowInput, ...request.Option) (*appflow.CreateFlowOutput, error)
	CreateFlowRequest(*appflow.CreateFlowInput) (*request.Request, *appflow.CreateFlowOutput)

	DeleteConnectorProfile(*appflow.DeleteConnectorProfileInput) (*appflow.DeleteConnectorProfileOutput, error)
	DeleteConnectorProfileWithContext(aws.Context, *appflow.DeleteConnectorProfileInput, ...request.Option) (*appflow.DeleteConnectorProfileOutput, error)
	DeleteConnectorProfileRequest(*appflow.DeleteConnectorProfileInput) (*request.Request, *appflow.DeleteConnectorProfileOutput)

	DeleteFlow(*appflow.DeleteFlowInput) (*appflow.DeleteFlowOutput, error)
	DeleteFlowWithContext(aws.Context, *appflow.DeleteFlowInput, ...request.Option) (*appflow.DeleteFlowOutput, error)
	DeleteFlowRequest(*appflow.DeleteFlowInput) (*request.Request, *appflow.DeleteFlowOutput)

	DescribeConnector(*appflow.DescribeConnectorInput) (*appflow.DescribeConnectorOutput, error)
	DescribeConnectorWithContext(aws.Context, *appflow.DescribeConnectorInput, ...request.Option) (*appflow.DescribeConnectorOutput, error)
	DescribeConnectorRequest(*appflow.DescribeConnectorInput) (*request.Request, *appflow.DescribeConnectorOutput)

	DescribeConnectorEntity(*appflow.DescribeConnectorEntityInput) (*appflow.DescribeConnectorEntityOutput, error)
	DescribeConnectorEntityWithContext(aws.Context, *appflow.DescribeConnectorEntityInput, ...request.Option) (*appflow.DescribeConnectorEntityOutput, error)
	DescribeConnectorEntityRequest(*appflow.DescribeConnectorEntityInput) (*request.Request, *appflow.DescribeConnectorEntityOutput)

	DescribeConnectorProfiles(*appflow.DescribeConnectorProfilesInput) (*appflow.DescribeConnectorProfilesOutput, error)
	DescribeConnectorProfilesWithContext(aws.Context, *appflow.DescribeConnectorProfilesInput, ...request.Option) (*appflow.DescribeConnectorProfilesOutput, error)
	DescribeConnectorProfilesRequest(*appflow.DescribeConnectorProfilesInput) (*request.Request, *appflow.DescribeConnectorProfilesOutput)

	DescribeConnectorProfilesPages(*appflow.DescribeConnectorProfilesInput, func(*appflow.DescribeConnectorProfilesOutput, bool) bool) error
	DescribeConnectorProfilesPagesWithContext(aws.Context, *appflow.DescribeConnectorProfilesInput, func(*appflow.DescribeConnectorProfilesOutput, bool) bool, ...request.Option) error

	DescribeConnectors(*appflow.DescribeConnectorsInput) (*appflow.DescribeConnectorsOutput, error)
	DescribeConnectorsWithContext(aws.Context, *appflow.DescribeConnectorsInput, ...request.Option) (*appflow.DescribeConnectorsOutput, error)
	DescribeConnectorsRequest(*appflow.DescribeConnectorsInput) (*request.Request, *appflow.DescribeConnectorsOutput)

	DescribeConnectorsPages(*appflow.DescribeConnectorsInput, func(*appflow.DescribeConnectorsOutput, bool) bool) error
	DescribeConnectorsPagesWithContext(aws.Context, *appflow.DescribeConnectorsInput, func(*appflow.DescribeConnectorsOutput, bool) bool, ...request.Option) error

	DescribeFlow(*appflow.DescribeFlowInput) (*appflow.DescribeFlowOutput, error)
	DescribeFlowWithContext(aws.Context, *appflow.DescribeFlowInput, ...request.Option) (*appflow.DescribeFlowOutput, error)
	DescribeFlowRequest(*appflow.DescribeFlowInput) (*request.Request, *appflow.DescribeFlowOutput)

	DescribeFlowExecutionRecords(*appflow.DescribeFlowExecutionRecordsInput) (*appflow.DescribeFlowExecutionRecordsOutput, error)
	DescribeFlowExecutionRecordsWithContext(aws.Context, *appflow.DescribeFlowExecutionRecordsInput, ...request.Option) (*appflow.DescribeFlowExecutionRecordsOutput, error)
	DescribeFlowExecutionRecordsRequest(*appflow.DescribeFlowExecutionRecordsInput) (*request.Request, *appflow.DescribeFlowExecutionRecordsOutput)

	DescribeFlowExecutionRecordsPages(*appflow.DescribeFlowExecutionRecordsInput, func(*appflow.DescribeFlowExecutionRecordsOutput, bool) bool) error
	DescribeFlowExecutionRecordsPagesWithContext(aws.Context, *appflow.DescribeFlowExecutionRecordsInput, func(*appflow.DescribeFlowExecutionRecordsOutput, bool) bool, ...request.Option) error

	ListConnectorEntities(*appflow.ListConnectorEntitiesInput) (*appflow.ListConnectorEntitiesOutput, error)
	ListConnectorEntitiesWithContext(aws.Context, *appflow.ListConnectorEntitiesInput, ...request.Option) (*appflow.ListConnectorEntitiesOutput, error)
	ListConnectorEntitiesRequest(*appflow.ListConnectorEntitiesInput) (*request.Request, *appflow.ListConnectorEntitiesOutput)

	ListConnectors(*appflow.ListConnectorsInput) (*appflow.ListConnectorsOutput, error)
	ListConnectorsWithContext(aws.Context, *appflow.ListConnectorsInput, ...request.Option) (*appflow.ListConnectorsOutput, error)
	ListConnectorsRequest(*appflow.ListConnectorsInput) (*request.Request, *appflow.ListConnectorsOutput)

	ListConnectorsPages(*appflow.ListConnectorsInput, func(*appflow.ListConnectorsOutput, bool) bool) error
	ListConnectorsPagesWithContext(aws.Context, *appflow.ListConnectorsInput, func(*appflow.ListConnectorsOutput, bool) bool, ...request.Option) error

	ListFlows(*appflow.ListFlowsInput) (*appflow.ListFlowsOutput, error)
	ListFlowsWithContext(aws.Context, *appflow.ListFlowsInput, ...request.Option) (*appflow.ListFlowsOutput, error)
	ListFlowsRequest(*appflow.ListFlowsInput) (*request.Request, *appflow.ListFlowsOutput)

	ListFlowsPages(*appflow.ListFlowsInput, func(*appflow.ListFlowsOutput, bool) bool) error
	ListFlowsPagesWithContext(aws.Context, *appflow.ListFlowsInput, func(*appflow.ListFlowsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*appflow.ListTagsForResourceInput) (*appflow.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *appflow.ListTagsForResourceInput, ...request.Option) (*appflow.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*appflow.ListTagsForResourceInput) (*request.Request, *appflow.ListTagsForResourceOutput)

	RegisterConnector(*appflow.RegisterConnectorInput) (*appflow.RegisterConnectorOutput, error)
	RegisterConnectorWithContext(aws.Context, *appflow.RegisterConnectorInput, ...request.Option) (*appflow.RegisterConnectorOutput, error)
	RegisterConnectorRequest(*appflow.RegisterConnectorInput) (*request.Request, *appflow.RegisterConnectorOutput)

	StartFlow(*appflow.StartFlowInput) (*appflow.StartFlowOutput, error)
	StartFlowWithContext(aws.Context, *appflow.StartFlowInput, ...request.Option) (*appflow.StartFlowOutput, error)
	StartFlowRequest(*appflow.StartFlowInput) (*request.Request, *appflow.StartFlowOutput)

	StopFlow(*appflow.StopFlowInput) (*appflow.StopFlowOutput, error)
	StopFlowWithContext(aws.Context, *appflow.StopFlowInput, ...request.Option) (*appflow.StopFlowOutput, error)
	StopFlowRequest(*appflow.StopFlowInput) (*request.Request, *appflow.StopFlowOutput)

	TagResource(*appflow.TagResourceInput) (*appflow.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *appflow.TagResourceInput, ...request.Option) (*appflow.TagResourceOutput, error)
	TagResourceRequest(*appflow.TagResourceInput) (*request.Request, *appflow.TagResourceOutput)

	UnregisterConnector(*appflow.UnregisterConnectorInput) (*appflow.UnregisterConnectorOutput, error)
	UnregisterConnectorWithContext(aws.Context, *appflow.UnregisterConnectorInput, ...request.Option) (*appflow.UnregisterConnectorOutput, error)
	UnregisterConnectorRequest(*appflow.UnregisterConnectorInput) (*request.Request, *appflow.UnregisterConnectorOutput)

	UntagResource(*appflow.UntagResourceInput) (*appflow.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *appflow.UntagResourceInput, ...request.Option) (*appflow.UntagResourceOutput, error)
	UntagResourceRequest(*appflow.UntagResourceInput) (*request.Request, *appflow.UntagResourceOutput)

	UpdateConnectorProfile(*appflow.UpdateConnectorProfileInput) (*appflow.UpdateConnectorProfileOutput, error)
	UpdateConnectorProfileWithContext(aws.Context, *appflow.UpdateConnectorProfileInput, ...request.Option) (*appflow.UpdateConnectorProfileOutput, error)
	UpdateConnectorProfileRequest(*appflow.UpdateConnectorProfileInput) (*request.Request, *appflow.UpdateConnectorProfileOutput)

	UpdateFlow(*appflow.UpdateFlowInput) (*appflow.UpdateFlowOutput, error)
	UpdateFlowWithContext(aws.Context, *appflow.UpdateFlowInput, ...request.Option) (*appflow.UpdateFlowOutput, error)
	UpdateFlowRequest(*appflow.UpdateFlowInput) (*request.Request, *appflow.UpdateFlowOutput)
}

var _ AppflowAPI = (*appflow.Appflow)(nil)
