/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.code.plugin.mcp.notifications;

import com.anthropic.code.plugin.IDENotificationUtil;
import com.anthropic.code.plugin.TerminalUtil;
import com.anthropic.code.plugin.UtilsKt;
import com.anthropic.code.plugin.mcp.CodeRange;
import com.anthropic.code.plugin.mcp.CursorPosition;
import com.anthropic.code.plugin.mcp.notifications.AtMentionedNotification;
import com.anthropic.code.plugin.mcp.notifications.IdeConnectedNotification;
import com.anthropic.code.plugin.mcp.notifications.NotificationManager;
import com.anthropic.code.plugin.mcp.notifications.SelectionChangedNotification;
import com.anthropic.code.plugin.mcp.tools.FileDiagnostic;
import com.anthropic.code.plugin.services.MCPService;
import com.anthropic.code.plugin.services.McpServerInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import io.modelcontextprotocol.kotlin.sdk.JSONRPCMessage;
import io.modelcontextprotocol.kotlin.sdk.JSONRPCNotification;
import io.modelcontextprotocol.kotlin.sdk.server.Server;
import io.modelcontextprotocol.kotlin.sdk.shared.Transport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/anthropic/code/plugin/mcp/notifications/NotificationManager;", "", "mcpService", "Lcom/anthropic/code/plugin/services/MCPService;", "mcpServer", "Lio/modelcontextprotocol/kotlin/sdk/server/Server;", "<init>", "(Lcom/anthropic/code/plugin/services/MCPService;Lio/modelcontextprotocol/kotlin/sdk/server/Server;)V", "registerHandlers", "", "server", "project", "Lcom/intellij/openapi/project/Project;", "registerSelectionListener", "sendSelectionChangeNotification", "editor", "Lcom/intellij/openapi/editor/Editor;", "sendAtMentionedNotification", "sendDiagnosticChangedNotification", "uri", "", "sendNotification", "mcpNotification", "Lio/modelcontextprotocol/kotlin/sdk/JSONRPCNotification;", "claude-code-jetbrains-plugin"})
@SourceDebugExtension(value={"SMAP\nNotificationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationManager.kt\ncom/anthropic/code/plugin/mcp/notifications/NotificationManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,199:1\n1#2:200\n1#2:214\n324#3:201\n324#3:202\n324#3:203\n11383#4,9:204\n13309#4:213\n13310#4:215\n11392#4:216\n*S KotlinDebug\n*F\n+ 1 NotificationManager.kt\ncom/anthropic/code/plugin/mcp/notifications/NotificationManager\n*L\n71#1:214\n120#1:201\n153#1:202\n172#1:203\n71#1:204,9\n71#1:213\n71#1:215\n71#1:216\n*E\n"})
public final class NotificationManager {
    @NotNull
    private final MCPService mcpService;
    @NotNull
    private final Server mcpServer;

    public NotificationManager(@NotNull MCPService mcpService, @NotNull Server mcpServer) {
        Intrinsics.checkNotNullParameter((Object)mcpService, (String)"mcpService");
        Intrinsics.checkNotNullParameter((Object)mcpServer, (String)"mcpServer");
        this.mcpService = mcpService;
        this.mcpServer = mcpServer;
    }

    public final void registerHandlers(@NotNull Server server, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        server.setFallbackNotificationHandler((Function2)new Function2<JSONRPCNotification, Continuation<? super Unit>, Object>(this, server, project, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ NotificationManager this$0;
            final /* synthetic */ Server $server;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$server = $server;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        JSONRPCNotification notification = (JSONRPCNotification)this.L$0;
                        try {
                            if (Intrinsics.areEqual((Object)notification.getMethod(), (Object)"ide_connected")) {
                                void $this$decodeFromJsonElement$iv;
                                Json json = (Json)Json.Default;
                                JsonElement json$iv = notification.getParams();
                                boolean $i$f$decodeFromJsonElement = false;
                                $this$decodeFromJsonElement$iv.getSerializersModule();
                                IdeConnectedNotification params = (IdeConnectedNotification)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)IdeConnectedNotification.Companion.serializer(), json$iv);
                                McpServerInfo mcpServerInfo = NotificationManager.access$getMcpService$p(this.this$0).getMcpServerInfos().get(this.$server);
                                if (mcpServerInfo != null) {
                                    mcpServerInfo.setPid(Boxing.boxLong((long)params.getPid()));
                                }
                                TerminalUtil.INSTANCE.configureTerminalSettings(this.$project, NotificationManager.access$getMcpService$p(this.this$0));
                                if (params.isPluginVersionUnsupported()) {
                                    IDENotificationUtil.INSTANCE.showPluginOutOfDateWarning(this.$project);
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(JSONRPCNotification p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        this.registerSelectionListener(project);
    }

    private final void registerSelectionListener(Project project) {
        SelectionListener selectionListener2 = new SelectionListener(this){
            final /* synthetic */ NotificationManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(SelectionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Editor editor = event.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                this.this$0.sendSelectionChangeNotification(editor);
            }
        };
        Ref.ObjectRef initialSelectionEditors = new Ref.ObjectRef();
        ApplicationManager.getApplication().invokeAndWait(() -> NotificationManager.registerSelectionListener$lambda$1(project, selectionListener2, this, initialSelectionEditors));
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this.mcpService);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(selectionListener2, this, (Ref.ObjectRef<List<WeakReference<TextEditor>>>)initialSelectionEditors){
            final /* synthetic */ registerSelectionListener.selectionListener.1 $selectionListener;
            final /* synthetic */ NotificationManager this$0;
            final /* synthetic */ Ref.ObjectRef<List<WeakReference<TextEditor>>> $initialSelectionEditors;
            {
                this.$selectionListener = $selectionListener;
                this.this$0 = $receiver;
                this.$initialSelectionEditors = $initialSelectionEditors;
            }

            /*
             * WARNING - void declaration
             */
            public void selectionChanged(FileEditorManagerEvent event) {
                FileEditor unselectedEditor;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FileEditor selectedEditor = event.getNewEditor();
                if (selectedEditor instanceof TextEditor) {
                    ((TextEditor)selectedEditor).getEditor().getSelectionModel().addSelectionListener((SelectionListener)this.$selectionListener);
                    Editor editor = ((TextEditor)selectedEditor).getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                    this.this$0.sendSelectionChangeNotification(editor);
                }
                if ((unselectedEditor = event.getOldEditor()) instanceof TextEditor) {
                    ((TextEditor)unselectedEditor).getEditor().getSelectionModel().removeSelectionListener((SelectionListener)this.$selectionListener);
                }
                List list = (List)this.$initialSelectionEditors.element;
                if (list != null) {
                    void $this$forEach$iv;
                    Iterable iterable = list;
                    registerSelectionListener.selectionListener.1 var5_5 = this.$selectionListener;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        WeakReference it = (WeakReference)element$iv;
                        boolean bl = false;
                        TextEditor textEditor = (TextEditor)it.get();
                        if (textEditor == null || (textEditor = textEditor.getEditor()) == null || (textEditor = textEditor.getSelectionModel()) == null) continue;
                        textEditor.removeSelectionListener((SelectionListener)var5_5);
                    }
                }
                this.$initialSelectionEditors.element = null;
            }
        });
    }

    public final void sendSelectionChangeNotification(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        try {
            String string;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
            Object object = virtualFile;
            if (object != null && (object = object.getPath()) != null) {
                Object it = object;
                boolean bl = false;
                string = UtilsKt.convertFromOSFilePath((String)it);
            } else {
                string = null;
            }
            String filePath = string;
            SelectionModel selectionModel = editor.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
            SelectionModel selectionModel2 = selectionModel;
            LogicalPosition logicalPosition = editor.offsetToLogicalPosition(selectionModel2.getSelectionStart());
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
            LogicalPosition startPosition = logicalPosition;
            LogicalPosition logicalPosition2 = editor.offsetToLogicalPosition(selectionModel2.getSelectionEnd());
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition2, (String)"offsetToLogicalPosition(...)");
            LogicalPosition endPosition = logicalPosition2;
            SelectionChangedNotification notification = new SelectionChangedNotification(new CodeRange(new CursorPosition(startPosition.line, startPosition.column), new CursorPosition(endPosition.line, endPosition.column)), selectionModel2.getSelectedText(), filePath);
            Json $this$encodeToJsonElement$iv = (Json)Json.Default;
            boolean $i$f$encodeToJsonElement = false;
            $this$encodeToJsonElement$iv.getSerializersModule();
            JsonElement jsonElement = $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)SelectionChangedNotification.Companion.serializer(), (Object)notification);
            Intrinsics.checkNotNull((Object)jsonElement, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
            JsonObject jsonParams = (JsonObject)jsonElement;
            JSONRPCNotification mcpNotification = new JSONRPCNotification("selection_changed", (JsonElement)jsonParams, null, 4, null);
            this.sendNotification(mcpNotification);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void sendAtMentionedNotification(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        try {
            Object object;
            block5: {
                block4: {
                    VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
                    object = virtualFile;
                    if (object == null || (object = object.getPath()) == null) break block4;
                    Object it = object;
                    boolean bl = false;
                    String string = UtilsKt.convertFromOSFilePath((String)it);
                    object = string;
                    if (string != null) break block5;
                }
                return;
            }
            Object filePath = object;
            SelectionModel selectionModel = editor.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
            SelectionModel selectionModel2 = selectionModel;
            LogicalPosition logicalPosition = editor.offsetToLogicalPosition(selectionModel2.getSelectionStart());
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
            LogicalPosition startPosition = logicalPosition;
            LogicalPosition logicalPosition2 = editor.offsetToLogicalPosition(selectionModel2.getSelectionEnd());
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition2, (String)"offsetToLogicalPosition(...)");
            LogicalPosition endPosition = logicalPosition2;
            AtMentionedNotification notification = startPosition.compareTo(endPosition) == 0 ? new AtMentionedNotification((String)filePath, null, null, 6, null) : new AtMentionedNotification((String)filePath, startPosition.line, endPosition.line);
            Json $this$encodeToJsonElement$iv = (Json)Json.Default;
            boolean $i$f$encodeToJsonElement = false;
            $this$encodeToJsonElement$iv.getSerializersModule();
            JsonElement jsonElement = $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)AtMentionedNotification.Companion.serializer(), (Object)notification);
            Intrinsics.checkNotNull((Object)jsonElement, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
            JsonObject jsonParams = (JsonObject)jsonElement;
            JSONRPCNotification mcpNotification = new JSONRPCNotification("at_mentioned", (JsonElement)jsonParams, null, 4, null);
            this.sendNotification(mcpNotification);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void sendDiagnosticChangedNotification(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        try {
            FileDiagnostic notification = new FileDiagnostic(uri, CollectionsKt.emptyList());
            Json $this$encodeToJsonElement$iv = (Json)Json.Default;
            boolean $i$f$encodeToJsonElement = false;
            $this$encodeToJsonElement$iv.getSerializersModule();
            JsonElement jsonElement = $this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)FileDiagnostic.Companion.serializer(), (Object)notification);
            Intrinsics.checkNotNull((Object)jsonElement, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
            JsonObject jsonParams = (JsonObject)jsonElement;
            JSONRPCNotification mcpNotification = new JSONRPCNotification("diagnostics_changed", (JsonElement)jsonParams, null, 4, null);
            this.sendNotification(mcpNotification);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void sendNotification(JSONRPCNotification mcpNotification) {
        try {
            BuildersKt.launch$default((CoroutineScope)this.mcpService.getServiceScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, mcpNotification, null){
                int label;
                final /* synthetic */ NotificationManager this$0;
                final /* synthetic */ JSONRPCNotification $mcpNotification;
                {
                    this.this$0 = $receiver;
                    this.$mcpNotification = $mcpNotification;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Transport transport = NotificationManager.access$getMcpServer$p(this.this$0).getTransport();
                            if (transport == null) return Unit.INSTANCE;
                            this.label = 1;
                            Object object3 = transport.send((JSONRPCMessage)this.$mcpNotification, (Continuation)this);
                            Object object4 = object3;
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            Object object4;
                            try {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                object4 = $result;
                                return Unit.INSTANCE;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void registerSelectionListener$lambda$1(Project $project, registerSelectionListener.selectionListener.1 $selectionListener, NotificationManager this$0, Ref.ObjectRef $initialSelectionEditors) {
        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.Companion.getInstanceEx($project);
        Editor selectedTextEditor = fileEditorManager.getSelectedTextEditor();
        if (selectedTextEditor != null) {
            selectedTextEditor.getSelectionModel().addSelectionListener((SelectionListener)$selectionListener);
            this$0.sendSelectionChangeNotification(selectedTextEditor);
        } else {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            FileEditor[] fileEditorArray = fileEditorManager.getAllEditors();
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
            Object[] objectArray = fileEditorArray;
            Ref.ObjectRef objectRef = $initialSelectionEditors;
            boolean $i$f$mapNotNull = false;
            void var8_9 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                WeakReference<FileEditor> weakReference;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                FileEditor otherEditor = (FileEditor)element$iv$iv;
                boolean bl2 = false;
                if (otherEditor instanceof TextEditor) {
                    ((TextEditor)otherEditor).getEditor().getSelectionModel().addSelectionListener((SelectionListener)$selectionListener);
                    Editor editor = ((TextEditor)otherEditor).getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                    this$0.sendSelectionChangeNotification(editor);
                    weakReference = new WeakReference<FileEditor>(otherEditor);
                } else {
                    weakReference = null;
                }
                if (weakReference == null) continue;
                WeakReference<FileEditor> it$iv$iv = weakReference;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            objectRef.element = (List)destination$iv$iv;
        }
    }

    public static final /* synthetic */ MCPService access$getMcpService$p(NotificationManager $this) {
        return $this.mcpService;
    }

    public static final /* synthetic */ Server access$getMcpServer$p(NotificationManager $this) {
        return $this.mcpServer;
    }
}

