RabbitMQ `3.12.9` is a maintenance release in the `3.12.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from the [3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0)
if upgrading from a version prior to 3.12.0.

This release requires Erlang 25 and supports Erlang versions up to `26.1.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.12.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Users upgrading from 3.11.x (or older releases) on Erlang 25 to 3.12.x on Erlang 26
(both RabbitMQ *and* Erlang are upgraded at the same time) **must** consult
the [v3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0) first.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.12.x/release-notes).

### Core Broker

#### Bug Fixes

 * When a topic permission was deleted, an [internal event](https://rabbitmq.com/logging.html#internal-events) of type `permission.deleted`
   was emitted in some cases, instead of `topic.permission.deleted`.

   Investigated by @bedia.

   GitHub issue: [#9937](https://github.com/rabbitmq/rabbitmq-server/issues/9937)


### Shovel Plugin

#### Bug Fixes

 * Shovels on `3.12.8` nodes failed during a rolling cluster upgrade due to internal
   identifier format changes.

   Starting with this release, both old and new formats are supported for upgrade safety.

   GitHub issue: [#9894](https://github.com/rabbitmq/rabbitmq-server/pull/9894)


### Grafana Dashboard

#### Enhancements

 * [Global counters for producers](https://github.com/rabbitmq/rabbitmq-server/pull/3127) are now available in the dashboard.

   Contributed by @johanrhodin (CloudAMQP)

   GitHub issue: [#9846](https://github.com/rabbitmq/rabbitmq-server/pull/9846)


### MQTT Plugin

#### Bug Fixes

 * Avoids an unnecessary warning in the logs.

   GitHub issue: [#9885](https://github.com/rabbitmq/rabbitmq-server/pull/9885)


### CLI Tools

#### Enhancements

 * `rabbitmq-diagnostics list_policies_that_match [queue name]` is a new command
   that simplifies troubleshooting of policy conflicts.

   GitHub issue: [#9916](https://github.com/rabbitmq/rabbitmq-server/pull/9916)


### Management Plugin

#### Enhancements

 * Nodes that have OAuth 2 enabled now redirect the user to the original landing page (if any)
   after successful login with the IDP.

   Contributed by @dukex.

   GitHub issue: [#9851](https://github.com/rabbitmq/rabbitmq-server/pull/9851)


## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.12.9.tar.xz`
instead of the source tarball produced by GitHub.
