// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/apps/alertcenter/v1beta1/alertcenter.proto

package alertcenter

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of alert feedback.
type AlertFeedbackType int32

const (
	// The feedback type is not specified.
	AlertFeedbackType_ALERT_FEEDBACK_TYPE_UNSPECIFIED AlertFeedbackType = 0
	// The alert report is not useful.
	AlertFeedbackType_NOT_USEFUL AlertFeedbackType = 1
	// The alert report is somewhat useful.
	AlertFeedbackType_SOMEWHAT_USEFUL AlertFeedbackType = 2
	// The alert report is very useful.
	AlertFeedbackType_VERY_USEFUL AlertFeedbackType = 3
)

// Enum value maps for AlertFeedbackType.
var (
	AlertFeedbackType_name = map[int32]string{
		0: "ALERT_FEEDBACK_TYPE_UNSPECIFIED",
		1: "NOT_USEFUL",
		2: "SOMEWHAT_USEFUL",
		3: "VERY_USEFUL",
	}
	AlertFeedbackType_value = map[string]int32{
		"ALERT_FEEDBACK_TYPE_UNSPECIFIED": 0,
		"NOT_USEFUL":                      1,
		"SOMEWHAT_USEFUL":                 2,
		"VERY_USEFUL":                     3,
	}
)

func (x AlertFeedbackType) Enum() *AlertFeedbackType {
	p := new(AlertFeedbackType)
	*p = x
	return p
}

func (x AlertFeedbackType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AlertFeedbackType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_enumTypes[0].Descriptor()
}

func (AlertFeedbackType) Type() protoreflect.EnumType {
	return &file_google_apps_alertcenter_v1beta1_alertcenter_proto_enumTypes[0]
}

func (x AlertFeedbackType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AlertFeedbackType.Descriptor instead.
func (AlertFeedbackType) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{0}
}

// The format of the payload.
type Settings_Notification_PayloadFormat int32

const (
	// Payload format is not specified (will use JSON as default).
	Settings_Notification_PAYLOAD_FORMAT_UNSPECIFIED Settings_Notification_PayloadFormat = 0
	// Use JSON.
	Settings_Notification_JSON Settings_Notification_PayloadFormat = 1
)

// Enum value maps for Settings_Notification_PayloadFormat.
var (
	Settings_Notification_PayloadFormat_name = map[int32]string{
		0: "PAYLOAD_FORMAT_UNSPECIFIED",
		1: "JSON",
	}
	Settings_Notification_PayloadFormat_value = map[string]int32{
		"PAYLOAD_FORMAT_UNSPECIFIED": 0,
		"JSON":                       1,
	}
)

func (x Settings_Notification_PayloadFormat) Enum() *Settings_Notification_PayloadFormat {
	p := new(Settings_Notification_PayloadFormat)
	*p = x
	return p
}

func (x Settings_Notification_PayloadFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Settings_Notification_PayloadFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_enumTypes[1].Descriptor()
}

func (Settings_Notification_PayloadFormat) Type() protoreflect.EnumType {
	return &file_google_apps_alertcenter_v1beta1_alertcenter_proto_enumTypes[1]
}

func (x Settings_Notification_PayloadFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Settings_Notification_PayloadFormat.Descriptor instead.
func (Settings_Notification_PayloadFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{3, 0, 0}
}

// An alert affecting a customer.
type Alert struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The unique identifier of the Google account of the customer.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Output only. The unique identifier for the alert.
	AlertId string `protobuf:"bytes,2,opt,name=alert_id,json=alertId,proto3" json:"alert_id,omitempty"`
	// Output only. The time this alert was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Required. The time the event that caused this alert was started or
	// detected.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Optional. The time the event that caused this alert ceased being active.
	// If provided, the end time must not be earlier than the start time.
	// If not provided, it indicates an ongoing alert.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Required. The type of the alert.
	// This is output only after alert is created.
	// For a list of available alert types see
	// [Google Workspace Alert
	// types](https://developers.google.com/admin-sdk/alertcenter/reference/alert-types).
	Type string `protobuf:"bytes,6,opt,name=type,proto3" json:"type,omitempty"`
	// Required. A unique identifier for the system that reported the alert.
	// This is output only after alert is created.
	//
	// Supported sources are any of the following:
	//
	// * Google Operations
	// * Mobile device management
	// * Gmail phishing
	// * Domain wide takeout
	// * State sponsored attack
	// * Google identity
	Source string `protobuf:"bytes,7,opt,name=source,proto3" json:"source,omitempty"`
	// Optional. The data associated with this alert, for example
	// [google.apps.alertcenter.type.DeviceCompromised] [google.apps.alertcenter.type.DeviceCompromised].
	Data *anypb.Any `protobuf:"bytes,8,opt,name=data,proto3" json:"data,omitempty"`
	// Output only. An optional
	// [Security Investigation Tool](https://support.google.com/a/answer/7575955)
	// query for this alert.
	SecurityInvestigationToolLink string `protobuf:"bytes,9,opt,name=security_investigation_tool_link,json=securityInvestigationToolLink,proto3" json:"security_investigation_tool_link,omitempty"`
	// Output only. `True` if this alert is marked for deletion.
	Deleted bool `protobuf:"varint,11,opt,name=deleted,proto3" json:"deleted,omitempty"`
	// Output only. The metadata associated with this alert.
	Metadata *AlertMetadata `protobuf:"bytes,12,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Output only. The time this alert was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. `etag` is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of an alert from overwriting each other.
	// It is strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform alert updates in order to avoid race
	// conditions: An `etag` is returned in the response which contains alerts,
	// and systems are expected to put that etag in the request to update alert to
	// ensure that their change will be applied to the same version of the alert.
	//
	// If no `etag` is provided in the call to update alert, then the existing
	// alert is overwritten blindly.
	Etag string `protobuf:"bytes,14,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *Alert) Reset() {
	*x = Alert{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Alert) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Alert) ProtoMessage() {}

func (x *Alert) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Alert.ProtoReflect.Descriptor instead.
func (*Alert) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{0}
}

func (x *Alert) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *Alert) GetAlertId() string {
	if x != nil {
		return x.AlertId
	}
	return ""
}

func (x *Alert) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Alert) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Alert) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Alert) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Alert) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *Alert) GetData() *anypb.Any {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *Alert) GetSecurityInvestigationToolLink() string {
	if x != nil {
		return x.SecurityInvestigationToolLink
	}
	return ""
}

func (x *Alert) GetDeleted() bool {
	if x != nil {
		return x.Deleted
	}
	return false
}

func (x *Alert) GetMetadata() *AlertMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Alert) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Alert) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// A customer feedback about an alert.
type AlertFeedback struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The unique identifier of the Google account of the customer.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Output only. The alert identifier.
	AlertId string `protobuf:"bytes,2,opt,name=alert_id,json=alertId,proto3" json:"alert_id,omitempty"`
	// Output only. The unique identifier for the feedback.
	FeedbackId string `protobuf:"bytes,3,opt,name=feedback_id,json=feedbackId,proto3" json:"feedback_id,omitempty"`
	// Output only. The time this feedback was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Required. The type of the feedback.
	Type AlertFeedbackType `protobuf:"varint,5,opt,name=type,proto3,enum=google.apps.alertcenter.v1beta1.AlertFeedbackType" json:"type,omitempty"`
	// Output only. The email of the user that provided the feedback.
	Email string `protobuf:"bytes,6,opt,name=email,proto3" json:"email,omitempty"`
}

func (x *AlertFeedback) Reset() {
	*x = AlertFeedback{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AlertFeedback) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlertFeedback) ProtoMessage() {}

func (x *AlertFeedback) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlertFeedback.ProtoReflect.Descriptor instead.
func (*AlertFeedback) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{1}
}

func (x *AlertFeedback) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *AlertFeedback) GetAlertId() string {
	if x != nil {
		return x.AlertId
	}
	return ""
}

func (x *AlertFeedback) GetFeedbackId() string {
	if x != nil {
		return x.FeedbackId
	}
	return ""
}

func (x *AlertFeedback) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AlertFeedback) GetType() AlertFeedbackType {
	if x != nil {
		return x.Type
	}
	return AlertFeedbackType_ALERT_FEEDBACK_TYPE_UNSPECIFIED
}

func (x *AlertFeedback) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

// An alert metadata.
type AlertMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The unique identifier of the Google account of the customer.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Output only. The alert identifier.
	AlertId string `protobuf:"bytes,2,opt,name=alert_id,json=alertId,proto3" json:"alert_id,omitempty"`
	// The current status of the alert.
	// The supported values are the following:
	//
	// * NOT_STARTED
	// * IN_PROGRESS
	// * CLOSED
	Status string `protobuf:"bytes,4,opt,name=status,proto3" json:"status,omitempty"`
	// The email address of the user assigned to the alert.
	Assignee string `protobuf:"bytes,5,opt,name=assignee,proto3" json:"assignee,omitempty"`
	// Output only. The time this metadata was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The severity value of the alert. Alert Center will set this field at alert
	// creation time, default's to an empty string when it could not be
	// determined.
	// The supported values for update actions on this field are the following:
	//
	// * HIGH
	// * MEDIUM
	// * LOW
	Severity string `protobuf:"bytes,7,opt,name=severity,proto3" json:"severity,omitempty"`
	// Optional. `etag` is used for optimistic concurrency control as a way to
	// help prevent simultaneous updates of an alert metadata from overwriting
	// each other. It is strongly suggested that systems make use of the `etag` in
	// the read-modify-write cycle to perform metatdata updates in order to avoid
	// race conditions: An `etag` is returned in the response which contains alert
	// metadata, and systems are expected to put that etag in the request to
	// update alert metadata to ensure that their change will be applied to the
	// same version of the alert metadata.
	//
	// If no `etag` is provided in the call to update alert metadata, then the
	// existing alert metadata is overwritten blindly.
	Etag string `protobuf:"bytes,8,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *AlertMetadata) Reset() {
	*x = AlertMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AlertMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlertMetadata) ProtoMessage() {}

func (x *AlertMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlertMetadata.ProtoReflect.Descriptor instead.
func (*AlertMetadata) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{2}
}

func (x *AlertMetadata) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *AlertMetadata) GetAlertId() string {
	if x != nil {
		return x.AlertId
	}
	return ""
}

func (x *AlertMetadata) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *AlertMetadata) GetAssignee() string {
	if x != nil {
		return x.Assignee
	}
	return ""
}

func (x *AlertMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *AlertMetadata) GetSeverity() string {
	if x != nil {
		return x.Severity
	}
	return ""
}

func (x *AlertMetadata) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Customer-level settings.
type Settings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of notifications.
	Notifications []*Settings_Notification `protobuf:"bytes,1,rep,name=notifications,proto3" json:"notifications,omitempty"`
}

func (x *Settings) Reset() {
	*x = Settings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Settings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Settings) ProtoMessage() {}

func (x *Settings) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Settings.ProtoReflect.Descriptor instead.
func (*Settings) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{3}
}

func (x *Settings) GetNotifications() []*Settings_Notification {
	if x != nil {
		return x.Notifications
	}
	return nil
}

// A request to perform batch delete on alerts.
type BatchDeleteAlertsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique identifier of the Google Workspace organization
	// account of the customer the alerts are associated with.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. list of alert IDs.
	AlertId []string `protobuf:"bytes,2,rep,name=alert_id,json=alertId,proto3" json:"alert_id,omitempty"`
}

func (x *BatchDeleteAlertsRequest) Reset() {
	*x = BatchDeleteAlertsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDeleteAlertsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeleteAlertsRequest) ProtoMessage() {}

func (x *BatchDeleteAlertsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeleteAlertsRequest.ProtoReflect.Descriptor instead.
func (*BatchDeleteAlertsRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{4}
}

func (x *BatchDeleteAlertsRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *BatchDeleteAlertsRequest) GetAlertId() []string {
	if x != nil {
		return x.AlertId
	}
	return nil
}

// Response to batch delete operation on alerts.
type BatchDeleteAlertsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The successful list of alert IDs.
	SuccessAlertIds []string `protobuf:"bytes,1,rep,name=success_alert_ids,json=successAlertIds,proto3" json:"success_alert_ids,omitempty"`
	// The status details for each failed alert_id.
	FailedAlertStatus map[string]*status.Status `protobuf:"bytes,2,rep,name=failed_alert_status,json=failedAlertStatus,proto3" json:"failed_alert_status,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *BatchDeleteAlertsResponse) Reset() {
	*x = BatchDeleteAlertsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDeleteAlertsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDeleteAlertsResponse) ProtoMessage() {}

func (x *BatchDeleteAlertsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDeleteAlertsResponse.ProtoReflect.Descriptor instead.
func (*BatchDeleteAlertsResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{5}
}

func (x *BatchDeleteAlertsResponse) GetSuccessAlertIds() []string {
	if x != nil {
		return x.SuccessAlertIds
	}
	return nil
}

func (x *BatchDeleteAlertsResponse) GetFailedAlertStatus() map[string]*status.Status {
	if x != nil {
		return x.FailedAlertStatus
	}
	return nil
}

// A request to perform batch undelete on alerts.
type BatchUndeleteAlertsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique identifier of the Google Workspace organization
	// account of the customer the alerts are associated with.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. list of alert IDs.
	AlertId []string `protobuf:"bytes,2,rep,name=alert_id,json=alertId,proto3" json:"alert_id,omitempty"`
}

func (x *BatchUndeleteAlertsRequest) Reset() {
	*x = BatchUndeleteAlertsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUndeleteAlertsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUndeleteAlertsRequest) ProtoMessage() {}

func (x *BatchUndeleteAlertsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUndeleteAlertsRequest.ProtoReflect.Descriptor instead.
func (*BatchUndeleteAlertsRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{6}
}

func (x *BatchUndeleteAlertsRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *BatchUndeleteAlertsRequest) GetAlertId() []string {
	if x != nil {
		return x.AlertId
	}
	return nil
}

// Response to batch undelete operation on alerts.
type BatchUndeleteAlertsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The successful list of alert IDs.
	SuccessAlertIds []string `protobuf:"bytes,1,rep,name=success_alert_ids,json=successAlertIds,proto3" json:"success_alert_ids,omitempty"`
	// The status details for each failed alert_id.
	FailedAlertStatus map[string]*status.Status `protobuf:"bytes,2,rep,name=failed_alert_status,json=failedAlertStatus,proto3" json:"failed_alert_status,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *BatchUndeleteAlertsResponse) Reset() {
	*x = BatchUndeleteAlertsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchUndeleteAlertsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchUndeleteAlertsResponse) ProtoMessage() {}

func (x *BatchUndeleteAlertsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchUndeleteAlertsResponse.ProtoReflect.Descriptor instead.
func (*BatchUndeleteAlertsResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{7}
}

func (x *BatchUndeleteAlertsResponse) GetSuccessAlertIds() []string {
	if x != nil {
		return x.SuccessAlertIds
	}
	return nil
}

func (x *BatchUndeleteAlertsResponse) GetFailedAlertStatus() map[string]*status.Status {
	if x != nil {
		return x.FailedAlertStatus
	}
	return nil
}

// An alert listing request.
type ListAlertsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique identifier of the Google Workspace organization
	// account of the customer the alerts are associated with.
	// Inferred from the caller identity if not provided.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Optional. The requested page size. Server may return fewer items than
	// requested. If unspecified, server picks an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	// If empty, a new iteration is started. To continue an iteration, pass in
	// the value from the previous ListAlertsResponse's
	// [next_page_token][google.apps.alertcenter.v1beta1.ListAlertsResponse.next_page_token] field.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A query string for filtering alert results.
	// For more details, see [Query
	// filters](https://developers.google.com/admin-sdk/alertcenter/guides/query-filters) and [Supported
	// query filter
	// fields](https://developers.google.com/admin-sdk/alertcenter/reference/filter-fields#alerts.list).
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The sort order of the list results.
	// If not specified results may be returned in arbitrary order.
	// You can sort the results in descending order based on the creation
	// timestamp using `order_by="create_time desc"`.
	// Currently, supported sorting are `create_time asc`, `create_time desc`,
	// `update_time desc`
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListAlertsRequest) Reset() {
	*x = ListAlertsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAlertsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAlertsRequest) ProtoMessage() {}

func (x *ListAlertsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAlertsRequest.ProtoReflect.Descriptor instead.
func (*ListAlertsRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{8}
}

func (x *ListAlertsRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *ListAlertsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAlertsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAlertsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAlertsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for an alert listing request.
type ListAlertsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of alerts.
	Alerts []*Alert `protobuf:"bytes,1,rep,name=alerts,proto3" json:"alerts,omitempty"`
	// The token for the next page. If not empty, indicates that there may be more
	// alerts that match the listing request; this value can be used in a
	// subsequent [ListAlertsRequest][google.apps.alertcenter.v1beta1.ListAlertsRequest] to get alerts continuing from last result
	// of the current list call.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAlertsResponse) Reset() {
	*x = ListAlertsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAlertsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAlertsResponse) ProtoMessage() {}

func (x *ListAlertsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAlertsResponse.ProtoReflect.Descriptor instead.
func (*ListAlertsResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{9}
}

func (x *ListAlertsResponse) GetAlerts() []*Alert {
	if x != nil {
		return x.Alerts
	}
	return nil
}

func (x *ListAlertsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for a specific alert.
type GetAlertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique identifier of the Google Workspace organization
	// account of the customer the alert is associated with.
	// Inferred from the caller identity if not provided.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The identifier of the alert to retrieve.
	AlertId string `protobuf:"bytes,2,opt,name=alert_id,json=alertId,proto3" json:"alert_id,omitempty"`
}

func (x *GetAlertRequest) Reset() {
	*x = GetAlertRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAlertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAlertRequest) ProtoMessage() {}

func (x *GetAlertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAlertRequest.ProtoReflect.Descriptor instead.
func (*GetAlertRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{10}
}

func (x *GetAlertRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *GetAlertRequest) GetAlertId() string {
	if x != nil {
		return x.AlertId
	}
	return ""
}

// A request to mark a specific alert for deletion.
type DeleteAlertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique identifier of the Google Workspace organization
	// account of the customer the alert is associated with.
	// Inferred from the caller identity if not provided.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The identifier of the alert to delete.
	AlertId string `protobuf:"bytes,2,opt,name=alert_id,json=alertId,proto3" json:"alert_id,omitempty"`
}

func (x *DeleteAlertRequest) Reset() {
	*x = DeleteAlertRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAlertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAlertRequest) ProtoMessage() {}

func (x *DeleteAlertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAlertRequest.ProtoReflect.Descriptor instead.
func (*DeleteAlertRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{11}
}

func (x *DeleteAlertRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *DeleteAlertRequest) GetAlertId() string {
	if x != nil {
		return x.AlertId
	}
	return ""
}

// A request to undelete a specific alert that was marked for deletion.
type UndeleteAlertRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique identifier of the Google Workspace organization
	// account of the customer the alert is associated with.
	// Inferred from the caller identity if not provided.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The identifier of the alert to undelete.
	AlertId string `protobuf:"bytes,2,opt,name=alert_id,json=alertId,proto3" json:"alert_id,omitempty"`
}

func (x *UndeleteAlertRequest) Reset() {
	*x = UndeleteAlertRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeleteAlertRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeleteAlertRequest) ProtoMessage() {}

func (x *UndeleteAlertRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeleteAlertRequest.ProtoReflect.Descriptor instead.
func (*UndeleteAlertRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{12}
}

func (x *UndeleteAlertRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *UndeleteAlertRequest) GetAlertId() string {
	if x != nil {
		return x.AlertId
	}
	return ""
}

// A request to create a new alert feedback.
type CreateAlertFeedbackRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique identifier of the Google Workspace organization
	// account of the customer the alert is associated with.
	// Inferred from the caller identity if not provided.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The identifier of the alert this feedback belongs to.
	AlertId string `protobuf:"bytes,2,opt,name=alert_id,json=alertId,proto3" json:"alert_id,omitempty"`
	// Required. The new alert feedback to create.
	Feedback *AlertFeedback `protobuf:"bytes,3,opt,name=feedback,proto3" json:"feedback,omitempty"`
}

func (x *CreateAlertFeedbackRequest) Reset() {
	*x = CreateAlertFeedbackRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAlertFeedbackRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAlertFeedbackRequest) ProtoMessage() {}

func (x *CreateAlertFeedbackRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAlertFeedbackRequest.ProtoReflect.Descriptor instead.
func (*CreateAlertFeedbackRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{13}
}

func (x *CreateAlertFeedbackRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *CreateAlertFeedbackRequest) GetAlertId() string {
	if x != nil {
		return x.AlertId
	}
	return ""
}

func (x *CreateAlertFeedbackRequest) GetFeedback() *AlertFeedback {
	if x != nil {
		return x.Feedback
	}
	return nil
}

// An alert feedback listing request.
type ListAlertFeedbackRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique identifier of the Google Workspace organization
	// account of the customer the alert feedback are associated with.
	// Inferred from the caller identity if not provided.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The alert identifier.
	// The "-" wildcard could be used to represent all alerts.
	AlertId string `protobuf:"bytes,2,opt,name=alert_id,json=alertId,proto3" json:"alert_id,omitempty"`
	// Optional. A query string for filtering alert feedback results.
	// For more details, see [Query
	// filters](https://developers.google.com/admin-sdk/alertcenter/guides/query-filters) and [Supported
	// query filter
	// fields](https://developers.google.com/admin-sdk/alertcenter/reference/filter-fields#alerts.feedback.list).
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListAlertFeedbackRequest) Reset() {
	*x = ListAlertFeedbackRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAlertFeedbackRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAlertFeedbackRequest) ProtoMessage() {}

func (x *ListAlertFeedbackRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAlertFeedbackRequest.ProtoReflect.Descriptor instead.
func (*ListAlertFeedbackRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{14}
}

func (x *ListAlertFeedbackRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *ListAlertFeedbackRequest) GetAlertId() string {
	if x != nil {
		return x.AlertId
	}
	return ""
}

func (x *ListAlertFeedbackRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for an alert feedback listing request.
type ListAlertFeedbackResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of alert feedback.
	// Feedback entries for each alert are ordered by creation time descending.
	Feedback []*AlertFeedback `protobuf:"bytes,1,rep,name=feedback,proto3" json:"feedback,omitempty"`
}

func (x *ListAlertFeedbackResponse) Reset() {
	*x = ListAlertFeedbackResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAlertFeedbackResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAlertFeedbackResponse) ProtoMessage() {}

func (x *ListAlertFeedbackResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAlertFeedbackResponse.ProtoReflect.Descriptor instead.
func (*ListAlertFeedbackResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{15}
}

func (x *ListAlertFeedbackResponse) GetFeedback() []*AlertFeedback {
	if x != nil {
		return x.Feedback
	}
	return nil
}

// Get the alert metadata.
type GetAlertMetadataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique identifier of the Google Workspace organization
	// account of the customer the alert metadata is associated with.
	// Inferred from the caller identity if not provided.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The identifier of the alert this metadata belongs to.
	AlertId string `protobuf:"bytes,2,opt,name=alert_id,json=alertId,proto3" json:"alert_id,omitempty"`
}

func (x *GetAlertMetadataRequest) Reset() {
	*x = GetAlertMetadataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAlertMetadataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAlertMetadataRequest) ProtoMessage() {}

func (x *GetAlertMetadataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAlertMetadataRequest.ProtoReflect.Descriptor instead.
func (*GetAlertMetadataRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{16}
}

func (x *GetAlertMetadataRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *GetAlertMetadataRequest) GetAlertId() string {
	if x != nil {
		return x.AlertId
	}
	return ""
}

// Get the customer level settings.
type GetSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique identifier of the Google Workspace organization
	// account of the customer the alert settings are associated with.
	// Inferred from the caller identity if not provided.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
}

func (x *GetSettingsRequest) Reset() {
	*x = GetSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSettingsRequest) ProtoMessage() {}

func (x *GetSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSettingsRequest.ProtoReflect.Descriptor instead.
func (*GetSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{17}
}

func (x *GetSettingsRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

// Update the customer level settings.
type UpdateSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique identifier of the Google Workspace organization
	// account of the customer the alert settings are associated with.
	// Inferred from the caller identity if not provided.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The customer settings to update.
	Settings *Settings `protobuf:"bytes,2,opt,name=settings,proto3" json:"settings,omitempty"`
}

func (x *UpdateSettingsRequest) Reset() {
	*x = UpdateSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSettingsRequest) ProtoMessage() {}

func (x *UpdateSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSettingsRequest.ProtoReflect.Descriptor instead.
func (*UpdateSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{18}
}

func (x *UpdateSettingsRequest) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *UpdateSettingsRequest) GetSettings() *Settings {
	if x != nil {
		return x.Settings
	}
	return nil
}

// Settings for callback notifications.
// For more details see [Google Workspace Alert
// Notification](https://developers.google.com/admin-sdk/alertcenter/guides/notifications).
type Settings_Notification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exactly one destination to be specified.
	//
	// Types that are assignable to Destination:
	//
	//	*Settings_Notification_CloudPubsubTopic_
	Destination isSettings_Notification_Destination `protobuf_oneof:"destination"`
}

func (x *Settings_Notification) Reset() {
	*x = Settings_Notification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Settings_Notification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Settings_Notification) ProtoMessage() {}

func (x *Settings_Notification) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Settings_Notification.ProtoReflect.Descriptor instead.
func (*Settings_Notification) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{3, 0}
}

func (m *Settings_Notification) GetDestination() isSettings_Notification_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *Settings_Notification) GetCloudPubsubTopic() *Settings_Notification_CloudPubsubTopic {
	if x, ok := x.GetDestination().(*Settings_Notification_CloudPubsubTopic_); ok {
		return x.CloudPubsubTopic
	}
	return nil
}

type isSettings_Notification_Destination interface {
	isSettings_Notification_Destination()
}

type Settings_Notification_CloudPubsubTopic_ struct {
	// A Google Cloud Pub/sub topic destination.
	CloudPubsubTopic *Settings_Notification_CloudPubsubTopic `protobuf:"bytes,1,opt,name=cloud_pubsub_topic,json=cloudPubsubTopic,proto3,oneof"`
}

func (*Settings_Notification_CloudPubsubTopic_) isSettings_Notification_Destination() {}

// A reference to a Cloud Pubsub topic.
//
// To register for notifications, the owner of the topic must grant
// `alerts-api-push-notifications@system.gserviceaccount.com` the
//
//	`projects.topics.publish` permission.
type Settings_Notification_CloudPubsubTopic struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `name` field of a Cloud Pubsub [Topic]
	// (https://cloud.google.com/pubsub/docs/reference/rest/v1/projects.topics#Topic).
	TopicName string `protobuf:"bytes,1,opt,name=topic_name,json=topicName,proto3" json:"topic_name,omitempty"`
	// Optional. The format of the payload that would be sent.
	// If not specified the format will be JSON.
	PayloadFormat Settings_Notification_PayloadFormat `protobuf:"varint,2,opt,name=payload_format,json=payloadFormat,proto3,enum=google.apps.alertcenter.v1beta1.Settings_Notification_PayloadFormat" json:"payload_format,omitempty"`
}

func (x *Settings_Notification_CloudPubsubTopic) Reset() {
	*x = Settings_Notification_CloudPubsubTopic{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Settings_Notification_CloudPubsubTopic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Settings_Notification_CloudPubsubTopic) ProtoMessage() {}

func (x *Settings_Notification_CloudPubsubTopic) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Settings_Notification_CloudPubsubTopic.ProtoReflect.Descriptor instead.
func (*Settings_Notification_CloudPubsubTopic) Descriptor() ([]byte, []int) {
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP(), []int{3, 0, 0}
}

func (x *Settings_Notification_CloudPubsubTopic) GetTopicName() string {
	if x != nil {
		return x.TopicName
	}
	return ""
}

func (x *Settings_Notification_CloudPubsubTopic) GetPayloadFormat() Settings_Notification_PayloadFormat {
	if x != nil {
		return x.PayloadFormat
	}
	return Settings_Notification_PAYLOAD_FORMAT_UNSPECIFIED
}

var File_google_apps_alertcenter_v1beta1_alertcenter_proto protoreflect.FileDescriptor

var file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x61, 0x6c,
	0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65,
	0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc8, 0x04,
	0x0a, 0x05, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x61, 0x6c, 0x65, 0x72,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x6c, 0x65, 0x72,
	0x74, 0x49, 0x64, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x28,
	0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41,
	0x6e, 0x79, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x47, 0x0a, 0x20, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x6e, 0x76, 0x65, 0x73, 0x74, 0x69, 0x67, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x1d, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x76, 0x65,
	0x73, 0x74, 0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6f, 0x6c, 0x4c, 0x69, 0x6e,
	0x6b, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x12, 0x4a, 0x0a, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x6c, 0x65, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x87, 0x02, 0x0a, 0x0d, 0x41, 0x6c, 0x65,
	0x72, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x61,
	0x6c, 0x65, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61,
	0x6c, 0x65, 0x72, 0x74, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61,
	0x63, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x66, 0x65, 0x65,
	0x64, 0x62, 0x61, 0x63, 0x6b, 0x49, 0x64, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61,
	0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x6d, 0x61,
	0x69, 0x6c, 0x22, 0xec, 0x01, 0x0a, 0x0d, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x49, 0x64,
	0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x61, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x65, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x61, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x65, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x12, 0x0a,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x22, 0xdd, 0x03, 0x0a, 0x08, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x5c,
	0x0a, 0x0d, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x6e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xf2, 0x02, 0x0a,
	0x0c, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x77, 0x0a,
	0x12, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f, 0x74, 0x6f,
	0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x54, 0x6f, 0x70,
	0x69, 0x63, 0x48, 0x00, 0x52, 0x10, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x50, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x1a, 0x9e, 0x01, 0x0a, 0x10, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x1d, 0x0a, 0x0a, 0x74,
	0x6f, 0x70, 0x69, 0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x6b, 0x0a, 0x0e, 0x70, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x4e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x0d, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x39, 0x0a, 0x0d, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x41, 0x59, 0x4c,
	0x4f, 0x41, 0x44, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4a, 0x53, 0x4f, 0x4e,
	0x10, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x56, 0x0a, 0x18, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a,
	0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x19,
	0x0a, 0x08, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x07, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x49, 0x64, 0x22, 0xa5, 0x02, 0x0a, 0x19, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x75, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x5f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0f, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x41, 0x6c, 0x65, 0x72, 0x74,
	0x49, 0x64, 0x73, 0x12, 0x81, 0x01, 0x0a, 0x13, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x61,
	0x6c, 0x65, 0x72, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41,
	0x6c, 0x65, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x46, 0x61,
	0x69, 0x6c, 0x65, 0x64, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x11, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x41, 0x6c, 0x65, 0x72,
	0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0x58, 0x0a, 0x16, 0x46, 0x61, 0x69, 0x6c, 0x65,
	0x64, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x28, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x58, 0x0a, 0x1a, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1f, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x19, 0x0a, 0x08, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x07, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x49, 0x64, 0x22, 0xa9, 0x02, 0x0a, 0x1b,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x65,
	0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x73,
	0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x41,
	0x6c, 0x65, 0x72, 0x74, 0x49, 0x64, 0x73, 0x12, 0x83, 0x01, 0x0a, 0x13, 0x66, 0x61, 0x69, 0x6c,
	0x65, 0x64, 0x5f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x6e, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x11, 0x66, 0x61, 0x69, 0x6c,
	0x65, 0x64, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0x58, 0x0a,
	0x16, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x28, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xa3, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a,
	0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x7c, 0x0a,
	0x12, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x06, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x52, 0x06, 0x61, 0x6c, 0x65,
	0x72, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x4d, 0x0a, 0x0f, 0x47,
	0x65, 0x74, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f,
	0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x19, 0x0a, 0x08, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x49, 0x64, 0x22, 0x50, 0x0a, 0x12, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x19, 0x0a, 0x08, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x49, 0x64, 0x22, 0x52, 0x0a, 0x14,
	0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x49, 0x64,
	0x22, 0xa4, 0x01, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6c, 0x65, 0x72, 0x74,
	0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1f, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64,
	0x12, 0x19, 0x0a, 0x08, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x49, 0x64, 0x12, 0x4a, 0x0a, 0x08, 0x66,
	0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72,
	0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x6c, 0x65, 0x72, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x08, 0x66,
	0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x22, 0x6e, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x6c, 0x65, 0x72, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x49, 0x64, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x67, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x6c, 0x65, 0x72, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x08, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x46, 0x65,
	0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x08, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b,
	0x22, 0x55, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08,
	0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x61, 0x6c, 0x65, 0x72, 0x74, 0x49, 0x64, 0x22, 0x35, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a,
	0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x22, 0x7f,
	0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x45, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2a,
	0x6e, 0x0a, 0x11, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x41, 0x4c, 0x45, 0x52, 0x54, 0x5f, 0x46, 0x45,
	0x45, 0x44, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x4e, 0x4f, 0x54,
	0x5f, 0x55, 0x53, 0x45, 0x46, 0x55, 0x4c, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x4f, 0x4d,
	0x45, 0x57, 0x48, 0x41, 0x54, 0x5f, 0x55, 0x53, 0x45, 0x46, 0x55, 0x4c, 0x10, 0x02, 0x12, 0x0f,
	0x0a, 0x0b, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x55, 0x53, 0x45, 0x46, 0x55, 0x4c, 0x10, 0x03, 0x32,
	0xd8, 0x0e, 0x0a, 0x12, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x8e, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x6c, 0x65, 0x72, 0x74, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6c, 0x65, 0x72,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x17,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x11, 0x12, 0x0f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x12, 0x88, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x41,
	0x6c, 0x65, 0x72, 0x74, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x22, 0x22,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1c, 0x12, 0x1a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x69,
	0x64, 0x7d, 0x12, 0x7e, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x65, 0x72,
	0x74, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x22,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1c, 0x2a, 0x1a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x69,
	0x64, 0x7d, 0x12, 0x9e, 0x01, 0x0a, 0x0d, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41,
	0x6c, 0x65, 0x72, 0x74, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41,
	0x6c, 0x65, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6c,
	0x65, 0x72, 0x74, 0x22, 0x2e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x28, 0x22, 0x23, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x6c,
	0x65, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x3a, 0x75, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x3a, 0x01, 0x2a, 0x12, 0xb9, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6c,
	0x65, 0x72, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74,
	0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x22, 0x35, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f,
	0x22, 0x23, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x6c, 0x65, 0x72, 0x74,
	0x73, 0x2f, 0x7b, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x66, 0x65, 0x65,
	0x64, 0x62, 0x61, 0x63, 0x6b, 0x3a, 0x08, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x12,
	0xb7, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x46, 0x65, 0x65,
	0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6c, 0x65, 0x72,
	0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x61,
	0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x46, 0x65, 0x65, 0x64,
	0x62, 0x61, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x25, 0x12, 0x23, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61,
	0x6c, 0x65, 0x72, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0xa9, 0x01, 0x0a, 0x10, 0x47, 0x65,
	0x74, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65,
	0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x2b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25,
	0x12, 0x23, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x6c, 0x65, 0x72, 0x74,
	0x73, 0x2f, 0x7b, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x88, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x19, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x13, 0x12, 0x11, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x98, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x23, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1d, 0x32, 0x11,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x3a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0xb2, 0x01, 0x0a, 0x11,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x65, 0x72, 0x74,
	0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41,
	0x6c, 0x65, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x26, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x20,
	0x22, 0x1b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x6c, 0x65, 0x72, 0x74,
	0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x3a, 0x01, 0x2a,
	0x12, 0xba, 0x01, 0x0a, 0x13, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x6e, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x28, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x22, 0x22, 0x1d, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x3a, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x3a, 0x01, 0x2a, 0x1a, 0x4b, 0xca,
	0x41, 0x1a, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2b, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x61,
	0x70, 0x70, 0x73, 0x2e, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x73, 0x42, 0xf5, 0x01, 0x0a, 0x23, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x61,
	0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x42, 0x10, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x70,
	0x70, 0x73, 0x2f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0xa2, 0x02, 0x04, 0x47, 0x41, 0x49, 0x43, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x41, 0x70, 0x70, 0x73, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x70, 0x70, 0x73, 0x5c, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x43,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x70, 0x70, 0x73, 0x3a, 0x3a, 0x41, 0x6c,
	0x65, 0x72, 0x74, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescOnce sync.Once
	file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescData = file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDesc
)

func file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescGZIP() []byte {
	file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescOnce.Do(func() {
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescData)
	})
	return file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDescData
}

var file_google_apps_alertcenter_v1beta1_alertcenter_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_google_apps_alertcenter_v1beta1_alertcenter_proto_goTypes = []interface{}{
	(AlertFeedbackType)(0),                         // 0: google.apps.alertcenter.v1beta1.AlertFeedbackType
	(Settings_Notification_PayloadFormat)(0),       // 1: google.apps.alertcenter.v1beta1.Settings.Notification.PayloadFormat
	(*Alert)(nil),                                  // 2: google.apps.alertcenter.v1beta1.Alert
	(*AlertFeedback)(nil),                          // 3: google.apps.alertcenter.v1beta1.AlertFeedback
	(*AlertMetadata)(nil),                          // 4: google.apps.alertcenter.v1beta1.AlertMetadata
	(*Settings)(nil),                               // 5: google.apps.alertcenter.v1beta1.Settings
	(*BatchDeleteAlertsRequest)(nil),               // 6: google.apps.alertcenter.v1beta1.BatchDeleteAlertsRequest
	(*BatchDeleteAlertsResponse)(nil),              // 7: google.apps.alertcenter.v1beta1.BatchDeleteAlertsResponse
	(*BatchUndeleteAlertsRequest)(nil),             // 8: google.apps.alertcenter.v1beta1.BatchUndeleteAlertsRequest
	(*BatchUndeleteAlertsResponse)(nil),            // 9: google.apps.alertcenter.v1beta1.BatchUndeleteAlertsResponse
	(*ListAlertsRequest)(nil),                      // 10: google.apps.alertcenter.v1beta1.ListAlertsRequest
	(*ListAlertsResponse)(nil),                     // 11: google.apps.alertcenter.v1beta1.ListAlertsResponse
	(*GetAlertRequest)(nil),                        // 12: google.apps.alertcenter.v1beta1.GetAlertRequest
	(*DeleteAlertRequest)(nil),                     // 13: google.apps.alertcenter.v1beta1.DeleteAlertRequest
	(*UndeleteAlertRequest)(nil),                   // 14: google.apps.alertcenter.v1beta1.UndeleteAlertRequest
	(*CreateAlertFeedbackRequest)(nil),             // 15: google.apps.alertcenter.v1beta1.CreateAlertFeedbackRequest
	(*ListAlertFeedbackRequest)(nil),               // 16: google.apps.alertcenter.v1beta1.ListAlertFeedbackRequest
	(*ListAlertFeedbackResponse)(nil),              // 17: google.apps.alertcenter.v1beta1.ListAlertFeedbackResponse
	(*GetAlertMetadataRequest)(nil),                // 18: google.apps.alertcenter.v1beta1.GetAlertMetadataRequest
	(*GetSettingsRequest)(nil),                     // 19: google.apps.alertcenter.v1beta1.GetSettingsRequest
	(*UpdateSettingsRequest)(nil),                  // 20: google.apps.alertcenter.v1beta1.UpdateSettingsRequest
	(*Settings_Notification)(nil),                  // 21: google.apps.alertcenter.v1beta1.Settings.Notification
	(*Settings_Notification_CloudPubsubTopic)(nil), // 22: google.apps.alertcenter.v1beta1.Settings.Notification.CloudPubsubTopic
	nil,                           // 23: google.apps.alertcenter.v1beta1.BatchDeleteAlertsResponse.FailedAlertStatusEntry
	nil,                           // 24: google.apps.alertcenter.v1beta1.BatchUndeleteAlertsResponse.FailedAlertStatusEntry
	(*timestamppb.Timestamp)(nil), // 25: google.protobuf.Timestamp
	(*anypb.Any)(nil),             // 26: google.protobuf.Any
	(*status.Status)(nil),         // 27: google.rpc.Status
	(*emptypb.Empty)(nil),         // 28: google.protobuf.Empty
}
var file_google_apps_alertcenter_v1beta1_alertcenter_proto_depIdxs = []int32{
	25, // 0: google.apps.alertcenter.v1beta1.Alert.create_time:type_name -> google.protobuf.Timestamp
	25, // 1: google.apps.alertcenter.v1beta1.Alert.start_time:type_name -> google.protobuf.Timestamp
	25, // 2: google.apps.alertcenter.v1beta1.Alert.end_time:type_name -> google.protobuf.Timestamp
	26, // 3: google.apps.alertcenter.v1beta1.Alert.data:type_name -> google.protobuf.Any
	4,  // 4: google.apps.alertcenter.v1beta1.Alert.metadata:type_name -> google.apps.alertcenter.v1beta1.AlertMetadata
	25, // 5: google.apps.alertcenter.v1beta1.Alert.update_time:type_name -> google.protobuf.Timestamp
	25, // 6: google.apps.alertcenter.v1beta1.AlertFeedback.create_time:type_name -> google.protobuf.Timestamp
	0,  // 7: google.apps.alertcenter.v1beta1.AlertFeedback.type:type_name -> google.apps.alertcenter.v1beta1.AlertFeedbackType
	25, // 8: google.apps.alertcenter.v1beta1.AlertMetadata.update_time:type_name -> google.protobuf.Timestamp
	21, // 9: google.apps.alertcenter.v1beta1.Settings.notifications:type_name -> google.apps.alertcenter.v1beta1.Settings.Notification
	23, // 10: google.apps.alertcenter.v1beta1.BatchDeleteAlertsResponse.failed_alert_status:type_name -> google.apps.alertcenter.v1beta1.BatchDeleteAlertsResponse.FailedAlertStatusEntry
	24, // 11: google.apps.alertcenter.v1beta1.BatchUndeleteAlertsResponse.failed_alert_status:type_name -> google.apps.alertcenter.v1beta1.BatchUndeleteAlertsResponse.FailedAlertStatusEntry
	2,  // 12: google.apps.alertcenter.v1beta1.ListAlertsResponse.alerts:type_name -> google.apps.alertcenter.v1beta1.Alert
	3,  // 13: google.apps.alertcenter.v1beta1.CreateAlertFeedbackRequest.feedback:type_name -> google.apps.alertcenter.v1beta1.AlertFeedback
	3,  // 14: google.apps.alertcenter.v1beta1.ListAlertFeedbackResponse.feedback:type_name -> google.apps.alertcenter.v1beta1.AlertFeedback
	5,  // 15: google.apps.alertcenter.v1beta1.UpdateSettingsRequest.settings:type_name -> google.apps.alertcenter.v1beta1.Settings
	22, // 16: google.apps.alertcenter.v1beta1.Settings.Notification.cloud_pubsub_topic:type_name -> google.apps.alertcenter.v1beta1.Settings.Notification.CloudPubsubTopic
	1,  // 17: google.apps.alertcenter.v1beta1.Settings.Notification.CloudPubsubTopic.payload_format:type_name -> google.apps.alertcenter.v1beta1.Settings.Notification.PayloadFormat
	27, // 18: google.apps.alertcenter.v1beta1.BatchDeleteAlertsResponse.FailedAlertStatusEntry.value:type_name -> google.rpc.Status
	27, // 19: google.apps.alertcenter.v1beta1.BatchUndeleteAlertsResponse.FailedAlertStatusEntry.value:type_name -> google.rpc.Status
	10, // 20: google.apps.alertcenter.v1beta1.AlertCenterService.ListAlerts:input_type -> google.apps.alertcenter.v1beta1.ListAlertsRequest
	12, // 21: google.apps.alertcenter.v1beta1.AlertCenterService.GetAlert:input_type -> google.apps.alertcenter.v1beta1.GetAlertRequest
	13, // 22: google.apps.alertcenter.v1beta1.AlertCenterService.DeleteAlert:input_type -> google.apps.alertcenter.v1beta1.DeleteAlertRequest
	14, // 23: google.apps.alertcenter.v1beta1.AlertCenterService.UndeleteAlert:input_type -> google.apps.alertcenter.v1beta1.UndeleteAlertRequest
	15, // 24: google.apps.alertcenter.v1beta1.AlertCenterService.CreateAlertFeedback:input_type -> google.apps.alertcenter.v1beta1.CreateAlertFeedbackRequest
	16, // 25: google.apps.alertcenter.v1beta1.AlertCenterService.ListAlertFeedback:input_type -> google.apps.alertcenter.v1beta1.ListAlertFeedbackRequest
	18, // 26: google.apps.alertcenter.v1beta1.AlertCenterService.GetAlertMetadata:input_type -> google.apps.alertcenter.v1beta1.GetAlertMetadataRequest
	19, // 27: google.apps.alertcenter.v1beta1.AlertCenterService.GetSettings:input_type -> google.apps.alertcenter.v1beta1.GetSettingsRequest
	20, // 28: google.apps.alertcenter.v1beta1.AlertCenterService.UpdateSettings:input_type -> google.apps.alertcenter.v1beta1.UpdateSettingsRequest
	6,  // 29: google.apps.alertcenter.v1beta1.AlertCenterService.BatchDeleteAlerts:input_type -> google.apps.alertcenter.v1beta1.BatchDeleteAlertsRequest
	8,  // 30: google.apps.alertcenter.v1beta1.AlertCenterService.BatchUndeleteAlerts:input_type -> google.apps.alertcenter.v1beta1.BatchUndeleteAlertsRequest
	11, // 31: google.apps.alertcenter.v1beta1.AlertCenterService.ListAlerts:output_type -> google.apps.alertcenter.v1beta1.ListAlertsResponse
	2,  // 32: google.apps.alertcenter.v1beta1.AlertCenterService.GetAlert:output_type -> google.apps.alertcenter.v1beta1.Alert
	28, // 33: google.apps.alertcenter.v1beta1.AlertCenterService.DeleteAlert:output_type -> google.protobuf.Empty
	2,  // 34: google.apps.alertcenter.v1beta1.AlertCenterService.UndeleteAlert:output_type -> google.apps.alertcenter.v1beta1.Alert
	3,  // 35: google.apps.alertcenter.v1beta1.AlertCenterService.CreateAlertFeedback:output_type -> google.apps.alertcenter.v1beta1.AlertFeedback
	17, // 36: google.apps.alertcenter.v1beta1.AlertCenterService.ListAlertFeedback:output_type -> google.apps.alertcenter.v1beta1.ListAlertFeedbackResponse
	4,  // 37: google.apps.alertcenter.v1beta1.AlertCenterService.GetAlertMetadata:output_type -> google.apps.alertcenter.v1beta1.AlertMetadata
	5,  // 38: google.apps.alertcenter.v1beta1.AlertCenterService.GetSettings:output_type -> google.apps.alertcenter.v1beta1.Settings
	5,  // 39: google.apps.alertcenter.v1beta1.AlertCenterService.UpdateSettings:output_type -> google.apps.alertcenter.v1beta1.Settings
	7,  // 40: google.apps.alertcenter.v1beta1.AlertCenterService.BatchDeleteAlerts:output_type -> google.apps.alertcenter.v1beta1.BatchDeleteAlertsResponse
	9,  // 41: google.apps.alertcenter.v1beta1.AlertCenterService.BatchUndeleteAlerts:output_type -> google.apps.alertcenter.v1beta1.BatchUndeleteAlertsResponse
	31, // [31:42] is the sub-list for method output_type
	20, // [20:31] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_google_apps_alertcenter_v1beta1_alertcenter_proto_init() }
func file_google_apps_alertcenter_v1beta1_alertcenter_proto_init() {
	if File_google_apps_alertcenter_v1beta1_alertcenter_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Alert); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AlertFeedback); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AlertMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Settings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchDeleteAlertsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchDeleteAlertsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUndeleteAlertsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchUndeleteAlertsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAlertsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAlertsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAlertRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAlertRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeleteAlertRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAlertFeedbackRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAlertFeedbackRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAlertFeedbackResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAlertMetadataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Settings_Notification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Settings_Notification_CloudPubsubTopic); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes[19].OneofWrappers = []interface{}{
		(*Settings_Notification_CloudPubsubTopic_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_apps_alertcenter_v1beta1_alertcenter_proto_goTypes,
		DependencyIndexes: file_google_apps_alertcenter_v1beta1_alertcenter_proto_depIdxs,
		EnumInfos:         file_google_apps_alertcenter_v1beta1_alertcenter_proto_enumTypes,
		MessageInfos:      file_google_apps_alertcenter_v1beta1_alertcenter_proto_msgTypes,
	}.Build()
	File_google_apps_alertcenter_v1beta1_alertcenter_proto = out.File
	file_google_apps_alertcenter_v1beta1_alertcenter_proto_rawDesc = nil
	file_google_apps_alertcenter_v1beta1_alertcenter_proto_goTypes = nil
	file_google_apps_alertcenter_v1beta1_alertcenter_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AlertCenterServiceClient is the client API for AlertCenterService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AlertCenterServiceClient interface {
	// Lists the alerts.
	ListAlerts(ctx context.Context, in *ListAlertsRequest, opts ...grpc.CallOption) (*ListAlertsResponse, error)
	// Gets the specified alert. Attempting to get a nonexistent alert returns
	// `NOT_FOUND` error.
	GetAlert(ctx context.Context, in *GetAlertRequest, opts ...grpc.CallOption) (*Alert, error)
	// Marks the specified alert for deletion. An alert that has been marked for
	// deletion is removed from Alert Center after 30 days.
	// Marking an alert for deletion has no effect on an alert which has
	// already been marked for deletion. Attempting to mark a nonexistent alert
	// for deletion results in a `NOT_FOUND` error.
	DeleteAlert(ctx context.Context, in *DeleteAlertRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Restores, or "undeletes", an alert that was marked for deletion within the
	// past 30 days. Attempting to undelete an alert which was marked for deletion
	// over 30 days ago (which has been removed from the Alert Center database) or
	// a nonexistent alert returns a `NOT_FOUND` error. Attempting to
	// undelete an alert which has not been marked for deletion has no effect.
	UndeleteAlert(ctx context.Context, in *UndeleteAlertRequest, opts ...grpc.CallOption) (*Alert, error)
	// Creates new feedback for an alert. Attempting to create a feedback for
	// a non-existent alert returns `NOT_FOUND` error. Attempting to create a
	// feedback for an alert that is marked for deletion returns
	// `FAILED_PRECONDITION' error.
	CreateAlertFeedback(ctx context.Context, in *CreateAlertFeedbackRequest, opts ...grpc.CallOption) (*AlertFeedback, error)
	// Lists all the feedback for an alert. Attempting to list feedbacks for
	// a non-existent alert returns `NOT_FOUND` error.
	ListAlertFeedback(ctx context.Context, in *ListAlertFeedbackRequest, opts ...grpc.CallOption) (*ListAlertFeedbackResponse, error)
	// Returns the metadata of an alert. Attempting to get metadata for
	// a non-existent alert returns `NOT_FOUND` error.
	GetAlertMetadata(ctx context.Context, in *GetAlertMetadataRequest, opts ...grpc.CallOption) (*AlertMetadata, error)
	// Returns customer-level settings.
	GetSettings(ctx context.Context, in *GetSettingsRequest, opts ...grpc.CallOption) (*Settings, error)
	// Updates the customer-level settings.
	UpdateSettings(ctx context.Context, in *UpdateSettingsRequest, opts ...grpc.CallOption) (*Settings, error)
	// Performs batch delete operation on alerts.
	BatchDeleteAlerts(ctx context.Context, in *BatchDeleteAlertsRequest, opts ...grpc.CallOption) (*BatchDeleteAlertsResponse, error)
	// Performs batch undelete operation on alerts.
	BatchUndeleteAlerts(ctx context.Context, in *BatchUndeleteAlertsRequest, opts ...grpc.CallOption) (*BatchUndeleteAlertsResponse, error)
}

type alertCenterServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAlertCenterServiceClient(cc grpc.ClientConnInterface) AlertCenterServiceClient {
	return &alertCenterServiceClient{cc}
}

func (c *alertCenterServiceClient) ListAlerts(ctx context.Context, in *ListAlertsRequest, opts ...grpc.CallOption) (*ListAlertsResponse, error) {
	out := new(ListAlertsResponse)
	err := c.cc.Invoke(ctx, "/google.apps.alertcenter.v1beta1.AlertCenterService/ListAlerts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *alertCenterServiceClient) GetAlert(ctx context.Context, in *GetAlertRequest, opts ...grpc.CallOption) (*Alert, error) {
	out := new(Alert)
	err := c.cc.Invoke(ctx, "/google.apps.alertcenter.v1beta1.AlertCenterService/GetAlert", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *alertCenterServiceClient) DeleteAlert(ctx context.Context, in *DeleteAlertRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.apps.alertcenter.v1beta1.AlertCenterService/DeleteAlert", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *alertCenterServiceClient) UndeleteAlert(ctx context.Context, in *UndeleteAlertRequest, opts ...grpc.CallOption) (*Alert, error) {
	out := new(Alert)
	err := c.cc.Invoke(ctx, "/google.apps.alertcenter.v1beta1.AlertCenterService/UndeleteAlert", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *alertCenterServiceClient) CreateAlertFeedback(ctx context.Context, in *CreateAlertFeedbackRequest, opts ...grpc.CallOption) (*AlertFeedback, error) {
	out := new(AlertFeedback)
	err := c.cc.Invoke(ctx, "/google.apps.alertcenter.v1beta1.AlertCenterService/CreateAlertFeedback", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *alertCenterServiceClient) ListAlertFeedback(ctx context.Context, in *ListAlertFeedbackRequest, opts ...grpc.CallOption) (*ListAlertFeedbackResponse, error) {
	out := new(ListAlertFeedbackResponse)
	err := c.cc.Invoke(ctx, "/google.apps.alertcenter.v1beta1.AlertCenterService/ListAlertFeedback", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *alertCenterServiceClient) GetAlertMetadata(ctx context.Context, in *GetAlertMetadataRequest, opts ...grpc.CallOption) (*AlertMetadata, error) {
	out := new(AlertMetadata)
	err := c.cc.Invoke(ctx, "/google.apps.alertcenter.v1beta1.AlertCenterService/GetAlertMetadata", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *alertCenterServiceClient) GetSettings(ctx context.Context, in *GetSettingsRequest, opts ...grpc.CallOption) (*Settings, error) {
	out := new(Settings)
	err := c.cc.Invoke(ctx, "/google.apps.alertcenter.v1beta1.AlertCenterService/GetSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *alertCenterServiceClient) UpdateSettings(ctx context.Context, in *UpdateSettingsRequest, opts ...grpc.CallOption) (*Settings, error) {
	out := new(Settings)
	err := c.cc.Invoke(ctx, "/google.apps.alertcenter.v1beta1.AlertCenterService/UpdateSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *alertCenterServiceClient) BatchDeleteAlerts(ctx context.Context, in *BatchDeleteAlertsRequest, opts ...grpc.CallOption) (*BatchDeleteAlertsResponse, error) {
	out := new(BatchDeleteAlertsResponse)
	err := c.cc.Invoke(ctx, "/google.apps.alertcenter.v1beta1.AlertCenterService/BatchDeleteAlerts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *alertCenterServiceClient) BatchUndeleteAlerts(ctx context.Context, in *BatchUndeleteAlertsRequest, opts ...grpc.CallOption) (*BatchUndeleteAlertsResponse, error) {
	out := new(BatchUndeleteAlertsResponse)
	err := c.cc.Invoke(ctx, "/google.apps.alertcenter.v1beta1.AlertCenterService/BatchUndeleteAlerts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AlertCenterServiceServer is the server API for AlertCenterService service.
type AlertCenterServiceServer interface {
	// Lists the alerts.
	ListAlerts(context.Context, *ListAlertsRequest) (*ListAlertsResponse, error)
	// Gets the specified alert. Attempting to get a nonexistent alert returns
	// `NOT_FOUND` error.
	GetAlert(context.Context, *GetAlertRequest) (*Alert, error)
	// Marks the specified alert for deletion. An alert that has been marked for
	// deletion is removed from Alert Center after 30 days.
	// Marking an alert for deletion has no effect on an alert which has
	// already been marked for deletion. Attempting to mark a nonexistent alert
	// for deletion results in a `NOT_FOUND` error.
	DeleteAlert(context.Context, *DeleteAlertRequest) (*emptypb.Empty, error)
	// Restores, or "undeletes", an alert that was marked for deletion within the
	// past 30 days. Attempting to undelete an alert which was marked for deletion
	// over 30 days ago (which has been removed from the Alert Center database) or
	// a nonexistent alert returns a `NOT_FOUND` error. Attempting to
	// undelete an alert which has not been marked for deletion has no effect.
	UndeleteAlert(context.Context, *UndeleteAlertRequest) (*Alert, error)
	// Creates new feedback for an alert. Attempting to create a feedback for
	// a non-existent alert returns `NOT_FOUND` error. Attempting to create a
	// feedback for an alert that is marked for deletion returns
	// `FAILED_PRECONDITION' error.
	CreateAlertFeedback(context.Context, *CreateAlertFeedbackRequest) (*AlertFeedback, error)
	// Lists all the feedback for an alert. Attempting to list feedbacks for
	// a non-existent alert returns `NOT_FOUND` error.
	ListAlertFeedback(context.Context, *ListAlertFeedbackRequest) (*ListAlertFeedbackResponse, error)
	// Returns the metadata of an alert. Attempting to get metadata for
	// a non-existent alert returns `NOT_FOUND` error.
	GetAlertMetadata(context.Context, *GetAlertMetadataRequest) (*AlertMetadata, error)
	// Returns customer-level settings.
	GetSettings(context.Context, *GetSettingsRequest) (*Settings, error)
	// Updates the customer-level settings.
	UpdateSettings(context.Context, *UpdateSettingsRequest) (*Settings, error)
	// Performs batch delete operation on alerts.
	BatchDeleteAlerts(context.Context, *BatchDeleteAlertsRequest) (*BatchDeleteAlertsResponse, error)
	// Performs batch undelete operation on alerts.
	BatchUndeleteAlerts(context.Context, *BatchUndeleteAlertsRequest) (*BatchUndeleteAlertsResponse, error)
}

// UnimplementedAlertCenterServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAlertCenterServiceServer struct {
}

func (*UnimplementedAlertCenterServiceServer) ListAlerts(context.Context, *ListAlertsRequest) (*ListAlertsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListAlerts not implemented")
}
func (*UnimplementedAlertCenterServiceServer) GetAlert(context.Context, *GetAlertRequest) (*Alert, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetAlert not implemented")
}
func (*UnimplementedAlertCenterServiceServer) DeleteAlert(context.Context, *DeleteAlertRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteAlert not implemented")
}
func (*UnimplementedAlertCenterServiceServer) UndeleteAlert(context.Context, *UndeleteAlertRequest) (*Alert, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UndeleteAlert not implemented")
}
func (*UnimplementedAlertCenterServiceServer) CreateAlertFeedback(context.Context, *CreateAlertFeedbackRequest) (*AlertFeedback, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateAlertFeedback not implemented")
}
func (*UnimplementedAlertCenterServiceServer) ListAlertFeedback(context.Context, *ListAlertFeedbackRequest) (*ListAlertFeedbackResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListAlertFeedback not implemented")
}
func (*UnimplementedAlertCenterServiceServer) GetAlertMetadata(context.Context, *GetAlertMetadataRequest) (*AlertMetadata, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetAlertMetadata not implemented")
}
func (*UnimplementedAlertCenterServiceServer) GetSettings(context.Context, *GetSettingsRequest) (*Settings, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetSettings not implemented")
}
func (*UnimplementedAlertCenterServiceServer) UpdateSettings(context.Context, *UpdateSettingsRequest) (*Settings, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateSettings not implemented")
}
func (*UnimplementedAlertCenterServiceServer) BatchDeleteAlerts(context.Context, *BatchDeleteAlertsRequest) (*BatchDeleteAlertsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchDeleteAlerts not implemented")
}
func (*UnimplementedAlertCenterServiceServer) BatchUndeleteAlerts(context.Context, *BatchUndeleteAlertsRequest) (*BatchUndeleteAlertsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchUndeleteAlerts not implemented")
}

func RegisterAlertCenterServiceServer(s *grpc.Server, srv AlertCenterServiceServer) {
	s.RegisterService(&_AlertCenterService_serviceDesc, srv)
}

func _AlertCenterService_ListAlerts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAlertsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlertCenterServiceServer).ListAlerts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.alertcenter.v1beta1.AlertCenterService/ListAlerts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlertCenterServiceServer).ListAlerts(ctx, req.(*ListAlertsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AlertCenterService_GetAlert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAlertRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlertCenterServiceServer).GetAlert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.alertcenter.v1beta1.AlertCenterService/GetAlert",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlertCenterServiceServer).GetAlert(ctx, req.(*GetAlertRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AlertCenterService_DeleteAlert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAlertRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlertCenterServiceServer).DeleteAlert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.alertcenter.v1beta1.AlertCenterService/DeleteAlert",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlertCenterServiceServer).DeleteAlert(ctx, req.(*DeleteAlertRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AlertCenterService_UndeleteAlert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteAlertRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlertCenterServiceServer).UndeleteAlert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.alertcenter.v1beta1.AlertCenterService/UndeleteAlert",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlertCenterServiceServer).UndeleteAlert(ctx, req.(*UndeleteAlertRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AlertCenterService_CreateAlertFeedback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAlertFeedbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlertCenterServiceServer).CreateAlertFeedback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.alertcenter.v1beta1.AlertCenterService/CreateAlertFeedback",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlertCenterServiceServer).CreateAlertFeedback(ctx, req.(*CreateAlertFeedbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AlertCenterService_ListAlertFeedback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAlertFeedbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlertCenterServiceServer).ListAlertFeedback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.alertcenter.v1beta1.AlertCenterService/ListAlertFeedback",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlertCenterServiceServer).ListAlertFeedback(ctx, req.(*ListAlertFeedbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AlertCenterService_GetAlertMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAlertMetadataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlertCenterServiceServer).GetAlertMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.alertcenter.v1beta1.AlertCenterService/GetAlertMetadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlertCenterServiceServer).GetAlertMetadata(ctx, req.(*GetAlertMetadataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AlertCenterService_GetSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlertCenterServiceServer).GetSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.alertcenter.v1beta1.AlertCenterService/GetSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlertCenterServiceServer).GetSettings(ctx, req.(*GetSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AlertCenterService_UpdateSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlertCenterServiceServer).UpdateSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.alertcenter.v1beta1.AlertCenterService/UpdateSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlertCenterServiceServer).UpdateSettings(ctx, req.(*UpdateSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AlertCenterService_BatchDeleteAlerts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteAlertsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlertCenterServiceServer).BatchDeleteAlerts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.alertcenter.v1beta1.AlertCenterService/BatchDeleteAlerts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlertCenterServiceServer).BatchDeleteAlerts(ctx, req.(*BatchDeleteAlertsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AlertCenterService_BatchUndeleteAlerts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUndeleteAlertsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AlertCenterServiceServer).BatchUndeleteAlerts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.apps.alertcenter.v1beta1.AlertCenterService/BatchUndeleteAlerts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AlertCenterServiceServer).BatchUndeleteAlerts(ctx, req.(*BatchUndeleteAlertsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AlertCenterService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.apps.alertcenter.v1beta1.AlertCenterService",
	HandlerType: (*AlertCenterServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListAlerts",
			Handler:    _AlertCenterService_ListAlerts_Handler,
		},
		{
			MethodName: "GetAlert",
			Handler:    _AlertCenterService_GetAlert_Handler,
		},
		{
			MethodName: "DeleteAlert",
			Handler:    _AlertCenterService_DeleteAlert_Handler,
		},
		{
			MethodName: "UndeleteAlert",
			Handler:    _AlertCenterService_UndeleteAlert_Handler,
		},
		{
			MethodName: "CreateAlertFeedback",
			Handler:    _AlertCenterService_CreateAlertFeedback_Handler,
		},
		{
			MethodName: "ListAlertFeedback",
			Handler:    _AlertCenterService_ListAlertFeedback_Handler,
		},
		{
			MethodName: "GetAlertMetadata",
			Handler:    _AlertCenterService_GetAlertMetadata_Handler,
		},
		{
			MethodName: "GetSettings",
			Handler:    _AlertCenterService_GetSettings_Handler,
		},
		{
			MethodName: "UpdateSettings",
			Handler:    _AlertCenterService_UpdateSettings_Handler,
		},
		{
			MethodName: "BatchDeleteAlerts",
			Handler:    _AlertCenterService_BatchDeleteAlerts_Handler,
		},
		{
			MethodName: "BatchUndeleteAlerts",
			Handler:    _AlertCenterService_BatchUndeleteAlerts_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/apps/alertcenter/v1beta1/alertcenter.proto",
}
