// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package billingconductor

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateAccounts = "AssociateAccounts"

// AssociateAccountsRequest generates a "aws/request.Request" representing the
// client's request for the AssociateAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateAccounts for more information on using the AssociateAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateAccountsRequest method.
//	req, resp := client.AssociateAccountsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/AssociateAccounts
func (c *BillingConductor) AssociateAccountsRequest(input *AssociateAccountsInput) (req *request.Request, output *AssociateAccountsOutput) {
	op := &request.Operation{
		Name:       opAssociateAccounts,
		HTTPMethod: "POST",
		HTTPPath:   "/associate-accounts",
	}

	if input == nil {
		input = &AssociateAccountsInput{}
	}

	output = &AssociateAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateAccounts API operation for AWSBillingConductor.
//
// Connects an array of account IDs in a consolidated billing family to a predefined
// billing group. The account IDs must be a part of the consolidated billing
// family during the current month, and not already associated with another
// billing group. The maximum number of accounts that can be associated in one
// call is 30.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation AssociateAccounts for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     You can cause an inconsistent state by updating or deleting a resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - ServiceLimitExceededException
//     The request would cause a service limit to exceed.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/AssociateAccounts
func (c *BillingConductor) AssociateAccounts(input *AssociateAccountsInput) (*AssociateAccountsOutput, error) {
	req, out := c.AssociateAccountsRequest(input)
	return out, req.Send()
}

// AssociateAccountsWithContext is the same as AssociateAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) AssociateAccountsWithContext(ctx aws.Context, input *AssociateAccountsInput, opts ...request.Option) (*AssociateAccountsOutput, error) {
	req, out := c.AssociateAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociatePricingRules = "AssociatePricingRules"

// AssociatePricingRulesRequest generates a "aws/request.Request" representing the
// client's request for the AssociatePricingRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociatePricingRules for more information on using the AssociatePricingRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociatePricingRulesRequest method.
//	req, resp := client.AssociatePricingRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/AssociatePricingRules
func (c *BillingConductor) AssociatePricingRulesRequest(input *AssociatePricingRulesInput) (req *request.Request, output *AssociatePricingRulesOutput) {
	op := &request.Operation{
		Name:       opAssociatePricingRules,
		HTTPMethod: "PUT",
		HTTPPath:   "/associate-pricing-rules",
	}

	if input == nil {
		input = &AssociatePricingRulesInput{}
	}

	output = &AssociatePricingRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociatePricingRules API operation for AWSBillingConductor.
//
// Connects an array of PricingRuleArns to a defined PricingPlan. The maximum
// number PricingRuleArn that can be associated in one call is 30.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation AssociatePricingRules for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     You can cause an inconsistent state by updating or deleting a resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - ServiceLimitExceededException
//     The request would cause a service limit to exceed.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/AssociatePricingRules
func (c *BillingConductor) AssociatePricingRules(input *AssociatePricingRulesInput) (*AssociatePricingRulesOutput, error) {
	req, out := c.AssociatePricingRulesRequest(input)
	return out, req.Send()
}

// AssociatePricingRulesWithContext is the same as AssociatePricingRules with the addition of
// the ability to pass a context and additional request options.
//
// See AssociatePricingRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) AssociatePricingRulesWithContext(ctx aws.Context, input *AssociatePricingRulesInput, opts ...request.Option) (*AssociatePricingRulesOutput, error) {
	req, out := c.AssociatePricingRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchAssociateResourcesToCustomLineItem = "BatchAssociateResourcesToCustomLineItem"

// BatchAssociateResourcesToCustomLineItemRequest generates a "aws/request.Request" representing the
// client's request for the BatchAssociateResourcesToCustomLineItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchAssociateResourcesToCustomLineItem for more information on using the BatchAssociateResourcesToCustomLineItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchAssociateResourcesToCustomLineItemRequest method.
//	req, resp := client.BatchAssociateResourcesToCustomLineItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/BatchAssociateResourcesToCustomLineItem
func (c *BillingConductor) BatchAssociateResourcesToCustomLineItemRequest(input *BatchAssociateResourcesToCustomLineItemInput) (req *request.Request, output *BatchAssociateResourcesToCustomLineItemOutput) {
	op := &request.Operation{
		Name:       opBatchAssociateResourcesToCustomLineItem,
		HTTPMethod: "PUT",
		HTTPPath:   "/batch-associate-resources-to-custom-line-item",
	}

	if input == nil {
		input = &BatchAssociateResourcesToCustomLineItemInput{}
	}

	output = &BatchAssociateResourcesToCustomLineItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchAssociateResourcesToCustomLineItem API operation for AWSBillingConductor.
//
// Associates a batch of resources to a percentage custom line item.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation BatchAssociateResourcesToCustomLineItem for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     You can cause an inconsistent state by updating or deleting a resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - ServiceLimitExceededException
//     The request would cause a service limit to exceed.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/BatchAssociateResourcesToCustomLineItem
func (c *BillingConductor) BatchAssociateResourcesToCustomLineItem(input *BatchAssociateResourcesToCustomLineItemInput) (*BatchAssociateResourcesToCustomLineItemOutput, error) {
	req, out := c.BatchAssociateResourcesToCustomLineItemRequest(input)
	return out, req.Send()
}

// BatchAssociateResourcesToCustomLineItemWithContext is the same as BatchAssociateResourcesToCustomLineItem with the addition of
// the ability to pass a context and additional request options.
//
// See BatchAssociateResourcesToCustomLineItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) BatchAssociateResourcesToCustomLineItemWithContext(ctx aws.Context, input *BatchAssociateResourcesToCustomLineItemInput, opts ...request.Option) (*BatchAssociateResourcesToCustomLineItemOutput, error) {
	req, out := c.BatchAssociateResourcesToCustomLineItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDisassociateResourcesFromCustomLineItem = "BatchDisassociateResourcesFromCustomLineItem"

// BatchDisassociateResourcesFromCustomLineItemRequest generates a "aws/request.Request" representing the
// client's request for the BatchDisassociateResourcesFromCustomLineItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDisassociateResourcesFromCustomLineItem for more information on using the BatchDisassociateResourcesFromCustomLineItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchDisassociateResourcesFromCustomLineItemRequest method.
//	req, resp := client.BatchDisassociateResourcesFromCustomLineItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/BatchDisassociateResourcesFromCustomLineItem
func (c *BillingConductor) BatchDisassociateResourcesFromCustomLineItemRequest(input *BatchDisassociateResourcesFromCustomLineItemInput) (req *request.Request, output *BatchDisassociateResourcesFromCustomLineItemOutput) {
	op := &request.Operation{
		Name:       opBatchDisassociateResourcesFromCustomLineItem,
		HTTPMethod: "PUT",
		HTTPPath:   "/batch-disassociate-resources-from-custom-line-item",
	}

	if input == nil {
		input = &BatchDisassociateResourcesFromCustomLineItemInput{}
	}

	output = &BatchDisassociateResourcesFromCustomLineItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDisassociateResourcesFromCustomLineItem API operation for AWSBillingConductor.
//
// Disassociates a batch of resources from a percentage custom line item.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation BatchDisassociateResourcesFromCustomLineItem for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     You can cause an inconsistent state by updating or deleting a resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/BatchDisassociateResourcesFromCustomLineItem
func (c *BillingConductor) BatchDisassociateResourcesFromCustomLineItem(input *BatchDisassociateResourcesFromCustomLineItemInput) (*BatchDisassociateResourcesFromCustomLineItemOutput, error) {
	req, out := c.BatchDisassociateResourcesFromCustomLineItemRequest(input)
	return out, req.Send()
}

// BatchDisassociateResourcesFromCustomLineItemWithContext is the same as BatchDisassociateResourcesFromCustomLineItem with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDisassociateResourcesFromCustomLineItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) BatchDisassociateResourcesFromCustomLineItemWithContext(ctx aws.Context, input *BatchDisassociateResourcesFromCustomLineItemInput, opts ...request.Option) (*BatchDisassociateResourcesFromCustomLineItemOutput, error) {
	req, out := c.BatchDisassociateResourcesFromCustomLineItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBillingGroup = "CreateBillingGroup"

// CreateBillingGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateBillingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBillingGroup for more information on using the CreateBillingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBillingGroupRequest method.
//	req, resp := client.CreateBillingGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreateBillingGroup
func (c *BillingConductor) CreateBillingGroupRequest(input *CreateBillingGroupInput) (req *request.Request, output *CreateBillingGroupOutput) {
	op := &request.Operation{
		Name:       opCreateBillingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/create-billing-group",
	}

	if input == nil {
		input = &CreateBillingGroupInput{}
	}

	output = &CreateBillingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBillingGroup API operation for AWSBillingConductor.
//
// Creates a billing group that resembles a consolidated billing family that
// Amazon Web Services charges, based off of the predefined pricing plan computation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation CreateBillingGroup for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     You can cause an inconsistent state by updating or deleting a resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - ServiceLimitExceededException
//     The request would cause a service limit to exceed.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreateBillingGroup
func (c *BillingConductor) CreateBillingGroup(input *CreateBillingGroupInput) (*CreateBillingGroupOutput, error) {
	req, out := c.CreateBillingGroupRequest(input)
	return out, req.Send()
}

// CreateBillingGroupWithContext is the same as CreateBillingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBillingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) CreateBillingGroupWithContext(ctx aws.Context, input *CreateBillingGroupInput, opts ...request.Option) (*CreateBillingGroupOutput, error) {
	req, out := c.CreateBillingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomLineItem = "CreateCustomLineItem"

// CreateCustomLineItemRequest generates a "aws/request.Request" representing the
// client's request for the CreateCustomLineItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCustomLineItem for more information on using the CreateCustomLineItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCustomLineItemRequest method.
//	req, resp := client.CreateCustomLineItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreateCustomLineItem
func (c *BillingConductor) CreateCustomLineItemRequest(input *CreateCustomLineItemInput) (req *request.Request, output *CreateCustomLineItemOutput) {
	op := &request.Operation{
		Name:       opCreateCustomLineItem,
		HTTPMethod: "POST",
		HTTPPath:   "/create-custom-line-item",
	}

	if input == nil {
		input = &CreateCustomLineItemInput{}
	}

	output = &CreateCustomLineItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCustomLineItem API operation for AWSBillingConductor.
//
// Creates a custom line item that can be used to create a one-time fixed charge
// that can be applied to a single billing group for the current or previous
// billing period. The one-time fixed charge is either a fee or discount.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation CreateCustomLineItem for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     You can cause an inconsistent state by updating or deleting a resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - ServiceLimitExceededException
//     The request would cause a service limit to exceed.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreateCustomLineItem
func (c *BillingConductor) CreateCustomLineItem(input *CreateCustomLineItemInput) (*CreateCustomLineItemOutput, error) {
	req, out := c.CreateCustomLineItemRequest(input)
	return out, req.Send()
}

// CreateCustomLineItemWithContext is the same as CreateCustomLineItem with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomLineItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) CreateCustomLineItemWithContext(ctx aws.Context, input *CreateCustomLineItemInput, opts ...request.Option) (*CreateCustomLineItemOutput, error) {
	req, out := c.CreateCustomLineItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePricingPlan = "CreatePricingPlan"

// CreatePricingPlanRequest generates a "aws/request.Request" representing the
// client's request for the CreatePricingPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePricingPlan for more information on using the CreatePricingPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePricingPlanRequest method.
//	req, resp := client.CreatePricingPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreatePricingPlan
func (c *BillingConductor) CreatePricingPlanRequest(input *CreatePricingPlanInput) (req *request.Request, output *CreatePricingPlanOutput) {
	op := &request.Operation{
		Name:       opCreatePricingPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/create-pricing-plan",
	}

	if input == nil {
		input = &CreatePricingPlanInput{}
	}

	output = &CreatePricingPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePricingPlan API operation for AWSBillingConductor.
//
// Creates a pricing plan that is used for computing Amazon Web Services charges
// for billing groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation CreatePricingPlan for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     You can cause an inconsistent state by updating or deleting a resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - ServiceLimitExceededException
//     The request would cause a service limit to exceed.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreatePricingPlan
func (c *BillingConductor) CreatePricingPlan(input *CreatePricingPlanInput) (*CreatePricingPlanOutput, error) {
	req, out := c.CreatePricingPlanRequest(input)
	return out, req.Send()
}

// CreatePricingPlanWithContext is the same as CreatePricingPlan with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePricingPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) CreatePricingPlanWithContext(ctx aws.Context, input *CreatePricingPlanInput, opts ...request.Option) (*CreatePricingPlanOutput, error) {
	req, out := c.CreatePricingPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePricingRule = "CreatePricingRule"

// CreatePricingRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreatePricingRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePricingRule for more information on using the CreatePricingRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePricingRuleRequest method.
//	req, resp := client.CreatePricingRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreatePricingRule
func (c *BillingConductor) CreatePricingRuleRequest(input *CreatePricingRuleInput) (req *request.Request, output *CreatePricingRuleOutput) {
	op := &request.Operation{
		Name:       opCreatePricingRule,
		HTTPMethod: "POST",
		HTTPPath:   "/create-pricing-rule",
	}

	if input == nil {
		input = &CreatePricingRuleInput{}
	}

	output = &CreatePricingRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePricingRule API operation for AWSBillingConductor.
//
// Creates a pricing rule can be associated to a pricing plan, or a set of pricing
// plans.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation CreatePricingRule for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     You can cause an inconsistent state by updating or deleting a resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - ServiceLimitExceededException
//     The request would cause a service limit to exceed.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreatePricingRule
func (c *BillingConductor) CreatePricingRule(input *CreatePricingRuleInput) (*CreatePricingRuleOutput, error) {
	req, out := c.CreatePricingRuleRequest(input)
	return out, req.Send()
}

// CreatePricingRuleWithContext is the same as CreatePricingRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePricingRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) CreatePricingRuleWithContext(ctx aws.Context, input *CreatePricingRuleInput, opts ...request.Option) (*CreatePricingRuleOutput, error) {
	req, out := c.CreatePricingRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBillingGroup = "DeleteBillingGroup"

// DeleteBillingGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBillingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBillingGroup for more information on using the DeleteBillingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBillingGroupRequest method.
//	req, resp := client.DeleteBillingGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeleteBillingGroup
func (c *BillingConductor) DeleteBillingGroupRequest(input *DeleteBillingGroupInput) (req *request.Request, output *DeleteBillingGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteBillingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-billing-group",
	}

	if input == nil {
		input = &DeleteBillingGroupInput{}
	}

	output = &DeleteBillingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBillingGroup API operation for AWSBillingConductor.
//
// Deletes a billing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation DeleteBillingGroup for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeleteBillingGroup
func (c *BillingConductor) DeleteBillingGroup(input *DeleteBillingGroupInput) (*DeleteBillingGroupOutput, error) {
	req, out := c.DeleteBillingGroupRequest(input)
	return out, req.Send()
}

// DeleteBillingGroupWithContext is the same as DeleteBillingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBillingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) DeleteBillingGroupWithContext(ctx aws.Context, input *DeleteBillingGroupInput, opts ...request.Option) (*DeleteBillingGroupOutput, error) {
	req, out := c.DeleteBillingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomLineItem = "DeleteCustomLineItem"

// DeleteCustomLineItemRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomLineItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomLineItem for more information on using the DeleteCustomLineItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCustomLineItemRequest method.
//	req, resp := client.DeleteCustomLineItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeleteCustomLineItem
func (c *BillingConductor) DeleteCustomLineItemRequest(input *DeleteCustomLineItemInput) (req *request.Request, output *DeleteCustomLineItemOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomLineItem,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-custom-line-item",
	}

	if input == nil {
		input = &DeleteCustomLineItemInput{}
	}

	output = &DeleteCustomLineItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCustomLineItem API operation for AWSBillingConductor.
//
// Deletes the custom line item identified by the given ARN in the current,
// or previous billing period.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation DeleteCustomLineItem for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     You can cause an inconsistent state by updating or deleting a resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeleteCustomLineItem
func (c *BillingConductor) DeleteCustomLineItem(input *DeleteCustomLineItemInput) (*DeleteCustomLineItemOutput, error) {
	req, out := c.DeleteCustomLineItemRequest(input)
	return out, req.Send()
}

// DeleteCustomLineItemWithContext is the same as DeleteCustomLineItem with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomLineItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) DeleteCustomLineItemWithContext(ctx aws.Context, input *DeleteCustomLineItemInput, opts ...request.Option) (*DeleteCustomLineItemOutput, error) {
	req, out := c.DeleteCustomLineItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePricingPlan = "DeletePricingPlan"

// DeletePricingPlanRequest generates a "aws/request.Request" representing the
// client's request for the DeletePricingPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePricingPlan for more information on using the DeletePricingPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePricingPlanRequest method.
//	req, resp := client.DeletePricingPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeletePricingPlan
func (c *BillingConductor) DeletePricingPlanRequest(input *DeletePricingPlanInput) (req *request.Request, output *DeletePricingPlanOutput) {
	op := &request.Operation{
		Name:       opDeletePricingPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-pricing-plan",
	}

	if input == nil {
		input = &DeletePricingPlanInput{}
	}

	output = &DeletePricingPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePricingPlan API operation for AWSBillingConductor.
//
// Deletes a pricing plan. The pricing plan must not be associated with any
// billing groups to delete successfully.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation DeletePricingPlan for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     You can cause an inconsistent state by updating or deleting a resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeletePricingPlan
func (c *BillingConductor) DeletePricingPlan(input *DeletePricingPlanInput) (*DeletePricingPlanOutput, error) {
	req, out := c.DeletePricingPlanRequest(input)
	return out, req.Send()
}

// DeletePricingPlanWithContext is the same as DeletePricingPlan with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePricingPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) DeletePricingPlanWithContext(ctx aws.Context, input *DeletePricingPlanInput, opts ...request.Option) (*DeletePricingPlanOutput, error) {
	req, out := c.DeletePricingPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePricingRule = "DeletePricingRule"

// DeletePricingRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeletePricingRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePricingRule for more information on using the DeletePricingRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePricingRuleRequest method.
//	req, resp := client.DeletePricingRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeletePricingRule
func (c *BillingConductor) DeletePricingRuleRequest(input *DeletePricingRuleInput) (req *request.Request, output *DeletePricingRuleOutput) {
	op := &request.Operation{
		Name:       opDeletePricingRule,
		HTTPMethod: "POST",
		HTTPPath:   "/delete-pricing-rule",
	}

	if input == nil {
		input = &DeletePricingRuleInput{}
	}

	output = &DeletePricingRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePricingRule API operation for AWSBillingConductor.
//
// Deletes the pricing rule that's identified by the input Amazon Resource Name
// (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation DeletePricingRule for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     You can cause an inconsistent state by updating or deleting a resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeletePricingRule
func (c *BillingConductor) DeletePricingRule(input *DeletePricingRuleInput) (*DeletePricingRuleOutput, error) {
	req, out := c.DeletePricingRuleRequest(input)
	return out, req.Send()
}

// DeletePricingRuleWithContext is the same as DeletePricingRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePricingRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) DeletePricingRuleWithContext(ctx aws.Context, input *DeletePricingRuleInput, opts ...request.Option) (*DeletePricingRuleOutput, error) {
	req, out := c.DeletePricingRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateAccounts = "DisassociateAccounts"

// DisassociateAccountsRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateAccounts for more information on using the DisassociateAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateAccountsRequest method.
//	req, resp := client.DisassociateAccountsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DisassociateAccounts
func (c *BillingConductor) DisassociateAccountsRequest(input *DisassociateAccountsInput) (req *request.Request, output *DisassociateAccountsOutput) {
	op := &request.Operation{
		Name:       opDisassociateAccounts,
		HTTPMethod: "POST",
		HTTPPath:   "/disassociate-accounts",
	}

	if input == nil {
		input = &DisassociateAccountsInput{}
	}

	output = &DisassociateAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateAccounts API operation for AWSBillingConductor.
//
// Removes the specified list of account IDs from the given billing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation DisassociateAccounts for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     You can cause an inconsistent state by updating or deleting a resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DisassociateAccounts
func (c *BillingConductor) DisassociateAccounts(input *DisassociateAccountsInput) (*DisassociateAccountsOutput, error) {
	req, out := c.DisassociateAccountsRequest(input)
	return out, req.Send()
}

// DisassociateAccountsWithContext is the same as DisassociateAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) DisassociateAccountsWithContext(ctx aws.Context, input *DisassociateAccountsInput, opts ...request.Option) (*DisassociateAccountsOutput, error) {
	req, out := c.DisassociateAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociatePricingRules = "DisassociatePricingRules"

// DisassociatePricingRulesRequest generates a "aws/request.Request" representing the
// client's request for the DisassociatePricingRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociatePricingRules for more information on using the DisassociatePricingRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociatePricingRulesRequest method.
//	req, resp := client.DisassociatePricingRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DisassociatePricingRules
func (c *BillingConductor) DisassociatePricingRulesRequest(input *DisassociatePricingRulesInput) (req *request.Request, output *DisassociatePricingRulesOutput) {
	op := &request.Operation{
		Name:       opDisassociatePricingRules,
		HTTPMethod: "PUT",
		HTTPPath:   "/disassociate-pricing-rules",
	}

	if input == nil {
		input = &DisassociatePricingRulesInput{}
	}

	output = &DisassociatePricingRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociatePricingRules API operation for AWSBillingConductor.
//
// Disassociates a list of pricing rules from a pricing plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation DisassociatePricingRules for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     You can cause an inconsistent state by updating or deleting a resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DisassociatePricingRules
func (c *BillingConductor) DisassociatePricingRules(input *DisassociatePricingRulesInput) (*DisassociatePricingRulesOutput, error) {
	req, out := c.DisassociatePricingRulesRequest(input)
	return out, req.Send()
}

// DisassociatePricingRulesWithContext is the same as DisassociatePricingRules with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociatePricingRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) DisassociatePricingRulesWithContext(ctx aws.Context, input *DisassociatePricingRulesInput, opts ...request.Option) (*DisassociatePricingRulesOutput, error) {
	req, out := c.DisassociatePricingRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccountAssociations = "ListAccountAssociations"

// ListAccountAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccountAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccountAssociations for more information on using the ListAccountAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAccountAssociationsRequest method.
//	req, resp := client.ListAccountAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListAccountAssociations
func (c *BillingConductor) ListAccountAssociationsRequest(input *ListAccountAssociationsInput) (req *request.Request, output *ListAccountAssociationsOutput) {
	op := &request.Operation{
		Name:       opListAccountAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/list-account-associations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccountAssociationsInput{}
	}

	output = &ListAccountAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccountAssociations API operation for AWSBillingConductor.
//
// This is a paginated call to list linked accounts that are linked to the payer
// account for the specified time period. If no information is provided, the
// current billing period is used. The response will optionally include the
// billing group that's associated with the linked account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation ListAccountAssociations for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListAccountAssociations
func (c *BillingConductor) ListAccountAssociations(input *ListAccountAssociationsInput) (*ListAccountAssociationsOutput, error) {
	req, out := c.ListAccountAssociationsRequest(input)
	return out, req.Send()
}

// ListAccountAssociationsWithContext is the same as ListAccountAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccountAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListAccountAssociationsWithContext(ctx aws.Context, input *ListAccountAssociationsInput, opts ...request.Option) (*ListAccountAssociationsOutput, error) {
	req, out := c.ListAccountAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccountAssociationsPages iterates over the pages of a ListAccountAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccountAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAccountAssociations operation.
//	pageNum := 0
//	err := client.ListAccountAssociationsPages(params,
//	    func(page *billingconductor.ListAccountAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BillingConductor) ListAccountAssociationsPages(input *ListAccountAssociationsInput, fn func(*ListAccountAssociationsOutput, bool) bool) error {
	return c.ListAccountAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccountAssociationsPagesWithContext same as ListAccountAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListAccountAssociationsPagesWithContext(ctx aws.Context, input *ListAccountAssociationsInput, fn func(*ListAccountAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccountAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccountAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccountAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBillingGroupCostReports = "ListBillingGroupCostReports"

// ListBillingGroupCostReportsRequest generates a "aws/request.Request" representing the
// client's request for the ListBillingGroupCostReports operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBillingGroupCostReports for more information on using the ListBillingGroupCostReports
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBillingGroupCostReportsRequest method.
//	req, resp := client.ListBillingGroupCostReportsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroupCostReports
func (c *BillingConductor) ListBillingGroupCostReportsRequest(input *ListBillingGroupCostReportsInput) (req *request.Request, output *ListBillingGroupCostReportsOutput) {
	op := &request.Operation{
		Name:       opListBillingGroupCostReports,
		HTTPMethod: "POST",
		HTTPPath:   "/list-billing-group-cost-reports",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBillingGroupCostReportsInput{}
	}

	output = &ListBillingGroupCostReportsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBillingGroupCostReports API operation for AWSBillingConductor.
//
// A paginated call to retrieve a summary report of actual Amazon Web Services
// charges and the calculated Amazon Web Services charges based on the associated
// pricing plan of a billing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation ListBillingGroupCostReports for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroupCostReports
func (c *BillingConductor) ListBillingGroupCostReports(input *ListBillingGroupCostReportsInput) (*ListBillingGroupCostReportsOutput, error) {
	req, out := c.ListBillingGroupCostReportsRequest(input)
	return out, req.Send()
}

// ListBillingGroupCostReportsWithContext is the same as ListBillingGroupCostReports with the addition of
// the ability to pass a context and additional request options.
//
// See ListBillingGroupCostReports for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListBillingGroupCostReportsWithContext(ctx aws.Context, input *ListBillingGroupCostReportsInput, opts ...request.Option) (*ListBillingGroupCostReportsOutput, error) {
	req, out := c.ListBillingGroupCostReportsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBillingGroupCostReportsPages iterates over the pages of a ListBillingGroupCostReports operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBillingGroupCostReports method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBillingGroupCostReports operation.
//	pageNum := 0
//	err := client.ListBillingGroupCostReportsPages(params,
//	    func(page *billingconductor.ListBillingGroupCostReportsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BillingConductor) ListBillingGroupCostReportsPages(input *ListBillingGroupCostReportsInput, fn func(*ListBillingGroupCostReportsOutput, bool) bool) error {
	return c.ListBillingGroupCostReportsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBillingGroupCostReportsPagesWithContext same as ListBillingGroupCostReportsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListBillingGroupCostReportsPagesWithContext(ctx aws.Context, input *ListBillingGroupCostReportsInput, fn func(*ListBillingGroupCostReportsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBillingGroupCostReportsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBillingGroupCostReportsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBillingGroupCostReportsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBillingGroups = "ListBillingGroups"

// ListBillingGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListBillingGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBillingGroups for more information on using the ListBillingGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBillingGroupsRequest method.
//	req, resp := client.ListBillingGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroups
func (c *BillingConductor) ListBillingGroupsRequest(input *ListBillingGroupsInput) (req *request.Request, output *ListBillingGroupsOutput) {
	op := &request.Operation{
		Name:       opListBillingGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/list-billing-groups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBillingGroupsInput{}
	}

	output = &ListBillingGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBillingGroups API operation for AWSBillingConductor.
//
// A paginated call to retrieve a list of billing groups for the given billing
// period. If you don't provide a billing group, the current billing period
// is used.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation ListBillingGroups for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroups
func (c *BillingConductor) ListBillingGroups(input *ListBillingGroupsInput) (*ListBillingGroupsOutput, error) {
	req, out := c.ListBillingGroupsRequest(input)
	return out, req.Send()
}

// ListBillingGroupsWithContext is the same as ListBillingGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListBillingGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListBillingGroupsWithContext(ctx aws.Context, input *ListBillingGroupsInput, opts ...request.Option) (*ListBillingGroupsOutput, error) {
	req, out := c.ListBillingGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBillingGroupsPages iterates over the pages of a ListBillingGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBillingGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBillingGroups operation.
//	pageNum := 0
//	err := client.ListBillingGroupsPages(params,
//	    func(page *billingconductor.ListBillingGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BillingConductor) ListBillingGroupsPages(input *ListBillingGroupsInput, fn func(*ListBillingGroupsOutput, bool) bool) error {
	return c.ListBillingGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBillingGroupsPagesWithContext same as ListBillingGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListBillingGroupsPagesWithContext(ctx aws.Context, input *ListBillingGroupsInput, fn func(*ListBillingGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBillingGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBillingGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBillingGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCustomLineItemVersions = "ListCustomLineItemVersions"

// ListCustomLineItemVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListCustomLineItemVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCustomLineItemVersions for more information on using the ListCustomLineItemVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCustomLineItemVersionsRequest method.
//	req, resp := client.ListCustomLineItemVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItemVersions
func (c *BillingConductor) ListCustomLineItemVersionsRequest(input *ListCustomLineItemVersionsInput) (req *request.Request, output *ListCustomLineItemVersionsOutput) {
	op := &request.Operation{
		Name:       opListCustomLineItemVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/list-custom-line-item-versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCustomLineItemVersionsInput{}
	}

	output = &ListCustomLineItemVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCustomLineItemVersions API operation for AWSBillingConductor.
//
// A paginated call to get a list of all custom line item versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation ListCustomLineItemVersions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItemVersions
func (c *BillingConductor) ListCustomLineItemVersions(input *ListCustomLineItemVersionsInput) (*ListCustomLineItemVersionsOutput, error) {
	req, out := c.ListCustomLineItemVersionsRequest(input)
	return out, req.Send()
}

// ListCustomLineItemVersionsWithContext is the same as ListCustomLineItemVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListCustomLineItemVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListCustomLineItemVersionsWithContext(ctx aws.Context, input *ListCustomLineItemVersionsInput, opts ...request.Option) (*ListCustomLineItemVersionsOutput, error) {
	req, out := c.ListCustomLineItemVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCustomLineItemVersionsPages iterates over the pages of a ListCustomLineItemVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCustomLineItemVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCustomLineItemVersions operation.
//	pageNum := 0
//	err := client.ListCustomLineItemVersionsPages(params,
//	    func(page *billingconductor.ListCustomLineItemVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BillingConductor) ListCustomLineItemVersionsPages(input *ListCustomLineItemVersionsInput, fn func(*ListCustomLineItemVersionsOutput, bool) bool) error {
	return c.ListCustomLineItemVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCustomLineItemVersionsPagesWithContext same as ListCustomLineItemVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListCustomLineItemVersionsPagesWithContext(ctx aws.Context, input *ListCustomLineItemVersionsInput, fn func(*ListCustomLineItemVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCustomLineItemVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCustomLineItemVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCustomLineItemVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCustomLineItems = "ListCustomLineItems"

// ListCustomLineItemsRequest generates a "aws/request.Request" representing the
// client's request for the ListCustomLineItems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCustomLineItems for more information on using the ListCustomLineItems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCustomLineItemsRequest method.
//	req, resp := client.ListCustomLineItemsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItems
func (c *BillingConductor) ListCustomLineItemsRequest(input *ListCustomLineItemsInput) (req *request.Request, output *ListCustomLineItemsOutput) {
	op := &request.Operation{
		Name:       opListCustomLineItems,
		HTTPMethod: "POST",
		HTTPPath:   "/list-custom-line-items",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCustomLineItemsInput{}
	}

	output = &ListCustomLineItemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCustomLineItems API operation for AWSBillingConductor.
//
// A paginated call to get a list of all custom line items (FFLIs) for the given
// billing period. If you don't provide a billing period, the current billing
// period is used.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation ListCustomLineItems for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItems
func (c *BillingConductor) ListCustomLineItems(input *ListCustomLineItemsInput) (*ListCustomLineItemsOutput, error) {
	req, out := c.ListCustomLineItemsRequest(input)
	return out, req.Send()
}

// ListCustomLineItemsWithContext is the same as ListCustomLineItems with the addition of
// the ability to pass a context and additional request options.
//
// See ListCustomLineItems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListCustomLineItemsWithContext(ctx aws.Context, input *ListCustomLineItemsInput, opts ...request.Option) (*ListCustomLineItemsOutput, error) {
	req, out := c.ListCustomLineItemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCustomLineItemsPages iterates over the pages of a ListCustomLineItems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCustomLineItems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCustomLineItems operation.
//	pageNum := 0
//	err := client.ListCustomLineItemsPages(params,
//	    func(page *billingconductor.ListCustomLineItemsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BillingConductor) ListCustomLineItemsPages(input *ListCustomLineItemsInput, fn func(*ListCustomLineItemsOutput, bool) bool) error {
	return c.ListCustomLineItemsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCustomLineItemsPagesWithContext same as ListCustomLineItemsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListCustomLineItemsPagesWithContext(ctx aws.Context, input *ListCustomLineItemsInput, fn func(*ListCustomLineItemsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCustomLineItemsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCustomLineItemsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCustomLineItemsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPricingPlans = "ListPricingPlans"

// ListPricingPlansRequest generates a "aws/request.Request" representing the
// client's request for the ListPricingPlans operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPricingPlans for more information on using the ListPricingPlans
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPricingPlansRequest method.
//	req, resp := client.ListPricingPlansRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlans
func (c *BillingConductor) ListPricingPlansRequest(input *ListPricingPlansInput) (req *request.Request, output *ListPricingPlansOutput) {
	op := &request.Operation{
		Name:       opListPricingPlans,
		HTTPMethod: "POST",
		HTTPPath:   "/list-pricing-plans",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPricingPlansInput{}
	}

	output = &ListPricingPlansOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPricingPlans API operation for AWSBillingConductor.
//
// A paginated call to get pricing plans for the given billing period. If you
// don't provide a billing period, the current billing period is used.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation ListPricingPlans for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlans
func (c *BillingConductor) ListPricingPlans(input *ListPricingPlansInput) (*ListPricingPlansOutput, error) {
	req, out := c.ListPricingPlansRequest(input)
	return out, req.Send()
}

// ListPricingPlansWithContext is the same as ListPricingPlans with the addition of
// the ability to pass a context and additional request options.
//
// See ListPricingPlans for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListPricingPlansWithContext(ctx aws.Context, input *ListPricingPlansInput, opts ...request.Option) (*ListPricingPlansOutput, error) {
	req, out := c.ListPricingPlansRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPricingPlansPages iterates over the pages of a ListPricingPlans operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPricingPlans method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPricingPlans operation.
//	pageNum := 0
//	err := client.ListPricingPlansPages(params,
//	    func(page *billingconductor.ListPricingPlansOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BillingConductor) ListPricingPlansPages(input *ListPricingPlansInput, fn func(*ListPricingPlansOutput, bool) bool) error {
	return c.ListPricingPlansPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPricingPlansPagesWithContext same as ListPricingPlansPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListPricingPlansPagesWithContext(ctx aws.Context, input *ListPricingPlansInput, fn func(*ListPricingPlansOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPricingPlansInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPricingPlansRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPricingPlansOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPricingPlansAssociatedWithPricingRule = "ListPricingPlansAssociatedWithPricingRule"

// ListPricingPlansAssociatedWithPricingRuleRequest generates a "aws/request.Request" representing the
// client's request for the ListPricingPlansAssociatedWithPricingRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPricingPlansAssociatedWithPricingRule for more information on using the ListPricingPlansAssociatedWithPricingRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPricingPlansAssociatedWithPricingRuleRequest method.
//	req, resp := client.ListPricingPlansAssociatedWithPricingRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlansAssociatedWithPricingRule
func (c *BillingConductor) ListPricingPlansAssociatedWithPricingRuleRequest(input *ListPricingPlansAssociatedWithPricingRuleInput) (req *request.Request, output *ListPricingPlansAssociatedWithPricingRuleOutput) {
	op := &request.Operation{
		Name:       opListPricingPlansAssociatedWithPricingRule,
		HTTPMethod: "POST",
		HTTPPath:   "/list-pricing-plans-associated-with-pricing-rule",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPricingPlansAssociatedWithPricingRuleInput{}
	}

	output = &ListPricingPlansAssociatedWithPricingRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPricingPlansAssociatedWithPricingRule API operation for AWSBillingConductor.
//
// A list of the pricing plans that are associated with a pricing rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation ListPricingPlansAssociatedWithPricingRule for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlansAssociatedWithPricingRule
func (c *BillingConductor) ListPricingPlansAssociatedWithPricingRule(input *ListPricingPlansAssociatedWithPricingRuleInput) (*ListPricingPlansAssociatedWithPricingRuleOutput, error) {
	req, out := c.ListPricingPlansAssociatedWithPricingRuleRequest(input)
	return out, req.Send()
}

// ListPricingPlansAssociatedWithPricingRuleWithContext is the same as ListPricingPlansAssociatedWithPricingRule with the addition of
// the ability to pass a context and additional request options.
//
// See ListPricingPlansAssociatedWithPricingRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListPricingPlansAssociatedWithPricingRuleWithContext(ctx aws.Context, input *ListPricingPlansAssociatedWithPricingRuleInput, opts ...request.Option) (*ListPricingPlansAssociatedWithPricingRuleOutput, error) {
	req, out := c.ListPricingPlansAssociatedWithPricingRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPricingPlansAssociatedWithPricingRulePages iterates over the pages of a ListPricingPlansAssociatedWithPricingRule operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPricingPlansAssociatedWithPricingRule method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPricingPlansAssociatedWithPricingRule operation.
//	pageNum := 0
//	err := client.ListPricingPlansAssociatedWithPricingRulePages(params,
//	    func(page *billingconductor.ListPricingPlansAssociatedWithPricingRuleOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BillingConductor) ListPricingPlansAssociatedWithPricingRulePages(input *ListPricingPlansAssociatedWithPricingRuleInput, fn func(*ListPricingPlansAssociatedWithPricingRuleOutput, bool) bool) error {
	return c.ListPricingPlansAssociatedWithPricingRulePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPricingPlansAssociatedWithPricingRulePagesWithContext same as ListPricingPlansAssociatedWithPricingRulePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListPricingPlansAssociatedWithPricingRulePagesWithContext(ctx aws.Context, input *ListPricingPlansAssociatedWithPricingRuleInput, fn func(*ListPricingPlansAssociatedWithPricingRuleOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPricingPlansAssociatedWithPricingRuleInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPricingPlansAssociatedWithPricingRuleRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPricingPlansAssociatedWithPricingRuleOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPricingRules = "ListPricingRules"

// ListPricingRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListPricingRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPricingRules for more information on using the ListPricingRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPricingRulesRequest method.
//	req, resp := client.ListPricingRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRules
func (c *BillingConductor) ListPricingRulesRequest(input *ListPricingRulesInput) (req *request.Request, output *ListPricingRulesOutput) {
	op := &request.Operation{
		Name:       opListPricingRules,
		HTTPMethod: "POST",
		HTTPPath:   "/list-pricing-rules",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPricingRulesInput{}
	}

	output = &ListPricingRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPricingRules API operation for AWSBillingConductor.
//
// Describes a pricing rule that can be associated to a pricing plan, or set
// of pricing plans.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation ListPricingRules for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRules
func (c *BillingConductor) ListPricingRules(input *ListPricingRulesInput) (*ListPricingRulesOutput, error) {
	req, out := c.ListPricingRulesRequest(input)
	return out, req.Send()
}

// ListPricingRulesWithContext is the same as ListPricingRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListPricingRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListPricingRulesWithContext(ctx aws.Context, input *ListPricingRulesInput, opts ...request.Option) (*ListPricingRulesOutput, error) {
	req, out := c.ListPricingRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPricingRulesPages iterates over the pages of a ListPricingRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPricingRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPricingRules operation.
//	pageNum := 0
//	err := client.ListPricingRulesPages(params,
//	    func(page *billingconductor.ListPricingRulesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BillingConductor) ListPricingRulesPages(input *ListPricingRulesInput, fn func(*ListPricingRulesOutput, bool) bool) error {
	return c.ListPricingRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPricingRulesPagesWithContext same as ListPricingRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListPricingRulesPagesWithContext(ctx aws.Context, input *ListPricingRulesInput, fn func(*ListPricingRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPricingRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPricingRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPricingRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPricingRulesAssociatedToPricingPlan = "ListPricingRulesAssociatedToPricingPlan"

// ListPricingRulesAssociatedToPricingPlanRequest generates a "aws/request.Request" representing the
// client's request for the ListPricingRulesAssociatedToPricingPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPricingRulesAssociatedToPricingPlan for more information on using the ListPricingRulesAssociatedToPricingPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPricingRulesAssociatedToPricingPlanRequest method.
//	req, resp := client.ListPricingRulesAssociatedToPricingPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRulesAssociatedToPricingPlan
func (c *BillingConductor) ListPricingRulesAssociatedToPricingPlanRequest(input *ListPricingRulesAssociatedToPricingPlanInput) (req *request.Request, output *ListPricingRulesAssociatedToPricingPlanOutput) {
	op := &request.Operation{
		Name:       opListPricingRulesAssociatedToPricingPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/list-pricing-rules-associated-to-pricing-plan",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPricingRulesAssociatedToPricingPlanInput{}
	}

	output = &ListPricingRulesAssociatedToPricingPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPricingRulesAssociatedToPricingPlan API operation for AWSBillingConductor.
//
// Lists the pricing rules that are associated with a pricing plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation ListPricingRulesAssociatedToPricingPlan for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRulesAssociatedToPricingPlan
func (c *BillingConductor) ListPricingRulesAssociatedToPricingPlan(input *ListPricingRulesAssociatedToPricingPlanInput) (*ListPricingRulesAssociatedToPricingPlanOutput, error) {
	req, out := c.ListPricingRulesAssociatedToPricingPlanRequest(input)
	return out, req.Send()
}

// ListPricingRulesAssociatedToPricingPlanWithContext is the same as ListPricingRulesAssociatedToPricingPlan with the addition of
// the ability to pass a context and additional request options.
//
// See ListPricingRulesAssociatedToPricingPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListPricingRulesAssociatedToPricingPlanWithContext(ctx aws.Context, input *ListPricingRulesAssociatedToPricingPlanInput, opts ...request.Option) (*ListPricingRulesAssociatedToPricingPlanOutput, error) {
	req, out := c.ListPricingRulesAssociatedToPricingPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPricingRulesAssociatedToPricingPlanPages iterates over the pages of a ListPricingRulesAssociatedToPricingPlan operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPricingRulesAssociatedToPricingPlan method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPricingRulesAssociatedToPricingPlan operation.
//	pageNum := 0
//	err := client.ListPricingRulesAssociatedToPricingPlanPages(params,
//	    func(page *billingconductor.ListPricingRulesAssociatedToPricingPlanOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BillingConductor) ListPricingRulesAssociatedToPricingPlanPages(input *ListPricingRulesAssociatedToPricingPlanInput, fn func(*ListPricingRulesAssociatedToPricingPlanOutput, bool) bool) error {
	return c.ListPricingRulesAssociatedToPricingPlanPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPricingRulesAssociatedToPricingPlanPagesWithContext same as ListPricingRulesAssociatedToPricingPlanPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListPricingRulesAssociatedToPricingPlanPagesWithContext(ctx aws.Context, input *ListPricingRulesAssociatedToPricingPlanInput, fn func(*ListPricingRulesAssociatedToPricingPlanOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPricingRulesAssociatedToPricingPlanInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPricingRulesAssociatedToPricingPlanRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPricingRulesAssociatedToPricingPlanOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResourcesAssociatedToCustomLineItem = "ListResourcesAssociatedToCustomLineItem"

// ListResourcesAssociatedToCustomLineItemRequest generates a "aws/request.Request" representing the
// client's request for the ListResourcesAssociatedToCustomLineItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResourcesAssociatedToCustomLineItem for more information on using the ListResourcesAssociatedToCustomLineItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResourcesAssociatedToCustomLineItemRequest method.
//	req, resp := client.ListResourcesAssociatedToCustomLineItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListResourcesAssociatedToCustomLineItem
func (c *BillingConductor) ListResourcesAssociatedToCustomLineItemRequest(input *ListResourcesAssociatedToCustomLineItemInput) (req *request.Request, output *ListResourcesAssociatedToCustomLineItemOutput) {
	op := &request.Operation{
		Name:       opListResourcesAssociatedToCustomLineItem,
		HTTPMethod: "POST",
		HTTPPath:   "/list-resources-associated-to-custom-line-item",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourcesAssociatedToCustomLineItemInput{}
	}

	output = &ListResourcesAssociatedToCustomLineItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResourcesAssociatedToCustomLineItem API operation for AWSBillingConductor.
//
// List the resources that are associated to a custom line item.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation ListResourcesAssociatedToCustomLineItem for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListResourcesAssociatedToCustomLineItem
func (c *BillingConductor) ListResourcesAssociatedToCustomLineItem(input *ListResourcesAssociatedToCustomLineItemInput) (*ListResourcesAssociatedToCustomLineItemOutput, error) {
	req, out := c.ListResourcesAssociatedToCustomLineItemRequest(input)
	return out, req.Send()
}

// ListResourcesAssociatedToCustomLineItemWithContext is the same as ListResourcesAssociatedToCustomLineItem with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourcesAssociatedToCustomLineItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListResourcesAssociatedToCustomLineItemWithContext(ctx aws.Context, input *ListResourcesAssociatedToCustomLineItemInput, opts ...request.Option) (*ListResourcesAssociatedToCustomLineItemOutput, error) {
	req, out := c.ListResourcesAssociatedToCustomLineItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResourcesAssociatedToCustomLineItemPages iterates over the pages of a ListResourcesAssociatedToCustomLineItem operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResourcesAssociatedToCustomLineItem method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResourcesAssociatedToCustomLineItem operation.
//	pageNum := 0
//	err := client.ListResourcesAssociatedToCustomLineItemPages(params,
//	    func(page *billingconductor.ListResourcesAssociatedToCustomLineItemOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BillingConductor) ListResourcesAssociatedToCustomLineItemPages(input *ListResourcesAssociatedToCustomLineItemInput, fn func(*ListResourcesAssociatedToCustomLineItemOutput, bool) bool) error {
	return c.ListResourcesAssociatedToCustomLineItemPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResourcesAssociatedToCustomLineItemPagesWithContext same as ListResourcesAssociatedToCustomLineItemPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListResourcesAssociatedToCustomLineItemPagesWithContext(ctx aws.Context, input *ListResourcesAssociatedToCustomLineItemInput, fn func(*ListResourcesAssociatedToCustomLineItemOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResourcesAssociatedToCustomLineItemInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResourcesAssociatedToCustomLineItemRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResourcesAssociatedToCustomLineItemOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListTagsForResource
func (c *BillingConductor) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWSBillingConductor.
//
// A list the tags for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListTagsForResource
func (c *BillingConductor) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/TagResource
func (c *BillingConductor) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWSBillingConductor.
//
// Associates the specified tags to a resource with the specified resourceArn.
// If existing tags on a resource are not specified in the request parameters,
// they are not changed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/TagResource
func (c *BillingConductor) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UntagResource
func (c *BillingConductor) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWSBillingConductor.
//
// Deletes specified tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UntagResource
func (c *BillingConductor) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBillingGroup = "UpdateBillingGroup"

// UpdateBillingGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBillingGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBillingGroup for more information on using the UpdateBillingGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBillingGroupRequest method.
//	req, resp := client.UpdateBillingGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdateBillingGroup
func (c *BillingConductor) UpdateBillingGroupRequest(input *UpdateBillingGroupInput) (req *request.Request, output *UpdateBillingGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateBillingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/update-billing-group",
	}

	if input == nil {
		input = &UpdateBillingGroupInput{}
	}

	output = &UpdateBillingGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBillingGroup API operation for AWSBillingConductor.
//
// This updates an existing billing group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation UpdateBillingGroup for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     You can cause an inconsistent state by updating or deleting a resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdateBillingGroup
func (c *BillingConductor) UpdateBillingGroup(input *UpdateBillingGroupInput) (*UpdateBillingGroupOutput, error) {
	req, out := c.UpdateBillingGroupRequest(input)
	return out, req.Send()
}

// UpdateBillingGroupWithContext is the same as UpdateBillingGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBillingGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) UpdateBillingGroupWithContext(ctx aws.Context, input *UpdateBillingGroupInput, opts ...request.Option) (*UpdateBillingGroupOutput, error) {
	req, out := c.UpdateBillingGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCustomLineItem = "UpdateCustomLineItem"

// UpdateCustomLineItemRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCustomLineItem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCustomLineItem for more information on using the UpdateCustomLineItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCustomLineItemRequest method.
//	req, resp := client.UpdateCustomLineItemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdateCustomLineItem
func (c *BillingConductor) UpdateCustomLineItemRequest(input *UpdateCustomLineItemInput) (req *request.Request, output *UpdateCustomLineItemOutput) {
	op := &request.Operation{
		Name:       opUpdateCustomLineItem,
		HTTPMethod: "POST",
		HTTPPath:   "/update-custom-line-item",
	}

	if input == nil {
		input = &UpdateCustomLineItemInput{}
	}

	output = &UpdateCustomLineItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCustomLineItem API operation for AWSBillingConductor.
//
// Update an existing custom line item in the current or previous billing period.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation UpdateCustomLineItem for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdateCustomLineItem
func (c *BillingConductor) UpdateCustomLineItem(input *UpdateCustomLineItemInput) (*UpdateCustomLineItemOutput, error) {
	req, out := c.UpdateCustomLineItemRequest(input)
	return out, req.Send()
}

// UpdateCustomLineItemWithContext is the same as UpdateCustomLineItem with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCustomLineItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) UpdateCustomLineItemWithContext(ctx aws.Context, input *UpdateCustomLineItemInput, opts ...request.Option) (*UpdateCustomLineItemOutput, error) {
	req, out := c.UpdateCustomLineItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePricingPlan = "UpdatePricingPlan"

// UpdatePricingPlanRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePricingPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePricingPlan for more information on using the UpdatePricingPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePricingPlanRequest method.
//	req, resp := client.UpdatePricingPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdatePricingPlan
func (c *BillingConductor) UpdatePricingPlanRequest(input *UpdatePricingPlanInput) (req *request.Request, output *UpdatePricingPlanOutput) {
	op := &request.Operation{
		Name:       opUpdatePricingPlan,
		HTTPMethod: "PUT",
		HTTPPath:   "/update-pricing-plan",
	}

	if input == nil {
		input = &UpdatePricingPlanInput{}
	}

	output = &UpdatePricingPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePricingPlan API operation for AWSBillingConductor.
//
// This updates an existing pricing plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation UpdatePricingPlan for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     You can cause an inconsistent state by updating or deleting a resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdatePricingPlan
func (c *BillingConductor) UpdatePricingPlan(input *UpdatePricingPlanInput) (*UpdatePricingPlanOutput, error) {
	req, out := c.UpdatePricingPlanRequest(input)
	return out, req.Send()
}

// UpdatePricingPlanWithContext is the same as UpdatePricingPlan with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePricingPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) UpdatePricingPlanWithContext(ctx aws.Context, input *UpdatePricingPlanInput, opts ...request.Option) (*UpdatePricingPlanOutput, error) {
	req, out := c.UpdatePricingPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePricingRule = "UpdatePricingRule"

// UpdatePricingRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePricingRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePricingRule for more information on using the UpdatePricingRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePricingRuleRequest method.
//	req, resp := client.UpdatePricingRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdatePricingRule
func (c *BillingConductor) UpdatePricingRuleRequest(input *UpdatePricingRuleInput) (req *request.Request, output *UpdatePricingRuleOutput) {
	op := &request.Operation{
		Name:       opUpdatePricingRule,
		HTTPMethod: "PUT",
		HTTPPath:   "/update-pricing-rule",
	}

	if input == nil {
		input = &UpdatePricingRuleInput{}
	}

	output = &UpdatePricingRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePricingRule API operation for AWSBillingConductor.
//
// Updates an existing pricing rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSBillingConductor's
// API operation UpdatePricingRule for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     You can cause an inconsistent state by updating or deleting a resource.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The input doesn't match with the constraints specified by Amazon Web Services.
//
//   - InternalServerException
//     An unexpected error occurred while processing a request.
//
//   - ResourceNotFoundException
//     The request references a resource that doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdatePricingRule
func (c *BillingConductor) UpdatePricingRule(input *UpdatePricingRuleInput) (*UpdatePricingRuleOutput, error) {
	req, out := c.UpdatePricingRuleRequest(input)
	return out, req.Send()
}

// UpdatePricingRuleWithContext is the same as UpdatePricingRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePricingRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BillingConductor) UpdatePricingRuleWithContext(ctx aws.Context, input *UpdatePricingRuleInput, opts ...request.Option) (*UpdatePricingRuleOutput, error) {
	req, out := c.UpdatePricingRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A representation of a linked account.
type AccountAssociationsListElement struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account email.
	//
	// AccountEmail is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AccountAssociationsListElement's
	// String and GoString methods.
	AccountEmail *string `type:"string" sensitive:"true"`

	// The associating array of account IDs.
	AccountId *string `type:"string"`

	// The Amazon Web Services account name.
	//
	// AccountName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AccountAssociationsListElement's
	// String and GoString methods.
	AccountName *string `type:"string" sensitive:"true"`

	// The Billing Group Arn that the linked account is associated to.
	BillingGroupArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountAssociationsListElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountAssociationsListElement) GoString() string {
	return s.String()
}

// SetAccountEmail sets the AccountEmail field's value.
func (s *AccountAssociationsListElement) SetAccountEmail(v string) *AccountAssociationsListElement {
	s.AccountEmail = &v
	return s
}

// SetAccountId sets the AccountId field's value.
func (s *AccountAssociationsListElement) SetAccountId(v string) *AccountAssociationsListElement {
	s.AccountId = &v
	return s
}

// SetAccountName sets the AccountName field's value.
func (s *AccountAssociationsListElement) SetAccountName(v string) *AccountAssociationsListElement {
	s.AccountName = &v
	return s
}

// SetBillingGroupArn sets the BillingGroupArn field's value.
func (s *AccountAssociationsListElement) SetBillingGroupArn(v string) *AccountAssociationsListElement {
	s.BillingGroupArn = &v
	return s
}

// The set of accounts that will be under the billing group. The set of accounts
// resemble the linked accounts in a consolidated billing family.
type AccountGrouping struct {
	_ struct{} `type:"structure"`

	// Specifies if this billing group will automatically associate newly added
	// Amazon Web Services accounts that join your consolidated billing family.
	AutoAssociate *bool `type:"boolean"`

	// The account IDs that make up the billing group. Account IDs must be a part
	// of the consolidated billing family, and not associated with another billing
	// group.
	//
	// LinkedAccountIds is a required field
	LinkedAccountIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountGrouping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountGrouping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountGrouping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccountGrouping"}
	if s.LinkedAccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("LinkedAccountIds"))
	}
	if s.LinkedAccountIds != nil && len(s.LinkedAccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LinkedAccountIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoAssociate sets the AutoAssociate field's value.
func (s *AccountGrouping) SetAutoAssociate(v bool) *AccountGrouping {
	s.AutoAssociate = &v
	return s
}

// SetLinkedAccountIds sets the LinkedAccountIds field's value.
func (s *AccountGrouping) SetLinkedAccountIds(v []*string) *AccountGrouping {
	s.LinkedAccountIds = v
	return s
}

type AssociateAccountsInput struct {
	_ struct{} `type:"structure"`

	// The associating array of account IDs.
	//
	// AccountIds is a required field
	AccountIds []*string `min:"1" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the billing group that associates the array
	// of account IDs.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAccountsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateAccountsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateAccountsInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *AssociateAccountsInput) SetAccountIds(v []*string) *AssociateAccountsInput {
	s.AccountIds = v
	return s
}

// SetArn sets the Arn field's value.
func (s *AssociateAccountsInput) SetArn(v string) *AssociateAccountsInput {
	s.Arn = &v
	return s
}

type AssociateAccountsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the billing group that associates the array
	// of account IDs.
	Arn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAccountsOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssociateAccountsOutput) SetArn(v string) *AssociateAccountsOutput {
	s.Arn = &v
	return s
}

type AssociatePricingRulesInput struct {
	_ struct{} `type:"structure"`

	// The PricingPlanArn that the PricingRuleArns are associated with.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The PricingRuleArns that are associated with the Pricing Plan.
	//
	// PricingRuleArns is a required field
	PricingRuleArns []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePricingRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePricingRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociatePricingRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociatePricingRulesInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.PricingRuleArns == nil {
		invalidParams.Add(request.NewErrParamRequired("PricingRuleArns"))
	}
	if s.PricingRuleArns != nil && len(s.PricingRuleArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PricingRuleArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *AssociatePricingRulesInput) SetArn(v string) *AssociatePricingRulesInput {
	s.Arn = &v
	return s
}

// SetPricingRuleArns sets the PricingRuleArns field's value.
func (s *AssociatePricingRulesInput) SetPricingRuleArns(v []*string) *AssociatePricingRulesInput {
	s.PricingRuleArns = v
	return s
}

type AssociatePricingRulesOutput struct {
	_ struct{} `type:"structure"`

	// The PricingPlanArn that the PricingRuleArns are associated with.
	Arn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePricingRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePricingRulesOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssociatePricingRulesOutput) SetArn(v string) *AssociatePricingRulesOutput {
	s.Arn = &v
	return s
}

// A representation of a resource association error.
type AssociateResourceError struct {
	_ struct{} `type:"structure"`

	// The reason why the resource association failed.
	Message *string `type:"string"`

	// A static error code that's used to classify the type of failure.
	Reason *string `type:"string" enum:"AssociateResourceErrorReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResourceError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResourceError) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *AssociateResourceError) SetMessage(v string) *AssociateResourceError {
	s.Message = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *AssociateResourceError) SetReason(v string) *AssociateResourceError {
	s.Reason = &v
	return s
}

// A resource association result for a percentage custom line item.
type AssociateResourceResponseElement struct {
	_ struct{} `type:"structure"`

	// The resource ARN that was associated to the custom line item.
	Arn *string `type:"string"`

	// An AssociateResourceError that will populate if the resource association
	// fails.
	Error *AssociateResourceError `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResourceResponseElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResourceResponseElement) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AssociateResourceResponseElement) SetArn(v string) *AssociateResourceResponseElement {
	s.Arn = &v
	return s
}

// SetError sets the Error field's value.
func (s *AssociateResourceResponseElement) SetError(v *AssociateResourceError) *AssociateResourceResponseElement {
	s.Error = v
	return s
}

type BatchAssociateResourcesToCustomLineItemInput struct {
	_ struct{} `type:"structure"`

	// The billing period range in which the custom line item request will be applied.
	BillingPeriodRange *CustomLineItemBillingPeriodRange `type:"structure"`

	// A list containing the ARNs of the resources to be associated.
	//
	// ResourceArns is a required field
	ResourceArns []*string `min:"1" type:"list" required:"true"`

	// A percentage custom line item ARN to associate the resources to.
	//
	// TargetArn is a required field
	TargetArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchAssociateResourcesToCustomLineItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchAssociateResourcesToCustomLineItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAssociateResourcesToCustomLineItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchAssociateResourcesToCustomLineItemInput"}
	if s.ResourceArns == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArns"))
	}
	if s.ResourceArns != nil && len(s.ResourceArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArns", 1))
	}
	if s.TargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetArn"))
	}
	if s.BillingPeriodRange != nil {
		if err := s.BillingPeriodRange.Validate(); err != nil {
			invalidParams.AddNested("BillingPeriodRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingPeriodRange sets the BillingPeriodRange field's value.
func (s *BatchAssociateResourcesToCustomLineItemInput) SetBillingPeriodRange(v *CustomLineItemBillingPeriodRange) *BatchAssociateResourcesToCustomLineItemInput {
	s.BillingPeriodRange = v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *BatchAssociateResourcesToCustomLineItemInput) SetResourceArns(v []*string) *BatchAssociateResourcesToCustomLineItemInput {
	s.ResourceArns = v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *BatchAssociateResourcesToCustomLineItemInput) SetTargetArn(v string) *BatchAssociateResourcesToCustomLineItemInput {
	s.TargetArn = &v
	return s
}

type BatchAssociateResourcesToCustomLineItemOutput struct {
	_ struct{} `type:"structure"`

	// A list of AssociateResourceResponseElement for each resource that failed
	// association to a percentage custom line item.
	FailedAssociatedResources []*AssociateResourceResponseElement `type:"list"`

	// A list of AssociateResourceResponseElement for each resource that's been
	// associated to a percentage custom line item successfully.
	SuccessfullyAssociatedResources []*AssociateResourceResponseElement `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchAssociateResourcesToCustomLineItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchAssociateResourcesToCustomLineItemOutput) GoString() string {
	return s.String()
}

// SetFailedAssociatedResources sets the FailedAssociatedResources field's value.
func (s *BatchAssociateResourcesToCustomLineItemOutput) SetFailedAssociatedResources(v []*AssociateResourceResponseElement) *BatchAssociateResourcesToCustomLineItemOutput {
	s.FailedAssociatedResources = v
	return s
}

// SetSuccessfullyAssociatedResources sets the SuccessfullyAssociatedResources field's value.
func (s *BatchAssociateResourcesToCustomLineItemOutput) SetSuccessfullyAssociatedResources(v []*AssociateResourceResponseElement) *BatchAssociateResourcesToCustomLineItemOutput {
	s.SuccessfullyAssociatedResources = v
	return s
}

type BatchDisassociateResourcesFromCustomLineItemInput struct {
	_ struct{} `type:"structure"`

	// The billing period range in which the custom line item request will be applied.
	BillingPeriodRange *CustomLineItemBillingPeriodRange `type:"structure"`

	// A list containing the ARNs of resources to be disassociated.
	//
	// ResourceArns is a required field
	ResourceArns []*string `min:"1" type:"list" required:"true"`

	// A percentage custom line item ARN to disassociate the resources from.
	//
	// TargetArn is a required field
	TargetArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDisassociateResourcesFromCustomLineItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDisassociateResourcesFromCustomLineItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDisassociateResourcesFromCustomLineItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDisassociateResourcesFromCustomLineItemInput"}
	if s.ResourceArns == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArns"))
	}
	if s.ResourceArns != nil && len(s.ResourceArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArns", 1))
	}
	if s.TargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetArn"))
	}
	if s.BillingPeriodRange != nil {
		if err := s.BillingPeriodRange.Validate(); err != nil {
			invalidParams.AddNested("BillingPeriodRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingPeriodRange sets the BillingPeriodRange field's value.
func (s *BatchDisassociateResourcesFromCustomLineItemInput) SetBillingPeriodRange(v *CustomLineItemBillingPeriodRange) *BatchDisassociateResourcesFromCustomLineItemInput {
	s.BillingPeriodRange = v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *BatchDisassociateResourcesFromCustomLineItemInput) SetResourceArns(v []*string) *BatchDisassociateResourcesFromCustomLineItemInput {
	s.ResourceArns = v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *BatchDisassociateResourcesFromCustomLineItemInput) SetTargetArn(v string) *BatchDisassociateResourcesFromCustomLineItemInput {
	s.TargetArn = &v
	return s
}

type BatchDisassociateResourcesFromCustomLineItemOutput struct {
	_ struct{} `type:"structure"`

	// A list of DisassociateResourceResponseElement for each resource that failed
	// disassociation from a percentage custom line item.
	FailedDisassociatedResources []*DisassociateResourceResponseElement `type:"list"`

	// A list of DisassociateResourceResponseElement for each resource that's been
	// disassociated from a percentage custom line item successfully.
	SuccessfullyDisassociatedResources []*DisassociateResourceResponseElement `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDisassociateResourcesFromCustomLineItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchDisassociateResourcesFromCustomLineItemOutput) GoString() string {
	return s.String()
}

// SetFailedDisassociatedResources sets the FailedDisassociatedResources field's value.
func (s *BatchDisassociateResourcesFromCustomLineItemOutput) SetFailedDisassociatedResources(v []*DisassociateResourceResponseElement) *BatchDisassociateResourcesFromCustomLineItemOutput {
	s.FailedDisassociatedResources = v
	return s
}

// SetSuccessfullyDisassociatedResources sets the SuccessfullyDisassociatedResources field's value.
func (s *BatchDisassociateResourcesFromCustomLineItemOutput) SetSuccessfullyDisassociatedResources(v []*DisassociateResourceResponseElement) *BatchDisassociateResourcesFromCustomLineItemOutput {
	s.SuccessfullyDisassociatedResources = v
	return s
}

// A summary report of actual Amazon Web Services charges and calculated Amazon
// Web Services charges, based on the associated pricing plan of a billing group.
type BillingGroupCostReportElement struct {
	_ struct{} `type:"structure"`

	// The actual Amazon Web Services charges for the billing group.
	AWSCost *string `type:"string"`

	// The Amazon Resource Name (ARN) of a billing group.
	Arn *string `type:"string"`

	// The displayed currency.
	Currency *string `type:"string"`

	// The billing group margin.
	Margin *string `type:"string"`

	// The percentage of billing group margin.
	MarginPercentage *string `type:"string"`

	// The hypothetical Amazon Web Services charges based on the associated pricing
	// plan of a billing group.
	ProformaCost *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BillingGroupCostReportElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BillingGroupCostReportElement) GoString() string {
	return s.String()
}

// SetAWSCost sets the AWSCost field's value.
func (s *BillingGroupCostReportElement) SetAWSCost(v string) *BillingGroupCostReportElement {
	s.AWSCost = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *BillingGroupCostReportElement) SetArn(v string) *BillingGroupCostReportElement {
	s.Arn = &v
	return s
}

// SetCurrency sets the Currency field's value.
func (s *BillingGroupCostReportElement) SetCurrency(v string) *BillingGroupCostReportElement {
	s.Currency = &v
	return s
}

// SetMargin sets the Margin field's value.
func (s *BillingGroupCostReportElement) SetMargin(v string) *BillingGroupCostReportElement {
	s.Margin = &v
	return s
}

// SetMarginPercentage sets the MarginPercentage field's value.
func (s *BillingGroupCostReportElement) SetMarginPercentage(v string) *BillingGroupCostReportElement {
	s.MarginPercentage = &v
	return s
}

// SetProformaCost sets the ProformaCost field's value.
func (s *BillingGroupCostReportElement) SetProformaCost(v string) *BillingGroupCostReportElement {
	s.ProformaCost = &v
	return s
}

// A representation of a billing group.
type BillingGroupListElement struct {
	_ struct{} `type:"structure"`

	// Specifies if the billing group has automatic account association (AutoAssociate)
	// enabled.
	AccountGrouping *ListBillingGroupAccountGrouping `type:"structure"`

	// The Amazon Resource Number (ARN) that can be used to uniquely identify the
	// billing group.
	Arn *string `type:"string"`

	// The preferences and settings that will be used to compute the Amazon Web
	// Services charges for a billing group.
	ComputationPreference *ComputationPreference `type:"structure"`

	// The time when the billing group was created.
	CreationTime *int64 `type:"long"`

	// The description of the billing group.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by BillingGroupListElement's
	// String and GoString methods.
	Description *string `type:"string" sensitive:"true"`

	// The most recent time when the billing group was modified.
	LastModifiedTime *int64 `type:"long"`

	// The name of the billing group.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by BillingGroupListElement's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The account ID that serves as the main account in a billing group.
	PrimaryAccountId *string `type:"string"`

	// The number of accounts in the particular billing group.
	Size *int64 `type:"long"`

	// The billing group status. Only one of the valid values can be used.
	Status *string `type:"string" enum:"BillingGroupStatus"`

	// The reason why the billing group is in its current status.
	StatusReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BillingGroupListElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BillingGroupListElement) GoString() string {
	return s.String()
}

// SetAccountGrouping sets the AccountGrouping field's value.
func (s *BillingGroupListElement) SetAccountGrouping(v *ListBillingGroupAccountGrouping) *BillingGroupListElement {
	s.AccountGrouping = v
	return s
}

// SetArn sets the Arn field's value.
func (s *BillingGroupListElement) SetArn(v string) *BillingGroupListElement {
	s.Arn = &v
	return s
}

// SetComputationPreference sets the ComputationPreference field's value.
func (s *BillingGroupListElement) SetComputationPreference(v *ComputationPreference) *BillingGroupListElement {
	s.ComputationPreference = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *BillingGroupListElement) SetCreationTime(v int64) *BillingGroupListElement {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *BillingGroupListElement) SetDescription(v string) *BillingGroupListElement {
	s.Description = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *BillingGroupListElement) SetLastModifiedTime(v int64) *BillingGroupListElement {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *BillingGroupListElement) SetName(v string) *BillingGroupListElement {
	s.Name = &v
	return s
}

// SetPrimaryAccountId sets the PrimaryAccountId field's value.
func (s *BillingGroupListElement) SetPrimaryAccountId(v string) *BillingGroupListElement {
	s.PrimaryAccountId = &v
	return s
}

// SetSize sets the Size field's value.
func (s *BillingGroupListElement) SetSize(v int64) *BillingGroupListElement {
	s.Size = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BillingGroupListElement) SetStatus(v string) *BillingGroupListElement {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *BillingGroupListElement) SetStatusReason(v string) *BillingGroupListElement {
	s.StatusReason = &v
	return s
}

// The preferences and settings that will be used to compute the Amazon Web
// Services charges for a billing group.
type ComputationPreference struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the pricing plan that's used to compute
	// the Amazon Web Services charges for a billing group.
	//
	// PricingPlanArn is a required field
	PricingPlanArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputationPreference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputationPreference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComputationPreference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComputationPreference"}
	if s.PricingPlanArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PricingPlanArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPricingPlanArn sets the PricingPlanArn field's value.
func (s *ComputationPreference) SetPricingPlanArn(v string) *ComputationPreference {
	s.PricingPlanArn = &v
	return s
}

// You can cause an inconsistent state by updating or deleting a resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Reason for the inconsistent state.
	Reason *string `type:"string" enum:"ConflictExceptionReason"`

	// Identifier of the resource in use.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// Type of the resource in use.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateBillingGroupInput struct {
	_ struct{} `type:"structure"`

	// The set of accounts that will be under the billing group. The set of accounts
	// resemble the linked accounts in a consolidated billing family.
	//
	// AccountGrouping is a required field
	AccountGrouping *AccountGrouping `type:"structure" required:"true"`

	// The token that is needed to support idempotency. Idempotency isn't currently
	// supported, but will be implemented in a future update.
	ClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The preferences and settings that will be used to compute the Amazon Web
	// Services charges for a billing group.
	//
	// ComputationPreference is a required field
	ComputationPreference *ComputationPreference `type:"structure" required:"true"`

	// The description of the billing group.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateBillingGroupInput's
	// String and GoString methods.
	Description *string `type:"string" sensitive:"true"`

	// The billing group name. The names must be unique.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateBillingGroupInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The account ID that serves as the main account in a billing group.
	PrimaryAccountId *string `type:"string"`

	// A map that contains tag keys and tag values that are attached to a billing
	// group. This feature isn't available during the beta.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBillingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBillingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBillingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBillingGroupInput"}
	if s.AccountGrouping == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountGrouping"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.ComputationPreference == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputationPreference"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.AccountGrouping != nil {
		if err := s.AccountGrouping.Validate(); err != nil {
			invalidParams.AddNested("AccountGrouping", err.(request.ErrInvalidParams))
		}
	}
	if s.ComputationPreference != nil {
		if err := s.ComputationPreference.Validate(); err != nil {
			invalidParams.AddNested("ComputationPreference", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountGrouping sets the AccountGrouping field's value.
func (s *CreateBillingGroupInput) SetAccountGrouping(v *AccountGrouping) *CreateBillingGroupInput {
	s.AccountGrouping = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateBillingGroupInput) SetClientToken(v string) *CreateBillingGroupInput {
	s.ClientToken = &v
	return s
}

// SetComputationPreference sets the ComputationPreference field's value.
func (s *CreateBillingGroupInput) SetComputationPreference(v *ComputationPreference) *CreateBillingGroupInput {
	s.ComputationPreference = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBillingGroupInput) SetDescription(v string) *CreateBillingGroupInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateBillingGroupInput) SetName(v string) *CreateBillingGroupInput {
	s.Name = &v
	return s
}

// SetPrimaryAccountId sets the PrimaryAccountId field's value.
func (s *CreateBillingGroupInput) SetPrimaryAccountId(v string) *CreateBillingGroupInput {
	s.PrimaryAccountId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateBillingGroupInput) SetTags(v map[string]*string) *CreateBillingGroupInput {
	s.Tags = v
	return s
}

type CreateBillingGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the created billing group.
	Arn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBillingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBillingGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateBillingGroupOutput) SetArn(v string) *CreateBillingGroupOutput {
	s.Arn = &v
	return s
}

type CreateCustomLineItemInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that references the billing group where the
	// custom line item applies to.
	//
	// BillingGroupArn is a required field
	BillingGroupArn *string `type:"string" required:"true"`

	// A time range for which the custom line item is effective.
	BillingPeriodRange *CustomLineItemBillingPeriodRange `type:"structure"`

	// A CustomLineItemChargeDetails that describes the charge details for a custom
	// line item.
	//
	// ChargeDetails is a required field
	ChargeDetails *CustomLineItemChargeDetails `type:"structure" required:"true"`

	// The token that is needed to support idempotency. Idempotency isn't currently
	// supported, but will be implemented in a future update.
	ClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The description of the custom line item. This is shown on the Bills page
	// in association with the charge value.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateCustomLineItemInput's
	// String and GoString methods.
	//
	// Description is a required field
	Description *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The name of the custom line item.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateCustomLineItemInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// A map that contains tag keys and tag values that are attached to a custom
	// line item.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomLineItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomLineItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCustomLineItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCustomLineItemInput"}
	if s.BillingGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BillingGroupArn"))
	}
	if s.ChargeDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("ChargeDetails"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.BillingPeriodRange != nil {
		if err := s.BillingPeriodRange.Validate(); err != nil {
			invalidParams.AddNested("BillingPeriodRange", err.(request.ErrInvalidParams))
		}
	}
	if s.ChargeDetails != nil {
		if err := s.ChargeDetails.Validate(); err != nil {
			invalidParams.AddNested("ChargeDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingGroupArn sets the BillingGroupArn field's value.
func (s *CreateCustomLineItemInput) SetBillingGroupArn(v string) *CreateCustomLineItemInput {
	s.BillingGroupArn = &v
	return s
}

// SetBillingPeriodRange sets the BillingPeriodRange field's value.
func (s *CreateCustomLineItemInput) SetBillingPeriodRange(v *CustomLineItemBillingPeriodRange) *CreateCustomLineItemInput {
	s.BillingPeriodRange = v
	return s
}

// SetChargeDetails sets the ChargeDetails field's value.
func (s *CreateCustomLineItemInput) SetChargeDetails(v *CustomLineItemChargeDetails) *CreateCustomLineItemInput {
	s.ChargeDetails = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateCustomLineItemInput) SetClientToken(v string) *CreateCustomLineItemInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateCustomLineItemInput) SetDescription(v string) *CreateCustomLineItemInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCustomLineItemInput) SetName(v string) *CreateCustomLineItemInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCustomLineItemInput) SetTags(v map[string]*string) *CreateCustomLineItemInput {
	s.Tags = v
	return s
}

type CreateCustomLineItemOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the created custom line item.
	Arn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomLineItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomLineItemOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateCustomLineItemOutput) SetArn(v string) *CreateCustomLineItemOutput {
	s.Arn = &v
	return s
}

// The possible Amazon Web Services Free Tier configurations.
type CreateFreeTierConfig struct {
	_ struct{} `type:"structure"`

	// Activate or deactivate Amazon Web Services Free Tier.
	//
	// Activated is a required field
	Activated *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFreeTierConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFreeTierConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFreeTierConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFreeTierConfig"}
	if s.Activated == nil {
		invalidParams.Add(request.NewErrParamRequired("Activated"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivated sets the Activated field's value.
func (s *CreateFreeTierConfig) SetActivated(v bool) *CreateFreeTierConfig {
	s.Activated = &v
	return s
}

type CreatePricingPlanInput struct {
	_ struct{} `type:"structure"`

	// The token that is needed to support idempotency. Idempotency isn't currently
	// supported, but will be implemented in a future update.
	ClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The description of the pricing plan.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreatePricingPlanInput's
	// String and GoString methods.
	Description *string `type:"string" sensitive:"true"`

	// The name of the pricing plan. The names must be unique to each pricing plan.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreatePricingPlanInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// A list of Amazon Resource Names (ARNs) that define the pricing plan parameters.
	PricingRuleArns []*string `type:"list"`

	// A map that contains tag keys and tag values that are attached to a pricing
	// plan.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePricingPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePricingPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePricingPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePricingPlanInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePricingPlanInput) SetClientToken(v string) *CreatePricingPlanInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreatePricingPlanInput) SetDescription(v string) *CreatePricingPlanInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePricingPlanInput) SetName(v string) *CreatePricingPlanInput {
	s.Name = &v
	return s
}

// SetPricingRuleArns sets the PricingRuleArns field's value.
func (s *CreatePricingPlanInput) SetPricingRuleArns(v []*string) *CreatePricingPlanInput {
	s.PricingRuleArns = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePricingPlanInput) SetTags(v map[string]*string) *CreatePricingPlanInput {
	s.Tags = v
	return s
}

type CreatePricingPlanOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the created pricing plan.
	Arn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePricingPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePricingPlanOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreatePricingPlanOutput) SetArn(v string) *CreatePricingPlanOutput {
	s.Arn = &v
	return s
}

type CreatePricingRuleInput struct {
	_ struct{} `type:"structure"`

	// The seller of services provided by Amazon Web Services, their affiliates,
	// or third-party providers selling services via Amazon Web Services Marketplace.
	BillingEntity *string `type:"string"`

	// The token that's needed to support idempotency. Idempotency isn't currently
	// supported, but will be implemented in a future update.
	ClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The pricing rule description.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreatePricingRuleInput's
	// String and GoString methods.
	Description *string `type:"string" sensitive:"true"`

	// A percentage modifier that's applied on the public pricing rates.
	ModifierPercentage *float64 `type:"double"`

	// The pricing rule name. The names must be unique to each pricing rule.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreatePricingRuleInput's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// Operation is the specific Amazon Web Services action covered by this line
	// item. This describes the specific usage of the line item.
	//
	// If the Scope attribute is set to SKU, this attribute indicates which operation
	// the PricingRule is modifying. For example, a value of RunInstances:0202 indicates
	// the operation of running an Amazon EC2 instance.
	Operation *string `min:"1" type:"string"`

	// The scope of pricing rule that indicates if it's globally applicable, or
	// it's service-specific.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true" enum:"PricingRuleScope"`

	// If the Scope attribute is set to SERVICE or SKU, the attribute indicates
	// which service the PricingRule is applicable for.
	Service *string `min:"1" type:"string"`

	// A map that contains tag keys and tag values that are attached to a pricing
	// rule.
	Tags map[string]*string `min:"1" type:"map"`

	// The set of tiering configurations for the pricing rule.
	Tiering *CreateTieringInput_ `type:"structure"`

	// The type of pricing rule.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"PricingRuleType"`

	// Usage type is the unit that each service uses to measure the usage of a specific
	// type of resource.
	UsageType *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePricingRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePricingRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePricingRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePricingRuleInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Operation != nil && len(*s.Operation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Operation", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}
	if s.Service != nil && len(*s.Service) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Service", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.UsageType != nil && len(*s.UsageType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UsageType", 1))
	}
	if s.Tiering != nil {
		if err := s.Tiering.Validate(); err != nil {
			invalidParams.AddNested("Tiering", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingEntity sets the BillingEntity field's value.
func (s *CreatePricingRuleInput) SetBillingEntity(v string) *CreatePricingRuleInput {
	s.BillingEntity = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePricingRuleInput) SetClientToken(v string) *CreatePricingRuleInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreatePricingRuleInput) SetDescription(v string) *CreatePricingRuleInput {
	s.Description = &v
	return s
}

// SetModifierPercentage sets the ModifierPercentage field's value.
func (s *CreatePricingRuleInput) SetModifierPercentage(v float64) *CreatePricingRuleInput {
	s.ModifierPercentage = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePricingRuleInput) SetName(v string) *CreatePricingRuleInput {
	s.Name = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *CreatePricingRuleInput) SetOperation(v string) *CreatePricingRuleInput {
	s.Operation = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *CreatePricingRuleInput) SetScope(v string) *CreatePricingRuleInput {
	s.Scope = &v
	return s
}

// SetService sets the Service field's value.
func (s *CreatePricingRuleInput) SetService(v string) *CreatePricingRuleInput {
	s.Service = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePricingRuleInput) SetTags(v map[string]*string) *CreatePricingRuleInput {
	s.Tags = v
	return s
}

// SetTiering sets the Tiering field's value.
func (s *CreatePricingRuleInput) SetTiering(v *CreateTieringInput_) *CreatePricingRuleInput {
	s.Tiering = v
	return s
}

// SetType sets the Type field's value.
func (s *CreatePricingRuleInput) SetType(v string) *CreatePricingRuleInput {
	s.Type = &v
	return s
}

// SetUsageType sets the UsageType field's value.
func (s *CreatePricingRuleInput) SetUsageType(v string) *CreatePricingRuleInput {
	s.UsageType = &v
	return s
}

type CreatePricingRuleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the created pricing rule.
	Arn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePricingRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePricingRuleOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreatePricingRuleOutput) SetArn(v string) *CreatePricingRuleOutput {
	s.Arn = &v
	return s
}

// The set of tiering configurations for the pricing rule.
type CreateTieringInput_ struct {
	_ struct{} `type:"structure"`

	// The possible Amazon Web Services Free Tier configurations.
	//
	// FreeTier is a required field
	FreeTier *CreateFreeTierConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTieringInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTieringInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTieringInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTieringInput_"}
	if s.FreeTier == nil {
		invalidParams.Add(request.NewErrParamRequired("FreeTier"))
	}
	if s.FreeTier != nil {
		if err := s.FreeTier.Validate(); err != nil {
			invalidParams.AddNested("FreeTier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFreeTier sets the FreeTier field's value.
func (s *CreateTieringInput_) SetFreeTier(v *CreateFreeTierConfig) *CreateTieringInput_ {
	s.FreeTier = v
	return s
}

// The billing period range in which the custom line item request will be applied.
type CustomLineItemBillingPeriodRange struct {
	_ struct{} `type:"structure"`

	// The inclusive end billing period that defines a billing period range where
	// a custom line is applied.
	ExclusiveEndBillingPeriod *string `type:"string"`

	// The inclusive start billing period that defines a billing period range where
	// a custom line is applied.
	//
	// InclusiveStartBillingPeriod is a required field
	InclusiveStartBillingPeriod *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLineItemBillingPeriodRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLineItemBillingPeriodRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomLineItemBillingPeriodRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomLineItemBillingPeriodRange"}
	if s.InclusiveStartBillingPeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("InclusiveStartBillingPeriod"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExclusiveEndBillingPeriod sets the ExclusiveEndBillingPeriod field's value.
func (s *CustomLineItemBillingPeriodRange) SetExclusiveEndBillingPeriod(v string) *CustomLineItemBillingPeriodRange {
	s.ExclusiveEndBillingPeriod = &v
	return s
}

// SetInclusiveStartBillingPeriod sets the InclusiveStartBillingPeriod field's value.
func (s *CustomLineItemBillingPeriodRange) SetInclusiveStartBillingPeriod(v string) *CustomLineItemBillingPeriodRange {
	s.InclusiveStartBillingPeriod = &v
	return s
}

// The charge details of a custom line item. It should contain only one of Flat
// or Percentage.
type CustomLineItemChargeDetails struct {
	_ struct{} `type:"structure"`

	// A CustomLineItemFlatChargeDetails that describes the charge details of a
	// flat custom line item.
	Flat *CustomLineItemFlatChargeDetails `type:"structure"`

	// A CustomLineItemPercentageChargeDetails that describes the charge details
	// of a percentage custom line item.
	Percentage *CustomLineItemPercentageChargeDetails `type:"structure"`

	// The type of the custom line item that indicates whether the charge is a fee
	// or credit.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"CustomLineItemType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLineItemChargeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLineItemChargeDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomLineItemChargeDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomLineItemChargeDetails"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Flat != nil {
		if err := s.Flat.Validate(); err != nil {
			invalidParams.AddNested("Flat", err.(request.ErrInvalidParams))
		}
	}
	if s.Percentage != nil {
		if err := s.Percentage.Validate(); err != nil {
			invalidParams.AddNested("Percentage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlat sets the Flat field's value.
func (s *CustomLineItemChargeDetails) SetFlat(v *CustomLineItemFlatChargeDetails) *CustomLineItemChargeDetails {
	s.Flat = v
	return s
}

// SetPercentage sets the Percentage field's value.
func (s *CustomLineItemChargeDetails) SetPercentage(v *CustomLineItemPercentageChargeDetails) *CustomLineItemChargeDetails {
	s.Percentage = v
	return s
}

// SetType sets the Type field's value.
func (s *CustomLineItemChargeDetails) SetType(v string) *CustomLineItemChargeDetails {
	s.Type = &v
	return s
}

// A representation of the charge details that are associated with a flat custom
// line item.
type CustomLineItemFlatChargeDetails struct {
	_ struct{} `type:"structure"`

	// The custom line item's fixed charge value in USD.
	//
	// ChargeValue is a required field
	ChargeValue *float64 `type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLineItemFlatChargeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLineItemFlatChargeDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomLineItemFlatChargeDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomLineItemFlatChargeDetails"}
	if s.ChargeValue == nil {
		invalidParams.Add(request.NewErrParamRequired("ChargeValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChargeValue sets the ChargeValue field's value.
func (s *CustomLineItemFlatChargeDetails) SetChargeValue(v float64) *CustomLineItemFlatChargeDetails {
	s.ChargeValue = &v
	return s
}

// A representation of a custom line item.
type CustomLineItemListElement struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Names (ARNs) for custom line items.
	Arn *string `type:"string"`

	// The number of resources that are associated to the custom line item.
	AssociationSize *int64 `type:"long"`

	// The Amazon Resource Name (ARN) that references the billing group where the
	// custom line item applies to.
	BillingGroupArn *string `type:"string"`

	// A ListCustomLineItemChargeDetails that describes the charge details of a
	// custom line item.
	ChargeDetails *ListCustomLineItemChargeDetails `type:"structure"`

	// The time created.
	CreationTime *int64 `type:"long"`

	// The custom line item's charge value currency. Only one of the valid values
	// can be used.
	CurrencyCode *string `type:"string" enum:"CurrencyCode"`

	// The custom line item's description. This is shown on the Bills page in association
	// with the charge value.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CustomLineItemListElement's
	// String and GoString methods.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The most recent time when the custom line item was modified.
	LastModifiedTime *int64 `type:"long"`

	// The custom line item's name.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CustomLineItemListElement's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The product code that's associated with the custom line item.
	ProductCode *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLineItemListElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLineItemListElement) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CustomLineItemListElement) SetArn(v string) *CustomLineItemListElement {
	s.Arn = &v
	return s
}

// SetAssociationSize sets the AssociationSize field's value.
func (s *CustomLineItemListElement) SetAssociationSize(v int64) *CustomLineItemListElement {
	s.AssociationSize = &v
	return s
}

// SetBillingGroupArn sets the BillingGroupArn field's value.
func (s *CustomLineItemListElement) SetBillingGroupArn(v string) *CustomLineItemListElement {
	s.BillingGroupArn = &v
	return s
}

// SetChargeDetails sets the ChargeDetails field's value.
func (s *CustomLineItemListElement) SetChargeDetails(v *ListCustomLineItemChargeDetails) *CustomLineItemListElement {
	s.ChargeDetails = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CustomLineItemListElement) SetCreationTime(v int64) *CustomLineItemListElement {
	s.CreationTime = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *CustomLineItemListElement) SetCurrencyCode(v string) *CustomLineItemListElement {
	s.CurrencyCode = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CustomLineItemListElement) SetDescription(v string) *CustomLineItemListElement {
	s.Description = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CustomLineItemListElement) SetLastModifiedTime(v int64) *CustomLineItemListElement {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *CustomLineItemListElement) SetName(v string) *CustomLineItemListElement {
	s.Name = &v
	return s
}

// SetProductCode sets the ProductCode field's value.
func (s *CustomLineItemListElement) SetProductCode(v string) *CustomLineItemListElement {
	s.ProductCode = &v
	return s
}

// A representation of the charge details that are associated with a percentage
// custom line item.
type CustomLineItemPercentageChargeDetails struct {
	_ struct{} `type:"structure"`

	// A list of resource ARNs to associate to the percentage custom line item.
	AssociatedValues []*string `type:"list"`

	// The custom line item's percentage value. This will be multiplied against
	// the combined value of its associated resources to determine its charge value.
	//
	// PercentageValue is a required field
	PercentageValue *float64 `type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLineItemPercentageChargeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLineItemPercentageChargeDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomLineItemPercentageChargeDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomLineItemPercentageChargeDetails"}
	if s.PercentageValue == nil {
		invalidParams.Add(request.NewErrParamRequired("PercentageValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociatedValues sets the AssociatedValues field's value.
func (s *CustomLineItemPercentageChargeDetails) SetAssociatedValues(v []*string) *CustomLineItemPercentageChargeDetails {
	s.AssociatedValues = v
	return s
}

// SetPercentageValue sets the PercentageValue field's value.
func (s *CustomLineItemPercentageChargeDetails) SetPercentageValue(v float64) *CustomLineItemPercentageChargeDetails {
	s.PercentageValue = &v
	return s
}

// A representation of a custom line item version.
type CustomLineItemVersionListElement struct {
	_ struct{} `type:"structure"`

	// A list of custom line item Amazon Resource Names (ARNs) to retrieve information.
	Arn *string `type:"string"`

	// The number of resources that are associated with the custom line item.
	AssociationSize *int64 `type:"long"`

	// The Amazon Resource Name (ARN) of the billing group that the custom line
	// item applies to.
	BillingGroupArn *string `type:"string"`

	// A representation of the charge details of a custom line item.
	ChargeDetails *ListCustomLineItemChargeDetails `type:"structure"`

	// The time when the custom line item version was created.
	CreationTime *int64 `type:"long"`

	// The charge value currency of the custom line item.
	CurrencyCode *string `type:"string" enum:"CurrencyCode"`

	// The description of the custom line item.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CustomLineItemVersionListElement's
	// String and GoString methods.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The end billing period of the custom line item version.
	EndBillingPeriod *string `type:"string"`

	// The most recent time that the custom line item version was modified.
	LastModifiedTime *int64 `type:"long"`

	// The name of the custom line item.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CustomLineItemVersionListElement's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The product code that’s associated with the custom line item.
	ProductCode *string `min:"1" type:"string"`

	// The start billing period of the custom line item version.
	StartBillingPeriod *string `type:"string"`

	// The inclusive start time.
	StartTime *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLineItemVersionListElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLineItemVersionListElement) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CustomLineItemVersionListElement) SetArn(v string) *CustomLineItemVersionListElement {
	s.Arn = &v
	return s
}

// SetAssociationSize sets the AssociationSize field's value.
func (s *CustomLineItemVersionListElement) SetAssociationSize(v int64) *CustomLineItemVersionListElement {
	s.AssociationSize = &v
	return s
}

// SetBillingGroupArn sets the BillingGroupArn field's value.
func (s *CustomLineItemVersionListElement) SetBillingGroupArn(v string) *CustomLineItemVersionListElement {
	s.BillingGroupArn = &v
	return s
}

// SetChargeDetails sets the ChargeDetails field's value.
func (s *CustomLineItemVersionListElement) SetChargeDetails(v *ListCustomLineItemChargeDetails) *CustomLineItemVersionListElement {
	s.ChargeDetails = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CustomLineItemVersionListElement) SetCreationTime(v int64) *CustomLineItemVersionListElement {
	s.CreationTime = &v
	return s
}

// SetCurrencyCode sets the CurrencyCode field's value.
func (s *CustomLineItemVersionListElement) SetCurrencyCode(v string) *CustomLineItemVersionListElement {
	s.CurrencyCode = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CustomLineItemVersionListElement) SetDescription(v string) *CustomLineItemVersionListElement {
	s.Description = &v
	return s
}

// SetEndBillingPeriod sets the EndBillingPeriod field's value.
func (s *CustomLineItemVersionListElement) SetEndBillingPeriod(v string) *CustomLineItemVersionListElement {
	s.EndBillingPeriod = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CustomLineItemVersionListElement) SetLastModifiedTime(v int64) *CustomLineItemVersionListElement {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *CustomLineItemVersionListElement) SetName(v string) *CustomLineItemVersionListElement {
	s.Name = &v
	return s
}

// SetProductCode sets the ProductCode field's value.
func (s *CustomLineItemVersionListElement) SetProductCode(v string) *CustomLineItemVersionListElement {
	s.ProductCode = &v
	return s
}

// SetStartBillingPeriod sets the StartBillingPeriod field's value.
func (s *CustomLineItemVersionListElement) SetStartBillingPeriod(v string) *CustomLineItemVersionListElement {
	s.StartBillingPeriod = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CustomLineItemVersionListElement) SetStartTime(v int64) *CustomLineItemVersionListElement {
	s.StartTime = &v
	return s
}

type DeleteBillingGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the billing group that you're deleting.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBillingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBillingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBillingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBillingGroupInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteBillingGroupInput) SetArn(v string) *DeleteBillingGroupInput {
	s.Arn = &v
	return s
}

type DeleteBillingGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted billing group.
	Arn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBillingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBillingGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteBillingGroupOutput) SetArn(v string) *DeleteBillingGroupOutput {
	s.Arn = &v
	return s
}

type DeleteCustomLineItemInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the custom line item to be deleted.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The billing period range in which the custom line item request will be applied.
	BillingPeriodRange *CustomLineItemBillingPeriodRange `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomLineItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomLineItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomLineItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomLineItemInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.BillingPeriodRange != nil {
		if err := s.BillingPeriodRange.Validate(); err != nil {
			invalidParams.AddNested("BillingPeriodRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteCustomLineItemInput) SetArn(v string) *DeleteCustomLineItemInput {
	s.Arn = &v
	return s
}

// SetBillingPeriodRange sets the BillingPeriodRange field's value.
func (s *DeleteCustomLineItemInput) SetBillingPeriodRange(v *CustomLineItemBillingPeriodRange) *DeleteCustomLineItemInput {
	s.BillingPeriodRange = v
	return s
}

type DeleteCustomLineItemOutput struct {
	_ struct{} `type:"structure"`

	// Then ARN of the deleted custom line item.
	Arn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomLineItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomLineItemOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeleteCustomLineItemOutput) SetArn(v string) *DeleteCustomLineItemOutput {
	s.Arn = &v
	return s
}

type DeletePricingPlanInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the pricing plan that you're deleting.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePricingPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePricingPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePricingPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePricingPlanInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeletePricingPlanInput) SetArn(v string) *DeletePricingPlanInput {
	s.Arn = &v
	return s
}

type DeletePricingPlanOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted pricing plan.
	Arn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePricingPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePricingPlanOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeletePricingPlanOutput) SetArn(v string) *DeletePricingPlanOutput {
	s.Arn = &v
	return s
}

type DeletePricingRuleInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the pricing rule that you are deleting.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePricingRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePricingRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePricingRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePricingRuleInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeletePricingRuleInput) SetArn(v string) *DeletePricingRuleInput {
	s.Arn = &v
	return s
}

type DeletePricingRuleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted pricing rule.
	Arn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePricingRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePricingRuleOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeletePricingRuleOutput) SetArn(v string) *DeletePricingRuleOutput {
	s.Arn = &v
	return s
}

type DisassociateAccountsInput struct {
	_ struct{} `type:"structure"`

	// The array of account IDs to disassociate.
	//
	// AccountIds is a required field
	AccountIds []*string `min:"1" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the billing group that the array of account
	// IDs will disassociate from.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAccountsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateAccountsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateAccountsInput"}
	if s.AccountIds == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountIds sets the AccountIds field's value.
func (s *DisassociateAccountsInput) SetAccountIds(v []*string) *DisassociateAccountsInput {
	s.AccountIds = v
	return s
}

// SetArn sets the Arn field's value.
func (s *DisassociateAccountsInput) SetArn(v string) *DisassociateAccountsInput {
	s.Arn = &v
	return s
}

type DisassociateAccountsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the billing group that the array of account
	// IDs is disassociated from.
	Arn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAccountsOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DisassociateAccountsOutput) SetArn(v string) *DisassociateAccountsOutput {
	s.Arn = &v
	return s
}

type DisassociatePricingRulesInput struct {
	_ struct{} `type:"structure"`

	// The pricing plan Amazon Resource Name (ARN) to disassociate pricing rules
	// from.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// A list containing the Amazon Resource Name (ARN) of the pricing rules that
	// will be disassociated.
	//
	// PricingRuleArns is a required field
	PricingRuleArns []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociatePricingRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociatePricingRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociatePricingRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociatePricingRulesInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.PricingRuleArns == nil {
		invalidParams.Add(request.NewErrParamRequired("PricingRuleArns"))
	}
	if s.PricingRuleArns != nil && len(s.PricingRuleArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PricingRuleArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DisassociatePricingRulesInput) SetArn(v string) *DisassociatePricingRulesInput {
	s.Arn = &v
	return s
}

// SetPricingRuleArns sets the PricingRuleArns field's value.
func (s *DisassociatePricingRulesInput) SetPricingRuleArns(v []*string) *DisassociatePricingRulesInput {
	s.PricingRuleArns = v
	return s
}

type DisassociatePricingRulesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the pricing plan that the pricing rules
	// successfully disassociated from.
	Arn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociatePricingRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociatePricingRulesOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DisassociatePricingRulesOutput) SetArn(v string) *DisassociatePricingRulesOutput {
	s.Arn = &v
	return s
}

// A resource disassociation result for a percentage custom line item.
type DisassociateResourceResponseElement struct {
	_ struct{} `type:"structure"`

	// The resource ARN that was disassociated from the custom line item.
	Arn *string `type:"string"`

	// An AssociateResourceError that's shown if the resource disassociation fails.
	Error *AssociateResourceError `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResourceResponseElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResourceResponseElement) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DisassociateResourceResponseElement) SetArn(v string) *DisassociateResourceResponseElement {
	s.Arn = &v
	return s
}

// SetError sets the Error field's value.
func (s *DisassociateResourceResponseElement) SetError(v *AssociateResourceError) *DisassociateResourceResponseElement {
	s.Error = v
	return s
}

// The possible Amazon Web Services Free Tier configurations.
type FreeTierConfig struct {
	_ struct{} `type:"structure"`

	// Activate or deactivate Amazon Web Services Free Tier application.
	//
	// Activated is a required field
	Activated *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FreeTierConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FreeTierConfig) GoString() string {
	return s.String()
}

// SetActivated sets the Activated field's value.
func (s *FreeTierConfig) SetActivated(v bool) *FreeTierConfig {
	s.Activated = &v
	return s
}

// An unexpected error occurred while processing a request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Number of seconds you can retry after the call.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The filter on the account ID of the linked account, or any of the following:
//
// MONITORED: linked accounts that are associated to billing groups.
//
// UNMONITORED: linked accounts that are not associated to billing groups.
//
// Billing Group Arn: linked accounts that are associated to the provided Billing
// Group Arn.
type ListAccountAssociationsFilter struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID to filter on.
	AccountId *string `type:"string"`

	// The list of Amazon Web Services IDs to retrieve their associated billing
	// group for a given time range.
	AccountIds []*string `min:"1" type:"list"`

	// MONITORED: linked accounts that are associated to billing groups.
	//
	// UNMONITORED: linked accounts that are not associated to billing groups.
	//
	// Billing Group Arn: linked accounts that are associated to the provided Billing
	// Group Arn.
	Association *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssociationsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssociationsFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountAssociationsFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountAssociationsFilter"}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListAccountAssociationsFilter) SetAccountId(v string) *ListAccountAssociationsFilter {
	s.AccountId = &v
	return s
}

// SetAccountIds sets the AccountIds field's value.
func (s *ListAccountAssociationsFilter) SetAccountIds(v []*string) *ListAccountAssociationsFilter {
	s.AccountIds = v
	return s
}

// SetAssociation sets the Association field's value.
func (s *ListAccountAssociationsFilter) SetAssociation(v string) *ListAccountAssociationsFilter {
	s.Association = &v
	return s
}

type ListAccountAssociationsInput struct {
	_ struct{} `type:"structure"`

	// The preferred billing period to get account associations.
	BillingPeriod *string `type:"string"`

	// The filter on the account ID of the linked account, or any of the following:
	//
	// MONITORED: linked accounts that are associated to billing groups.
	//
	// UNMONITORED: linked accounts that aren't associated to billing groups.
	//
	// Billing Group Arn: linked accounts that are associated to the provided billing
	// group Arn.
	Filters *ListAccountAssociationsFilter `type:"structure"`

	// The pagination token that's used on subsequent calls to retrieve accounts.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountAssociationsInput"}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingPeriod sets the BillingPeriod field's value.
func (s *ListAccountAssociationsInput) SetBillingPeriod(v string) *ListAccountAssociationsInput {
	s.BillingPeriod = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListAccountAssociationsInput) SetFilters(v *ListAccountAssociationsFilter) *ListAccountAssociationsInput {
	s.Filters = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountAssociationsInput) SetNextToken(v string) *ListAccountAssociationsInput {
	s.NextToken = &v
	return s
}

type ListAccountAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of linked accounts in the payer account.
	LinkedAccounts []*AccountAssociationsListElement `type:"list"`

	// The pagination token that's used on subsequent calls to get accounts.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssociationsOutput) GoString() string {
	return s.String()
}

// SetLinkedAccounts sets the LinkedAccounts field's value.
func (s *ListAccountAssociationsOutput) SetLinkedAccounts(v []*AccountAssociationsListElement) *ListAccountAssociationsOutput {
	s.LinkedAccounts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountAssociationsOutput) SetNextToken(v string) *ListAccountAssociationsOutput {
	s.NextToken = &v
	return s
}

// Specifies if the billing group has the following features enabled.
type ListBillingGroupAccountGrouping struct {
	_ struct{} `type:"structure"`

	// Specifies if this billing group will automatically associate newly added
	// Amazon Web Services accounts that join your consolidated billing family.
	AutoAssociate *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBillingGroupAccountGrouping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBillingGroupAccountGrouping) GoString() string {
	return s.String()
}

// SetAutoAssociate sets the AutoAssociate field's value.
func (s *ListBillingGroupAccountGrouping) SetAutoAssociate(v bool) *ListBillingGroupAccountGrouping {
	s.AutoAssociate = &v
	return s
}

// The filter used to retrieve specific BillingGroupCostReportElements.
type ListBillingGroupCostReportsFilter struct {
	_ struct{} `type:"structure"`

	// The list of Amazon Resource Names (ARNs) used to filter billing groups to
	// retrieve reports.
	BillingGroupArns []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBillingGroupCostReportsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBillingGroupCostReportsFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBillingGroupCostReportsFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBillingGroupCostReportsFilter"}
	if s.BillingGroupArns != nil && len(s.BillingGroupArns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BillingGroupArns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingGroupArns sets the BillingGroupArns field's value.
func (s *ListBillingGroupCostReportsFilter) SetBillingGroupArns(v []*string) *ListBillingGroupCostReportsFilter {
	s.BillingGroupArns = v
	return s
}

type ListBillingGroupCostReportsInput struct {
	_ struct{} `type:"structure"`

	// The preferred billing period for your report.
	BillingPeriod *string `type:"string"`

	// A ListBillingGroupCostReportsFilter to specify billing groups to retrieve
	// reports from.
	Filters *ListBillingGroupCostReportsFilter `type:"structure"`

	// The maximum number of reports to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token that's used on subsequent calls to get reports.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBillingGroupCostReportsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBillingGroupCostReportsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBillingGroupCostReportsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBillingGroupCostReportsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingPeriod sets the BillingPeriod field's value.
func (s *ListBillingGroupCostReportsInput) SetBillingPeriod(v string) *ListBillingGroupCostReportsInput {
	s.BillingPeriod = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListBillingGroupCostReportsInput) SetFilters(v *ListBillingGroupCostReportsFilter) *ListBillingGroupCostReportsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBillingGroupCostReportsInput) SetMaxResults(v int64) *ListBillingGroupCostReportsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBillingGroupCostReportsInput) SetNextToken(v string) *ListBillingGroupCostReportsInput {
	s.NextToken = &v
	return s
}

type ListBillingGroupCostReportsOutput struct {
	_ struct{} `type:"structure"`

	// A list of BillingGroupCostReportElement retrieved.
	BillingGroupCostReports []*BillingGroupCostReportElement `type:"list"`

	// The pagination token that's used on subsequent calls to get reports.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBillingGroupCostReportsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBillingGroupCostReportsOutput) GoString() string {
	return s.String()
}

// SetBillingGroupCostReports sets the BillingGroupCostReports field's value.
func (s *ListBillingGroupCostReportsOutput) SetBillingGroupCostReports(v []*BillingGroupCostReportElement) *ListBillingGroupCostReportsOutput {
	s.BillingGroupCostReports = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBillingGroupCostReportsOutput) SetNextToken(v string) *ListBillingGroupCostReportsOutput {
	s.NextToken = &v
	return s
}

// The filter that specifies the billing groups and pricing plans to retrieve
// billing group information.
type ListBillingGroupsFilter struct {
	_ struct{} `type:"structure"`

	// The list of billing group Amazon Resource Names (ARNs) to retrieve information.
	Arns []*string `min:"1" type:"list"`

	// Specifies if this billing group will automatically associate newly added
	// Amazon Web Services accounts that join your consolidated billing family.
	AutoAssociate *bool `type:"boolean"`

	// The pricing plan Amazon Resource Names (ARNs) to retrieve information.
	PricingPlan *string `type:"string"`

	// A list of billing groups to retrieve their current status for a specific
	// time range
	Statuses []*string `min:"1" type:"list" enum:"BillingGroupStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBillingGroupsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBillingGroupsFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBillingGroupsFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBillingGroupsFilter"}
	if s.Arns != nil && len(s.Arns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arns", 1))
	}
	if s.Statuses != nil && len(s.Statuses) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Statuses", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArns sets the Arns field's value.
func (s *ListBillingGroupsFilter) SetArns(v []*string) *ListBillingGroupsFilter {
	s.Arns = v
	return s
}

// SetAutoAssociate sets the AutoAssociate field's value.
func (s *ListBillingGroupsFilter) SetAutoAssociate(v bool) *ListBillingGroupsFilter {
	s.AutoAssociate = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *ListBillingGroupsFilter) SetPricingPlan(v string) *ListBillingGroupsFilter {
	s.PricingPlan = &v
	return s
}

// SetStatuses sets the Statuses field's value.
func (s *ListBillingGroupsFilter) SetStatuses(v []*string) *ListBillingGroupsFilter {
	s.Statuses = v
	return s
}

type ListBillingGroupsInput struct {
	_ struct{} `type:"structure"`

	// The preferred billing period to get billing groups.
	BillingPeriod *string `type:"string"`

	// A ListBillingGroupsFilter that specifies the billing group and pricing plan
	// to retrieve billing group information.
	Filters *ListBillingGroupsFilter `type:"structure"`

	// The maximum number of billing groups to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token that's used on subsequent calls to get billing groups.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBillingGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBillingGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBillingGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBillingGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingPeriod sets the BillingPeriod field's value.
func (s *ListBillingGroupsInput) SetBillingPeriod(v string) *ListBillingGroupsInput {
	s.BillingPeriod = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListBillingGroupsInput) SetFilters(v *ListBillingGroupsFilter) *ListBillingGroupsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBillingGroupsInput) SetMaxResults(v int64) *ListBillingGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBillingGroupsInput) SetNextToken(v string) *ListBillingGroupsInput {
	s.NextToken = &v
	return s
}

type ListBillingGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of BillingGroupListElement retrieved.
	BillingGroups []*BillingGroupListElement `type:"list"`

	// The pagination token that's used on subsequent calls to get billing groups.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBillingGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBillingGroupsOutput) GoString() string {
	return s.String()
}

// SetBillingGroups sets the BillingGroups field's value.
func (s *ListBillingGroupsOutput) SetBillingGroups(v []*BillingGroupListElement) *ListBillingGroupsOutput {
	s.BillingGroups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBillingGroupsOutput) SetNextToken(v string) *ListBillingGroupsOutput {
	s.NextToken = &v
	return s
}

// A representation of the charge details of a custom line item.
type ListCustomLineItemChargeDetails struct {
	_ struct{} `type:"structure"`

	// A ListCustomLineItemFlatChargeDetails that describes the charge details of
	// a flat custom line item.
	Flat *ListCustomLineItemFlatChargeDetails `type:"structure"`

	// A ListCustomLineItemPercentageChargeDetails that describes the charge details
	// of a percentage custom line item.
	Percentage *ListCustomLineItemPercentageChargeDetails `type:"structure"`

	// The type of the custom line item that indicates whether the charge is a fee
	// or credit.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"CustomLineItemType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomLineItemChargeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomLineItemChargeDetails) GoString() string {
	return s.String()
}

// SetFlat sets the Flat field's value.
func (s *ListCustomLineItemChargeDetails) SetFlat(v *ListCustomLineItemFlatChargeDetails) *ListCustomLineItemChargeDetails {
	s.Flat = v
	return s
}

// SetPercentage sets the Percentage field's value.
func (s *ListCustomLineItemChargeDetails) SetPercentage(v *ListCustomLineItemPercentageChargeDetails) *ListCustomLineItemChargeDetails {
	s.Percentage = v
	return s
}

// SetType sets the Type field's value.
func (s *ListCustomLineItemChargeDetails) SetType(v string) *ListCustomLineItemChargeDetails {
	s.Type = &v
	return s
}

// A representation of the charge details that are associated with a flat custom
// line item.
type ListCustomLineItemFlatChargeDetails struct {
	_ struct{} `type:"structure"`

	// The custom line item's fixed charge value in USD.
	//
	// ChargeValue is a required field
	ChargeValue *float64 `type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomLineItemFlatChargeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomLineItemFlatChargeDetails) GoString() string {
	return s.String()
}

// SetChargeValue sets the ChargeValue field's value.
func (s *ListCustomLineItemFlatChargeDetails) SetChargeValue(v float64) *ListCustomLineItemFlatChargeDetails {
	s.ChargeValue = &v
	return s
}

// A representation of the charge details that are associated with a percentage
// custom line item.
type ListCustomLineItemPercentageChargeDetails struct {
	_ struct{} `type:"structure"`

	// The custom line item's percentage value. This will be multiplied against
	// the combined value of its associated resources to determine its charge value.
	//
	// PercentageValue is a required field
	PercentageValue *float64 `type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomLineItemPercentageChargeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomLineItemPercentageChargeDetails) GoString() string {
	return s.String()
}

// SetPercentageValue sets the PercentageValue field's value.
func (s *ListCustomLineItemPercentageChargeDetails) SetPercentageValue(v float64) *ListCustomLineItemPercentageChargeDetails {
	s.PercentageValue = &v
	return s
}

// A billing period filter that specifies the custom line item versions to retrieve.
type ListCustomLineItemVersionsBillingPeriodRangeFilter struct {
	_ struct{} `type:"structure"`

	// The exclusive end billing period that defines a billing period range where
	// a custom line item version is applied.
	EndBillingPeriod *string `type:"string"`

	// The inclusive start billing period that defines a billing period range where
	// a custom line item version is applied.
	StartBillingPeriod *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomLineItemVersionsBillingPeriodRangeFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomLineItemVersionsBillingPeriodRangeFilter) GoString() string {
	return s.String()
}

// SetEndBillingPeriod sets the EndBillingPeriod field's value.
func (s *ListCustomLineItemVersionsBillingPeriodRangeFilter) SetEndBillingPeriod(v string) *ListCustomLineItemVersionsBillingPeriodRangeFilter {
	s.EndBillingPeriod = &v
	return s
}

// SetStartBillingPeriod sets the StartBillingPeriod field's value.
func (s *ListCustomLineItemVersionsBillingPeriodRangeFilter) SetStartBillingPeriod(v string) *ListCustomLineItemVersionsBillingPeriodRangeFilter {
	s.StartBillingPeriod = &v
	return s
}

// A filter that specifies the billing period range where the custom line item
// versions reside.
type ListCustomLineItemVersionsFilter struct {
	_ struct{} `type:"structure"`

	// The billing period range in which the custom line item version is applied.
	BillingPeriodRange *ListCustomLineItemVersionsBillingPeriodRangeFilter `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomLineItemVersionsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomLineItemVersionsFilter) GoString() string {
	return s.String()
}

// SetBillingPeriodRange sets the BillingPeriodRange field's value.
func (s *ListCustomLineItemVersionsFilter) SetBillingPeriodRange(v *ListCustomLineItemVersionsBillingPeriodRangeFilter) *ListCustomLineItemVersionsFilter {
	s.BillingPeriodRange = v
	return s
}

type ListCustomLineItemVersionsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the custom line item.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// A ListCustomLineItemVersionsFilter that specifies the billing period range
	// in which the custom line item versions are applied.
	Filters *ListCustomLineItemVersionsFilter `type:"structure"`

	// The maximum number of custom line item versions to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token that's used on subsequent calls to retrieve custom line
	// item versions.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomLineItemVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomLineItemVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCustomLineItemVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCustomLineItemVersionsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListCustomLineItemVersionsInput) SetArn(v string) *ListCustomLineItemVersionsInput {
	s.Arn = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListCustomLineItemVersionsInput) SetFilters(v *ListCustomLineItemVersionsFilter) *ListCustomLineItemVersionsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCustomLineItemVersionsInput) SetMaxResults(v int64) *ListCustomLineItemVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomLineItemVersionsInput) SetNextToken(v string) *ListCustomLineItemVersionsInput {
	s.NextToken = &v
	return s
}

type ListCustomLineItemVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of CustomLineItemVersionListElements that are received.
	CustomLineItemVersions []*CustomLineItemVersionListElement `type:"list"`

	// The pagination token that's used on subsequent calls to retrieve custom line
	// item versions.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomLineItemVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomLineItemVersionsOutput) GoString() string {
	return s.String()
}

// SetCustomLineItemVersions sets the CustomLineItemVersions field's value.
func (s *ListCustomLineItemVersionsOutput) SetCustomLineItemVersions(v []*CustomLineItemVersionListElement) *ListCustomLineItemVersionsOutput {
	s.CustomLineItemVersions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomLineItemVersionsOutput) SetNextToken(v string) *ListCustomLineItemVersionsOutput {
	s.NextToken = &v
	return s
}

// A filter that specifies the custom line items and billing groups to retrieve
// FFLI information.
type ListCustomLineItemsFilter struct {
	_ struct{} `type:"structure"`

	// A list of custom line item ARNs to retrieve information.
	Arns []*string `min:"1" type:"list"`

	// The billing group Amazon Resource Names (ARNs) to retrieve information.
	BillingGroups []*string `min:"1" type:"list"`

	// A list of custom line items to retrieve information.
	Names []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomLineItemsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomLineItemsFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCustomLineItemsFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCustomLineItemsFilter"}
	if s.Arns != nil && len(s.Arns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arns", 1))
	}
	if s.BillingGroups != nil && len(s.BillingGroups) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BillingGroups", 1))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Names", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArns sets the Arns field's value.
func (s *ListCustomLineItemsFilter) SetArns(v []*string) *ListCustomLineItemsFilter {
	s.Arns = v
	return s
}

// SetBillingGroups sets the BillingGroups field's value.
func (s *ListCustomLineItemsFilter) SetBillingGroups(v []*string) *ListCustomLineItemsFilter {
	s.BillingGroups = v
	return s
}

// SetNames sets the Names field's value.
func (s *ListCustomLineItemsFilter) SetNames(v []*string) *ListCustomLineItemsFilter {
	s.Names = v
	return s
}

type ListCustomLineItemsInput struct {
	_ struct{} `type:"structure"`

	// The preferred billing period to get custom line items (FFLIs).
	BillingPeriod *string `type:"string"`

	// A ListCustomLineItemsFilter that specifies the custom line item names and/or
	// billing group Amazon Resource Names (ARNs) to retrieve FFLI information.
	Filters *ListCustomLineItemsFilter `type:"structure"`

	// The maximum number of billing groups to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token that's used on subsequent calls to get custom line items
	// (FFLIs).
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomLineItemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomLineItemsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCustomLineItemsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCustomLineItemsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingPeriod sets the BillingPeriod field's value.
func (s *ListCustomLineItemsInput) SetBillingPeriod(v string) *ListCustomLineItemsInput {
	s.BillingPeriod = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListCustomLineItemsInput) SetFilters(v *ListCustomLineItemsFilter) *ListCustomLineItemsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCustomLineItemsInput) SetMaxResults(v int64) *ListCustomLineItemsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomLineItemsInput) SetNextToken(v string) *ListCustomLineItemsInput {
	s.NextToken = &v
	return s
}

type ListCustomLineItemsOutput struct {
	_ struct{} `type:"structure"`

	// A list of FreeFormLineItemListElements received.
	CustomLineItems []*CustomLineItemListElement `type:"list"`

	// The pagination token that's used on subsequent calls to get custom line items
	// (FFLIs).
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomLineItemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomLineItemsOutput) GoString() string {
	return s.String()
}

// SetCustomLineItems sets the CustomLineItems field's value.
func (s *ListCustomLineItemsOutput) SetCustomLineItems(v []*CustomLineItemListElement) *ListCustomLineItemsOutput {
	s.CustomLineItems = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomLineItemsOutput) SetNextToken(v string) *ListCustomLineItemsOutput {
	s.NextToken = &v
	return s
}

type ListPricingPlansAssociatedWithPricingRuleInput struct {
	_ struct{} `type:"structure"`

	// The pricing plan billing period for which associations will be listed.
	BillingPeriod *string `type:"string"`

	// The optional maximum number of pricing rule associations to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The optional pagination token returned by a previous call.
	NextToken *string `type:"string"`

	// The pricing rule Amazon Resource Name (ARN) for which associations will be
	// listed.
	//
	// PricingRuleArn is a required field
	PricingRuleArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPricingPlansAssociatedWithPricingRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPricingPlansAssociatedWithPricingRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPricingPlansAssociatedWithPricingRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPricingPlansAssociatedWithPricingRuleInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PricingRuleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PricingRuleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingPeriod sets the BillingPeriod field's value.
func (s *ListPricingPlansAssociatedWithPricingRuleInput) SetBillingPeriod(v string) *ListPricingPlansAssociatedWithPricingRuleInput {
	s.BillingPeriod = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPricingPlansAssociatedWithPricingRuleInput) SetMaxResults(v int64) *ListPricingPlansAssociatedWithPricingRuleInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPricingPlansAssociatedWithPricingRuleInput) SetNextToken(v string) *ListPricingPlansAssociatedWithPricingRuleInput {
	s.NextToken = &v
	return s
}

// SetPricingRuleArn sets the PricingRuleArn field's value.
func (s *ListPricingPlansAssociatedWithPricingRuleInput) SetPricingRuleArn(v string) *ListPricingPlansAssociatedWithPricingRuleInput {
	s.PricingRuleArn = &v
	return s
}

type ListPricingPlansAssociatedWithPricingRuleOutput struct {
	_ struct{} `type:"structure"`

	// The pricing plan billing period for which associations will be listed.
	BillingPeriod *string `type:"string"`

	// The pagination token to be used on subsequent calls.
	NextToken *string `type:"string"`

	// The list containing pricing plans that are associated with the requested
	// pricing rule.
	PricingPlanArns []*string `min:"1" type:"list"`

	// The pricing rule Amazon Resource Name (ARN) for which associations will be
	// listed.
	PricingRuleArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPricingPlansAssociatedWithPricingRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPricingPlansAssociatedWithPricingRuleOutput) GoString() string {
	return s.String()
}

// SetBillingPeriod sets the BillingPeriod field's value.
func (s *ListPricingPlansAssociatedWithPricingRuleOutput) SetBillingPeriod(v string) *ListPricingPlansAssociatedWithPricingRuleOutput {
	s.BillingPeriod = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPricingPlansAssociatedWithPricingRuleOutput) SetNextToken(v string) *ListPricingPlansAssociatedWithPricingRuleOutput {
	s.NextToken = &v
	return s
}

// SetPricingPlanArns sets the PricingPlanArns field's value.
func (s *ListPricingPlansAssociatedWithPricingRuleOutput) SetPricingPlanArns(v []*string) *ListPricingPlansAssociatedWithPricingRuleOutput {
	s.PricingPlanArns = v
	return s
}

// SetPricingRuleArn sets the PricingRuleArn field's value.
func (s *ListPricingPlansAssociatedWithPricingRuleOutput) SetPricingRuleArn(v string) *ListPricingPlansAssociatedWithPricingRuleOutput {
	s.PricingRuleArn = &v
	return s
}

// The filter that specifies the Amazon Resource Names (ARNs) of pricing plans,
// to retrieve pricing plan information.
type ListPricingPlansFilter struct {
	_ struct{} `type:"structure"`

	// A list of pricing plan Amazon Resource Names (ARNs) to retrieve information.
	Arns []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPricingPlansFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPricingPlansFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPricingPlansFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPricingPlansFilter"}
	if s.Arns != nil && len(s.Arns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArns sets the Arns field's value.
func (s *ListPricingPlansFilter) SetArns(v []*string) *ListPricingPlansFilter {
	s.Arns = v
	return s
}

type ListPricingPlansInput struct {
	_ struct{} `type:"structure"`

	// The preferred billing period to get pricing plan.
	BillingPeriod *string `type:"string"`

	// A ListPricingPlansFilter that specifies the Amazon Resource Name (ARNs) of
	// pricing plans to retrieve pricing plans information.
	Filters *ListPricingPlansFilter `type:"structure"`

	// The maximum number of pricing plans to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token that's used on subsequent call to get pricing plans.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPricingPlansInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPricingPlansInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPricingPlansInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPricingPlansInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingPeriod sets the BillingPeriod field's value.
func (s *ListPricingPlansInput) SetBillingPeriod(v string) *ListPricingPlansInput {
	s.BillingPeriod = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListPricingPlansInput) SetFilters(v *ListPricingPlansFilter) *ListPricingPlansInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPricingPlansInput) SetMaxResults(v int64) *ListPricingPlansInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPricingPlansInput) SetNextToken(v string) *ListPricingPlansInput {
	s.NextToken = &v
	return s
}

type ListPricingPlansOutput struct {
	_ struct{} `type:"structure"`

	// The billing period for which the described pricing plans are applicable.
	BillingPeriod *string `type:"string"`

	// The pagination token that's used on subsequent calls to get pricing plans.
	NextToken *string `type:"string"`

	// A list of PricingPlanListElement retrieved.
	PricingPlans []*PricingPlanListElement `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPricingPlansOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPricingPlansOutput) GoString() string {
	return s.String()
}

// SetBillingPeriod sets the BillingPeriod field's value.
func (s *ListPricingPlansOutput) SetBillingPeriod(v string) *ListPricingPlansOutput {
	s.BillingPeriod = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPricingPlansOutput) SetNextToken(v string) *ListPricingPlansOutput {
	s.NextToken = &v
	return s
}

// SetPricingPlans sets the PricingPlans field's value.
func (s *ListPricingPlansOutput) SetPricingPlans(v []*PricingPlanListElement) *ListPricingPlansOutput {
	s.PricingPlans = v
	return s
}

type ListPricingRulesAssociatedToPricingPlanInput struct {
	_ struct{} `type:"structure"`

	// The billing period for which the pricing rule associations are to be listed.
	BillingPeriod *string `type:"string"`

	// The optional maximum number of pricing rule associations to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The optional pagination token returned by a previous call.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) of the pricing plan for which associations
	// are to be listed.
	//
	// PricingPlanArn is a required field
	PricingPlanArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPricingRulesAssociatedToPricingPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPricingRulesAssociatedToPricingPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPricingRulesAssociatedToPricingPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPricingRulesAssociatedToPricingPlanInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PricingPlanArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PricingPlanArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingPeriod sets the BillingPeriod field's value.
func (s *ListPricingRulesAssociatedToPricingPlanInput) SetBillingPeriod(v string) *ListPricingRulesAssociatedToPricingPlanInput {
	s.BillingPeriod = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPricingRulesAssociatedToPricingPlanInput) SetMaxResults(v int64) *ListPricingRulesAssociatedToPricingPlanInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPricingRulesAssociatedToPricingPlanInput) SetNextToken(v string) *ListPricingRulesAssociatedToPricingPlanInput {
	s.NextToken = &v
	return s
}

// SetPricingPlanArn sets the PricingPlanArn field's value.
func (s *ListPricingRulesAssociatedToPricingPlanInput) SetPricingPlanArn(v string) *ListPricingRulesAssociatedToPricingPlanInput {
	s.PricingPlanArn = &v
	return s
}

type ListPricingRulesAssociatedToPricingPlanOutput struct {
	_ struct{} `type:"structure"`

	// The billing period for which the pricing rule associations are listed.
	BillingPeriod *string `type:"string"`

	// The pagination token to be used on subsequent calls.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) of the pricing plan for which associations
	// are listed.
	PricingPlanArn *string `type:"string"`

	// A list containing pricing rules that are associated with the requested pricing
	// plan.
	PricingRuleArns []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPricingRulesAssociatedToPricingPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPricingRulesAssociatedToPricingPlanOutput) GoString() string {
	return s.String()
}

// SetBillingPeriod sets the BillingPeriod field's value.
func (s *ListPricingRulesAssociatedToPricingPlanOutput) SetBillingPeriod(v string) *ListPricingRulesAssociatedToPricingPlanOutput {
	s.BillingPeriod = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPricingRulesAssociatedToPricingPlanOutput) SetNextToken(v string) *ListPricingRulesAssociatedToPricingPlanOutput {
	s.NextToken = &v
	return s
}

// SetPricingPlanArn sets the PricingPlanArn field's value.
func (s *ListPricingRulesAssociatedToPricingPlanOutput) SetPricingPlanArn(v string) *ListPricingRulesAssociatedToPricingPlanOutput {
	s.PricingPlanArn = &v
	return s
}

// SetPricingRuleArns sets the PricingRuleArns field's value.
func (s *ListPricingRulesAssociatedToPricingPlanOutput) SetPricingRuleArns(v []*string) *ListPricingRulesAssociatedToPricingPlanOutput {
	s.PricingRuleArns = v
	return s
}

// The filter that specifies criteria that the pricing rules returned by the
// ListPricingRules API will adhere to.
type ListPricingRulesFilter struct {
	_ struct{} `type:"structure"`

	// A list containing the pricing rule Amazon Resource Names (ARNs) to include
	// in the API response.
	Arns []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPricingRulesFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPricingRulesFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPricingRulesFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPricingRulesFilter"}
	if s.Arns != nil && len(s.Arns) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arns", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArns sets the Arns field's value.
func (s *ListPricingRulesFilter) SetArns(v []*string) *ListPricingRulesFilter {
	s.Arns = v
	return s
}

type ListPricingRulesInput struct {
	_ struct{} `type:"structure"`

	// The preferred billing period to get the pricing plan.
	BillingPeriod *string `type:"string"`

	// A DescribePricingRuleFilter that specifies the Amazon Resource Name (ARNs)
	// of pricing rules to retrieve pricing rules information.
	Filters *ListPricingRulesFilter `type:"structure"`

	// The maximum number of pricing rules to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token that's used on subsequent call to get pricing rules.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPricingRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPricingRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPricingRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPricingRulesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBillingPeriod sets the BillingPeriod field's value.
func (s *ListPricingRulesInput) SetBillingPeriod(v string) *ListPricingRulesInput {
	s.BillingPeriod = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListPricingRulesInput) SetFilters(v *ListPricingRulesFilter) *ListPricingRulesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPricingRulesInput) SetMaxResults(v int64) *ListPricingRulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPricingRulesInput) SetNextToken(v string) *ListPricingRulesInput {
	s.NextToken = &v
	return s
}

type ListPricingRulesOutput struct {
	_ struct{} `type:"structure"`

	// The billing period for which the described pricing rules are applicable.
	BillingPeriod *string `type:"string"`

	// The pagination token that's used on subsequent calls to get pricing rules.
	NextToken *string `type:"string"`

	// A list containing the described pricing rules.
	PricingRules []*PricingRuleListElement `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPricingRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPricingRulesOutput) GoString() string {
	return s.String()
}

// SetBillingPeriod sets the BillingPeriod field's value.
func (s *ListPricingRulesOutput) SetBillingPeriod(v string) *ListPricingRulesOutput {
	s.BillingPeriod = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPricingRulesOutput) SetNextToken(v string) *ListPricingRulesOutput {
	s.NextToken = &v
	return s
}

// SetPricingRules sets the PricingRules field's value.
func (s *ListPricingRulesOutput) SetPricingRules(v []*PricingRuleListElement) *ListPricingRulesOutput {
	s.PricingRules = v
	return s
}

// A filter that specifies the type of resource associations that should be
// retrieved for a custom line item.
type ListResourcesAssociatedToCustomLineItemFilter struct {
	_ struct{} `type:"structure"`

	// The type of relationship between the custom line item and the associated
	// resource.
	Relationship *string `type:"string" enum:"CustomLineItemRelationship"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourcesAssociatedToCustomLineItemFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourcesAssociatedToCustomLineItemFilter) GoString() string {
	return s.String()
}

// SetRelationship sets the Relationship field's value.
func (s *ListResourcesAssociatedToCustomLineItemFilter) SetRelationship(v string) *ListResourcesAssociatedToCustomLineItemFilter {
	s.Relationship = &v
	return s
}

type ListResourcesAssociatedToCustomLineItemInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the custom line item for which the resource associations will
	// be listed.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The billing period for which the resource associations will be listed.
	BillingPeriod *string `type:"string"`

	// (Optional) A ListResourcesAssociatedToCustomLineItemFilter that can specify
	// the types of resources that should be retrieved.
	Filters *ListResourcesAssociatedToCustomLineItemFilter `type:"structure"`

	// (Optional) The maximum number of resource associations to be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) The pagination token that's returned by a previous request.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourcesAssociatedToCustomLineItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourcesAssociatedToCustomLineItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourcesAssociatedToCustomLineItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourcesAssociatedToCustomLineItemInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *ListResourcesAssociatedToCustomLineItemInput) SetArn(v string) *ListResourcesAssociatedToCustomLineItemInput {
	s.Arn = &v
	return s
}

// SetBillingPeriod sets the BillingPeriod field's value.
func (s *ListResourcesAssociatedToCustomLineItemInput) SetBillingPeriod(v string) *ListResourcesAssociatedToCustomLineItemInput {
	s.BillingPeriod = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListResourcesAssociatedToCustomLineItemInput) SetFilters(v *ListResourcesAssociatedToCustomLineItemFilter) *ListResourcesAssociatedToCustomLineItemInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResourcesAssociatedToCustomLineItemInput) SetMaxResults(v int64) *ListResourcesAssociatedToCustomLineItemInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourcesAssociatedToCustomLineItemInput) SetNextToken(v string) *ListResourcesAssociatedToCustomLineItemInput {
	s.NextToken = &v
	return s
}

type ListResourcesAssociatedToCustomLineItemOutput struct {
	_ struct{} `type:"structure"`

	// The custom line item ARN for which the resource associations are listed.
	Arn *string `type:"string"`

	// A list of ListResourcesAssociatedToCustomLineItemResponseElement for each
	// resource association retrieved.
	AssociatedResources []*ListResourcesAssociatedToCustomLineItemResponseElement `type:"list"`

	// The pagination token to be used in subsequent requests to retrieve additional
	// results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourcesAssociatedToCustomLineItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourcesAssociatedToCustomLineItemOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListResourcesAssociatedToCustomLineItemOutput) SetArn(v string) *ListResourcesAssociatedToCustomLineItemOutput {
	s.Arn = &v
	return s
}

// SetAssociatedResources sets the AssociatedResources field's value.
func (s *ListResourcesAssociatedToCustomLineItemOutput) SetAssociatedResources(v []*ListResourcesAssociatedToCustomLineItemResponseElement) *ListResourcesAssociatedToCustomLineItemOutput {
	s.AssociatedResources = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResourcesAssociatedToCustomLineItemOutput) SetNextToken(v string) *ListResourcesAssociatedToCustomLineItemOutput {
	s.NextToken = &v
	return s
}

// A representation of a resource association for a custom line item.
type ListResourcesAssociatedToCustomLineItemResponseElement struct {
	_ struct{} `type:"structure"`

	// The ARN of the associated resource.
	Arn *string `type:"string"`

	// The end billing period of the associated resource.
	EndBillingPeriod *string `type:"string"`

	// The type of relationship between the custom line item and the associated
	// resource.
	Relationship *string `type:"string" enum:"CustomLineItemRelationship"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourcesAssociatedToCustomLineItemResponseElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResourcesAssociatedToCustomLineItemResponseElement) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ListResourcesAssociatedToCustomLineItemResponseElement) SetArn(v string) *ListResourcesAssociatedToCustomLineItemResponseElement {
	s.Arn = &v
	return s
}

// SetEndBillingPeriod sets the EndBillingPeriod field's value.
func (s *ListResourcesAssociatedToCustomLineItemResponseElement) SetEndBillingPeriod(v string) *ListResourcesAssociatedToCustomLineItemResponseElement {
	s.EndBillingPeriod = &v
	return s
}

// SetRelationship sets the Relationship field's value.
func (s *ListResourcesAssociatedToCustomLineItemResponseElement) SetRelationship(v string) *ListResourcesAssociatedToCustomLineItemResponseElement {
	s.Relationship = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) that identifies the resource to list the tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags for the resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A representation of a pricing plan.
type PricingPlanListElement struct {
	_ struct{} `type:"structure"`

	// The pricing plan Amazon Resource Names (ARN). This can be used to uniquely
	// identify a pricing plan.
	Arn *string `type:"string"`

	// The time when the pricing plan was created.
	CreationTime *int64 `type:"long"`

	// The pricing plan description.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PricingPlanListElement's
	// String and GoString methods.
	Description *string `type:"string" sensitive:"true"`

	// The most recent time when the pricing plan was modified.
	LastModifiedTime *int64 `type:"long"`

	// The name of a pricing plan.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PricingPlanListElement's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The pricing rules count that's currently associated with this pricing plan
	// list element.
	Size *int64 `min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PricingPlanListElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PricingPlanListElement) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PricingPlanListElement) SetArn(v string) *PricingPlanListElement {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *PricingPlanListElement) SetCreationTime(v int64) *PricingPlanListElement {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PricingPlanListElement) SetDescription(v string) *PricingPlanListElement {
	s.Description = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *PricingPlanListElement) SetLastModifiedTime(v int64) *PricingPlanListElement {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *PricingPlanListElement) SetName(v string) *PricingPlanListElement {
	s.Name = &v
	return s
}

// SetSize sets the Size field's value.
func (s *PricingPlanListElement) SetSize(v int64) *PricingPlanListElement {
	s.Size = &v
	return s
}

// A representation of a pricing rule.
type PricingRuleListElement struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) used to uniquely identify a pricing rule.
	Arn *string `type:"string"`

	// The pricing plans count that this pricing rule is associated with.
	AssociatedPricingPlanCount *int64 `type:"long"`

	// The seller of services provided by Amazon Web Services, their affiliates,
	// or third-party providers selling services via Amazon Web Services Marketplace.
	BillingEntity *string `type:"string"`

	// The time when the pricing rule was created.
	CreationTime *int64 `type:"long"`

	// The pricing rule description.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PricingRuleListElement's
	// String and GoString methods.
	Description *string `type:"string" sensitive:"true"`

	// The most recent time when the pricing rule was modified.
	LastModifiedTime *int64 `type:"long"`

	// A percentage modifier applied on the public pricing rates.
	ModifierPercentage *float64 `type:"double"`

	// The name of a pricing rule.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PricingRuleListElement's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// Operation is the specific Amazon Web Services action covered by this line
	// item. This describes the specific usage of the line item.
	//
	// If the Scope attribute is set to SKU, this attribute indicates which operation
	// the PricingRule is modifying. For example, a value of RunInstances:0202 indicates
	// the operation of running an Amazon EC2 instance.
	Operation *string `min:"1" type:"string"`

	// The scope of pricing rule that indicates if it is globally applicable, or
	// if it is service-specific.
	Scope *string `type:"string" enum:"PricingRuleScope"`

	// If the Scope attribute is SERVICE, this attribute indicates which service
	// the PricingRule is applicable for.
	Service *string `min:"1" type:"string"`

	// The set of tiering configurations for the pricing rule.
	Tiering *Tiering `type:"structure"`

	// The type of pricing rule.
	Type *string `type:"string" enum:"PricingRuleType"`

	// Usage type is the unit that each service uses to measure the usage of a specific
	// type of resource.
	UsageType *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PricingRuleListElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PricingRuleListElement) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PricingRuleListElement) SetArn(v string) *PricingRuleListElement {
	s.Arn = &v
	return s
}

// SetAssociatedPricingPlanCount sets the AssociatedPricingPlanCount field's value.
func (s *PricingRuleListElement) SetAssociatedPricingPlanCount(v int64) *PricingRuleListElement {
	s.AssociatedPricingPlanCount = &v
	return s
}

// SetBillingEntity sets the BillingEntity field's value.
func (s *PricingRuleListElement) SetBillingEntity(v string) *PricingRuleListElement {
	s.BillingEntity = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *PricingRuleListElement) SetCreationTime(v int64) *PricingRuleListElement {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PricingRuleListElement) SetDescription(v string) *PricingRuleListElement {
	s.Description = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *PricingRuleListElement) SetLastModifiedTime(v int64) *PricingRuleListElement {
	s.LastModifiedTime = &v
	return s
}

// SetModifierPercentage sets the ModifierPercentage field's value.
func (s *PricingRuleListElement) SetModifierPercentage(v float64) *PricingRuleListElement {
	s.ModifierPercentage = &v
	return s
}

// SetName sets the Name field's value.
func (s *PricingRuleListElement) SetName(v string) *PricingRuleListElement {
	s.Name = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *PricingRuleListElement) SetOperation(v string) *PricingRuleListElement {
	s.Operation = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *PricingRuleListElement) SetScope(v string) *PricingRuleListElement {
	s.Scope = &v
	return s
}

// SetService sets the Service field's value.
func (s *PricingRuleListElement) SetService(v string) *PricingRuleListElement {
	s.Service = &v
	return s
}

// SetTiering sets the Tiering field's value.
func (s *PricingRuleListElement) SetTiering(v *Tiering) *PricingRuleListElement {
	s.Tiering = v
	return s
}

// SetType sets the Type field's value.
func (s *PricingRuleListElement) SetType(v string) *PricingRuleListElement {
	s.Type = &v
	return s
}

// SetUsageType sets the UsageType field's value.
func (s *PricingRuleListElement) SetUsageType(v string) *PricingRuleListElement {
	s.UsageType = &v
	return s
}

// The request references a resource that doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Resource identifier that was not found.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// Resource type that was not found.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request would cause a service limit to exceed.
type ServiceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The unique code identifier of the service limit that is being exceeded.
	//
	// LimitCode is a required field
	LimitCode *string `type:"string" required:"true"`

	Message_ *string `locationName:"Message" type:"string"`

	// Identifier of the resource affected.
	ResourceId *string `type:"string"`

	// Type of the resource affected.
	ResourceType *string `type:"string"`

	// The unique code for the service of the limit that is being exceeded.
	//
	// ServiceCode is a required field
	ServiceCode *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorServiceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ServiceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceLimitExceededException) Code() string {
	return "ServiceLimitExceededException"
}

// Message returns the exception's message.
func (s *ServiceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ServiceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to which to add tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The tags to add to the resource as a list of key-value pairs.
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// Number of seconds you can safely retry after the call.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The set of tiering configurations for the pricing rule.
type Tiering struct {
	_ struct{} `type:"structure"`

	// The possible Amazon Web Services Free Tier configurations.
	//
	// FreeTier is a required field
	FreeTier *FreeTierConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tiering) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tiering) GoString() string {
	return s.String()
}

// SetFreeTier sets the FreeTier field's value.
func (s *Tiering) SetFreeTier(v *FreeTierConfig) *Tiering {
	s.FreeTier = v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource to which to delete tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" type:"string" required:"true"`

	// The tags to delete from the resource as a list of key-value pairs.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Specifies if the billing group has the following features enabled.
type UpdateBillingGroupAccountGrouping struct {
	_ struct{} `type:"structure"`

	// Specifies if this billing group will automatically associate newly added
	// Amazon Web Services accounts that join your consolidated billing family.
	AutoAssociate *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBillingGroupAccountGrouping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBillingGroupAccountGrouping) GoString() string {
	return s.String()
}

// SetAutoAssociate sets the AutoAssociate field's value.
func (s *UpdateBillingGroupAccountGrouping) SetAutoAssociate(v bool) *UpdateBillingGroupAccountGrouping {
	s.AutoAssociate = &v
	return s
}

type UpdateBillingGroupInput struct {
	_ struct{} `type:"structure"`

	// Specifies if the billing group has automatic account association (AutoAssociate)
	// enabled.
	AccountGrouping *UpdateBillingGroupAccountGrouping `type:"structure"`

	// The Amazon Resource Name (ARN) of the billing group being updated.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The preferences and settings that will be used to compute the Amazon Web
	// Services charges for a billing group.
	ComputationPreference *ComputationPreference `type:"structure"`

	// A description of the billing group.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateBillingGroupInput's
	// String and GoString methods.
	Description *string `type:"string" sensitive:"true"`

	// The name of the billing group. The names must be unique to each billing group.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateBillingGroupInput's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The status of the billing group. Only one of the valid values can be used.
	Status *string `type:"string" enum:"BillingGroupStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBillingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBillingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBillingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBillingGroupInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ComputationPreference != nil {
		if err := s.ComputationPreference.Validate(); err != nil {
			invalidParams.AddNested("ComputationPreference", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountGrouping sets the AccountGrouping field's value.
func (s *UpdateBillingGroupInput) SetAccountGrouping(v *UpdateBillingGroupAccountGrouping) *UpdateBillingGroupInput {
	s.AccountGrouping = v
	return s
}

// SetArn sets the Arn field's value.
func (s *UpdateBillingGroupInput) SetArn(v string) *UpdateBillingGroupInput {
	s.Arn = &v
	return s
}

// SetComputationPreference sets the ComputationPreference field's value.
func (s *UpdateBillingGroupInput) SetComputationPreference(v *ComputationPreference) *UpdateBillingGroupInput {
	s.ComputationPreference = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateBillingGroupInput) SetDescription(v string) *UpdateBillingGroupInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateBillingGroupInput) SetName(v string) *UpdateBillingGroupInput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateBillingGroupInput) SetStatus(v string) *UpdateBillingGroupInput {
	s.Status = &v
	return s
}

type UpdateBillingGroupOutput struct {
	_ struct{} `type:"structure"`

	// Specifies if the billing group has automatic account association (AutoAssociate)
	// enabled.
	AccountGrouping *UpdateBillingGroupAccountGrouping `type:"structure"`

	// The Amazon Resource Name (ARN) of the billing group that was updated.
	Arn *string `type:"string"`

	// A description of the billing group.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateBillingGroupOutput's
	// String and GoString methods.
	Description *string `type:"string" sensitive:"true"`

	// The most recent time when the billing group was modified.
	LastModifiedTime *int64 `type:"long"`

	// The name of the billing group. The names must be unique to each billing group.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateBillingGroupOutput's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the pricing plan to compute Amazon Web
	// Services charges for the billing group.
	PricingPlanArn *string `type:"string"`

	// The account ID that serves as the main account in a billing group.
	PrimaryAccountId *string `type:"string"`

	// The number of accounts in the particular billing group.
	Size *int64 `type:"long"`

	// The status of the billing group. Only one of the valid values can be used.
	Status *string `type:"string" enum:"BillingGroupStatus"`

	// The reason why the billing group is in its current status.
	StatusReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBillingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBillingGroupOutput) GoString() string {
	return s.String()
}

// SetAccountGrouping sets the AccountGrouping field's value.
func (s *UpdateBillingGroupOutput) SetAccountGrouping(v *UpdateBillingGroupAccountGrouping) *UpdateBillingGroupOutput {
	s.AccountGrouping = v
	return s
}

// SetArn sets the Arn field's value.
func (s *UpdateBillingGroupOutput) SetArn(v string) *UpdateBillingGroupOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateBillingGroupOutput) SetDescription(v string) *UpdateBillingGroupOutput {
	s.Description = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdateBillingGroupOutput) SetLastModifiedTime(v int64) *UpdateBillingGroupOutput {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateBillingGroupOutput) SetName(v string) *UpdateBillingGroupOutput {
	s.Name = &v
	return s
}

// SetPricingPlanArn sets the PricingPlanArn field's value.
func (s *UpdateBillingGroupOutput) SetPricingPlanArn(v string) *UpdateBillingGroupOutput {
	s.PricingPlanArn = &v
	return s
}

// SetPrimaryAccountId sets the PrimaryAccountId field's value.
func (s *UpdateBillingGroupOutput) SetPrimaryAccountId(v string) *UpdateBillingGroupOutput {
	s.PrimaryAccountId = &v
	return s
}

// SetSize sets the Size field's value.
func (s *UpdateBillingGroupOutput) SetSize(v int64) *UpdateBillingGroupOutput {
	s.Size = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateBillingGroupOutput) SetStatus(v string) *UpdateBillingGroupOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *UpdateBillingGroupOutput) SetStatusReason(v string) *UpdateBillingGroupOutput {
	s.StatusReason = &v
	return s
}

// A representation of the new charge details of a custom line item. This should
// contain only one of Flat or Percentage.
type UpdateCustomLineItemChargeDetails struct {
	_ struct{} `type:"structure"`

	// An UpdateCustomLineItemFlatChargeDetails that describes the new charge details
	// of a flat custom line item.
	Flat *UpdateCustomLineItemFlatChargeDetails `type:"structure"`

	// An UpdateCustomLineItemPercentageChargeDetails that describes the new charge
	// details of a percentage custom line item.
	Percentage *UpdateCustomLineItemPercentageChargeDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomLineItemChargeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomLineItemChargeDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCustomLineItemChargeDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCustomLineItemChargeDetails"}
	if s.Flat != nil {
		if err := s.Flat.Validate(); err != nil {
			invalidParams.AddNested("Flat", err.(request.ErrInvalidParams))
		}
	}
	if s.Percentage != nil {
		if err := s.Percentage.Validate(); err != nil {
			invalidParams.AddNested("Percentage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlat sets the Flat field's value.
func (s *UpdateCustomLineItemChargeDetails) SetFlat(v *UpdateCustomLineItemFlatChargeDetails) *UpdateCustomLineItemChargeDetails {
	s.Flat = v
	return s
}

// SetPercentage sets the Percentage field's value.
func (s *UpdateCustomLineItemChargeDetails) SetPercentage(v *UpdateCustomLineItemPercentageChargeDetails) *UpdateCustomLineItemChargeDetails {
	s.Percentage = v
	return s
}

// A representation of the new charge details that are associated with a flat
// custom line item.
type UpdateCustomLineItemFlatChargeDetails struct {
	_ struct{} `type:"structure"`

	// The custom line item's new fixed charge value in USD.
	//
	// ChargeValue is a required field
	ChargeValue *float64 `type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomLineItemFlatChargeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomLineItemFlatChargeDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCustomLineItemFlatChargeDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCustomLineItemFlatChargeDetails"}
	if s.ChargeValue == nil {
		invalidParams.Add(request.NewErrParamRequired("ChargeValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChargeValue sets the ChargeValue field's value.
func (s *UpdateCustomLineItemFlatChargeDetails) SetChargeValue(v float64) *UpdateCustomLineItemFlatChargeDetails {
	s.ChargeValue = &v
	return s
}

type UpdateCustomLineItemInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the custom line item to be updated.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The billing period range in which the custom line item request will be applied.
	BillingPeriodRange *CustomLineItemBillingPeriodRange `type:"structure"`

	// A ListCustomLineItemChargeDetails containing the new charge details for the
	// custom line item.
	ChargeDetails *UpdateCustomLineItemChargeDetails `type:"structure"`

	// The new line item description of the custom line item.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateCustomLineItemInput's
	// String and GoString methods.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The new name for the custom line item.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateCustomLineItemInput's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomLineItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomLineItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCustomLineItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCustomLineItemInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.BillingPeriodRange != nil {
		if err := s.BillingPeriodRange.Validate(); err != nil {
			invalidParams.AddNested("BillingPeriodRange", err.(request.ErrInvalidParams))
		}
	}
	if s.ChargeDetails != nil {
		if err := s.ChargeDetails.Validate(); err != nil {
			invalidParams.AddNested("ChargeDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateCustomLineItemInput) SetArn(v string) *UpdateCustomLineItemInput {
	s.Arn = &v
	return s
}

// SetBillingPeriodRange sets the BillingPeriodRange field's value.
func (s *UpdateCustomLineItemInput) SetBillingPeriodRange(v *CustomLineItemBillingPeriodRange) *UpdateCustomLineItemInput {
	s.BillingPeriodRange = v
	return s
}

// SetChargeDetails sets the ChargeDetails field's value.
func (s *UpdateCustomLineItemInput) SetChargeDetails(v *UpdateCustomLineItemChargeDetails) *UpdateCustomLineItemInput {
	s.ChargeDetails = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateCustomLineItemInput) SetDescription(v string) *UpdateCustomLineItemInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateCustomLineItemInput) SetName(v string) *UpdateCustomLineItemInput {
	s.Name = &v
	return s
}

type UpdateCustomLineItemOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the successfully updated custom line item.
	Arn *string `type:"string"`

	// The number of resources that are associated to the custom line item.
	AssociationSize *int64 `type:"long"`

	// The ARN of the billing group that the custom line item is applied to.
	BillingGroupArn *string `type:"string"`

	// A ListCustomLineItemChargeDetails containing the charge details of the successfully
	// updated custom line item.
	ChargeDetails *ListCustomLineItemChargeDetails `type:"structure"`

	// The description of the successfully updated custom line item.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateCustomLineItemOutput's
	// String and GoString methods.
	Description *string `min:"1" type:"string" sensitive:"true"`

	// The most recent time when the custom line item was modified.
	LastModifiedTime *int64 `type:"long"`

	// The name of the successfully updated custom line item.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateCustomLineItemOutput's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomLineItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomLineItemOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateCustomLineItemOutput) SetArn(v string) *UpdateCustomLineItemOutput {
	s.Arn = &v
	return s
}

// SetAssociationSize sets the AssociationSize field's value.
func (s *UpdateCustomLineItemOutput) SetAssociationSize(v int64) *UpdateCustomLineItemOutput {
	s.AssociationSize = &v
	return s
}

// SetBillingGroupArn sets the BillingGroupArn field's value.
func (s *UpdateCustomLineItemOutput) SetBillingGroupArn(v string) *UpdateCustomLineItemOutput {
	s.BillingGroupArn = &v
	return s
}

// SetChargeDetails sets the ChargeDetails field's value.
func (s *UpdateCustomLineItemOutput) SetChargeDetails(v *ListCustomLineItemChargeDetails) *UpdateCustomLineItemOutput {
	s.ChargeDetails = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateCustomLineItemOutput) SetDescription(v string) *UpdateCustomLineItemOutput {
	s.Description = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdateCustomLineItemOutput) SetLastModifiedTime(v int64) *UpdateCustomLineItemOutput {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateCustomLineItemOutput) SetName(v string) *UpdateCustomLineItemOutput {
	s.Name = &v
	return s
}

// A representation of the new charge details that are associated with a percentage
// custom line item.
type UpdateCustomLineItemPercentageChargeDetails struct {
	_ struct{} `type:"structure"`

	// The custom line item's new percentage value. This will be multiplied against
	// the combined value of its associated resources to determine its charge value.
	//
	// PercentageValue is a required field
	PercentageValue *float64 `type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomLineItemPercentageChargeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomLineItemPercentageChargeDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCustomLineItemPercentageChargeDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCustomLineItemPercentageChargeDetails"}
	if s.PercentageValue == nil {
		invalidParams.Add(request.NewErrParamRequired("PercentageValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPercentageValue sets the PercentageValue field's value.
func (s *UpdateCustomLineItemPercentageChargeDetails) SetPercentageValue(v float64) *UpdateCustomLineItemPercentageChargeDetails {
	s.PercentageValue = &v
	return s
}

// The possible Amazon Web Services Free Tier configurations.
type UpdateFreeTierConfig struct {
	_ struct{} `type:"structure"`

	// Activate or deactivate application of Amazon Web Services Free Tier.
	//
	// Activated is a required field
	Activated *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFreeTierConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFreeTierConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFreeTierConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFreeTierConfig"}
	if s.Activated == nil {
		invalidParams.Add(request.NewErrParamRequired("Activated"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivated sets the Activated field's value.
func (s *UpdateFreeTierConfig) SetActivated(v bool) *UpdateFreeTierConfig {
	s.Activated = &v
	return s
}

type UpdatePricingPlanInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the pricing plan that you're updating.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The description of the pricing plan.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePricingPlanInput's
	// String and GoString methods.
	Description *string `type:"string" sensitive:"true"`

	// The name of the pricing plan. The name must be unique to each pricing plan.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePricingPlanInput's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePricingPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePricingPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePricingPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePricingPlanInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdatePricingPlanInput) SetArn(v string) *UpdatePricingPlanInput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdatePricingPlanInput) SetDescription(v string) *UpdatePricingPlanInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdatePricingPlanInput) SetName(v string) *UpdatePricingPlanInput {
	s.Name = &v
	return s
}

type UpdatePricingPlanOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the updated pricing plan.
	Arn *string `type:"string"`

	// The new description for the pricing rule.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePricingPlanOutput's
	// String and GoString methods.
	Description *string `type:"string" sensitive:"true"`

	// The most recent time when the pricing plan was modified.
	LastModifiedTime *int64 `type:"long"`

	// The name of the pricing plan. The name must be unique to each pricing plan.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePricingPlanOutput's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The pricing rules count that's currently associated with this pricing plan
	// list.
	Size *int64 `min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePricingPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePricingPlanOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdatePricingPlanOutput) SetArn(v string) *UpdatePricingPlanOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdatePricingPlanOutput) SetDescription(v string) *UpdatePricingPlanOutput {
	s.Description = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdatePricingPlanOutput) SetLastModifiedTime(v int64) *UpdatePricingPlanOutput {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdatePricingPlanOutput) SetName(v string) *UpdatePricingPlanOutput {
	s.Name = &v
	return s
}

// SetSize sets the Size field's value.
func (s *UpdatePricingPlanOutput) SetSize(v int64) *UpdatePricingPlanOutput {
	s.Size = &v
	return s
}

type UpdatePricingRuleInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the pricing rule to update.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The new description for the pricing rule.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePricingRuleInput's
	// String and GoString methods.
	Description *string `type:"string" sensitive:"true"`

	// The new modifier to show pricing plan rates as a percentage.
	ModifierPercentage *float64 `type:"double"`

	// The new name of the pricing rule. The name must be unique to each pricing
	// rule.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePricingRuleInput's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// The set of tiering configurations for the pricing rule.
	Tiering *UpdateTieringInput_ `type:"structure"`

	// The new pricing rule type.
	Type *string `type:"string" enum:"PricingRuleType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePricingRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePricingRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePricingRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePricingRuleInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tiering != nil {
		if err := s.Tiering.Validate(); err != nil {
			invalidParams.AddNested("Tiering", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdatePricingRuleInput) SetArn(v string) *UpdatePricingRuleInput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdatePricingRuleInput) SetDescription(v string) *UpdatePricingRuleInput {
	s.Description = &v
	return s
}

// SetModifierPercentage sets the ModifierPercentage field's value.
func (s *UpdatePricingRuleInput) SetModifierPercentage(v float64) *UpdatePricingRuleInput {
	s.ModifierPercentage = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdatePricingRuleInput) SetName(v string) *UpdatePricingRuleInput {
	s.Name = &v
	return s
}

// SetTiering sets the Tiering field's value.
func (s *UpdatePricingRuleInput) SetTiering(v *UpdateTieringInput_) *UpdatePricingRuleInput {
	s.Tiering = v
	return s
}

// SetType sets the Type field's value.
func (s *UpdatePricingRuleInput) SetType(v string) *UpdatePricingRuleInput {
	s.Type = &v
	return s
}

type UpdatePricingRuleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the successfully updated pricing rule.
	Arn *string `type:"string"`

	// The pricing plans count that this pricing rule is associated with.
	AssociatedPricingPlanCount *int64 `type:"long"`

	// The seller of services provided by Amazon Web Services, their affiliates,
	// or third-party providers selling services via Amazon Web Services Marketplace.
	BillingEntity *string `type:"string"`

	// The new description for the pricing rule.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePricingRuleOutput's
	// String and GoString methods.
	Description *string `type:"string" sensitive:"true"`

	// The most recent time the pricing rule was modified.
	LastModifiedTime *int64 `type:"long"`

	// The new modifier to show pricing plan rates as a percentage.
	ModifierPercentage *float64 `type:"double"`

	// The new name of the pricing rule. The name must be unique to each pricing
	// rule.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePricingRuleOutput's
	// String and GoString methods.
	Name *string `min:"1" type:"string" sensitive:"true"`

	// Operation refers to the specific Amazon Web Services covered by this line
	// item. This describes the specific usage of the line item.
	//
	// If the Scope attribute is set to SKU, this attribute indicates which operation
	// the PricingRule is modifying. For example, a value of RunInstances:0202 indicates
	// the operation of running an Amazon EC2 instance.
	Operation *string `min:"1" type:"string"`

	// The scope of pricing rule that indicates if it's globally applicable, or
	// it's service-specific.
	Scope *string `type:"string" enum:"PricingRuleScope"`

	// If the Scope attribute is set to SERVICE, the attribute indicates which service
	// the PricingRule is applicable for.
	Service *string `min:"1" type:"string"`

	// The set of tiering configurations for the pricing rule.
	Tiering *UpdateTieringInput_ `type:"structure"`

	// The new pricing rule type.
	Type *string `type:"string" enum:"PricingRuleType"`

	// Usage type is the unit that each service uses to measure the usage of a specific
	// type of resource.
	//
	// If the Scope attribute is set to SKU, this attribute indicates which usage
	// type the PricingRule is modifying. For example, USW2-BoxUsage:m2.2xlarge
	// describes an M2 High Memory Double Extra Large instance in the US West (Oregon)
	// Region.
	UsageType *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePricingRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePricingRuleOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdatePricingRuleOutput) SetArn(v string) *UpdatePricingRuleOutput {
	s.Arn = &v
	return s
}

// SetAssociatedPricingPlanCount sets the AssociatedPricingPlanCount field's value.
func (s *UpdatePricingRuleOutput) SetAssociatedPricingPlanCount(v int64) *UpdatePricingRuleOutput {
	s.AssociatedPricingPlanCount = &v
	return s
}

// SetBillingEntity sets the BillingEntity field's value.
func (s *UpdatePricingRuleOutput) SetBillingEntity(v string) *UpdatePricingRuleOutput {
	s.BillingEntity = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdatePricingRuleOutput) SetDescription(v string) *UpdatePricingRuleOutput {
	s.Description = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdatePricingRuleOutput) SetLastModifiedTime(v int64) *UpdatePricingRuleOutput {
	s.LastModifiedTime = &v
	return s
}

// SetModifierPercentage sets the ModifierPercentage field's value.
func (s *UpdatePricingRuleOutput) SetModifierPercentage(v float64) *UpdatePricingRuleOutput {
	s.ModifierPercentage = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdatePricingRuleOutput) SetName(v string) *UpdatePricingRuleOutput {
	s.Name = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *UpdatePricingRuleOutput) SetOperation(v string) *UpdatePricingRuleOutput {
	s.Operation = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *UpdatePricingRuleOutput) SetScope(v string) *UpdatePricingRuleOutput {
	s.Scope = &v
	return s
}

// SetService sets the Service field's value.
func (s *UpdatePricingRuleOutput) SetService(v string) *UpdatePricingRuleOutput {
	s.Service = &v
	return s
}

// SetTiering sets the Tiering field's value.
func (s *UpdatePricingRuleOutput) SetTiering(v *UpdateTieringInput_) *UpdatePricingRuleOutput {
	s.Tiering = v
	return s
}

// SetType sets the Type field's value.
func (s *UpdatePricingRuleOutput) SetType(v string) *UpdatePricingRuleOutput {
	s.Type = &v
	return s
}

// SetUsageType sets the UsageType field's value.
func (s *UpdatePricingRuleOutput) SetUsageType(v string) *UpdatePricingRuleOutput {
	s.UsageType = &v
	return s
}

// The set of tiering configurations for the pricing rule.
type UpdateTieringInput_ struct {
	_ struct{} `type:"structure"`

	// The possible Amazon Web Services Free Tier configurations.
	//
	// FreeTier is a required field
	FreeTier *UpdateFreeTierConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTieringInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTieringInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTieringInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTieringInput_"}
	if s.FreeTier == nil {
		invalidParams.Add(request.NewErrParamRequired("FreeTier"))
	}
	if s.FreeTier != nil {
		if err := s.FreeTier.Validate(); err != nil {
			invalidParams.AddNested("FreeTier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFreeTier sets the FreeTier field's value.
func (s *UpdateTieringInput_) SetFreeTier(v *UpdateFreeTierConfig) *UpdateTieringInput_ {
	s.FreeTier = v
	return s
}

// The input doesn't match with the constraints specified by Amazon Web Services.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The fields that caused the error, if applicable.
	Fields []*ValidationExceptionField `type:"list"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason the request's validation failed.
	Reason *string `type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The field's information of a request that resulted in an exception.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The message describing why the field failed validation.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The field name.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// AssociateResourceErrorReasonInvalidArn is a AssociateResourceErrorReason enum value
	AssociateResourceErrorReasonInvalidArn = "INVALID_ARN"

	// AssociateResourceErrorReasonServiceLimitExceeded is a AssociateResourceErrorReason enum value
	AssociateResourceErrorReasonServiceLimitExceeded = "SERVICE_LIMIT_EXCEEDED"

	// AssociateResourceErrorReasonIllegalCustomlineitem is a AssociateResourceErrorReason enum value
	AssociateResourceErrorReasonIllegalCustomlineitem = "ILLEGAL_CUSTOMLINEITEM"

	// AssociateResourceErrorReasonInternalServerException is a AssociateResourceErrorReason enum value
	AssociateResourceErrorReasonInternalServerException = "INTERNAL_SERVER_EXCEPTION"

	// AssociateResourceErrorReasonInvalidBillingPeriodRange is a AssociateResourceErrorReason enum value
	AssociateResourceErrorReasonInvalidBillingPeriodRange = "INVALID_BILLING_PERIOD_RANGE"
)

// AssociateResourceErrorReason_Values returns all elements of the AssociateResourceErrorReason enum
func AssociateResourceErrorReason_Values() []string {
	return []string{
		AssociateResourceErrorReasonInvalidArn,
		AssociateResourceErrorReasonServiceLimitExceeded,
		AssociateResourceErrorReasonIllegalCustomlineitem,
		AssociateResourceErrorReasonInternalServerException,
		AssociateResourceErrorReasonInvalidBillingPeriodRange,
	}
}

const (
	// BillingGroupStatusActive is a BillingGroupStatus enum value
	BillingGroupStatusActive = "ACTIVE"

	// BillingGroupStatusPrimaryAccountMissing is a BillingGroupStatus enum value
	BillingGroupStatusPrimaryAccountMissing = "PRIMARY_ACCOUNT_MISSING"
)

// BillingGroupStatus_Values returns all elements of the BillingGroupStatus enum
func BillingGroupStatus_Values() []string {
	return []string{
		BillingGroupStatusActive,
		BillingGroupStatusPrimaryAccountMissing,
	}
}

const (
	// ConflictExceptionReasonResourceNameConflict is a ConflictExceptionReason enum value
	ConflictExceptionReasonResourceNameConflict = "RESOURCE_NAME_CONFLICT"

	// ConflictExceptionReasonPricingRuleInPricingPlanConflict is a ConflictExceptionReason enum value
	ConflictExceptionReasonPricingRuleInPricingPlanConflict = "PRICING_RULE_IN_PRICING_PLAN_CONFLICT"

	// ConflictExceptionReasonPricingPlanAttachedToBillingGroupDeleteConflict is a ConflictExceptionReason enum value
	ConflictExceptionReasonPricingPlanAttachedToBillingGroupDeleteConflict = "PRICING_PLAN_ATTACHED_TO_BILLING_GROUP_DELETE_CONFLICT"

	// ConflictExceptionReasonPricingRuleAttachedToPricingPlanDeleteConflict is a ConflictExceptionReason enum value
	ConflictExceptionReasonPricingRuleAttachedToPricingPlanDeleteConflict = "PRICING_RULE_ATTACHED_TO_PRICING_PLAN_DELETE_CONFLICT"

	// ConflictExceptionReasonWriteConflictRetry is a ConflictExceptionReason enum value
	ConflictExceptionReasonWriteConflictRetry = "WRITE_CONFLICT_RETRY"
)

// ConflictExceptionReason_Values returns all elements of the ConflictExceptionReason enum
func ConflictExceptionReason_Values() []string {
	return []string{
		ConflictExceptionReasonResourceNameConflict,
		ConflictExceptionReasonPricingRuleInPricingPlanConflict,
		ConflictExceptionReasonPricingPlanAttachedToBillingGroupDeleteConflict,
		ConflictExceptionReasonPricingRuleAttachedToPricingPlanDeleteConflict,
		ConflictExceptionReasonWriteConflictRetry,
	}
}

const (
	// CurrencyCodeUsd is a CurrencyCode enum value
	CurrencyCodeUsd = "USD"

	// CurrencyCodeCny is a CurrencyCode enum value
	CurrencyCodeCny = "CNY"
)

// CurrencyCode_Values returns all elements of the CurrencyCode enum
func CurrencyCode_Values() []string {
	return []string{
		CurrencyCodeUsd,
		CurrencyCodeCny,
	}
}

const (
	// CustomLineItemRelationshipParent is a CustomLineItemRelationship enum value
	CustomLineItemRelationshipParent = "PARENT"

	// CustomLineItemRelationshipChild is a CustomLineItemRelationship enum value
	CustomLineItemRelationshipChild = "CHILD"
)

// CustomLineItemRelationship_Values returns all elements of the CustomLineItemRelationship enum
func CustomLineItemRelationship_Values() []string {
	return []string{
		CustomLineItemRelationshipParent,
		CustomLineItemRelationshipChild,
	}
}

const (
	// CustomLineItemTypeCredit is a CustomLineItemType enum value
	CustomLineItemTypeCredit = "CREDIT"

	// CustomLineItemTypeFee is a CustomLineItemType enum value
	CustomLineItemTypeFee = "FEE"
)

// CustomLineItemType_Values returns all elements of the CustomLineItemType enum
func CustomLineItemType_Values() []string {
	return []string{
		CustomLineItemTypeCredit,
		CustomLineItemTypeFee,
	}
}

const (
	// PricingRuleScopeGlobal is a PricingRuleScope enum value
	PricingRuleScopeGlobal = "GLOBAL"

	// PricingRuleScopeService is a PricingRuleScope enum value
	PricingRuleScopeService = "SERVICE"

	// PricingRuleScopeBillingEntity is a PricingRuleScope enum value
	PricingRuleScopeBillingEntity = "BILLING_ENTITY"

	// PricingRuleScopeSku is a PricingRuleScope enum value
	PricingRuleScopeSku = "SKU"
)

// PricingRuleScope_Values returns all elements of the PricingRuleScope enum
func PricingRuleScope_Values() []string {
	return []string{
		PricingRuleScopeGlobal,
		PricingRuleScopeService,
		PricingRuleScopeBillingEntity,
		PricingRuleScopeSku,
	}
}

const (
	// PricingRuleTypeMarkup is a PricingRuleType enum value
	PricingRuleTypeMarkup = "MARKUP"

	// PricingRuleTypeDiscount is a PricingRuleType enum value
	PricingRuleTypeDiscount = "DISCOUNT"

	// PricingRuleTypeTiering is a PricingRuleType enum value
	PricingRuleTypeTiering = "TIERING"
)

// PricingRuleType_Values returns all elements of the PricingRuleType enum
func PricingRuleType_Values() []string {
	return []string{
		PricingRuleTypeMarkup,
		PricingRuleTypeDiscount,
		PricingRuleTypeTiering,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CANNOT_PARSE"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"

	// ValidationExceptionReasonPrimaryNotAssociated is a ValidationExceptionReason enum value
	ValidationExceptionReasonPrimaryNotAssociated = "PRIMARY_NOT_ASSOCIATED"

	// ValidationExceptionReasonPrimaryCannotDisassociate is a ValidationExceptionReason enum value
	ValidationExceptionReasonPrimaryCannotDisassociate = "PRIMARY_CANNOT_DISASSOCIATE"

	// ValidationExceptionReasonAccountsNotAssociated is a ValidationExceptionReason enum value
	ValidationExceptionReasonAccountsNotAssociated = "ACCOUNTS_NOT_ASSOCIATED"

	// ValidationExceptionReasonAccountsAlreadyAssociated is a ValidationExceptionReason enum value
	ValidationExceptionReasonAccountsAlreadyAssociated = "ACCOUNTS_ALREADY_ASSOCIATED"

	// ValidationExceptionReasonIllegalPrimaryAccount is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalPrimaryAccount = "ILLEGAL_PRIMARY_ACCOUNT"

	// ValidationExceptionReasonIllegalAccounts is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalAccounts = "ILLEGAL_ACCOUNTS"

	// ValidationExceptionReasonMismatchedBillinggroupArn is a ValidationExceptionReason enum value
	ValidationExceptionReasonMismatchedBillinggroupArn = "MISMATCHED_BILLINGGROUP_ARN"

	// ValidationExceptionReasonMissingBillinggroup is a ValidationExceptionReason enum value
	ValidationExceptionReasonMissingBillinggroup = "MISSING_BILLINGGROUP"

	// ValidationExceptionReasonMismatchedCustomlineitemArn is a ValidationExceptionReason enum value
	ValidationExceptionReasonMismatchedCustomlineitemArn = "MISMATCHED_CUSTOMLINEITEM_ARN"

	// ValidationExceptionReasonIllegalBillingPeriod is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalBillingPeriod = "ILLEGAL_BILLING_PERIOD"

	// ValidationExceptionReasonIllegalBillingPeriodRange is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalBillingPeriodRange = "ILLEGAL_BILLING_PERIOD_RANGE"

	// ValidationExceptionReasonTooManyAccountsInRequest is a ValidationExceptionReason enum value
	ValidationExceptionReasonTooManyAccountsInRequest = "TOO_MANY_ACCOUNTS_IN_REQUEST"

	// ValidationExceptionReasonDuplicateAccount is a ValidationExceptionReason enum value
	ValidationExceptionReasonDuplicateAccount = "DUPLICATE_ACCOUNT"

	// ValidationExceptionReasonInvalidBillingGroupStatus is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidBillingGroupStatus = "INVALID_BILLING_GROUP_STATUS"

	// ValidationExceptionReasonMismatchedPricingplanArn is a ValidationExceptionReason enum value
	ValidationExceptionReasonMismatchedPricingplanArn = "MISMATCHED_PRICINGPLAN_ARN"

	// ValidationExceptionReasonMissingPricingplan is a ValidationExceptionReason enum value
	ValidationExceptionReasonMissingPricingplan = "MISSING_PRICINGPLAN"

	// ValidationExceptionReasonMismatchedPricingruleArn is a ValidationExceptionReason enum value
	ValidationExceptionReasonMismatchedPricingruleArn = "MISMATCHED_PRICINGRULE_ARN"

	// ValidationExceptionReasonDuplicatePricingruleArns is a ValidationExceptionReason enum value
	ValidationExceptionReasonDuplicatePricingruleArns = "DUPLICATE_PRICINGRULE_ARNS"

	// ValidationExceptionReasonIllegalExpression is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalExpression = "ILLEGAL_EXPRESSION"

	// ValidationExceptionReasonIllegalScope is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalScope = "ILLEGAL_SCOPE"

	// ValidationExceptionReasonIllegalService is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalService = "ILLEGAL_SERVICE"

	// ValidationExceptionReasonPricingrulesNotExist is a ValidationExceptionReason enum value
	ValidationExceptionReasonPricingrulesNotExist = "PRICINGRULES_NOT_EXIST"

	// ValidationExceptionReasonPricingrulesAlreadyAssociated is a ValidationExceptionReason enum value
	ValidationExceptionReasonPricingrulesAlreadyAssociated = "PRICINGRULES_ALREADY_ASSOCIATED"

	// ValidationExceptionReasonPricingrulesNotAssociated is a ValidationExceptionReason enum value
	ValidationExceptionReasonPricingrulesNotAssociated = "PRICINGRULES_NOT_ASSOCIATED"

	// ValidationExceptionReasonInvalidTimeRange is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidTimeRange = "INVALID_TIME_RANGE"

	// ValidationExceptionReasonInvalidBillingviewArn is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidBillingviewArn = "INVALID_BILLINGVIEW_ARN"

	// ValidationExceptionReasonMismatchedBillingviewArn is a ValidationExceptionReason enum value
	ValidationExceptionReasonMismatchedBillingviewArn = "MISMATCHED_BILLINGVIEW_ARN"

	// ValidationExceptionReasonIllegalCustomlineitem is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalCustomlineitem = "ILLEGAL_CUSTOMLINEITEM"

	// ValidationExceptionReasonMissingCustomlineitem is a ValidationExceptionReason enum value
	ValidationExceptionReasonMissingCustomlineitem = "MISSING_CUSTOMLINEITEM"

	// ValidationExceptionReasonIllegalCustomlineitemUpdate is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalCustomlineitemUpdate = "ILLEGAL_CUSTOMLINEITEM_UPDATE"

	// ValidationExceptionReasonTooManyCustomlineitemsInRequest is a ValidationExceptionReason enum value
	ValidationExceptionReasonTooManyCustomlineitemsInRequest = "TOO_MANY_CUSTOMLINEITEMS_IN_REQUEST"

	// ValidationExceptionReasonIllegalChargeDetails is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalChargeDetails = "ILLEGAL_CHARGE_DETAILS"

	// ValidationExceptionReasonIllegalUpdateChargeDetails is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalUpdateChargeDetails = "ILLEGAL_UPDATE_CHARGE_DETAILS"

	// ValidationExceptionReasonInvalidArn is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidArn = "INVALID_ARN"

	// ValidationExceptionReasonIllegalResourceArns is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalResourceArns = "ILLEGAL_RESOURCE_ARNS"

	// ValidationExceptionReasonIllegalCustomlineitemModification is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalCustomlineitemModification = "ILLEGAL_CUSTOMLINEITEM_MODIFICATION"

	// ValidationExceptionReasonMissingLinkedAccountIds is a ValidationExceptionReason enum value
	ValidationExceptionReasonMissingLinkedAccountIds = "MISSING_LINKED_ACCOUNT_IDS"

	// ValidationExceptionReasonMultipleLinkedAccountIds is a ValidationExceptionReason enum value
	ValidationExceptionReasonMultipleLinkedAccountIds = "MULTIPLE_LINKED_ACCOUNT_IDS"

	// ValidationExceptionReasonMissingPricingPlanArn is a ValidationExceptionReason enum value
	ValidationExceptionReasonMissingPricingPlanArn = "MISSING_PRICING_PLAN_ARN"

	// ValidationExceptionReasonMultiplePricingPlanArn is a ValidationExceptionReason enum value
	ValidationExceptionReasonMultiplePricingPlanArn = "MULTIPLE_PRICING_PLAN_ARN"

	// ValidationExceptionReasonIllegalChildAssociateResource is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalChildAssociateResource = "ILLEGAL_CHILD_ASSOCIATE_RESOURCE"

	// ValidationExceptionReasonCustomLineItemAssociationExists is a ValidationExceptionReason enum value
	ValidationExceptionReasonCustomLineItemAssociationExists = "CUSTOM_LINE_ITEM_ASSOCIATION_EXISTS"

	// ValidationExceptionReasonInvalidBillingGroup is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidBillingGroup = "INVALID_BILLING_GROUP"

	// ValidationExceptionReasonInvalidBillingPeriodForOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidBillingPeriodForOperation = "INVALID_BILLING_PERIOD_FOR_OPERATION"

	// ValidationExceptionReasonIllegalBillingEntity is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalBillingEntity = "ILLEGAL_BILLING_ENTITY"

	// ValidationExceptionReasonIllegalModifierPercentage is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalModifierPercentage = "ILLEGAL_MODIFIER_PERCENTAGE"

	// ValidationExceptionReasonIllegalType is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalType = "ILLEGAL_TYPE"

	// ValidationExceptionReasonIllegalEndedBillinggroup is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalEndedBillinggroup = "ILLEGAL_ENDED_BILLINGGROUP"

	// ValidationExceptionReasonIllegalTieringInput is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalTieringInput = "ILLEGAL_TIERING_INPUT"

	// ValidationExceptionReasonIllegalOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalOperation = "ILLEGAL_OPERATION"

	// ValidationExceptionReasonIllegalUsageType is a ValidationExceptionReason enum value
	ValidationExceptionReasonIllegalUsageType = "ILLEGAL_USAGE_TYPE"

	// ValidationExceptionReasonInvalidSkuCombo is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidSkuCombo = "INVALID_SKU_COMBO"

	// ValidationExceptionReasonInvalidFilter is a ValidationExceptionReason enum value
	ValidationExceptionReasonInvalidFilter = "INVALID_FILTER"

	// ValidationExceptionReasonTooManyAutoAssociateBillingGroups is a ValidationExceptionReason enum value
	ValidationExceptionReasonTooManyAutoAssociateBillingGroups = "TOO_MANY_AUTO_ASSOCIATE_BILLING_GROUPS"

	// ValidationExceptionReasonCannotDeleteAutoAssociateBillingGroup is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotDeleteAutoAssociateBillingGroup = "CANNOT_DELETE_AUTO_ASSOCIATE_BILLING_GROUP"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
		ValidationExceptionReasonPrimaryNotAssociated,
		ValidationExceptionReasonPrimaryCannotDisassociate,
		ValidationExceptionReasonAccountsNotAssociated,
		ValidationExceptionReasonAccountsAlreadyAssociated,
		ValidationExceptionReasonIllegalPrimaryAccount,
		ValidationExceptionReasonIllegalAccounts,
		ValidationExceptionReasonMismatchedBillinggroupArn,
		ValidationExceptionReasonMissingBillinggroup,
		ValidationExceptionReasonMismatchedCustomlineitemArn,
		ValidationExceptionReasonIllegalBillingPeriod,
		ValidationExceptionReasonIllegalBillingPeriodRange,
		ValidationExceptionReasonTooManyAccountsInRequest,
		ValidationExceptionReasonDuplicateAccount,
		ValidationExceptionReasonInvalidBillingGroupStatus,
		ValidationExceptionReasonMismatchedPricingplanArn,
		ValidationExceptionReasonMissingPricingplan,
		ValidationExceptionReasonMismatchedPricingruleArn,
		ValidationExceptionReasonDuplicatePricingruleArns,
		ValidationExceptionReasonIllegalExpression,
		ValidationExceptionReasonIllegalScope,
		ValidationExceptionReasonIllegalService,
		ValidationExceptionReasonPricingrulesNotExist,
		ValidationExceptionReasonPricingrulesAlreadyAssociated,
		ValidationExceptionReasonPricingrulesNotAssociated,
		ValidationExceptionReasonInvalidTimeRange,
		ValidationExceptionReasonInvalidBillingviewArn,
		ValidationExceptionReasonMismatchedBillingviewArn,
		ValidationExceptionReasonIllegalCustomlineitem,
		ValidationExceptionReasonMissingCustomlineitem,
		ValidationExceptionReasonIllegalCustomlineitemUpdate,
		ValidationExceptionReasonTooManyCustomlineitemsInRequest,
		ValidationExceptionReasonIllegalChargeDetails,
		ValidationExceptionReasonIllegalUpdateChargeDetails,
		ValidationExceptionReasonInvalidArn,
		ValidationExceptionReasonIllegalResourceArns,
		ValidationExceptionReasonIllegalCustomlineitemModification,
		ValidationExceptionReasonMissingLinkedAccountIds,
		ValidationExceptionReasonMultipleLinkedAccountIds,
		ValidationExceptionReasonMissingPricingPlanArn,
		ValidationExceptionReasonMultiplePricingPlanArn,
		ValidationExceptionReasonIllegalChildAssociateResource,
		ValidationExceptionReasonCustomLineItemAssociationExists,
		ValidationExceptionReasonInvalidBillingGroup,
		ValidationExceptionReasonInvalidBillingPeriodForOperation,
		ValidationExceptionReasonIllegalBillingEntity,
		ValidationExceptionReasonIllegalModifierPercentage,
		ValidationExceptionReasonIllegalType,
		ValidationExceptionReasonIllegalEndedBillinggroup,
		ValidationExceptionReasonIllegalTieringInput,
		ValidationExceptionReasonIllegalOperation,
		ValidationExceptionReasonIllegalUsageType,
		ValidationExceptionReasonInvalidSkuCombo,
		ValidationExceptionReasonInvalidFilter,
		ValidationExceptionReasonTooManyAutoAssociateBillingGroups,
		ValidationExceptionReasonCannotDeleteAutoAssociateBillingGroup,
	}
}
