/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.BoundedSize;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Container;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public abstract class FormSpec
implements Serializable {
    static final DefaultAlignment LEFT_ALIGN = new DefaultAlignment("left");
    static final DefaultAlignment RIGHT_ALIGN = new DefaultAlignment("right");
    static final DefaultAlignment TOP_ALIGN = new DefaultAlignment("top");
    static final DefaultAlignment BOTTOM_ALIGN = new DefaultAlignment("bottom");
    static final DefaultAlignment CENTER_ALIGN = new DefaultAlignment("center");
    static final DefaultAlignment FILL_ALIGN = new DefaultAlignment("fill");
    private static final DefaultAlignment[] VALUES = new DefaultAlignment[]{LEFT_ALIGN, RIGHT_ALIGN, TOP_ALIGN, BOTTOM_ALIGN, CENTER_ALIGN, FILL_ALIGN};
    private DefaultAlignment defaultAlignment;
    private Size size;
    private double resizeWeight;

    protected FormSpec(DefaultAlignment defaultAlignment, Size size, double resizeWeight) {
        this.defaultAlignment = defaultAlignment;
        this.size = size;
        this.resizeWeight = resizeWeight;
        if (resizeWeight < 0.0) {
            throw new IllegalArgumentException("The resize weight must be non-negative.");
        }
    }

    protected FormSpec(DefaultAlignment defaultAlignment, String encodedDescription) {
        this(defaultAlignment, Sizes.DEFAULT, 0.0);
        this.parseAndInitValues(encodedDescription.toLowerCase(Locale.ENGLISH));
    }

    public final DefaultAlignment getDefaultAlignment() {
        return this.defaultAlignment;
    }

    public final Size getSize() {
        return this.size;
    }

    public final double getResizeWeight() {
        return this.resizeWeight;
    }

    final boolean canGrow() {
        return this.getResizeWeight() != 0.0;
    }

    private void parseAndInitValues(String encodedDescription) {
        StringTokenizer tokenizer = new StringTokenizer(encodedDescription, ":");
        if (!tokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("The form spec must not be empty.");
        }
        String token = tokenizer.nextToken();
        DefaultAlignment alignment = DefaultAlignment.valueOf(token, this.isHorizontal());
        if (alignment != null) {
            this.defaultAlignment = alignment;
            if (!tokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException("The form spec must provide a size.");
            }
            token = tokenizer.nextToken();
        }
        this.parseAndInitSize(token);
        if (tokenizer.hasMoreTokens()) {
            this.resizeWeight = this.decodeResize(tokenizer.nextToken());
        }
    }

    private void parseAndInitSize(String token) {
        if (token.startsWith("max(") && token.endsWith(")")) {
            this.size = this.parseAndInitBoundedSize(token, false);
            return;
        }
        if (token.startsWith("min(") && token.endsWith(")")) {
            this.size = this.parseAndInitBoundedSize(token, true);
            return;
        }
        this.size = this.decodeAtomicSize(token);
    }

    private Size parseAndInitBoundedSize(String token, boolean setMax) {
        int semicolonIndex = token.indexOf(59);
        String sizeToken1 = token.substring(4, semicolonIndex);
        String sizeToken2 = token.substring(semicolonIndex + 1, token.length() - 1);
        Size size1 = this.decodeAtomicSize(sizeToken1);
        Size size2 = this.decodeAtomicSize(sizeToken2);
        if (size1 instanceof ConstantSize) {
            if (size2 instanceof Sizes.ComponentSize) {
                return new BoundedSize(size2, setMax ? null : size1, setMax ? size1 : null);
            }
            throw new IllegalArgumentException("Bounded sizes must not be both constants.");
        }
        if (size2 instanceof ConstantSize) {
            return new BoundedSize(size1, setMax ? null : size2, setMax ? size2 : null);
        }
        throw new IllegalArgumentException("Bounded sizes must not be both logical.");
    }

    private Size decodeAtomicSize(String token) {
        Sizes.ComponentSize componentSize = Sizes.ComponentSize.valueOf(token);
        if (componentSize != null) {
            return componentSize;
        }
        return ConstantSize.valueOf(token, this.isHorizontal());
    }

    private double decodeResize(String token) {
        if (token.equals("g") || token.equals("grow")) {
            return 1.0;
        }
        if (token.equals("n") || token.equals("nogrow") || token.equals("none")) {
            return 0.0;
        }
        if ((token.startsWith("grow(") || token.startsWith("g(")) && token.endsWith(")")) {
            int leftParen = token.indexOf(40);
            int rightParen = token.indexOf(41);
            String substring = token.substring(leftParen + 1, rightParen);
            return Double.parseDouble(substring);
        }
        throw new IllegalArgumentException("The resize argument '" + token + "' is invalid. " + " Must be one of: grow, g, none, n, grow(<double>), g(<double>)");
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.defaultAlignment);
        buffer.append(":");
        buffer.append(this.size.toString());
        buffer.append(':');
        if (this.resizeWeight == 0.0) {
            buffer.append("noGrow");
        } else if (this.resizeWeight == 1.0) {
            buffer.append("grow");
        } else {
            buffer.append("grow(");
            buffer.append(this.resizeWeight);
            buffer.append(')');
        }
        return buffer.toString();
    }

    abstract boolean isHorizontal();

    final int maximumSize(Container container, List components, FormLayout.Measure minMeasure, FormLayout.Measure prefMeasure, FormLayout.Measure defaultMeasure) {
        return this.size.maximumSize(container, components, minMeasure, prefMeasure, defaultMeasure);
    }

    public static final class DefaultAlignment
    implements Serializable {
        private final transient String name;
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;

        private DefaultAlignment(String name) {
            this.name = name;
        }

        private static DefaultAlignment valueOf(String str, boolean isHorizontal) {
            if (str.equals("f") || str.equals("fill")) {
                return FILL_ALIGN;
            }
            if (str.equals("c") || str.equals("center")) {
                return CENTER_ALIGN;
            }
            if (isHorizontal) {
                if (str.equals("r") || str.equals("right")) {
                    return RIGHT_ALIGN;
                }
                if (str.equals("l") || str.equals("left")) {
                    return LEFT_ALIGN;
                }
                return null;
            }
            if (str.equals("t") || str.equals("top")) {
                return TOP_ALIGN;
            }
            if (str.equals("b") || str.equals("bottom")) {
                return BOTTOM_ALIGN;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        private Object readResolve() {
            return VALUES[this.ordinal];
        }
    }
}

