/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.AlreadyRegisteredException;
import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.InitializationException;
import Ice.LocalObjectImpl;
import Ice.Logger;
import Ice.LoggerFactory;
import Ice.NotRegisteredException;
import Ice.Plugin;
import Ice.PluginFactory;
import Ice.PluginInitializationException;
import Ice.PluginManager;
import Ice.Properties;
import Ice.StringSeqHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;

public final class PluginManagerI
extends LocalObjectImpl
implements PluginManager {
    private static String _kindOfObject;
    private Communicator _communicator;
    private HashMap _plugins = new HashMap();
    private ArrayList _initOrder = new ArrayList();
    private Logger _logger = null;
    private boolean _initialized;
    static final /* synthetic */ boolean $assertionsDisabled;

    public synchronized void initializePlugins() {
        if (this._initialized) {
            InitializationException ex = new InitializationException();
            ex.reason = "plugins already initialized";
            throw ex;
        }
        ArrayList<Plugin> initializedPlugins = new ArrayList<Plugin>();
        try {
            Iterator i = this._initOrder.iterator();
            while (i.hasNext()) {
                Plugin p = (Plugin)i.next();
                p.initialize();
                initializedPlugins.add(p);
            }
        }
        catch (RuntimeException ex) {
            ListIterator i = initializedPlugins.listIterator(initializedPlugins.size());
            while (i.hasPrevious()) {
                Plugin p = (Plugin)i.previous();
                try {
                    p.destroy();
                }
                catch (RuntimeException e) {}
            }
            throw ex;
        }
        this._initialized = true;
    }

    public synchronized Plugin getPlugin(String name) {
        if (this._communicator == null) {
            throw new CommunicatorDestroyedException();
        }
        Plugin p = (Plugin)this._plugins.get(name);
        if (p != null) {
            return p;
        }
        NotRegisteredException ex = new NotRegisteredException();
        ex.id = name;
        ex.kindOfObject = _kindOfObject;
        throw ex;
    }

    public synchronized void addPlugin(String name, Plugin plugin) {
        if (this._communicator == null) {
            throw new CommunicatorDestroyedException();
        }
        if (this._plugins.containsKey(name)) {
            AlreadyRegisteredException ex = new AlreadyRegisteredException();
            ex.id = name;
            ex.kindOfObject = _kindOfObject;
            throw ex;
        }
        this._plugins.put(name, plugin);
    }

    public synchronized void destroy() {
        if (this._communicator != null) {
            Iterator i = this._plugins.values().iterator();
            while (i.hasNext()) {
                Plugin p = (Plugin)i.next();
                p.destroy();
            }
            this._logger = null;
            this._communicator = null;
        }
    }

    public PluginManagerI(Communicator communicator) {
        this._communicator = communicator;
        this._initialized = false;
    }

    public void loadPlugins(StringSeqHolder cmdArgs) {
        String value;
        if (!$assertionsDisabled && this._communicator == null) {
            throw new AssertionError();
        }
        String prefix = "Ice.Plugin.";
        Properties properties = this._communicator.getProperties();
        Map plugins = properties.getPropertiesForPrefix("Ice.Plugin.");
        String loadOrder = properties.getProperty("Ice.PluginLoadOrder");
        if (loadOrder.length() > 0) {
            String[] names = loadOrder.split("[, \t\n]+");
            for (int i = 0; i < names.length; ++i) {
                if (this._plugins.containsKey(names[i])) {
                    PluginInitializationException ex = new PluginInitializationException();
                    ex.reason = "plugin `" + names[i] + "' already loaded";
                    throw ex;
                }
                String key = "Ice.Plugin." + names[i];
                if (!plugins.containsKey(key)) {
                    PluginInitializationException ex = new PluginInitializationException();
                    ex.reason = "plugin `" + names[i] + "' not defined";
                    throw ex;
                }
                value = (String)plugins.get(key);
                this.loadPlugin(names[i], value, cmdArgs, false);
                plugins.remove(key);
            }
        }
        Iterator p = plugins.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            String name = ((String)entry.getKey()).substring("Ice.Plugin.".length());
            value = (String)entry.getValue();
            this.loadPlugin(name, value, cmdArgs, false);
        }
        String loggerStr = properties.getProperty("Ice.LoggerPlugin");
        if (loggerStr.length() != 0) {
            this.loadPlugin("Logger", loggerStr, cmdArgs, true);
        }
        if (properties.getPropertyAsIntWithDefault("Ice.InitPlugins", 1) > 0) {
            this.initializePlugins();
        }
    }

    private void loadPlugin(String name, String pluginSpec, StringSeqHolder cmdArgs, boolean isLogger) {
        PluginInitializationException e;
        String[] args;
        String className;
        if (!$assertionsDisabled && this._communicator == null) {
            throw new AssertionError();
        }
        int pos = pluginSpec.indexOf(32);
        if (pos == -1) {
            pos = pluginSpec.indexOf(9);
        }
        if (pos == -1) {
            pos = pluginSpec.indexOf(10);
        }
        if (pos == -1) {
            className = pluginSpec;
            args = new String[]{};
        } else {
            className = pluginSpec.substring(0, pos);
            args = pluginSpec.substring(pos).trim().split("[ \t\n]+", pos);
        }
        Properties properties = this._communicator.getProperties();
        args = properties.parseCommandLineOptions(name, args);
        cmdArgs.value = properties.parseCommandLineOptions(name, cmdArgs.value);
        PluginFactory pluginFactory = null;
        LoggerFactory loggerFactory = null;
        try {
            Class<?> c = Class.forName(className);
            Object obj = c.newInstance();
            try {
                if (isLogger) {
                    loggerFactory = (LoggerFactory)obj;
                } else {
                    pluginFactory = (PluginFactory)obj;
                }
            }
            catch (ClassCastException ex) {
                PluginInitializationException e2 = new PluginInitializationException();
                e2.reason = "class " + className + " does not implement " + (isLogger ? "Ice.LoggerFactory" : "Ice.PluginFactory");
                e2.initCause(ex);
                throw e2;
            }
        }
        catch (ClassNotFoundException ex) {
            PluginInitializationException e3 = new PluginInitializationException();
            e3.reason = "class " + className + " not found";
            e3.initCause(ex);
            throw e3;
        }
        catch (IllegalAccessException ex) {
            PluginInitializationException e4 = new PluginInitializationException();
            e4.reason = "unable to access default constructor in class " + className;
            e4.initCause(ex);
            throw e4;
        }
        catch (InstantiationException ex) {
            PluginInitializationException e5 = new PluginInitializationException();
            e5.reason = "unable to instantiate class " + className;
            e5.initCause(ex);
            throw e5;
        }
        if (isLogger) {
            try {
                this._logger = loggerFactory.create(this._communicator, args);
            }
            catch (Throwable ex) {
                e = new PluginInitializationException();
                e.reason = "exception in factory " + className;
                e.initCause(ex);
                throw e;
            }
            if (this._logger == null) {
                PluginInitializationException e6 = new PluginInitializationException();
                e6.reason = "failure in factory " + className;
                throw e6;
            }
        } else {
            Plugin plugin = null;
            try {
                plugin = pluginFactory.create(this._communicator, name, args);
            }
            catch (PluginInitializationException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                PluginInitializationException e7 = new PluginInitializationException();
                e7.reason = "exception in factory " + className;
                e7.initCause(ex);
                throw e7;
            }
            if (plugin == null) {
                e = new PluginInitializationException();
                e.reason = "failure in factory " + className;
                throw e;
            }
            this._plugins.put(name, plugin);
            this._initOrder.add(plugin);
        }
    }

    public Logger getLogger() {
        return this._logger;
    }

    static {
        $assertionsDisabled = !PluginManagerI.class.desiredAssertionStatus();
        _kindOfObject = "plugin";
    }
}

