/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SIDTUNEMOD_H
#define SIDTUNEMOD_H

#ifdef SID_WITH_SIDPLAY2
# include <sidplay/SidTune.h>
#else
# include <sidplay/sidtune.h>
#endif  /* SID_WITH_SIDPLAY2 */

class MD5;

// Derivation of the sidtune class is a bit complicated with
// libsidplay1 because of strong member access protection.

#ifdef SID_WITH_SIDPLAY2
class SidTuneMod : public SidTune
#else
class SidTuneMod : public sidTune
#endif
{
 public:  // --------------------------------------------------------- public

#ifdef SID_WITH_SIDPLAY2
    SidTuneMod(const char* fileName) : SidTune(fileName)
#else
    SidTuneMod(const char* fileName) : sidTune(fileName)
#endif
    { ; }

#ifndef SID_WITH_SIDPLAY2
    uword selectSongPublic(uword selectedSong);
#else
    const unsigned char *getDataBuffer();
    int getDataLength();
#endif

    void createMD5(MD5&);
};

#endif  /* SIDTUNEMOD_H */
