// file      : tests/cxx/tree/complex/ctor/driver.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2006-2008 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

// Test generation of varous complex type constructors.
//

#include "test.hxx"

using namespace test;

int
main ()
{
  // Test case A.
  //
  {
    a_base b1;
    a_base b2 ("abc");        // empty ultimate base + required
    a_base b3 ("abc", "foo"); // ultimate base + required

    a_derived a1;
    a_derived a2 ("foo", "bar");        // empty ultimate base + required
    a_derived a3 (b3, "bar");           // base + required
    a_derived a4 ("abc", "foo", "bar"); // ultimate base + required
  }

  // Test case B.
  //
  {
    b_simple s ("base");
    b_base b ("base", "foo");
    b_derived d ("base", "foo", "bar");
    b_type t ("base");
  }

  // Test case C.
  //
  {
    c_simple s (c_enum::a);
    c_base b (c_enum::a, "foo");
    c_derived d (c_enum::a, "foo", "bar");
    c_type t (c_enum::a);
  }

  // Test case D.
  //
  {
    d_simple s (1);
    d_base b (1, "foo");
    d_derived d (1, "foo", "bar");
    d_type t (1);
  }
}
