// file      : xsde/cxx/parser/validating/xml-schema-pskel.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <xsde/cxx/parser/validating/xml-schema-pskel.hxx>

namespace xsde
{
  namespace cxx
  {
    namespace parser
    {
      namespace validating
      {
        // any_type
        //

        bool any_type_pskel::
        _start_element_impl (const ro_string& ns, const ro_string& name)
        {
          _start_any_element (ns, name);
          context_.top ().any_ = true;
          return true;
        }

        bool any_type_pskel::
        _end_element_impl (const ro_string& ns, const ro_string& name)
        {
          context_.top ().any_ = false;
          _end_any_element (ns, name);
          return true;
        }

        bool any_type_pskel::
        _attribute_impl_phase_two (const ro_string& ns,
                                   const ro_string& name,
                                   const ro_string& value)
        {
          _any_attribute (ns, name, value);
          return true;
        }

        bool any_type_pskel::
        _characters_impl (const ro_string& s)
        {
          _any_characters (s);
          return true;
        }

        // any_simple_type
        //

        bool any_simple_type_pskel::
        _characters_impl (const ro_string& s)
        {
          _any_characters (s);
          return true;
        }
      }
    }
  }
}

