// file      : xsd-frontend/semantic-graph/complex.hxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2008 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef XSD_FRONTEND_SEMANTIC_GRAPH_COMPLEX_HXX
#define XSD_FRONTEND_SEMANTIC_GRAPH_COMPLEX_HXX

#include <xsd-frontend/semantic-graph/elements.hxx>
#include <xsd-frontend/semantic-graph/compositors.hxx>

#include <cult/containers/vector.hxx>

namespace XSDFrontend
{
  namespace SemanticGraph
  {
    class Complex: public virtual Type, public virtual Scope
    {
    public:
      Boolean
      inherits_p () const
      {
        return inherits_ != 0;
      }

      Inherits&
      inherits () const
      {
        assert (inherits_ != 0);
        return *inherits_;
      }

    public:
      Boolean
      mixed () const
      {
        return mixed_;
      }

    public:
      Boolean
      contains_compositor_p ()
      {
        return contains_compositor_ != 0;
      }

      ContainsCompositor&
      contains_compositor ()
      {
        assert (contains_compositor_ != 0);
        return *contains_compositor_;
      }

    public:
      Boolean
      mixed (Boolean m)
      {
        mixed_ = m;
      }

    protected:
      friend class Bits::Graph<Node, Edge>;

      Complex (); // Virtual inheritance (Enumeration).
      Complex (Path const& file, UnsignedLong line, UnsignedLong column);

      using Type::add_edge_right;
      using Scope::add_edge_left;

      Void
      add_edge_left (Inherits& e)
      {
        assert (inherits_ == 0);
        inherits_ = &e;
      }

      Void
      add_edge_left (ContainsCompositor& e)
      {
        assert (contains_compositor_ == 0);
        contains_compositor_ = &e;
      }

    private:
      Boolean mixed_;
      Inherits* inherits_;
      ContainsCompositor* contains_compositor_;
    };
  }
}

#endif  // XSD_FRONTEND_SEMANTIC_GRAPH_COMPLEX_HXX
