/*

   xlog - GTK+ logging program for amateur radio operators
   Copyright (C) 2001 - 2007 Joop Stakenborg <pg4i@amsat.org>

   This file is part of xlog.

   Xlog is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   Xlog is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with xlog.  If not, see <http://www.gnu.org/licenses/>.

*/

/*
 * gui_dialogsdialog.c - creation and destruction of the dialogs dialog
 *
 * show a dialog with 2 pages which will allow you to:
 * 1) select the fields in the "worked before" dialog. If the worked before
 *    dialog is active the fields are updated.
 * 2) set export options for save as ADIF and TSV (for glabels).
 */
#include <stdlib.h>
#include <gtk/gtk.h>

#include "gui_dialogsdialog.h"
#include "gui_scorewindow.h"
#include "support.h"
#include "preferences.h"
#include "xlog_enum.h"
#include "dxcc.h"

extern GtkWidget *mainwindow;
extern GtkWidget *b4window;
extern GtkWidget *scorewindow;
extern preferencestype preferences;

void
on_menu_dialogs_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *dialogsdialog, *notebook, *vbox, *label,
		*frame, *framehbox, *leftvbox, *middlevbox, *rightvbox, *vbox2,
		*b40, *b41, *b42, *b43, *b44, *b45, *b46, *b47, *b48, *b49,
		*b410, *b411, *b412, *b413, *b414, *b415, *b416, *b417, *b418,
		*b419,
		*badif, *hsep,
		*bu1, *bu2, *bu3, *bu4, *bu5, *bu6, *bu7, *bu8, *bu9, *bu10,
		*bu11, *bu12, *bu13, *bu14, *bu15, *bu16, *bu17, *bu18,
		*b4treeview, *tsvhbox, *bucalc,
		*bb1, *bb2, *bb3, *bb4, *bb5, *bb6, *bb7, *bb8, *bb9, *bb10,
		*bb11, *bb12, *bb13, *bb14, *bb15, *bb16, *bb17, *bb18, *bb19,
		*bb20, *bb21, *bb22, *bb23, *bb24, *bb25, *bb26, *bb27, *bb28,
		*bb29, *vbox3, *bwac, *bwas, *bwaz, *biota, *bloc,
		*countrytreeview, *dxcctreeview;
	gchar **states, **split, *scoringbands;
	gboolean check;
	GtkTreeViewColumn *column;
	GtkTreeIter iter;
	gint i, j, response;
	gchar iter_num[2] = "1";

	split = g_strsplit(preferences.b4columns2, ",", 0);
	dialogsdialog = gtk_dialog_new_with_buttons (_("xlog - dialogs and windows"),
		GTK_WINDOW(mainwindow), GTK_DIALOG_DESTROY_WITH_PARENT,
		GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
		GTK_STOCK_OK, GTK_RESPONSE_OK, NULL);
	notebook = gtk_notebook_new ();
	gtk_container_add
		(GTK_CONTAINER (GTK_DIALOG (dialogsdialog)->vbox), notebook);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (notebook), vbox);
	label = gtk_label_new (_("Columns to show in the 'Worked Before' dialog"));
	gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 10);
	gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);

	frame = gtk_frame_new (NULL);
	gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
	framehbox = gtk_hbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (frame), framehbox);

	leftvbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (framehbox), leftvbox, FALSE, FALSE, 0);
	b40 = gtk_check_button_new_with_label (_("Logname"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b40), atoi(split[0]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b40, FALSE, FALSE, 0);
	b41 = gtk_check_button_new_with_label (_("QSO Number"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b41), atoi(split[1]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b41, FALSE, FALSE, 0);
	b42 = gtk_check_button_new_with_label (_("Date"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b42), atoi(split[2]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b42, FALSE, FALSE, 0);
	b43 = gtk_check_button_new_with_label ("UTC");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b43), atoi(split[3]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b43, FALSE, FALSE, 0);
	b44 = gtk_check_button_new_with_label (_("UTC - end"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b44), atoi(split[4]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b44, FALSE, FALSE, 0);
	b45 = gtk_check_button_new_with_label (_("Call"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b45), atoi(split[5]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b45, FALSE, FALSE, 0);
	b46 = gtk_check_button_new_with_label (_("Frequency"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b46), atoi(split[6]));
	gtk_box_pack_start (GTK_BOX (leftvbox), b46, FALSE, FALSE, 0);

	middlevbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (framehbox), middlevbox, FALSE, FALSE, 0);
	b47 = gtk_check_button_new_with_label (_("Mode"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b47), atoi(split[7]));
	gtk_box_pack_start (GTK_BOX (middlevbox), b47, FALSE, FALSE, 0);
	b48 = gtk_check_button_new_with_label ("TX(RST)");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b48), atoi(split[8]));
	gtk_box_pack_start (GTK_BOX (middlevbox), b48, FALSE, FALSE, 0);
	b49 = gtk_check_button_new_with_label ("RX(RST)");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b49), atoi(split[9]));
	gtk_box_pack_start (GTK_BOX (middlevbox), b49, FALSE, FALSE, 0);
	b410 = gtk_check_button_new_with_label (_("Awards"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b410), atoi(split[10]));
	gtk_box_pack_start (GTK_BOX (middlevbox), b410, FALSE, FALSE, 0);
	b411 = gtk_check_button_new_with_label (_("Qsl Out"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b411), atoi(split[11]));
	gtk_box_pack_start (GTK_BOX (middlevbox), b411, FALSE, FALSE, 0);
	b412 = gtk_check_button_new_with_label (_("Qsl In"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b412), atoi(split[12]));
	gtk_box_pack_start (GTK_BOX (middlevbox), b412, FALSE, FALSE, 0);
	b413 = gtk_check_button_new_with_label (_("Power"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b413), atoi(split[13]));
	gtk_box_pack_start (GTK_BOX (middlevbox), b413, FALSE, FALSE, 0);

	rightvbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (framehbox), rightvbox, FALSE, FALSE, 0);
	b414 = gtk_check_button_new_with_label (_("Name"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b414), atoi(split[14]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b414, FALSE, FALSE, 0);
	b415 = gtk_check_button_new_with_label ("QTH");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b415), atoi(split[15]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b415, FALSE, FALSE, 0);
	b416 = gtk_check_button_new_with_label (_("Locator"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b416), atoi(split[16]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b416, FALSE, FALSE, 0);
	b417 = gtk_check_button_new_with_label ("");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b417), atoi(split[17]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b417, FALSE, FALSE, 0);
	b418 = gtk_check_button_new_with_label ("");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b418), atoi(split[18]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b418, FALSE, FALSE, 0);
	b419 = gtk_check_button_new_with_label (_("Remarks"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (b419), atoi(split[19]));
	gtk_box_pack_start (GTK_BOX (rightvbox), b419, FALSE, FALSE, 0);

	g_strfreev(split);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (notebook), vbox);

	label = gtk_label_new (_("Options for the export dialog"));
	gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 10);
	gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);

	frame = gtk_frame_new ("ADIF");
	gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
	badif = gtk_check_button_new_with_label
		(_("When exporting to ADIF convert frequency to band"));
	if (preferences.saveasadif == 1)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (badif), TRUE);
	gtk_container_add (GTK_CONTAINER (frame), badif);
	gtk_label_set_line_wrap	(GTK_LABEL (GTK_BIN (badif)->child), TRUE);

	frame = gtk_frame_new ("TSV");
	gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (frame), vbox2);
	label = gtk_label_new
(_("Fields to export when saving as TSV (Tab Separated Value) for glabels"));
	gtk_container_add (GTK_CONTAINER (vbox2), label);
	gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
	hsep = gtk_hseparator_new ();
	gtk_container_add (GTK_CONTAINER (vbox2), hsep);
	tsvhbox = gtk_hbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (vbox2), tsvhbox);

	split = g_strsplit(preferences.saveastsv2, ",", 0);
	leftvbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (tsvhbox), leftvbox, FALSE, FALSE, 0);
	bu1 = gtk_check_button_new_with_label (_("Date"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu1), atoi(split[0]));
	gtk_box_pack_start (GTK_BOX (leftvbox), bu1, FALSE, FALSE, 0);
	bu2 = gtk_check_button_new_with_label ("UTC");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu2), atoi(split[1]));
	gtk_box_pack_start (GTK_BOX (leftvbox), bu2, FALSE, FALSE, 0);
	bu3 = gtk_check_button_new_with_label (_("UTC - end"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu3), atoi(split[2]));
	gtk_box_pack_start (GTK_BOX (leftvbox), bu3, FALSE, FALSE, 0);
	bu4 = gtk_check_button_new_with_label (_("Call"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu4), atoi(split[3]));
	gtk_box_pack_start (GTK_BOX (leftvbox), bu4, FALSE, FALSE, 0);
	bu5 = gtk_check_button_new_with_label (_("Frequency"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu5), atoi(split[4]));
	gtk_box_pack_start (GTK_BOX (leftvbox), bu5, FALSE, FALSE, 0);
	bu6 = gtk_check_button_new_with_label (_("Mode"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu6), atoi(split[5]));
	gtk_box_pack_start (GTK_BOX (leftvbox), bu6, FALSE, FALSE, 0);

	middlevbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (tsvhbox), middlevbox, FALSE, FALSE, 0);
	bu7 = gtk_check_button_new_with_label ("TX(RST)");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu7), atoi(split[6]));
	gtk_box_pack_start (GTK_BOX (middlevbox), bu7, FALSE, FALSE, 0);
	bu8 = gtk_check_button_new_with_label ("RX(RST)");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu8), atoi(split[7]));
	gtk_box_pack_start (GTK_BOX (middlevbox), bu8, FALSE, FALSE, 0);
	bu9 = gtk_check_button_new_with_label (_("Awards"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu9), atoi(split[8]));
	gtk_box_pack_start (GTK_BOX (middlevbox), bu9, FALSE, FALSE, 0);
	bu10 = gtk_check_button_new_with_label (_("Qsl Out"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu10), atoi(split[9]));
	gtk_box_pack_start (GTK_BOX (middlevbox), bu10, FALSE, FALSE, 0);
	bu11 = gtk_check_button_new_with_label (_("Qsl In"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu11), atoi(split[10]));
	gtk_box_pack_start (GTK_BOX (middlevbox), bu11, FALSE, FALSE, 0);
	bu12 = gtk_check_button_new_with_label (_("Power"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu12), atoi(split[11]));
	gtk_box_pack_start (GTK_BOX (middlevbox), bu12, FALSE, FALSE, 0);

	rightvbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (tsvhbox), rightvbox, FALSE, FALSE, 0);
	bu13 = gtk_check_button_new_with_label (_("Name"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu13), atoi(split[12]));
	gtk_box_pack_start (GTK_BOX (rightvbox), bu13, FALSE, FALSE, 0);
	bu14 = gtk_check_button_new_with_label ("QTH");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu14), atoi(split[13]));
	gtk_box_pack_start (GTK_BOX (rightvbox), bu14, FALSE, FALSE, 0);
	bu15 = gtk_check_button_new_with_label (_("Locator"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu15), atoi(split[14]));
	gtk_box_pack_start (GTK_BOX (rightvbox), bu15, FALSE, FALSE, 0);
	bu16 = gtk_check_button_new_with_label ("");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu16), atoi(split[15]));
	gtk_box_pack_start (GTK_BOX (rightvbox), bu16, FALSE, FALSE, 0);
	bu17 = gtk_check_button_new_with_label ("");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu17), atoi(split[16]));
	gtk_box_pack_start (GTK_BOX (rightvbox), bu17, FALSE, FALSE, 0);
	bu18 = gtk_check_button_new_with_label (_("Remarks"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bu18), atoi(split[17]));
	gtk_box_pack_start (GTK_BOX (rightvbox), bu18, FALSE, FALSE, 0);

	g_strfreev(split);

	hsep = gtk_hseparator_new ();
	gtk_container_add (GTK_CONTAINER (vbox2), hsep);
	bucalc = gtk_check_button_new_with_label
(_("Add calculated bearing and distance fields when the locator log field is used"));
	gtk_label_set_line_wrap	(GTK_LABEL (GTK_BIN (bucalc)->child), TRUE);
	gtk_toggle_button_set_active
		(GTK_TOGGLE_BUTTON (bucalc), preferences.tsvcalc);
	gtk_box_pack_start (GTK_BOX (vbox2), bucalc, FALSE, FALSE, 0);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (notebook), vbox);
	frame = gtk_frame_new (_("Bands"));
	gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
	vbox2 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (frame), vbox2);
	label = gtk_label_new (_("Bands to include in the scoring window"));
	gtk_container_add (GTK_CONTAINER (vbox2), label);
	gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
	hsep = gtk_hseparator_new ();
	gtk_container_add (GTK_CONTAINER (vbox2), hsep);

	framehbox = gtk_hbox_new (TRUE	, 0);
	gtk_container_add (GTK_CONTAINER (vbox2), framehbox);

	leftvbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (framehbox), leftvbox, FALSE, FALSE, 0);
	bb1 = gtk_check_button_new_with_label ("0.136 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb1),
		preferences.scoringbands[BAND_2190] - 48);
	gtk_box_pack_start (GTK_BOX (leftvbox), bb1, FALSE, FALSE, 0);
	bb2 = gtk_check_button_new_with_label ("1.8 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb2),
		preferences.scoringbands[BAND_160] - 48);
	gtk_box_pack_start (GTK_BOX (leftvbox), bb2, FALSE, FALSE, 0);
	bb3 = gtk_check_button_new_with_label ("3.5 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb3),
		preferences.scoringbands[BAND_80] - 48);
	gtk_box_pack_start (GTK_BOX (leftvbox), bb3, FALSE, FALSE, 0);
	bb4 = gtk_check_button_new_with_label ("5.2 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb4),
		preferences.scoringbands[BAND_60] - 48);
	gtk_box_pack_start (GTK_BOX (leftvbox), bb4, FALSE, FALSE, 0);
	bb5 = gtk_check_button_new_with_label ("7 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb5),
		preferences.scoringbands[BAND_40] - 48);
	gtk_box_pack_start (GTK_BOX (leftvbox), bb5, FALSE, FALSE, 0);
	bb6 = gtk_check_button_new_with_label ("10 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb6),
		preferences.scoringbands[BAND_30] - 48);
	gtk_box_pack_start (GTK_BOX (leftvbox), bb6, FALSE, FALSE, 0);
	bb7 = gtk_check_button_new_with_label ("14 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb7),
		preferences.scoringbands[BAND_20] - 48);
	gtk_box_pack_start (GTK_BOX (leftvbox), bb7, FALSE, FALSE, 0);
	bb8 = gtk_check_button_new_with_label ("18 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb8),
		preferences.scoringbands[BAND_17] - 48);
	gtk_box_pack_start (GTK_BOX (leftvbox), bb8, FALSE, FALSE, 0);
	bb9 = gtk_check_button_new_with_label ("21 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb9),
		preferences.scoringbands[BAND_15] - 48);
	gtk_box_pack_start (GTK_BOX (leftvbox), bb9, FALSE, FALSE, 0);
	bb10 = gtk_check_button_new_with_label ("24 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb10),
		preferences.scoringbands[BAND_12] - 48);
	gtk_box_pack_start (GTK_BOX (leftvbox), bb10, FALSE, FALSE, 0);

	middlevbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (framehbox), middlevbox, FALSE, FALSE, 0);
	bb11 = gtk_check_button_new_with_label ("28 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb11),
		preferences.scoringbands[BAND_10] - 48);
	gtk_box_pack_start (GTK_BOX (middlevbox), bb11, FALSE, FALSE, 0);
	bb12 = gtk_check_button_new_with_label ("50 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb12),
		preferences.scoringbands[BAND_6] - 48);
	gtk_box_pack_start (GTK_BOX (middlevbox), bb12, FALSE, FALSE, 0);
	bb13 = gtk_check_button_new_with_label ("70 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb13),
		preferences.scoringbands[BAND_4] - 48);
	gtk_box_pack_start (GTK_BOX (middlevbox), bb13, FALSE, FALSE, 0);
	bb14 = gtk_check_button_new_with_label ("144 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb14),
		preferences.scoringbands[BAND_2] - 48);
	gtk_box_pack_start (GTK_BOX (middlevbox), bb14, FALSE, FALSE, 0);
	bb15 = gtk_check_button_new_with_label ("222 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb15),
		preferences.scoringbands[BAND_125CM] - 48);
	gtk_box_pack_start (GTK_BOX (middlevbox), bb15, FALSE, FALSE, 0);
	bb16 = gtk_check_button_new_with_label ("420 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb16),
		preferences.scoringbands[BAND_70CM] - 48);
	gtk_box_pack_start (GTK_BOX (middlevbox), bb16, FALSE, FALSE, 0);
	bb17 = gtk_check_button_new_with_label ("902 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb17),
		preferences.scoringbands[BAND_33CM] - 48);
	gtk_box_pack_start (GTK_BOX (middlevbox), bb17, FALSE, FALSE, 0);
	bb18 = gtk_check_button_new_with_label ("1240 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb18),
		preferences.scoringbands[BAND_23CM] - 48);
	gtk_box_pack_start (GTK_BOX (middlevbox), bb18, FALSE, FALSE, 0);
	bb19 = gtk_check_button_new_with_label ("2300 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb19),
		preferences.scoringbands[BAND_13CM] - 48);
	gtk_box_pack_start (GTK_BOX (middlevbox), bb19, FALSE, FALSE, 0);
	bb20 = gtk_check_button_new_with_label ("3300 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb20),
		preferences.scoringbands[BAND_9CM] - 48);
	gtk_box_pack_start (GTK_BOX (middlevbox), bb20, FALSE, FALSE, 0);

	rightvbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (framehbox), rightvbox, FALSE, FALSE, 0);
	bb21 = gtk_check_button_new_with_label ("5650 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb21),
		preferences.scoringbands[BAND_6CM] - 48);
	gtk_box_pack_start (GTK_BOX (rightvbox), bb21, FALSE, FALSE, 0);
	bb22 = gtk_check_button_new_with_label ("10000 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb22),
		preferences.scoringbands[BAND_3CM] - 48);
	gtk_box_pack_start (GTK_BOX (rightvbox), bb22, FALSE, FALSE, 0);
	bb23 = gtk_check_button_new_with_label ("24000 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb23),
		preferences.scoringbands[BAND_12HMM] - 48);
	gtk_box_pack_start (GTK_BOX (rightvbox), bb23, FALSE, FALSE, 0);
	bb24 = gtk_check_button_new_with_label ("47000 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb24),
		preferences.scoringbands[BAND_6MM] - 48);
	gtk_box_pack_start (GTK_BOX (rightvbox), bb24, FALSE, FALSE, 0);
	bb25 = gtk_check_button_new_with_label ("75500 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb25),
		preferences.scoringbands[BAND_4MM] - 48);
	gtk_box_pack_start (GTK_BOX (rightvbox), bb25, FALSE, FALSE, 0);
	bb26 = gtk_check_button_new_with_label ("120000 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb26),
		preferences.scoringbands[BAND_2HMM] - 48);
	gtk_box_pack_start (GTK_BOX (rightvbox), bb26, FALSE, FALSE, 0);
	bb27 = gtk_check_button_new_with_label ("142000 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb27),
		preferences.scoringbands[BAND_2MM] - 48);
	gtk_box_pack_start (GTK_BOX (rightvbox), bb27, FALSE, FALSE, 0);
	bb28 = gtk_check_button_new_with_label ("241000 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb28),
		preferences.scoringbands[BAND_1MM] - 48);
	gtk_box_pack_start (GTK_BOX (rightvbox), bb28, FALSE, FALSE, 0);
	bb29 = gtk_check_button_new_with_label ("300000 MHz");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bb29),
		preferences.scoringbands[BAND_SUBMM] - 48);
	gtk_box_pack_start (GTK_BOX (rightvbox), bb29, FALSE, FALSE, 0);

	frame = gtk_frame_new (_("Awards"));
	gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
	vbox3 = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (frame), vbox3);
	label = gtk_label_new (_("Awards to add to the scoring window"));
	gtk_container_add (GTK_CONTAINER (vbox3), label);
	gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
	hsep = gtk_hseparator_new ();
	gtk_container_add (GTK_CONTAINER (vbox3), hsep);
	bwac = gtk_check_button_new_with_label ("WAC (Worked All Continents)");
	gtk_box_pack_start (GTK_BOX (vbox3), bwac, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bwac), preferences.awardswac);
	bwas = gtk_check_button_new_with_label ("WAS (Worked All States)");
	gtk_box_pack_start (GTK_BOX (vbox3), bwas, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bwas), preferences.awardswas);
	bwaz = gtk_check_button_new_with_label ("WAZ (Worked All Zones)");
	gtk_box_pack_start (GTK_BOX (vbox3), bwaz, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bwaz), preferences.awardswaz);
	biota = gtk_check_button_new_with_label ("IOTA (Islands On The Air)");
	gtk_box_pack_start (GTK_BOX (vbox3), biota, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (biota), preferences.awardsiota);
	bloc = gtk_check_button_new_with_label ("Grid Locators");
	gtk_box_pack_start (GTK_BOX (vbox3), bloc, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bloc), preferences.awardsloc);

	label = gtk_label_new (_("Worked Before"));
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook),
		gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 0), label);
	label = gtk_label_new (_("Export"));
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook),
		gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 1), label);
	label = gtk_label_new (_("Scoring"));
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook),
		gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 2), label);

	gtk_button_set_label (GTK_BUTTON (b417), preferences.freefield1);
	gtk_button_set_label (GTK_BUTTON (b418), preferences.freefield2);
	gtk_button_set_label (GTK_BUTTON (bu16), preferences.freefield1);
	gtk_button_set_label (GTK_BUTTON (bu17), preferences.freefield2);

	gtk_dialog_set_default_response (GTK_DIALOG (dialogsdialog),
                                             GTK_RESPONSE_OK);

	gtk_widget_show_all (dialogsdialog);
	response = gtk_dialog_run (GTK_DIALOG(dialogsdialog));
	if (response == GTK_RESPONSE_OK)
	{
		states = g_new0 (gchar *, 21);
		b4treeview = lookup_widget (b4window, "b4treeview");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b40));
		if (b4window && GTK_WIDGET_VISIBLE (b4window))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 0);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[0] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b41));
		if (b4window && GTK_WIDGET_VISIBLE (b4window))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 1);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[1] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b42));
		if (b4window && GTK_WIDGET_VISIBLE (b4window))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 2);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[2] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b43));
		if (b4window && GTK_WIDGET_VISIBLE (b4window))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 3);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[3] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b44));
		if (b4window && GTK_WIDGET_VISIBLE (b4window))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 4);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[4] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b45));
		if (b4window && GTK_WIDGET_VISIBLE (b4window))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 5);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[5] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b46));
		if (b4window && GTK_WIDGET_VISIBLE (b4window))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 6);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[6] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b47));
		if (b4window && GTK_WIDGET_VISIBLE (b4window))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 7);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[7] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b48));
		if (b4window && GTK_WIDGET_VISIBLE (b4window))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 8);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[8] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b49));
		if (b4window && GTK_WIDGET_VISIBLE (b4window))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 9);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[9] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b410));
		if (b4window && GTK_WIDGET_VISIBLE (b4window))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 10);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[10] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b411));
		if (b4window && GTK_WIDGET_VISIBLE (b4window))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 11);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[11] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b412));
		if (b4window && GTK_WIDGET_VISIBLE (b4window))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 12);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[12] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b413));
		if (b4window && GTK_WIDGET_VISIBLE (b4window))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 13);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[13] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b414));
		if (b4window && GTK_WIDGET_VISIBLE (b4window))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 14);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[14] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b415));
		if (b4window && GTK_WIDGET_VISIBLE (b4window))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 15);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[15] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b416));
		if (b4window && GTK_WIDGET_VISIBLE (b4window))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 16);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[16] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b417));
		if (b4window && GTK_WIDGET_VISIBLE (b4window))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 17);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[17] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b418));
		if (b4window && GTK_WIDGET_VISIBLE (b4window))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 18);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[18] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b419));
		if (b4window && GTK_WIDGET_VISIBLE (b4window))
		{
			column = gtk_tree_view_get_column (GTK_TREE_VIEW(b4treeview), 19);
			gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), check);
		}
		states[19] = g_strdup (check ? "1" : "0");

		states[20] = NULL;	/* terminator for g_strjoinv */
		preferences.b4columns2 = g_strjoinv (",", states);

		for (i = 0; i < 21; i++)
			g_free (states[i]);
		g_free (states);

		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(badif));
		if (check)
			preferences.saveasadif = 1;
		else
			preferences.saveasadif = 0;

		states = g_new0 (gchar *, 19);
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu1));
		states[0] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu2));
		states[1] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu3));
		states[2] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu4));
		states[3] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu5));
		states[4] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu6));
		states[5] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu7));
		states[6] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu8));
		states[7] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu9));
		states[8] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu10));
		states[9] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu11));
		states[10] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu12));
		states[11] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu13));
		states[12] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu14));
		states[13] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu15));
		states[14] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu16));
		states[15] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu17));
		states[16] = g_strdup (check ? "1" : "0");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bu18));
		states[17] = g_strdup (check ? "1" : "0");

		states[18] = NULL;	/* terminator for g_strjoinv */
		preferences.saveastsv2 = g_strjoinv (",", states);

		for (i = 0; i < 18; i++)
			g_free (states[i]);
		g_free (states);

		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bucalc));
		if (check)
			preferences.tsvcalc = 1;
		else
			preferences.tsvcalc = 0;

		scoringbands = g_strdup ("00000000000000000000000000000");
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb1));
		scoringbands[BAND_2190] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb2));
		scoringbands[BAND_160] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb3));
		scoringbands[BAND_80] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb4));
		scoringbands[BAND_60] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb5));
		scoringbands[BAND_40] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb6));
		scoringbands[BAND_30] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb7));
		scoringbands[BAND_20] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb8));
		scoringbands[BAND_17] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb9));
		scoringbands[BAND_15] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb10));
		scoringbands[BAND_12] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb11));
		scoringbands[BAND_10] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb12));
		scoringbands[BAND_6] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb13));
		scoringbands[BAND_4] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb14));
		scoringbands[BAND_2] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb15));
		scoringbands[BAND_125CM] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb16));
		scoringbands[BAND_70CM] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb17));
		scoringbands[BAND_33CM] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb18));
		scoringbands[BAND_23CM] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb19));
		scoringbands[BAND_13CM] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb20));
		scoringbands[BAND_9CM] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb21));
		scoringbands[BAND_6CM] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb22));
		scoringbands[BAND_3CM] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb23));
		scoringbands[BAND_12HMM] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb24));
		scoringbands[BAND_6MM] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb25));
		scoringbands[BAND_4MM] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb26));
		scoringbands[BAND_2HMM] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb27));
		scoringbands[BAND_2MM] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb28));
		scoringbands[BAND_1MM] = check ? '1' : '0';
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bb29));
		scoringbands[BAND_SUBMM] = check ? '1' : '0';

		/* WAC */
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bwac));
		if (check)
		{
			if (preferences.awardswac == 0)
			{
				GtkWidget *awardsnotebook = lookup_widget (scorewindow, "awardsnotebook");
				notebook_append_wacpage (scorewindow, awardsnotebook);
				fill_scoring_arrays ();
				update_wacscoring ();
			}
			preferences.awardswac = 1;
		}
		else
		{
			if (preferences.awardswac == 1)
			{
				GtkWidget *awardsnotebook = lookup_widget (scorewindow, "awardsnotebook");
				GtkWidget *scrolledwindow2 = lookup_widget (scorewindow, "scrolledwindow2");
				gtk_notebook_remove_page (GTK_NOTEBOOK(awardsnotebook),
					gtk_notebook_page_num (GTK_NOTEBOOK(awardsnotebook), scrolledwindow2));
				GtkWidget *countrytreeview = lookup_widget (scorewindow, "countrytreeview");
				GtkTreeModel *model = gtk_tree_view_get_model (GTK_TREE_VIEW (countrytreeview));
				gtk_tree_model_get_iter (model, &iter, gtk_tree_path_new_from_string (iter_num));
				iter_num[0]++;
				for (j = 0; j < MAX_BANDS + 1; j++)
					gtk_list_store_set (GTK_LIST_STORE (model), &iter, j, "", -1);
			}
			preferences.awardswac = 0;
		}

		/* WAS */
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bwas));
		if (check)
		{
			if (preferences.awardswas == 0)
			{
				GtkWidget *awardsnotebook = lookup_widget (scorewindow, "awardsnotebook");
				notebook_append_waspage (scorewindow, awardsnotebook);
				fill_scoring_arrays ();
				update_wasscoring ();
			}
			preferences.awardswas = 1;
		}
		else
		{
			if (preferences.awardswas == 1)
			{
				GtkWidget *awardsnotebook = lookup_widget (scorewindow, "awardsnotebook");
				GtkWidget *scrolledwindow3 = lookup_widget (scorewindow, "scrolledwindow3");
				gtk_notebook_remove_page (GTK_NOTEBOOK(awardsnotebook),
					gtk_notebook_page_num (GTK_NOTEBOOK(awardsnotebook), scrolledwindow3));
				GtkWidget *countrytreeview = lookup_widget (scorewindow, "countrytreeview");
				GtkTreeModel *model = gtk_tree_view_get_model (GTK_TREE_VIEW (countrytreeview));
				gtk_tree_model_get_iter (model, &iter, gtk_tree_path_new_from_string (iter_num));
				iter_num[0]++;
				for (j = 0; j < MAX_BANDS + 1; j++)
					gtk_list_store_set (GTK_LIST_STORE (model), &iter, j, "", -1);
			}
			preferences.awardswas = 0;
		}

		/* WAZ */
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bwaz));
		if (check)
		{
			if (preferences.awardswaz == 0)
			{
				GtkWidget *awardsnotebook = lookup_widget (scorewindow, "awardsnotebook");
				notebook_append_wazpage (scorewindow, awardsnotebook);
				fill_scoring_arrays ();
				update_wazscoring ();
			}
			preferences.awardswaz = 1;
		}
		else
		{
			if (preferences.awardswaz == 1)
			{
				GtkWidget *awardsnotebook = lookup_widget (scorewindow, "awardsnotebook");
				GtkWidget *scrolledwindow4 = lookup_widget (scorewindow, "scrolledwindow4");
				gtk_notebook_remove_page (GTK_NOTEBOOK(awardsnotebook),
					gtk_notebook_page_num (GTK_NOTEBOOK(awardsnotebook), scrolledwindow4));
				GtkWidget *countrytreeview = lookup_widget (scorewindow, "countrytreeview");
				GtkTreeModel *model = gtk_tree_view_get_model (GTK_TREE_VIEW (countrytreeview));
				gtk_tree_model_get_iter (model, &iter, gtk_tree_path_new_from_string (iter_num));
				iter_num[0]++;
				for (j = 0; j < MAX_BANDS + 1; j++)
					gtk_list_store_set (GTK_LIST_STORE (model), &iter, j, "", -1);
			}
			preferences.awardswaz = 0;
		}

		/* IOTA */
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(biota));
		if (check)
		{
			if (preferences.awardsiota == 0)
			{
				GtkWidget *awardsnotebook = lookup_widget (scorewindow, "awardsnotebook");
				notebook_append_iotapage (scorewindow, awardsnotebook);
				fill_scoring_arrays ();
				update_iotascoring ();
			}
			preferences.awardsiota = 1;
		}
		else
		{
			if (preferences.awardsiota == 1)
			{
				GtkWidget *awardsnotebook = lookup_widget (scorewindow, "awardsnotebook");
				GtkWidget *scrolledwindow5 = lookup_widget (scorewindow, "scrolledwindow5");
				gtk_notebook_remove_page (GTK_NOTEBOOK(awardsnotebook),
					gtk_notebook_page_num (GTK_NOTEBOOK(awardsnotebook), scrolledwindow5));
				GtkWidget *countrytreeview = lookup_widget (scorewindow, "countrytreeview");
				GtkTreeModel *model = gtk_tree_view_get_model (GTK_TREE_VIEW (countrytreeview));
				gtk_tree_model_get_iter (model, &iter, gtk_tree_path_new_from_string (iter_num));
				iter_num[0]++;
				for (j = 0; j < MAX_BANDS + 1; j++)
					gtk_list_store_set (GTK_LIST_STORE (model), &iter, j, "", -1);
			}
			preferences.awardsiota = 0;
		}

		/* Grid locator */
		check = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bloc));
		if (check)
		{
			if (preferences.awardsloc == 0)
			{
				GtkWidget *awardsnotebook = lookup_widget (scorewindow, "awardsnotebook");
				notebook_append_locpage (scorewindow, awardsnotebook);
				fill_scoring_arrays ();
				update_locscoring ();
			}
			preferences.awardsloc = 1;
		}
		else
		{
			if (preferences.awardsloc == 1)
			{
				GtkWidget *awardsnotebook = lookup_widget (scorewindow, "awardsnotebook");
				GtkWidget *scrolledwindow6 = lookup_widget (scorewindow, "scrolledwindow6");
				gtk_notebook_remove_page (GTK_NOTEBOOK(awardsnotebook),
					gtk_notebook_page_num (GTK_NOTEBOOK(awardsnotebook), scrolledwindow6));
				GtkWidget *countrytreeview = lookup_widget (scorewindow, "countrytreeview");
				GtkTreeModel *model = gtk_tree_view_get_model (GTK_TREE_VIEW (countrytreeview));
				gtk_tree_model_get_iter (model, &iter, gtk_tree_path_new_from_string (iter_num));
				iter_num[0]++;
				for (j = 0; j < MAX_BANDS + 1; j++)
					gtk_list_store_set (GTK_LIST_STORE (model), &iter, j, "", -1);
			}
			preferences.awardsloc = 0;
		}

		countrytreeview = lookup_widget (scorewindow, "countrytreeview");
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_2190 + 1), scoringbands[BAND_2190] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_160 + 1), scoringbands[BAND_160] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_80 + 1), scoringbands[BAND_80] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_60 + 1), scoringbands[BAND_60] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_40 + 1), scoringbands[BAND_40] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_30 + 1), scoringbands[BAND_30] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_20 + 1), scoringbands[BAND_20] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_17 + 1), scoringbands[BAND_17] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_15 + 1), scoringbands[BAND_15] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_12 + 1), scoringbands[BAND_12] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_10 + 1), scoringbands[BAND_10] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_6 + 1), scoringbands[BAND_6] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_4 + 1), scoringbands[BAND_4] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_2 + 1), scoringbands[BAND_2] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_125CM + 1), scoringbands[BAND_125CM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_70CM + 1), scoringbands[BAND_70CM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_33CM + 1), scoringbands[BAND_33CM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_23CM + 1), scoringbands[BAND_23CM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_13CM + 1), scoringbands[BAND_13CM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_9CM + 1), scoringbands[BAND_9CM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_6CM + 1), scoringbands[BAND_6CM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_3CM + 1), scoringbands[BAND_3CM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_12HMM + 1), scoringbands[BAND_12HMM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_6MM + 1), scoringbands[BAND_6MM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_4MM + 1), scoringbands[BAND_4MM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_2HMM + 1), scoringbands[BAND_2HMM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_2MM + 1), scoringbands[BAND_2MM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_1MM + 1), scoringbands[BAND_1MM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(countrytreeview), BAND_SUBMM + 1), scoringbands[BAND_SUBMM] - 48);

		dxcctreeview = lookup_widget (scorewindow, "dxcctreeview");
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_2190), scoringbands[BAND_2190] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_160), scoringbands[BAND_160] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_80), scoringbands[BAND_80] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_60), scoringbands[BAND_60] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_40), scoringbands[BAND_40] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_30), scoringbands[BAND_30] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_20), scoringbands[BAND_20] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_17), scoringbands[BAND_17] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_15), scoringbands[BAND_15] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_12), scoringbands[BAND_12] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_10), scoringbands[BAND_10] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_6), scoringbands[BAND_6] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_4), scoringbands[BAND_4] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_2), scoringbands[BAND_2] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_125CM), scoringbands[BAND_125CM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_70CM), scoringbands[BAND_70CM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_33CM), scoringbands[BAND_33CM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_23CM), scoringbands[BAND_23CM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_13CM), scoringbands[BAND_13CM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_9CM), scoringbands[BAND_9CM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_6CM), scoringbands[BAND_6CM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_3CM), scoringbands[BAND_3CM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_12HMM), scoringbands[BAND_12HMM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_6MM), scoringbands[BAND_6MM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_4MM), scoringbands[BAND_4MM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_2HMM), scoringbands[BAND_2HMM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_2MM), scoringbands[BAND_2MM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_1MM), scoringbands[BAND_1MM] - 48);
		gtk_tree_view_column_set_visible (gtk_tree_view_get_column
(GTK_TREE_VIEW(dxcctreeview), BAND_SUBMM), scoringbands[BAND_SUBMM] - 48);

		preferences.scoringbands = g_strdup (scoringbands);
		g_free (scoringbands);
	}
	gtk_widget_destroy (dialogsdialog);
}
