/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import writer2latex.office.OfficeReader;
import writer2latex.office.OfficeStyleFamily;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.CSVList;
import writer2latex.util.Config;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.StyleWithPropertiesConverterHelper;
import writer2latex.xhtml.XhtmlStyleMap;

public class TableStyleConverter
extends StyleWithPropertiesConverterHelper {
    public TableStyleConverter(OfficeReader ofr, Config config, Converter converter, int nType) {
        super(ofr, config, converter, nType);
        this.styleMap = new XhtmlStyleMap();
        this.bConvertStyles = config.xhtmlTableFormatting() == 4 || config.xhtmlTableFormatting() == 7;
        this.bConvertHard = config.xhtmlTableFormatting() == 4 || config.xhtmlTableFormatting() == 6;
    }

    public OfficeStyleFamily getStyles() {
        return this.ofr.getTableStyles();
    }

    public String getDefaultTagName(StyleWithProperties style) {
        return "table";
    }

    public void applyProperties(StyleWithProperties style, CSVList props, boolean bInherit) {
        this.getFrameSc().cssBackground(style, props, bInherit);
        this.cssTable(style, props, bInherit);
    }

    private void cssTable(StyleWithProperties style, CSVList props, boolean bInherit) {
        String sMarginRight;
        String sMarginTop = style.getAbsoluteProperty("fo:margin-top");
        if (sMarginTop != null) {
            props.addValue("margin-top", this.scale(sMarginTop));
        } else {
            props.addValue("margin-top", "0");
        }
        String sMarginBottom = style.getAbsoluteProperty("fo:margin-bottom");
        if (sMarginBottom != null) {
            props.addValue("margin-bottom", this.scale(sMarginBottom));
        } else {
            props.addValue("margin-bottom", "0");
        }
        String sAlign = style.getProperty("table:align");
        String sMarginLeft = style.getAbsoluteProperty("fo:margin-left");
        if (sMarginLeft != null) {
            sMarginLeft = this.scale(sMarginLeft);
        }
        if ((sMarginRight = style.getAbsoluteProperty("fo:margin-right")) != null) {
            sMarginRight = this.scale(sMarginRight);
        }
        if ("center".equals(sAlign)) {
            sMarginLeft = "auto";
            sMarginRight = "auto";
        } else if ("right".equals(sAlign)) {
            sMarginLeft = "auto";
        } else if ("left".equals(sAlign)) {
            sMarginRight = "auto";
        }
        if (sMarginLeft != null) {
            props.addValue("margin-left", sMarginLeft);
        }
        if (sMarginRight != null) {
            props.addValue("margin-right", sMarginRight);
        }
    }
}

