/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.latex.util.Context;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class ColorConverter
extends ConverterHelper {
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private boolean bUseColor;

    public ColorConverter(OfficeReader ofr, Config config, ConverterPalette palette) {
        super(ofr, config, palette);
        this.bUseColor = config.useColor() && config.formatting() > 0;
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bUseColor) {
            pack.append("\\usepackage{color}").nl();
        }
    }

    public void setNormalColor(String sColor, LaTeXDocumentPortion ldp) {
        if (this.bUseColor && sColor != null) {
            ldp.append("\\renewcommand\\normalcolor{\\color").append(ColorConverter.color(sColor)).append("}").nl();
        }
    }

    public void applyNormalColor(BeforeAfter ba) {
        if (this.bUseColor) {
            ba.add("\\normalcolor", "");
        }
    }

    public void applyColor(StyleWithProperties style, boolean bDecl, boolean bInherit, BeforeAfter ba, Context context) {
        if (this.bUseColor && style != null) {
            String sColor = style.getProperty("fo:color", bInherit);
            if (sColor != null) {
                if (!sColor.equals(context.getFontColor())) {
                    context.setFontColor(sColor);
                    this.applyColor(sColor, bDecl, ba, context);
                }
            } else {
                StyleWithProperties defaultStyle;
                String sAutomatic = style.getProperty("style:use-window-font-color", bInherit);
                if (sAutomatic == null && bInherit && (defaultStyle = this.ofr.getDefaultParStyle()) != null) {
                    sAutomatic = defaultStyle.getProperty("style:use-window-font-color", bInherit);
                }
                if ("true".equals(sAutomatic) && context.getBgColor() != null) {
                    this.applyAutomaticColor(ba, bDecl, context);
                }
            }
        }
    }

    public void applyColor(String sColor, boolean bDecl, BeforeAfter ba, Context context) {
        if (this.bUseColor && sColor != null) {
            String s;
            String string = s = context.getBgColor() != null ? ColorConverter.fullcolor(sColor) : ColorConverter.color(sColor);
            if (s != null) {
                if (bDecl) {
                    ba.add("\\color" + s, "");
                } else {
                    ba.add("\\textcolor" + s + "{", "}");
                }
            }
        }
    }

    public void applyBgColor(String sCommand, String sColor, BeforeAfter ba, Context context) {
        if (sColor != null && !"transparent".equals(sColor)) {
            String s = ColorConverter.fullcolor(sColor);
            if (this.bUseColor && s != null) {
                context.setBgColor(sColor);
                ba.add(sCommand + s, "");
            }
        }
    }

    public void applyAutomaticColor(BeforeAfter ba, boolean bDecl, Context context) {
        String s = ColorConverter.automaticcolor(context.getBgColor());
        if (s != null) {
            if (bDecl) {
                ba.add("\\color" + s, "");
            } else {
                ba.add("\\textcolor" + s + "{", "}");
            }
        }
    }

    private static final String automaticcolor(String sBgColor) {
        float[] rgb;
        if (sBgColor != null && sBgColor.length() == 7 && (double)((rgb = ColorConverter.getRgb(sBgColor))[0] + rgb[1] + rgb[2]) < 0.6) {
            return "{white}";
        }
        return "{black}";
    }

    private static final String color(String sColor) {
        if ("#000000".equalsIgnoreCase(sColor)) {
            return "{black}";
        }
        if ("#ff0000".equalsIgnoreCase(sColor)) {
            return "{red}";
        }
        if ("#00ff00".equalsIgnoreCase(sColor)) {
            return "{green}";
        }
        if ("#0000ff".equalsIgnoreCase(sColor)) {
            return "{blue}";
        }
        if ("#ffff00".equalsIgnoreCase(sColor)) {
            return "{yellow}";
        }
        if ("#ff00ff".equalsIgnoreCase(sColor)) {
            return "{magenta}";
        }
        if ("#00ffff".equalsIgnoreCase(sColor)) {
            return "{cyan}";
        }
        if (sColor == null || sColor.length() != 7) {
            return null;
        }
        float[] rgb = ColorConverter.getRgb(sColor);
        if ((double)(rgb[0] + rgb[1] + rgb[2]) > 2.7) {
            return "{black}";
        }
        return "[rgb]{" + rgb[0] + "," + rgb[1] + "," + rgb[2] + "}";
    }

    private static final String fullcolor(String sColor) {
        if ("#000000".equalsIgnoreCase(sColor)) {
            return "{black}";
        }
        if ("#ff0000".equalsIgnoreCase(sColor)) {
            return "{red}";
        }
        if ("#00ff00".equalsIgnoreCase(sColor)) {
            return "{green}";
        }
        if ("#0000ff".equalsIgnoreCase(sColor)) {
            return "{blue}";
        }
        if ("#ffff00".equalsIgnoreCase(sColor)) {
            return "{yellow}";
        }
        if ("#ff00ff".equalsIgnoreCase(sColor)) {
            return "{magenta}";
        }
        if ("#00ffff".equalsIgnoreCase(sColor)) {
            return "{cyan}";
        }
        if ("#ffffff".equalsIgnoreCase(sColor)) {
            return "{white}";
        }
        if (sColor == null || sColor.length() != 7) {
            return null;
        }
        float[] rgb = ColorConverter.getRgb(sColor);
        return "[rgb]{" + rgb[0] + "," + rgb[1] + "," + rgb[2] + "}";
    }

    private static final float[] getRgb(String sColor) {
        float[] rgb = new float[]{(float)Misc.getIntegerFromHex(sColor.substring(1, 3), 0) / 255.0f, (float)Misc.getIntegerFromHex(sColor.substring(3, 5), 0) / 255.0f, (float)Misc.getIntegerFromHex(sColor.substring(5, 7), 0) / 255.0f};
        return rgb;
    }

    static {
        RED = 0;
        GREEN = 1;
        BLUE = 2;
    }
}

