/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.api;

import writer2latex.api.Converter;
import writer2latex.api.GraphicConverter;
import writer2latex.latex.ConverterPalette;
import writer2latex.util.Config;
import writer2latex.util.ConverterBase;

public class ConverterFactory {
    private static final String VERSION = "0.5";
    private static final String DATE = "2007-10-15";
    private Config config = null;
    private GraphicConverter gc = null;

    public static String getVersion() {
        return VERSION;
    }

    public static String getDate() {
        return DATE;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setGraphicConverter(GraphicConverter gc) {
        this.gc = gc;
    }

    public Converter createConverter(String sMIME) {
        ConverterBase converter = null;
        if ("application/x-latex".equals(sMIME)) {
            converter = new ConverterPalette();
        } else if ("application/x-bibtex".equals(sMIME)) {
            converter = new writer2latex.bibtex.Converter();
        } else if ("text/html".equals(sMIME)) {
            converter = new writer2latex.xhtml.Converter(0);
        } else if ("application/xhtml+xml".equals(sMIME)) {
            converter = new writer2latex.xhtml.Converter(2);
        } else if ("application/xml".equals(sMIME)) {
            converter = new writer2latex.xhtml.Converter(3);
        } else {
            return null;
        }
        if (this.config != null) {
            converter.setConfig(this.config);
        }
        if (this.gc != null) {
            converter.setGraphicConverter(this.gc);
        }
        return converter;
    }

    static {
        VERSION = VERSION;
        DATE = DATE;
    }
}

