/* wconfig_termconf.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "wconfig_termconf.hh"
#include "wconfig.h"
#include "worker.h"

TermConfPanel::TermConfPanel( AWindow &basewin, WConfig &baseconfig ) : WConfigPanel( basewin, baseconfig )
{
}

TermConfPanel::~TermConfPanel()
{
}

int TermConfPanel::create()
{
  int res;
  
  res = Panel::create();

  AContainer *ac1 = setContainer( new AContainer( this, 1, 4 ), true );
  ac1->setBorderWidth( 5 );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );
  
  addMultiLineText( catalog.getLocale( 687 ),
                    *ac1,
                    0, 0,
                    NULL, NULL );
  
  ac1->add( new Text( _aguix,
                      0,
                      0,
                      catalog.getLocale( 134 ),
                      1 ), 0, 1, AContainer::CINCWNR );

  sg = (StringGadget*)ac1->add( new StringGadget( _aguix, 0, 0, 30, _baseconfig.getTerminalBin(), 0 ),
                                0, 2, AContainer::CINCW );
  sg->connect( this );

  AContainer *ac1_1 = ac1->add( new AContainer( this, 2, 1 ),
                                0, 3 );
  ac1_1->setBorderWidth( 0 );
  ac1_1->setMinSpace( 5 );
  ac1_1->setMaxSpace( 5 );
  validtext = (Text*)ac1_1->add( new Text( _aguix,
                                           0,
                                           0,
                                           catalog.getLocale( 720 ),
                                           1 ),
                                 0, 0, AContainer::CINCW );
  defaultbutton = (Button*)ac1_1->add( new Button( _aguix,
                                                   0,
                                                   0,
                                                   catalog.getLocale( 196 ),
                                                   1, 0, 0 ),
                                       1, 0, AContainer::CFIX );
  defaultbutton->connect( this );
  
  contMaximize( true );
  return 0;
}

int TermConfPanel::saveValues()
{
  _baseconfig.setTerminalBin( sg->getText() );
  return 0;
}

void TermConfPanel::run( Widget *elem, AGMessage &msg )
{
  if ( msg.type == AG_STRINGGADGET_CONTENTCHANGE ) {
    if ( msg.stringgadget.sg == sg ) {
      if ( WConfig::isCorrectTerminalBin( sg->getText() ) == false ) {
        validtext->setText( catalog.getLocale( 721 ) );
      } else {
        validtext->setText( catalog.getLocale( 720 ) );
      }
    }
  } else if ( msg.type == AG_BUTTONCLICKED ) {
    if ( msg.button.button == defaultbutton ) {
      sg->setText( TERMINAL_BIN );
      validtext->setText( catalog.getLocale( 720 ) );
    }
  }
}
