
/*  A Bison parser, made from wiplcexpr-yacc.yy
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	NUMFEXPR	257
#define	UINTCONST	258
#define	FLOATCONST	259
#define	SHL	260
#define	SHR	261
#define	ERROR	262

#line 1 "wiplcexpr-yacc.yy"


// Note about implementation:
//
//  * We number the colums in the following way:
//      The colum numbers [0..clientcolc[ are the client colums
//      The colum numbers [clientcolc..clientcolc+servercolc[ are 
//      the server colums.
//      

// Define this to print some debug info to stderr      
//#define PRINT_DEBUG_INFO

#include <stdio.h>
#include <cmath>
#include <stdlib.h> // Might be used by yacc

#include "common.h"
#include "wiplcexpr.h"

int yyparse();
void yy_scan_string(const char*);
void yyerror(char*);
int yylex();          // for Debian slink.

//-----------------------------------------------------------------------------
// Generel-purpose classes and definitions.

int max(int a,int b) { return a>b ? a : b; }

// This represents an array with a fixed size and with elments of type T.
// The array supports a "shift-all-elements-to-the-right" operation.
template<class T> class CycArray {
  T* array;
  int len;
  int startpos;

  public:
  // Creates the array with the given size:
  CycArray(int len) {
    array=new T[this->len=len];
    startpos=0;
  }
  
  // All elements are moved one position in the direction of the end of the 
  // array. The last element becomes the first element:
  void shift() {
    startpos--;
    if(startpos<0) startpos=len-1;
  }
  
  int size() {
    return len;
  }
  
  T& operator [] (int idx) {
    return array[(idx+startpos)%len];
  }
};

//-----------------------------------------------------------------------------
// The Dependency class
//
// This class represents what dependencies a given expression has on time 
// values and old colums:
class Dependency {   
  // All these are indexed by a colum number:
  
  int* Keep_col; // Keep_col[n] is the highest number of iterations back
                 // that this expression is depend on the values in colum n.
		 // If this expression is not at alle depend on colum n
		 // then Keep_col[n]==-1. If it is depend on the value
		 // from the same iteration it is 0, if depend on the value
		 // from the previous iteration it is 1 an so on.
  int* ColDep;   // 0 for colums we are depend on in the same iteration
                 // and -1 else. Is used to determine in which order the
		 // different expressions should be evaluated.
  int* Start_col;// Start_col[n] is 0 if this expression is depend on the
                 // the values of colum n as they were when the client
		 // started execurting. I.e.: As they were on the first
		 // iteration. If Start_col[n]!=0 it is -1
  int totalcolc; // Number of client and server colums and number of
                 // elements in the arrays above.
  int Keep_t;    // On how many iterations back we are depend on
                 // time values. Can be -1, 0 or >0.		 
  
  public:
  Dependency();
  ~Dependency() { delete[] Keep_col; delete[] ColDep; delete[] Start_col; }
  
  // Extend what we are depend on to what the argument is depend on:
  void addDependencies(Dependency&);
  
  // Add dependenci to colum x n iterations ago:
  void add_dep_col(int x,int n) { Keep_col[x]=max(Keep_col[x],n); 
                                  if(n==0) ColDep[x]=0; 
		   	        }

  // Add dependcy to the time values n iteration ago:				
  void add_dep_t(int n)         { Keep_t=max(Keep_t,n); }
  
  // Add dependency to the initial value of colum x:
  void add_dep_b(int x)         { Start_col[x]=0; }
  
  // Give information on the current dependecies. See description of
  // the returned variabels above:
  int* get_col_dep() { return ColDep; }
  int* keep_col()    { return Keep_col; }
  int* start_col()   { return Start_col; }
  int  keep_t()      { return Keep_t; }
  
  // Print debug information:
  #ifdef PRINT_DEBUG_INFO
    void print();
  #endif  
};

#ifdef PRINT_DEBUG_INFO
void Dependency::print() {
  fprintf(stderr,"    Time depened          : %i\n",Keep_t);

  fprintf(stderr,"    Colums same iteration :");
  for(int i=0; i<totalcolc; i++) if(ColDep[i]==0) fprintf(stderr," %i",i);
  fprintf(stderr,"\n");

  fprintf(stderr,"    Colums first iteration :");
  for(int i=0; i<totalcolc; i++) if(Start_col[i]==0) fprintf(stderr," %i",i);
  fprintf(stderr,"\n");

  fprintf(stderr,"    Colums other iteration:");
  for(int i=0; i<totalcolc; i++) {
    if(Keep_col[i]!=-1) fprintf(stderr," %i(back:%i)",i,Keep_col[i]);
  }
  fprintf(stderr,"\n");
}
#endif

Dependency::Dependency() {
  totalcolc=WiplcExpr::instance->totalcolc;
  Keep_col=new int[totalcolc];
  ColDep=new int[totalcolc];
  Start_col=new int[totalcolc];
  for(int i=0; i<totalcolc; i++) { 
    Keep_col[i]=-1;
    ColDep[i]=-1;
    Start_col[i]=-1;
  }
  Keep_t=-1;
}

void Dependency::addDependencies(Dependency& d) {
  int i,j;
  
  // Merge col information:
  for(j=0; j<totalcolc; j++) Keep_col[j]=max(Keep_col[j],d.Keep_col[j]);

  // Merge colDep information:
  for(j=0; j<totalcolc; j++) ColDep[j]=max(ColDep[j],d.ColDep[j]);

  // Merge Start_col information:
  for(j=0; j<totalcolc; j++) Start_col[j]=max(Start_col[j],d.Start_col[j]);
  
  // Merge t information:
  Keep_t=max(Keep_t,d.Keep_t);
}

//---------------------------------------------------------------------------
// The ValueServer class
//
// This class remembers all information about old colums etc.

typedef CycArray<double*> ColumArray; // A colum with values from several
                                      // iterations.
typedef CycArray<Time>    TimeArray;  // Times as they were on different
                                      // iterations.

class ValueServer {
  // The following are used to save information for alle the old and
  // new colums etc. We only save information which is needed.

  ColumArray** saved_cols;    // The colums we have. Is 0 for colums
                              // we don't save information about (i.e.
			      // unused server-colums).  
  TimeArray* saved_times;     // The times we have saved. 0 if we don't
                              // save time values.
  double**   saved_first;     // The contents of the conters on the first
                              // iteration. 0 for colums for which we have
			      // not saved this value.
  
  // This contain the adresses coresponding to the colums saved in saved_cols
  // and saved_first:
  mac_addr* macaddr;
  ip_addr*  ipaddr; 
  int       cardc; // And this the number of elements in all these tabels
  
  // Are we in the first iteration?
  int first_iteration;
  
  // Static information:
  card_id_type cit;
  int          clientcolc,servercolc,totalcolc;
  
  // These mainpulates saved_cols and saved_first:
  
  // Copy row i to row j
  void copy_row(int i,int j);
  
  // This is called when a new network card is discoverd. It initiliazes
  // the card to be on row i. If server_values is != 0 saved_first is
  // initialized with that values. Else saved_first is initialized to 0.
  //
  // (server_values should only be != 0 in the first iteration since cards not
  //  in the table should be implicitly assumed to be there but have
  //  all counters set to 0).
  void new_card(int i, const int64* server_values);
  
  // Update the given row with the given information from the server:
  void set_latest_row(int i, const int64* server_values, ip_addr, mac_addr);  
  
  public:
  // These are used when by expressions when they are asked to evaluate
  // themself. They correspond to user functions:  
  double* col(int x,int n) { return (*saved_cols[x])[n]; }
  Time    t(int n)         { return (*saved_times)[n];   }
  double* b(int x)         { return saved_first[x];      }
  
  // Initialize the server.
  //
  // The dependency information isused  to find out which colums etc this
  // class must save:
  ValueServer(Dependency&, int maxcards, int clientcolc, int servercolc, 
              card_id_type cit);
  
  // Every time we start a new period(=iteration) this should be called. It 
  // will update all the values represented by this class:
  void newPeriod(const ServerMem*, Time t);
  
  // This will return the position of the latest version of the colum given
  // as parameter. The user is supposed to evalute the colum expressions and
  // put them directly into this array:
  double* getColum(int i) {
    return col(i,0);
  }
  
  // Return infromation about mac/ip adresses:
  mac_addr* getMacColum() {
    return macaddr;
  }
  ip_addr* getIpColum() {
    return ipaddr;
  }
};

ValueServer::ValueServer(Dependency& d, int maxcardc, int clientcolc, int servercolc, card_id_type cit) {
  // Basic initialization:
  this->cit=cit;
  this->clientcolc=clientcolc;
  this->servercolc=servercolc;
  this->totalcolc=clientcolc+servercolc;
  cardc=0;
  ipaddr=new ip_addr[maxcardc];   
  macaddr=new mac_addr[maxcardc]; 
  first_iteration=1;

  // Allocate all colums and initialize all values in them to 0.
  saved_cols=new ColumArray*[totalcolc];  
  int* cols=d.keep_col();
  for(int i=0; i<totalcolc; i++) {
    if(cols[i]!=-1) { // This colum is used by someone
      saved_cols[i]=new ColumArray(cols[i]+1); 
      for(int j=0; j<=cols[i]; j++) {
        double* d=new double[maxcardc];	
        for(int k=0; k<maxcardc; k++) d[k]=0.0;
        (*saved_cols[i])[j]=d;
      }
    } else {
      saved_cols[i]=0;
    }
  }
  
  // Allocate room for the first colums:
  saved_first=new double*[totalcolc];
  for(int k=0; k<totalcolc; k++) 
    if(d.start_col()[k]!=-1)
      saved_first[k]=new double[maxcardc];
    else
      saved_first[k]=0;
  
  // And allocate the timearray and set default values:
  if(d.keep_t()!=-1) {
    saved_times=new TimeArray(d.keep_t()+1); // constructor sets default time to 0
  } else
    saved_times=0;
}

inline void ValueServer::copy_row(int i,int j) {
  for(int a=0; a<totalcolc; a++) {
    ColumArray* c=saved_cols[a];
    if(!c) continue;
    int d=c->size();
    for(int b=0; b<d; b++) {
      double* e=(*c)[b];      
      e[j]=e[i];
    }
    if(saved_first[a]) {
      saved_first[a][j]=saved_first[a][i];
    }
  }
  ipaddr[j]=ipaddr[i];
  macaddr[j]=macaddr[i];
}

inline void ValueServer::new_card(int i, const int64* counters) {
  for(int a=0; a<totalcolc; a++) {
    ColumArray* c=saved_cols[a];
    if(c) {
      int d=c->size();
      for(int b=0; b<d; b++) {
        double* e=(*c)[b];      
        e[i]=0.0;
      }
    }
    if(saved_first[a]) {
      if(a>=clientcolc && counters!=0)
        saved_first[a][i]=counters[a-clientcolc];
      else
        saved_first[a][i]=0;
    }
  }
}

inline void ValueServer::set_latest_row(int r, const int64* rows, 
                                        ip_addr ip, mac_addr mac) {
  for(int i=clientcolc; i<totalcolc; i++) {
     ColumArray* c=saved_cols[i];
     if(c) {
       (*c)[0][r]=rows[i-clientcolc];
     }
  }
  ipaddr[r]=ip;
  macaddr[r]=mac;
}

void ValueServer::newPeriod(const ServerMem* sm, Time time) {
  // Move everything one step:
  if(saved_times) {
    saved_times->shift();
    (*saved_times)[0]=time; // And update time
  }
  for(int i=0; i<totalcolc; i++) {
    if(saved_cols[i]) saved_cols[i]->shift();
  }
    
  // And copy in the new values. This is a bit complicated since cards might
  // have been inserted or deleted in the server. And in this situation we 
  // must do the same insertion / deltion in all tabels.

  // First we copy the new value of the counters and delete the cards that
  // are no longer in the server:
  int t=0;    // Index in our table we copy from
  int tnew=0; // Index in our table we copy to
  int d=0;    // Index in the daemon area.
  
  while(t<cardc || d<sm->curcardc) {
    // Set dif to the same sign as:
    //   <card id for table> minus <card id for daemon area>
    int dif;
    if(t==cardc)
      dif=1;
    else if(d==sm->curcardc) 
      dif=-1;
    else {
      if(cit==idIP) {
        dif=ip_addr::compare(ipaddr[t],sm->cards[d].ipaddr);
      } else {
        dif=mac_addr::compare(macaddr[t],sm->cards[d].macaddr);
      }
    }
    
    if(dif==0) {
      if(tnew!=t) {
        // Copy card to new location:
        copy_row(t,tnew);      
      }
      
      // We are at the same card - copy information to the row:
      set_latest_row(tnew,sm->cards[d].Counters,sm->cards[d].ipaddr,
                                                sm->cards[d].macaddr);
      
      tnew++; 
      d++; 
      t++;
    } else if(dif<0) {
      // A card in the table should be deleted
      t++;       
    } else if(dif>0) {
      // A card in the daemon should be inserted
      d++;
    }
  }
  
  cardc=tnew;
  
  // Now insert the new cards if any. Note that at this point all cards in 
  // the client area are also in the server area.

  t=cardc-1;        // Copy from this place in client
  d=sm->curcardc-1; // Copy to this place in client / 
                    //   from this place in server
    
  for(;(t!=d);d--) { // Walk through the server table        
    assert(d>t);
    
    // Set dif as above:
    int dif;
    if(t<0) {
      dif=-1;
    } else if(cit==idIP) {
      dif=ip_addr::compare(ipaddr[t],sm->cards[d].ipaddr);
    } else {
      dif=mac_addr::compare(macaddr[t],sm->cards[d].macaddr);
    }
    
    if(dif==0) {
      // We are at the samme card - so just move if neccesarry
      copy_row(t,d);	
      t--;
    } else {
      // We need to insert a card from the server in the client
      assert(dif<0);
      new_card(d,first_iteration ? sm->cards[d].Counters : 0);
      set_latest_row(d,sm->cards[d].Counters,sm->cards[d].ipaddr,
                                             sm->cards[d].macaddr);
    }
  }
  
  cardc=sm->curcardc;
  first_iteration=0;
}

//---------------------------------------------------------------------------
// Expressions.
//
// Note: 
//   Everything calculated in the program is calculated in the same
//   way in every colum. For efficiency reasons we calculate values for 
//   a whole colum at a time (and hope the cache-miss penalty is not
//   too big...).

// This represents an expression on an _array_ of floating point values
// (i.e. for a whole colum):
class FloatExpr {  
  public:  
  // Every expression should set this in it's construtor. In this
  // way dependency information for expressions can be calculated
  // button-up.
  Dependency dep;
  
  // This should evaluate the expression for the first numcards elements
  // of the array:
  virtual double* eval(int numcards)=0;
};  

// An expression with a constant element on all fields:
class ConstExpr:public FloatExpr {
  double* val;

  // This will evaluate the expression for the given number of elements
  // in the array:
  virtual double* eval(int numcards) {
    return val;
  }
  
  public:
  ConstExpr(double value) {
    int i=WiplcExpr::instance->maxcardc;
    val=new double[i];
    for(int a=0; a<i; a++) val[a]=value;
  }
};

// A generic binary operator with two floating point operands
class BinopExpr:public FloatExpr {
  protected:
  double* result;
  FloatExpr &left,&right;

  public:
   
  BinopExpr(FloatExpr& Left, FloatExpr& Right) : left(Left), right(Right) {
    dep.addDependencies(Left.dep);
    dep.addDependencies(Right.dep);
    result=new double[WiplcExpr::instance->maxcardc];
  }
};

class AddExpr:public BinopExpr {
  virtual double* eval(int numcards) {
    double* Left=left.eval(numcards);
    double* Right=right.eval(numcards);
    for(int i=0; i<numcards; i++) {
      result[i]=Left[i]+Right[i];
    }  
    return result;
  }
  public:
  AddExpr(FloatExpr& Left,FloatExpr& Right) : BinopExpr(Left,Right) {}
};

class SubExpr:public BinopExpr {
  virtual double* eval(int numcards) {
    double* Left=left.eval(numcards);
    double* Right=right.eval(numcards);
    for(int i=0; i<numcards; i++) {
      result[i]=Left[i]-Right[i];
    }  
    return result;
  }
  public:
  SubExpr(FloatExpr& Left,FloatExpr& Right) : BinopExpr(Left,Right) {}
};
  
class MulExpr:public BinopExpr {
  virtual double* eval(int numcards) {
    double* Left=left.eval(numcards);
    double* Right=right.eval(numcards);
    for(int i=0; i<numcards; i++) {
      result[i]=Left[i]*Right[i];
    }  
    return result;
  }
  public:
  MulExpr(FloatExpr& Left,FloatExpr& Right) : BinopExpr(Left,Right) {}
};

class DivExpr:public BinopExpr {
  virtual double* eval(int numcards) {
    double* Left=left.eval(numcards);
    double* Right=right.eval(numcards);
    for(int i=0; i<numcards; i++) {      
      result[i]=Left[i]/Right[i];
    }  
    return result;
  }
  public:
  DivExpr(FloatExpr& Left,FloatExpr& Right) : BinopExpr(Left,Right) {}
};

// A generic binary operator with a floating point and an integer oprand.
class ShExpr:public FloatExpr {
  protected:
  double* result;
  FloatExpr &left;
  int right;

  public:
   
  ShExpr(FloatExpr& Left, int Right) : left(Left), right(Right) {
    dep.addDependencies(Left.dep);
    result=new double[WiplcExpr::instance->maxcardc];
  }
};

class ShlExpr:public ShExpr {
  virtual double* eval(int numcards) {
    double* Left=left.eval(numcards);
    for(int i=0; i<numcards; i++) {
      result[i]=ldexp(Left[i],-right);
    }  
    return result;
  }
  public:
  ShlExpr(FloatExpr& Left,int Right) : ShExpr(Left,Right) {}
};

class ShrExpr:public ShExpr {
  virtual double* eval(int numcards) {
    double* Left=left.eval(numcards);
    for(int i=0; i<numcards; i++) {
      result[i]=ldexp(Left[i],right);
    }  
    return result;
  }
  public:
  ShrExpr(FloatExpr& Left,int Right) : ShExpr(Left,Right) {}
};

// Expressions representing the different functions the user can use:
class tExpr:public FloatExpr {
  int n;
  double* val;

  virtual double* eval(int numcards) {
    double v=WiplcExpr::instance->vs->t(n).asDouble();
    for(int a=0; a<numcards; a++) val[a]=v;
    return val;
  }
  
  public:
    
  tExpr(int N) {
    n=N;
    dep.add_dep_t(n);
    val=new double[WiplcExpr::instance->maxcardc];
  }  
};

class colExpr:public FloatExpr {
  int x,n;

  virtual double* eval(int numcards) {
    return WiplcExpr::instance->vs->col(x,n);
  }
  
  public:
    
  colExpr(int X,int N) {
    x=X; n=N;
    dep.add_dep_col(x,n);
  }  
};

class bExpr:public FloatExpr {
  int x;

  virtual double* eval(int numcards) {
    return WiplcExpr::instance->vs->b(x);
  }
  
  public:
    
  bExpr(int X) {
    x=X;
    dep.add_dep_b(x);
  }  
};

//---------------------------------------------------------------------------
// Grammar and semantic actions.

// Result of parsing is put here:
FloatExpr* result;


#line 646 "wiplcexpr-yacc.yy"
typedef union {
  FloatExpr* nfexpr;
  unsigned   nuintconst;
  float      nfloatconst;
} YYSTYPE;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		42
#define	YYFLAG		-32768
#define	YYNTBASE	20

#define YYTRANSLATE(x) ((unsigned)(x) <= 262 ? yytranslate[x] : 23)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,    13,
    14,    11,     9,    16,    10,     2,    12,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    18,    15,    17,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,    19,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,     6,    10,    14,    18,    22,    26,    30,    32,
    39,    46,    51,    56,    58
};

static const short yyrhs[] = {    21,
     0,    13,    21,    14,     0,    21,     9,    21,     0,    21,
    10,    21,     0,    21,    11,    21,     0,    21,    12,    21,
     0,    21,     6,    22,     0,    21,     7,    22,     0,    22,
     0,    15,    13,    22,    16,    22,    14,     0,    17,    13,
    22,    16,    22,    14,     0,    18,    13,    22,    14,     0,
    19,    13,    22,    14,     0,     5,     0,     4,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   669,   670,   671,   672,   673,   674,   675,   676,   677,   679,
   684,   690,   696,   697,   699
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","NUMFEXPR",
"UINTCONST","FLOATCONST","SHL","SHR","ERROR","'+'","'-'","'*'","'/'","'('","')'",
"'c'","','","'d'","'b'","'t'","start","fexpr","uintconst", NULL
};
#endif

static const short yyr1[] = {     0,
    20,    21,    21,    21,    21,    21,    21,    21,    21,    21,
    21,    21,    21,    21,    22
};

static const short yyr2[] = {     0,
     1,     3,     3,     3,     3,     3,     3,     3,     1,     6,
     6,     4,     4,     1,     1
};

static const short yydefact[] = {     0,
    15,    14,     0,     0,     0,     0,     0,     1,     9,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     2,     0,     0,     0,     0,     7,     8,     3,     4,     5,
     6,     0,     0,    12,    13,     0,     0,    10,    11,     0,
     0,     0
};

static const short yydefgoto[] = {    40,
     8,     9
};

static const short yypact[] = {    14,
-32768,-32768,    14,    -7,     7,    15,    17,    28,-32768,     1,
    10,    10,    10,    10,    10,    10,    14,    14,    14,    14,
-32768,    20,    25,    29,    30,-32768,-32768,     5,     5,-32768,
-32768,    10,    10,-32768,-32768,    31,    32,-32768,-32768,    42,
    47,-32768
};

static const short yypgoto[] = {-32768,
     6,   -11
};


#define	YYLAST		47


static const short yytable[] = {    22,
    23,    24,    25,    26,    27,    11,    15,    16,    10,    17,
    18,    19,    20,     1,    21,    19,    20,     1,     2,    12,
    36,    37,    28,    29,    30,    31,     3,    13,     4,    14,
     5,     6,     7,    15,    16,    32,    17,    18,    19,    20,
    33,    41,    34,    35,    38,    39,    42
};

static const short yycheck[] = {    11,
    12,    13,    14,    15,    16,    13,     6,     7,     3,     9,
    10,    11,    12,     4,    14,    11,    12,     4,     5,    13,
    32,    33,    17,    18,    19,    20,    13,    13,    15,    13,
    17,    18,    19,     6,     7,    16,     9,    10,    11,    12,
    16,     0,    14,    14,    14,    14,     0
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/misc/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/share/misc/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 669 "wiplcexpr-yacc.yy"
{ result=yyval.nfexpr;               ;
    break;}
case 2:
#line 670 "wiplcexpr-yacc.yy"
{ yyval.nfexpr=yyvsp[-1].nfexpr;                   ;
    break;}
case 3:
#line 671 "wiplcexpr-yacc.yy"
{ yyval.nfexpr=new AddExpr(*yyvsp[-2].nfexpr,*yyvsp[0].nfexpr); ;
    break;}
case 4:
#line 672 "wiplcexpr-yacc.yy"
{ yyval.nfexpr=new SubExpr(*yyvsp[-2].nfexpr,*yyvsp[0].nfexpr); ;
    break;}
case 5:
#line 673 "wiplcexpr-yacc.yy"
{ yyval.nfexpr=new MulExpr(*yyvsp[-2].nfexpr,*yyvsp[0].nfexpr); ;
    break;}
case 6:
#line 674 "wiplcexpr-yacc.yy"
{ yyval.nfexpr=new DivExpr(*yyvsp[-2].nfexpr,*yyvsp[0].nfexpr); ;
    break;}
case 7:
#line 675 "wiplcexpr-yacc.yy"
{ yyval.nfexpr=new ShrExpr(*yyvsp[-2].nfexpr,yyvsp[0].nuintconst);  ;
    break;}
case 8:
#line 676 "wiplcexpr-yacc.yy"
{ yyval.nfexpr=new ShlExpr(*yyvsp[-2].nfexpr,yyvsp[0].nuintconst);  ;
    break;}
case 9:
#line 677 "wiplcexpr-yacc.yy"
{ yyval.nfexpr=new ConstExpr(yyvsp[0].nuintconst);    ;
    break;}
case 10:
#line 679 "wiplcexpr-yacc.yy"
{ 
	         if(yyvsp[-3].nuintconst>=WiplcExpr::instance->clientcolc) {
	           yyerror("Invalid client colum number"); YYERROR;
		 }	   
	         yyval.nfexpr=new colExpr(yyvsp[-3].nuintconst,yyvsp[-1].nuintconst);   ;
    break;}
case 11:
#line 684 "wiplcexpr-yacc.yy"
{ 
	         if(yyvsp[-3].nuintconst>=WiplcExpr::instance->servercolc) {
	           yyerror("Invalid server counter number"); YYERROR;
		 }	   
	         yyval.nfexpr=new colExpr(yyvsp[-3].nuintconst+WiplcExpr::instance->clientcolc,yyvsp[-1].nuintconst); ;
    break;}
case 12:
#line 690 "wiplcexpr-yacc.yy"
{
	         if(yyvsp[-1].nuintconst>=WiplcExpr::instance->servercolc) {
	           yyerror("Invalid server counter number"); YYERROR;
		 }	   
	         yyval.nfexpr=new bExpr(yyvsp[-1].nuintconst+WiplcExpr::instance->clientcolc); ;
    break;}
case 13:
#line 696 "wiplcexpr-yacc.yy"
{ yyval.nfexpr=new tExpr(yyvsp[-1].nuintconst);       ;
    break;}
case 14:
#line 697 "wiplcexpr-yacc.yy"
{ yyval.nfexpr=new ConstExpr(yyvsp[0].nfloatconst);   ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/share/misc/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 701 "wiplcexpr-yacc.yy"


//-----------------------------------------------------------------------------
// The WiplcExpr class:

#include <assert.h>

// Compiletime error handling:
int anyerror;
int col;
void yyerror(char *s) {
  if(!anyerror) {
    snprintf(errmsg,sizeof(errmsg),"In expression for colum %i: %s",col,s);
    anyerror=1;
  }
}

WiplcExpr* WiplcExpr::instance=0;

WiplcExpr::WiplcExpr(int clientcolc, int servercolc, 
                     int maxcardc, card_id_type cit, int timebackdep) {
  assert(instance==0); // Only one instance is allowed because of global
                       // variabels.
  instance=this;		      
  this->clientcolc=clientcolc;
  this->servercolc=servercolc;
  this->totalcolc=clientcolc+servercolc;
  this->maxcardc=maxcardc;
  this->cit=cit;
  this->timebackdep=timebackdep;
  vs=0;
  colums=new FloatExpr*[clientcolc];
  colnums=new int[clientcolc];
  for(int i=0; i<clientcolc; i++) colums[i]=0;
}

WiplcExpr::~WiplcExpr() {
  instance=0;
}

char* WiplcExpr::setExpression(int colum, char* program) {
  col=colum;
  anyerror=0;
  
  // Parse program
  yy_scan_string(program);
  if(yyparse()) {
    if(!anyerror) yyerror("Parse error"); // make a default error message
    return errmsg;
  }
  
  // And set it:
  colums[colum]=result;
  
  return 0;
}

char* WiplcExpr::noMoreExpressions() {
  // Find common dependencies for all colums:
  Dependency dep;
  
  for(int i=0; i<clientcolc; i++) {
    if(colums[i]!=0) {
      // What this colum is depend on:
      dep.addDependencies(colums[i]->dep);
     
      // We are outself depend on the latest version of this colum because
      // we must be able to give it to the user of this class via the
      // getColum method:
      dep.add_dep_col(i,0);
    }
  }
  
  // Add dependency for the getTimeBack method:
  dep.add_dep_t(timebackdep);
  
  // Create the valueserver:
  vs=new ValueServer(dep,maxcardc,clientcolc,servercolc,cit);

  // Now reorder the colums variable to have the colums in an order
  // in which they can be evaluated. I.e.: Make a topological sort of the
  // dependenci graf:
  
  FloatExpr** result=new FloatExpr*[clientcolc+1];
  int resultc=0;
  
  for(;;) {
    // Try to find a colum we can evaluate:
    int i,j;
    for(i=0;i<clientcolc; i++) {
      // Check if we can evaluate colum i
      if(!colums[i]) continue;
      int* dep=colums[i]->dep.get_col_dep();
      for(j=0; j<clientcolc; j++) {
        if(!colums[j]) continue;
        if(dep[j]==0 && colums[j]!=0) 
          // Colum i is depend on coulm j which is not evalutated yet
  	  break;
      }
      if(j==clientcolc) break; // break if we can evaluate colum i
    }
    
    if(i==clientcolc) {
      // We could not find any colum to evaluate. See if there
      // is any colums left:
      for(int a=0; a<clientcolc; a++)
        if(colums[a]) { // There is      
          delete[] colums;
          return "Cyclic dependencies in colum expressions";
	}
	
      // All colums could be evaluated - save new value of colums:
      result[resultc++]=0;
      delete[] colums;
      colums=result;
      
      #ifdef PRINT_DEBUG_INFO      
        fprintf(stderr,"Colum order: ");
	for(int i=0; result[i]; i++) fprintf(stderr,"%i ",colnums[i]);
	fprintf(stderr,"\n");
	
	fprintf(stderr,"Colum dependencies:\n");
	for(int i=0; i<clientcolc; i++) {
	  if(colums[i]) {
    	    Dependency& dep=colums[i]->dep;
            fprintf(stderr,"  Colum %i:\n",colnums[i]);
	    dep.print();
	  }
	}
	fprintf(stderr,"  Total:\n");
	dep.print();
     #endif
      
      return 0;
    }
    
    // We can evalute colum i:
    colnums[resultc]=i;
    result[resultc++]=colums[i];
    
    // Remove it from list of unevaluated colums:
    colums[i]=0;
  }
}

void WiplcExpr::nextIteration(const ServerMem* sm, Time t) {
  // Shift old colums and copy in new values of the server:
  vs->newPeriod(sm,t);
  cardcntc=sm->curcardc;
};

void WiplcExpr::updateValues() {  
  // Calculate all expressions and give them to the value server:
  for(int i=0; colums[i]; i++) {
    memcpy(vs->getColum(colnums[i]),
           colums[i]->eval(cardcntc),
	   cardcntc*sizeof(double));
  }
}

const double* WiplcExpr::getColum(int n) {
  return vs->getColum(n);
}    

const mac_addr* WiplcExpr::getMacColum() {
  return vs->getMacColum();
}

const ip_addr* WiplcExpr::getIpColum() {
  return vs->getIpColum();
}

Time WiplcExpr::getTimeBack(int n) {
  return vs->t(n);
}
