
/*  A Bison parser, made from parseprg-yacc.yy
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	INT64VAR	257
#define	BOOLVAR	258
#define	MACVAR	259
#define	IPVAR	260
#define	INT64EXPR	261
#define	BOOLEXPR	262
#define	MACEXPR	263
#define	IPEXPR	264
#define	NOTYPEVAR	265
#define	STRING	266
#define	IF	267
#define	ELSE	268
#define	WHILE	269
#define	PRINT	270
#define	PRINTS	271
#define	AND	272
#define	OR	273
#define	LEQ	274
#define	GEQ	275
#define	EQ	276
#define	NEQ	277
#define	LE	278
#define	GE	279
#define	SHL	280
#define	SHR	281
#define	ADDEQ	282
#define	SUBEQ	283
#define	DIVEQ	284
#define	MULEQ	285
#define	SHREQ	286
#define	SHLEQ	287
#define	TBLCARDCNT	288
#define	TBLCNTCNT	289
#define	TBLGETIDX	290
#define	TBLGETIPADR	291
#define	TBLGETMACADR	292
#define	TBLIDXDEL	293
#define	DECLMACA	294
#define	DECLIPA	295
#define	DECLINT64	296
#define	DECLBOOL	297
#define	ERROR	298

#line 1 "parseprg-yacc.yy"


#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "common.h"
#include "parseprg.h"
#include "parseprg-internal.h"

int yyparse();
void yy_scan_string(const char*);
void yyerror(char*);
int yylex();          // for Debian slink.
extern int yylineno;

node_stmt* program; // The result of parsing

// This is set on runtime errors:
char* runerror;

// Maximal number of iterations allowed in loops in a single execution
// of a program. We set a limit to prevent infintely executing code which 
// blocks everything:
const int max_iterations=10000;

// Number of iterations in this execution
int iterations;

//-----------------------------------------------------------------------------
// The symbol table

Symtable symtabel;  

Symtable::SymEntry* Symtable::getSymbol(char* name) {
  for(int a=0; a<symc; a++)
    if(!strcmp(name,symbols[a].name) && symbols[a].valid) // Symbol found 
      return &symbols[a];
  return 0;
}

Symtable::SymEntry* Symtable::createSymbol(char* name) {
  assert(!getSymbol(name));

  // Create the symbol:    
  if(symc==maxsymbols) { yyerror("Too many variabels"); return 0; }  
  if(strlen(name)>maxsymlen) { yyerror("Variabel name too long"); return 0; }
  strcpy(symbols[symc].name,name);
  symbols[symc].valid=0;
  return &symbols[symc++];
}
  
void Symtable::setType(SymEntry* s, ParseProgram::types type) {
  s->valid=1;
  s->type=type;
  
  switch(type) {
    case ParseProgram::tINT64: s->value.int64_value=new DynVarInt64(0); break;
    case ParseProgram::tBOOL:  s->value.bool_value=new DynVarBool(0); break;
    case ParseProgram::tMAC:   { mac_addr a; a.setZero(); s->value.mac_value=new DynVarMac(a); break; }
    case ParseProgram::tIP:    { ip_addr a; a.setZero(); s->value.ip_value=new DynVarIp(a); break; }
    default: assert(0);
  }
}
	
//-----------------------------------------------------------------------------
// Statement nodes:

class JoinStmt:public node_stmt {
  node_stmt &a, &b;
  virtual void eval() { a.eval(); b.eval(); }
  public:
  JoinStmt(node_stmt& A, node_stmt& B) : a(A), b(B) {}
};

class If:public node_stmt {
  node_boolexpr &boole;
  node_stmt& stmts;  
  virtual void eval() { if(boole.eval()) stmts.eval(); }
  public:
  If(node_boolexpr& A, node_stmt& B) : boole(A), stmts(B) {}
};

class While:public node_stmt {
  node_boolexpr &boole;
  node_stmt& stmts;  
  virtual void eval() { 
    while(boole.eval()) {
      if(iterations>=max_iterations) {
        // If we have executed too many times:
	if(!runerror) runerror="Program made too many loops. If this is not an error adjust constant in parseprg.y";
        return; // The program will not exit emditiatly but now more iteratins
	        // are performed... 
      }
      iterations++;    
      stmts.eval();      
    }
  }
  public:
  While(node_boolexpr& A, node_stmt& B) : boole(A), stmts(B) {}
};

class IfElse:public node_stmt {
  node_boolexpr &boole;
  node_stmt &stmt1, &stmt2;  
  virtual void eval() { 
    if(boole.eval()) { 
      stmt1.eval(); 
    } else { 
      stmt2.eval(); 
    } 
  }
  public:
  // B and C can be 0
  IfElse(node_boolexpr& A, node_stmt& B, node_stmt& C) : boole(A), stmt1(B), stmt2(C) {}
};

//------------------------------------------------------------------------------
// Logical operations

template<class NodeT>class LogAnd:public node_boolexpr {
  NodeT &a,&b;
  virtual Bool eval() {
    return a.eval() && b.eval();
  }
  
  public:  
  LogAnd(NodeT& A, NodeT& B) : a(A), b(B) {}  
};
typedef LogAnd<node_boolexpr> LogAndBool;

template<class NodeT> class LogOr:public node_boolexpr {
  NodeT &a,&b;
  
  virtual Bool eval() {
    return a.eval() || b.eval();
  }
  
  public:
  LogOr(NodeT& A, NodeT& B) : a(A), b(B) {}  
};
typedef LogOr<node_boolexpr> LogOrBool;

template<class NodeT> class LogNot:public node_boolexpr {
  NodeT &a;
  
  virtual Bool eval() {
    return a.eval()==0;
  }
  
  public:
  LogNot(NodeT& A) : a(A) {}
};
typedef LogNot<node_boolexpr> LogNotBool;

template<class NodeT> class Less:public node_boolexpr {
  NodeT &a,&b;
  
  virtual Bool eval() {
    return a.eval()<b.eval();
  }
  
  public:
  Less(NodeT& A, NodeT& B) : a(A), b(B) {}  
};
typedef Less<node_int64expr> LessInt;
typedef Less<node_int64expr> LessInt64;

template<class NodeT> class LessEq:public node_boolexpr {
  NodeT &a,&b;
  
  virtual Bool eval() {
    return a.eval()<=b.eval();
  }
  
  public:
  LessEq(NodeT& A, NodeT& B) : a(A), b(B) {}  
};
typedef LessEq<node_int64expr> LessEqInt;
typedef LessEq<node_int64expr> LessEqInt64;

template<class NodeT, class T> class Eq:public node_boolexpr {
  NodeT &a,&b;
  
  virtual Bool eval() {
    return a.eval()==b.eval();
  }
  
  public:
  Eq(NodeT& A, NodeT& B) : a(A), b(B) {}  
};
typedef Eq<node_int64expr,int64> EqInt;
typedef Eq<node_boolexpr,Bool> EqBool;
typedef Eq<node_macexpr,mac_addr> EqMac;
typedef Eq<node_ipexpr,ip_addr> EqIp;

template<class NodeT, class T> class Neq:public node_boolexpr {
  NodeT &a,&b;
  
  virtual Bool eval() {
    return a.eval()!=b.eval();
  }
  
  public:
  Neq(NodeT& A, NodeT& B) : a(A), b(B) {}  
};
typedef Neq<node_int64expr,int64> NeqInt;
typedef Neq<node_boolexpr,Bool> NeqBool;
typedef Neq<node_macexpr,mac_addr> NeqMac;
typedef Neq<node_ipexpr,ip_addr> NeqIp;

//------------------------------------------------------------------------------
// Arithmetic operations.

template<class NodeT, class T> class Add:public NodeT {
  NodeT &a,&b;
  virtual T eval() {
    return a.eval() + b.eval();
  }
  
  public:  
  Add(NodeT& A, NodeT& B) : a(A), b(B) {}  
};
typedef Add<node_int64expr,int64> AddInt64;

template<class NodeT, class T> class Sub:public NodeT {
  NodeT &a,&b;
  virtual T eval() {
    return a.eval() - b.eval();
  }
  
  public:  
  Sub(NodeT& A, NodeT& B) : a(A), b(B) {}  
};
typedef Sub<node_int64expr,int64> SubInt64;

template<class NodeT, class T> class Mul:public NodeT {
  NodeT &a,&b;
  virtual T eval() {
    return a.eval() * b.eval();
  }
  
  public:  
  Mul(NodeT& A, NodeT& B) : a(A), b(B) {}  
};
typedef Mul<node_int64expr,int64> MulInt64;

template<class NodeT, class T> class Div:public NodeT {
  NodeT &a,&b;
  virtual T eval() {
    T d=b.eval();
    if(d==(T)0) { if(!runerror) runerror="Division by zero"; return 0; }
    return a.eval() / d;
  }
  
  public:  
  Div(NodeT& A, NodeT& B) : a(A), b(B) {}  
};
typedef Div<node_int64expr,int64> DivInt64;

template<class NodeT, class T> class Shl:public NodeT {
  NodeT &a;
  node_int64expr &b;
  virtual T eval() {
    return a.eval() << b.eval();
  }
  
  public:  
  Shl(NodeT& A, node_int64expr& B) : a(A), b(B) {}  
};
typedef Shl<node_int64expr,int64> ShlInt64;

template<class NodeT, class T> class Shr:public NodeT {
  NodeT &a;
  node_int64expr &b;
  virtual T eval() {
    return a.eval() >> b.eval();
  }
  
  public:  
  Shr(NodeT& A, node_int64expr& B) : a(A), b(B) {}  
};
typedef Shr<node_int64expr,int64> ShrInt64;

//------------------------------------------------------------------------------
// Other nodes

template<class ExprT, class VarT, class T> class VarToExpr:public ExprT {
  VarT& a;
  virtual T eval() { return *(a.eval()); }
  public:
  VarToExpr(VarT& A): a(A) {}
};
typedef VarToExpr<node_int64expr,node_int64var,int64> VarToExprInt64;
typedef VarToExpr<node_boolexpr,node_boolvar,Bool> VarToExprBool;
typedef VarToExpr<node_macexpr,node_macvar,mac_addr> VarToExprMac;
typedef VarToExpr<node_ipexpr,node_ipvar,ip_addr> VarToExprIp;

template<class NodeT> class ExprToStmt:public node_stmt {
  NodeT& a;
  virtual void eval() { a.eval(); }
  public:
  ExprToStmt(NodeT& A) : a(A) {}
};
typedef ExprToStmt<node_int64expr> ExprToStmtInt64;
typedef ExprToStmt<node_boolexpr> ExprToStmtBool;
typedef ExprToStmt<node_macexpr> ExprToStmtMac;
typedef ExprToStmt<node_ipexpr> ExprToStmtIp;

template<class ExprT, class VarT, class T> class Assign:public ExprT {
  VarT& location;
  ExprT& value;
  
  virtual T eval() { return *location.eval()=value.eval(); }
  
  public:
  Assign(VarT& A, ExprT& B) : location(A), value(B)  {}
};
typedef Assign<node_int64expr,node_int64var,int64> AssignInt64;
typedef Assign<node_boolexpr,node_boolvar,Bool> AssignBool;
typedef Assign<node_macexpr,node_macvar,mac_addr> AssignMac;
typedef Assign<node_ipexpr,node_ipvar,ip_addr> AssignIp;

//------------------------------------------------------------------------------
// Other simple converting:

class BoolToInt64:public node_int64expr {
  node_boolexpr& i;  
  
  virtual int64 eval() { return i.eval()!=0; }

  public:
  BoolToInt64(node_boolexpr& f) : i(f) {}
};

class IpMask: public node_ipexpr {
  node_ipexpr& ip;
  node_int64expr& num;

  virtual ip_addr eval() {
    unsigned int in;
    ip_addr ret;

    in = ntohl(ip.eval().ia.s_addr);
    ret.ia.s_addr = htonl(((unsigned long)(~0)) << (32-(int) num.eval()) & in);
    return ret;
  }

public:
  IpMask(node_ipexpr& cip, node_int64expr& cnum) : ip(cip), num(cnum) { }
};

class Int64ToBool:public node_boolexpr {
  node_int64expr& i;  
  
  virtual Bool eval() { return i.eval()!=(int64)0; }

  public:
  Int64ToBool(node_int64expr& f) : i(f) {}
};

class MacToId:public node_idexpr {  
  node_macexpr& m;
  
  virtual card_id eval() {
    card_id ci; 
    memset(&ci,0,sizeof(ci));
    ci.macaddr=m.eval();
    return ci;
  }
  
  public:
  MacToId(node_macexpr& mm) : m(mm) {}
};

class IpToId:public node_idexpr {  
  node_ipexpr& m;
  
  virtual card_id eval() {
    card_id ci; 
    memset(&ci,0,sizeof(ci));
    ci.ipaddr=m.eval();
    return ci;
  }
  
  public:
  IpToId(node_ipexpr& mm) : m(mm) {}
}; 

//-----------------------------------------------------------------------------
// Printing:

class PrintExprInt:public node_stmt {
  node_int64expr& a;
  
  virtual void eval() {  
    int64 r=a.eval();
    char buf[40]; snprintf(buf,40,"%u:%u",unsigned(r>>32),unsigned(r & int64(0xffffffffU)));
    ParseProgram::instance->print(buf);
  }
  
  public:
  PrintExprInt(node_int64expr& expr) : a(expr) {}
};

class PrintExprShort:public node_stmt {
  node_int64expr& a;
  
  virtual void eval() {
    char buf[40]; snprintf(buf,40,"%u",unsigned(a.eval()));
    ParseProgram::instance->print(buf);
  }
  
  public:
  PrintExprShort(node_int64expr& expr) : a(expr) {}
};

class PrintExprBool:public node_stmt {
  node_boolexpr& a;
  
  virtual void eval() {
    ParseProgram::instance->print(a.eval()!=0 ? "true" : "false");
  }
  
  public:
  PrintExprBool(node_boolexpr& expr) : a(expr) {}
};

class PrintExprMac:public node_stmt {
  node_macexpr& a;
  
  virtual void eval() {
    ParseProgram::instance->print(a.eval().tostr());
  }
  
  public:
  PrintExprMac(node_macexpr& expr) : a(expr) {}
};

class PrintExprIp:public node_stmt {
  node_ipexpr& a;
  
  virtual void eval() {
    ParseProgram::instance->print(a.eval().tostr());
  }
  
  public:
  PrintExprIp(node_ipexpr& expr) : a(expr) {}
};

class PrintString:public node_stmt {
  char* a;
  
  virtual void eval() {
    ParseProgram::instance->print(a);
  }
  
  public:
  PrintString(char* A) : a(A) {}
};

//-----------------------------------------------------------------------------
// Table manipulation:

// Number of cards
class fncTBLcardcnt:public node_int64expr {
  virtual int64 eval() {
    return ParseProgram::instance->TBLcardcnt();
  }
};

// Number of counters:
class fncTBLcntcnt:public node_int64expr {
  virtual int64 eval() {
    return ParseProgram::instance->TBLcntcnt();
  }
};

// Deleting a card:
class fncTBLidxdel:public node_stmt {
  node_int64expr& idx;
 
  virtual void eval() {
    ParseProgram::instance->TBLidxdel(idx.eval(),runerror);
  }
  
  public:
  fncTBLidxdel(node_int64expr& a) : idx(a) {}
};

// Get index for a card_id adress
class fncTBLgetidx:public node_int64expr {
  node_idexpr& m;
 
  virtual int64 eval() {
    return ParseProgram::instance->TBLgetidx(m.eval(),runerror);
  }
  
  public:
  fncTBLgetidx(node_idexpr& a) : m(a) {}
};

// Get a MAC address:
class fncTBLgetmacadr:public node_macexpr {
  node_int64expr& idx;
  
  virtual mac_addr eval() {
    return ParseProgram::instance->TBLgetmacaddr(idx.eval(),runerror);
  }
  
  public:
  fncTBLgetmacadr(node_int64expr& a) : idx(a) {}
};

// Get an IP address:
class fncTBLgetipadr:public node_ipexpr {
  node_int64expr& idx;
  
  virtual ip_addr eval() {
    return ParseProgram::instance->TBLgetipaddr(idx.eval(),runerror);
  }
  
  public:
  fncTBLgetipadr(node_int64expr& a) : idx(a) {}
};

// Returns a counter value:
class fncTBLgetcnt:public node_int64var {
  node_idexpr& m;
  node_int64expr& i;
 
  virtual int64* eval() {
    return ParseProgram::instance->TBLgetcnt(m.eval(),i.eval(),runerror);
  }
  
  public:
  fncTBLgetcnt(node_idexpr& A, node_int64expr& B) : m(A), i(B) {}
};

//-----------------------------------------------------------------------------

#line 543 "parseprg-yacc.yy"
typedef union {
  node_stmt*      nstmt;      
  node_int64expr* nint64expr;
  node_boolexpr*  nboolexpr;
  node_macexpr*   nmacexpr;
  node_ipexpr*    nipexpr;
  node_idexpr*    nidexpr;
  node_int64var*  nint64var;
  node_boolvar*   nboolvar;
  node_macvar*    nmacvar;
  node_ipvar*     nipvar;
  char*           nstring;
  Symtable::SymEntry* nnotypevar;
} YYSTYPE;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		192
#define	YYFLAG		-32768
#define	YYNTBASE	58

#define YYTRANSLATE(x) ((unsigned)(x) <= 298 ? yytranslate[x] : 70)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    50,     2,     2,     2,     2,     2,     2,    53,
    54,    48,    46,     2,    47,     2,    49,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,    55,     2,
    45,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
    56,     2,    57,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    51,     2,    52,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
    27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
    37,    38,    39,    40,    41,    42,    43,    44
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     1,     3,     6,     8,    12,    20,    26,    32,    38,
    44,    50,    56,    62,    68,    74,    77,    80,    83,    86,
    88,    90,    92,    96,    98,   102,   107,   109,   112,   114,
   118,   120,   124,   129,   133,   135,   138,   140,   144,   146,
   150,   154,   158,   162,   166,   170,   174,   178,   182,   186,
   190,   194,   198,   202,   206,   211,   216,   218,   221,   223,
   228,   230,   234,   236,   240,   244,   247,   251,   255,   259,
   263,   267,   271,   275,   279,   283,   287,   291,   295,   299,
   304,   306
};

static const short yyrhs[] = {    -1,
    59,     0,    59,    60,     0,    60,     0,    51,    59,    52,
     0,    13,    53,    68,    54,    60,    14,    60,     0,    13,
    53,    68,    54,    60,     0,    15,    53,    68,    54,    60,
     0,    39,    53,    66,    54,    55,     0,    16,    53,    66,
    54,    55,     0,    17,    53,    66,    54,    55,     0,    16,
    53,    68,    54,    55,     0,    16,    53,    12,    54,    55,
     0,    16,    53,    62,    54,    55,     0,    16,    53,    64,
    54,    55,     0,    66,    55,     0,    68,    55,     0,    64,
    55,     0,    62,    55,     0,    62,     0,    64,     0,    63,
     0,    63,    45,    62,     0,     9,     0,    53,    62,    54,
     0,    38,    53,    66,    54,     0,     5,     0,    40,    11,
     0,    65,     0,    65,    45,    64,     0,    10,     0,    53,
    64,    54,     0,    37,    53,    66,    54,     0,    64,    49,
    66,     0,     6,     0,    41,    11,     0,    67,     0,    67,
    45,    66,     0,     7,     0,    53,    66,    54,     0,    66,
    46,    66,     0,    66,    47,    66,     0,    66,    48,    66,
     0,    66,    49,    66,     0,    66,    26,    66,     0,    66,
    27,    66,     0,    67,    28,    66,     0,    67,    29,    66,
     0,    67,    30,    66,     0,    67,    31,    66,     0,    67,
    33,    66,     0,    67,    32,    66,     0,    34,    53,    54,
     0,    35,    53,    54,     0,    36,    53,    61,    54,     0,
    42,    53,    68,    54,     0,     3,     0,    42,    11,     0,
    11,     0,    61,    56,    66,    57,     0,    69,     0,    69,
    45,    68,     0,     8,     0,    68,    18,    68,     0,    68,
    19,    68,     0,    50,    68,     0,    53,    68,    54,     0,
    62,    22,    62,     0,    62,    23,    62,     0,    64,    22,
    64,     0,    64,    23,    64,     0,    68,    22,    68,     0,
    68,    23,    68,     0,    66,    22,    66,     0,    66,    23,
    66,     0,    66,    24,    66,     0,    66,    20,    66,     0,
    66,    25,    66,     0,    66,    21,    66,     0,    43,    53,
    66,    54,     0,     4,     0,    43,    11,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   600,   601,   603,   604,   606,   607,   608,   609,   610,   611,
   612,   613,   614,   615,   616,   617,   618,   619,   620,   622,
   625,   630,   631,   632,   633,   634,   636,   637,   639,   640,
   641,   642,   643,   644,   646,   647,   649,   650,   651,   652,
   653,   654,   655,   656,   657,   658,   659,   660,   661,   662,
   663,   664,   665,   666,   667,   668,   670,   671,   672,   673,
   675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
   685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
   696,   697
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","INT64VAR",
"BOOLVAR","MACVAR","IPVAR","INT64EXPR","BOOLEXPR","MACEXPR","IPEXPR","NOTYPEVAR",
"STRING","IF","ELSE","WHILE","PRINT","PRINTS","AND","OR","LEQ","GEQ","EQ","NEQ",
"LE","GE","SHL","SHR","ADDEQ","SUBEQ","DIVEQ","MULEQ","SHREQ","SHLEQ","TBLCARDCNT",
"TBLCNTCNT","TBLGETIDX","TBLGETIPADR","TBLGETMACADR","TBLIDXDEL","DECLMACA",
"DECLIPA","DECLINT64","DECLBOOL","ERROR","'='","'+'","'-'","'*'","'/'","'!'",
"'{'","'}'","'('","')'","';'","'['","']'","program","stmtlist","stmt","idexpr",
"macexpr","macvar","ipexpr","ipvar","int64expr","int64var","boolexpr","boolvar", NULL
};
#endif

static const short yyr1[] = {     0,
    58,    58,    59,    59,    60,    60,    60,    60,    60,    60,
    60,    60,    60,    60,    60,    60,    60,    60,    60,    61,
    61,    62,    62,    62,    62,    62,    63,    63,    64,    64,
    64,    64,    64,    64,    65,    65,    66,    66,    66,    66,
    66,    66,    66,    66,    66,    66,    66,    66,    66,    66,
    66,    66,    66,    66,    66,    66,    67,    67,    67,    67,
    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,
    68,    68,    68,    68,    68,    68,    68,    68,    68,    68,
    69,    69
};

static const short yyr2[] = {     0,
     0,     1,     2,     1,     3,     7,     5,     5,     5,     5,
     5,     5,     5,     5,     5,     2,     2,     2,     2,     1,
     1,     1,     3,     1,     3,     4,     1,     2,     1,     3,
     1,     3,     4,     3,     1,     2,     1,     3,     1,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     4,     4,     1,     2,     1,     4,
     1,     3,     1,     3,     3,     2,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     4,
     1,     2
};

static const short yydefact[] = {     1,
    57,    81,    27,    35,    39,    63,    24,    31,    59,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     2,     4,     0,    20,
    22,    21,    29,     0,    37,     0,    61,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    28,    36,    58,
     0,    82,     0,    20,    21,     0,    66,     0,    20,    21,
     0,     0,     3,     0,     0,     0,    19,     0,     0,     0,
     0,    18,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,    16,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    17,     0,     0,
     0,     0,    20,    21,     0,     0,     0,    20,    21,     0,
    53,    54,     0,     0,     0,     0,     0,     0,     0,     5,
    25,    32,    40,    67,     0,     0,    68,    69,    23,     0,
    70,    71,    34,    30,    77,    79,    74,    75,    76,    78,
    45,    46,    41,    42,    43,    44,    47,    48,    49,    50,
    52,    51,    38,    64,    65,    72,    73,    62,     0,     0,
     0,     0,     0,     0,     0,    20,    21,     0,     0,     0,
     0,    55,    33,    26,     0,    56,    80,    60,     7,     8,
    13,    14,    15,    10,    12,    11,     9,     0,     6,     0,
     0,     0
};

static const short yydefgoto[] = {   190,
    27,    28,    29,   108,    31,   109,    33,    56,    35,    36,
    37
};

static const short yypact[] = {   272,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,   -31,
   -29,    20,    33,    53,    61,    65,    68,    72,    76,    27,
    46,    -2,    -1,   343,   272,   343,   272,-32768,     7,   -20,
    86,    10,    87,   389,   220,    -7,    88,   343,   343,   323,
   392,    89,    91,   334,   392,   392,   392,-32768,-32768,-32768,
   343,-32768,   392,    82,    45,   461,-32768,   221,   -15,    73,
   270,    90,-32768,   392,    -4,    -4,-32768,    -4,    13,    13,
   392,-32768,    13,   392,   392,   392,   392,   392,   392,   392,
   392,   392,   392,   392,   392,-32768,   392,   392,   392,   392,
   392,   392,   392,   343,   343,   343,   343,-32768,   343,    97,
   154,    98,   124,   133,   426,   167,   392,-32768,   105,   450,
-32768,-32768,   334,   103,   465,   474,   489,   192,   498,-32768,
-32768,-32768,-32768,-32768,   413,    -4,-32768,-32768,-32768,    13,
   105,   105,   395,   105,   342,   342,   342,   342,   342,   342,
   195,   195,   -28,   -28,-32768,-32768,   -28,   -28,-32768,-32768,
   195,   195,   342,   101,    38,-32768,-32768,    -5,   272,   272,
   107,   111,   114,   115,   116,   104,    48,   507,   119,   104,
    48,-32768,-32768,-32768,   120,-32768,-32768,-32768,   151,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,   272,-32768,   181,
   184,-32768
};

static const short yypgoto[] = {-32768,
   166,   -21,   149,     4,-32768,   110,-32768,     0,-32768,   102,
-32768
};


#define	YYLAST		561


static const short yytable[] = {    34,
     3,    65,    66,    30,     7,    63,    65,    66,    50,    52,
    94,    95,    94,    95,    96,    97,    96,    97,     4,    84,
    85,    38,     8,    39,    34,    61,    34,    54,    30,    59,
    30,    69,    70,    18,    67,    20,    63,    48,   121,   105,
   110,    54,    54,   103,   115,   116,   117,    98,   126,    17,
    51,    53,   119,    21,    54,    94,    49,    34,    71,    96,
    97,    30,    64,   125,    72,   130,    69,    70,   127,   128,
   133,   129,    40,   135,   136,   137,   138,   139,   140,   141,
   142,   143,   144,   145,   146,    41,   147,   148,   149,   150,
   151,   152,   153,    71,    69,    70,    71,    54,    54,    54,
    54,   122,    54,    65,    66,    42,   168,    94,    95,    32,
   166,    96,    97,    43,    94,    95,   170,    44,    96,    97,
    45,    71,    96,    97,    46,    57,   122,    62,    47,   170,
    68,    73,    99,    55,    32,    60,    32,   179,   180,   100,
   101,   106,   111,   124,   112,    65,    66,    55,    55,   104,
   159,   161,   118,    71,    69,    70,   172,   121,    34,    34,
    55,   181,    30,    30,   188,   182,   189,    32,   183,   184,
   185,    94,    95,   186,   187,    96,    97,   162,   131,   132,
   191,    71,   134,   192,    94,    95,   163,    34,    96,    97,
    58,    30,   114,     0,     0,   154,   155,   156,   157,     0,
   158,     0,     0,    55,    55,    55,    55,   160,    55,    94,
    95,     0,     0,    96,    97,     0,   167,     0,     0,     0,
   165,     0,   171,     1,     2,     3,     4,     5,     6,     7,
     8,     9,     0,    10,     0,    11,    12,    13,     0,   171,
    82,    83,    84,    85,     0,   176,     0,    87,    88,    89,
    90,    91,    92,     0,    14,    15,    16,    17,    18,    19,
    20,    21,    22,    23,    93,     0,     0,     0,    32,    32,
    24,    25,   120,    26,     1,     2,     3,     4,     5,     6,
     7,     8,     9,     0,    10,     0,    11,    12,    13,    74,
    75,    76,    77,    78,    79,    80,    81,    32,     0,     0,
     0,     0,     0,     0,     0,    14,    15,    16,    17,    18,
    19,    20,    21,    22,    23,    82,    83,    84,    85,     0,
     0,    24,    25,   123,    26,     1,     2,     3,     4,     5,
     6,     7,     8,     9,   102,     0,     0,     0,     3,     4,
     0,     0,     7,     8,     0,     1,     2,     3,     4,     5,
     6,     7,     8,     9,     0,     0,    14,    15,    16,    17,
    18,     0,    20,    21,    22,    23,     0,    80,    81,     0,
    17,    18,    24,    20,    21,    26,    14,    15,    16,    17,
    18,     0,    20,    21,    22,    23,   113,    82,    83,    84,
    85,     0,    24,     0,     1,    26,     3,     4,     5,     0,
     7,     8,     9,     0,     0,     0,     0,     0,    74,    75,
    76,    77,    78,    79,    80,    81,     0,     0,     0,     0,
    80,    81,     0,     0,     0,    14,    15,    16,    17,    18,
     0,    20,    21,    22,    82,    83,    84,    85,    80,    81,
    82,    83,    84,    86,   107,    74,    75,    76,    77,    78,
    79,    80,    81,     0,     0,     0,     0,     0,    82,    83,
    84,    85,     0,     0,     0,     0,     0,     0,     0,   178,
     0,    82,    83,    84,    85,    80,    81,     0,     0,   164,
    74,    75,    76,    77,    78,    79,    80,    81,     0,     0,
    80,    81,     0,     0,     0,    82,    83,    84,    85,    80,
    81,     0,     0,   169,     0,     0,    82,    83,    84,    85,
    82,    83,    84,    85,    80,    81,     0,     0,   173,    82,
    83,    84,    85,    80,    81,     0,     0,   174,     0,     0,
     0,     0,    80,    81,    82,    83,    84,    85,     0,     0,
     0,     0,   175,    82,    83,    84,    85,     0,     0,     0,
     0,   177,    82,    83,    84,    85,     0,     0,     0,     0,
   123
};

static const short yycheck[] = {     0,
     5,    22,    23,     0,     9,    27,    22,    23,    11,    11,
    18,    19,    18,    19,    22,    23,    22,    23,     6,    48,
    49,    53,    10,    53,    25,    26,    27,    24,    25,    26,
    27,    22,    23,    38,    55,    40,    58,    11,    54,    40,
    41,    38,    39,    40,    45,    46,    47,    55,    53,    37,
    53,    53,    53,    41,    51,    18,    11,    58,    49,    22,
    23,    58,    56,    64,    55,    53,    22,    23,    65,    66,
    71,    68,    53,    74,    75,    76,    77,    78,    79,    80,
    81,    82,    83,    84,    85,    53,    87,    88,    89,    90,
    91,    92,    93,    49,    22,    23,    49,    94,    95,    96,
    97,    54,    99,    22,    23,    53,   107,    18,    19,     0,
   107,    22,    23,    53,    18,    19,   113,    53,    22,    23,
    53,    49,    22,    23,    53,    24,    54,    26,    53,   126,
    45,    45,    45,    24,    25,    26,    27,   159,   160,    38,
    39,    40,    54,    54,    54,    22,    23,    38,    39,    40,
    54,    54,    51,    49,    22,    23,    54,    54,   159,   160,
    51,    55,   159,   160,    14,    55,   188,    58,    55,    55,
    55,    18,    19,    55,    55,    22,    23,    54,    69,    70,
     0,    49,    73,     0,    18,    19,    54,   188,    22,    23,
    25,   188,    44,    -1,    -1,    94,    95,    96,    97,    -1,
    99,    -1,    -1,    94,    95,    96,    97,    54,    99,    18,
    19,    -1,    -1,    22,    23,    -1,   107,    -1,    -1,    -1,
    54,    -1,   113,     3,     4,     5,     6,     7,     8,     9,
    10,    11,    -1,    13,    -1,    15,    16,    17,    -1,   130,
    46,    47,    48,    49,    -1,    54,    -1,    28,    29,    30,
    31,    32,    33,    -1,    34,    35,    36,    37,    38,    39,
    40,    41,    42,    43,    45,    -1,    -1,    -1,   159,   160,
    50,    51,    52,    53,     3,     4,     5,     6,     7,     8,
     9,    10,    11,    -1,    13,    -1,    15,    16,    17,    20,
    21,    22,    23,    24,    25,    26,    27,   188,    -1,    -1,
    -1,    -1,    -1,    -1,    -1,    34,    35,    36,    37,    38,
    39,    40,    41,    42,    43,    46,    47,    48,    49,    -1,
    -1,    50,    51,    54,    53,     3,     4,     5,     6,     7,
     8,     9,    10,    11,    12,    -1,    -1,    -1,     5,     6,
    -1,    -1,     9,    10,    -1,     3,     4,     5,     6,     7,
     8,     9,    10,    11,    -1,    -1,    34,    35,    36,    37,
    38,    -1,    40,    41,    42,    43,    -1,    26,    27,    -1,
    37,    38,    50,    40,    41,    53,    34,    35,    36,    37,
    38,    -1,    40,    41,    42,    43,    53,    46,    47,    48,
    49,    -1,    50,    -1,     3,    53,     5,     6,     7,    -1,
     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    20,    21,
    22,    23,    24,    25,    26,    27,    -1,    -1,    -1,    -1,
    26,    27,    -1,    -1,    -1,    34,    35,    36,    37,    38,
    -1,    40,    41,    42,    46,    47,    48,    49,    26,    27,
    46,    47,    48,    55,    53,    20,    21,    22,    23,    24,
    25,    26,    27,    -1,    -1,    -1,    -1,    -1,    46,    47,
    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    57,
    -1,    46,    47,    48,    49,    26,    27,    -1,    -1,    54,
    20,    21,    22,    23,    24,    25,    26,    27,    -1,    -1,
    26,    27,    -1,    -1,    -1,    46,    47,    48,    49,    26,
    27,    -1,    -1,    54,    -1,    -1,    46,    47,    48,    49,
    46,    47,    48,    49,    26,    27,    -1,    -1,    54,    46,
    47,    48,    49,    26,    27,    -1,    -1,    54,    -1,    -1,
    -1,    -1,    26,    27,    46,    47,    48,    49,    -1,    -1,
    -1,    -1,    54,    46,    47,    48,    49,    -1,    -1,    -1,
    -1,    54,    46,    47,    48,    49,    -1,    -1,    -1,    -1,
    54
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/misc/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/share/misc/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 600 "parseprg-yacc.yy"
{ program=0; ;
    break;}
case 2:
#line 601 "parseprg-yacc.yy"
{ program=yyvsp[0].nstmt; ;
    break;}
case 3:
#line 603 "parseprg-yacc.yy"
{ yyval.nstmt=new JoinStmt(*yyvsp[-1].nstmt,*yyvsp[0].nstmt); ;
    break;}
case 4:
#line 604 "parseprg-yacc.yy"
{ yyval.nstmt=yyvsp[0].nstmt; ;
    break;}
case 5:
#line 606 "parseprg-yacc.yy"
{ yyval.nstmt=yyvsp[-1].nstmt; ;
    break;}
case 6:
#line 607 "parseprg-yacc.yy"
{ yyval.nstmt=new IfElse(*yyvsp[-4].nboolexpr,*yyvsp[-2].nstmt,*yyvsp[0].nstmt); ;
    break;}
case 7:
#line 608 "parseprg-yacc.yy"
{ yyval.nstmt=new If(*yyvsp[-2].nboolexpr,*yyvsp[0].nstmt);    ;
    break;}
case 8:
#line 609 "parseprg-yacc.yy"
{ yyval.nstmt=new While(*yyvsp[-2].nboolexpr,*yyvsp[0].nstmt); ;
    break;}
case 9:
#line 610 "parseprg-yacc.yy"
{ yyval.nstmt=new fncTBLidxdel(*yyvsp[-2].nint64expr); ;
    break;}
case 10:
#line 611 "parseprg-yacc.yy"
{ yyval.nstmt=new PrintExprInt(*yyvsp[-2].nint64expr); ;
    break;}
case 11:
#line 612 "parseprg-yacc.yy"
{ yyval.nstmt=new PrintExprShort(*yyvsp[-2].nint64expr); ;
    break;}
case 12:
#line 613 "parseprg-yacc.yy"
{ yyval.nstmt=new PrintExprBool(*yyvsp[-2].nboolexpr); ;
    break;}
case 13:
#line 614 "parseprg-yacc.yy"
{ yyval.nstmt=new PrintString(yyvsp[-2].nstring); ;
    break;}
case 14:
#line 615 "parseprg-yacc.yy"
{ yyval.nstmt=new PrintExprMac(*yyvsp[-2].nmacexpr); ;
    break;}
case 15:
#line 616 "parseprg-yacc.yy"
{ yyval.nstmt=new PrintExprIp(*yyvsp[-2].nipexpr); ;
    break;}
case 16:
#line 617 "parseprg-yacc.yy"
{ yyval.nstmt=new ExprToStmtInt64(*yyvsp[-1].nint64expr); ;
    break;}
case 17:
#line 618 "parseprg-yacc.yy"
{ yyval.nstmt=new ExprToStmtBool(*yyvsp[-1].nboolexpr);  ;
    break;}
case 18:
#line 619 "parseprg-yacc.yy"
{ yyval.nstmt=new ExprToStmtIp(*yyvsp[-1].nipexpr);    ;
    break;}
case 19:
#line 620 "parseprg-yacc.yy"
{ yyval.nstmt=new ExprToStmtMac(*yyvsp[-1].nmacexpr);   ;
    break;}
case 20:
#line 622 "parseprg-yacc.yy"
{ char* c=ParseProgram::instance->assert_cit(idMAC); 
                                                         if(c) { yyerror(c); YYERROR; }
                                                         yyval.nidexpr=new MacToId(*yyvsp[0].nmacexpr); ;
    break;}
case 21:
#line 625 "parseprg-yacc.yy"
{ char* c=ParseProgram::instance->assert_cit(idIP); 
                                                         if(c) { yyerror(c); YYERROR; }
                                                         yyval.nidexpr=new IpToId(*yyvsp[0].nipexpr); ;
    break;}
case 22:
#line 630 "parseprg-yacc.yy"
{ yyval.nmacexpr=new VarToExprMac(*yyvsp[0].nmacvar);  ;
    break;}
case 23:
#line 631 "parseprg-yacc.yy"
{ yyval.nmacexpr=new AssignMac(*yyvsp[-2].nmacvar,*yyvsp[0].nmacexpr); ;
    break;}
case 25:
#line 633 "parseprg-yacc.yy"
{ yyval.nmacexpr=yyvsp[-1].nmacexpr; ;
    break;}
case 26:
#line 634 "parseprg-yacc.yy"
{ yyval.nmacexpr=new fncTBLgetmacadr(*yyvsp[-1].nint64expr);    ;
    break;}
case 28:
#line 637 "parseprg-yacc.yy"
{ symtabel.setType(yyvsp[0].nnotypevar,ParseProgram::tMAC); yyval.nmacvar=yyvsp[0].nnotypevar->value.mac_value; ;
    break;}
case 29:
#line 639 "parseprg-yacc.yy"
{ yyval.nipexpr=new VarToExprIp(*yyvsp[0].nipvar);  ;
    break;}
case 30:
#line 640 "parseprg-yacc.yy"
{ yyval.nipexpr=new AssignIp(*yyvsp[-2].nipvar,*yyvsp[0].nipexpr); ;
    break;}
case 32:
#line 642 "parseprg-yacc.yy"
{ yyval.nipexpr=yyvsp[-1].nipexpr; ;
    break;}
case 33:
#line 643 "parseprg-yacc.yy"
{ yyval.nipexpr=new fncTBLgetipadr(*yyvsp[-1].nint64expr);    ;
    break;}
case 34:
#line 644 "parseprg-yacc.yy"
{ yyval.nipexpr=new IpMask(*yyvsp[-2].nipexpr, *yyvsp[0].nint64expr); ;
    break;}
case 36:
#line 647 "parseprg-yacc.yy"
{ symtabel.setType(yyvsp[0].nnotypevar,ParseProgram::tIP); yyval.nipvar=yyvsp[0].nnotypevar->value.ip_value; ;
    break;}
case 37:
#line 649 "parseprg-yacc.yy"
{ yyval.nint64expr=new VarToExprInt64(*yyvsp[0].nint64var);  ;
    break;}
case 38:
#line 650 "parseprg-yacc.yy"
{ yyval.nint64expr=new AssignInt64(*yyvsp[-2].nint64var,*yyvsp[0].nint64expr); ;
    break;}
case 40:
#line 652 "parseprg-yacc.yy"
{ yyval.nint64expr=yyvsp[-1].nint64expr;                     ;
    break;}
case 41:
#line 653 "parseprg-yacc.yy"
{ yyval.nint64expr=new AddInt64(*yyvsp[-2].nint64expr,*yyvsp[0].nint64expr);    ;
    break;}
case 42:
#line 654 "parseprg-yacc.yy"
{ yyval.nint64expr=new SubInt64(*yyvsp[-2].nint64expr,*yyvsp[0].nint64expr);    ;
    break;}
case 43:
#line 655 "parseprg-yacc.yy"
{ yyval.nint64expr=new MulInt64(*yyvsp[-2].nint64expr,*yyvsp[0].nint64expr);    ;
    break;}
case 44:
#line 656 "parseprg-yacc.yy"
{ yyval.nint64expr=new DivInt64(*yyvsp[-2].nint64expr,*yyvsp[0].nint64expr);    ;
    break;}
case 45:
#line 657 "parseprg-yacc.yy"
{ yyval.nint64expr=new ShlInt64(*yyvsp[-2].nint64expr,*yyvsp[0].nint64expr);    ;
    break;}
case 46:
#line 658 "parseprg-yacc.yy"
{ yyval.nint64expr=new ShrInt64(*yyvsp[-2].nint64expr,*yyvsp[0].nint64expr);    ;
    break;}
case 47:
#line 659 "parseprg-yacc.yy"
{ yyval.nint64expr=new AssignInt64(*yyvsp[-2].nint64var,*new AddInt64(*new VarToExprInt64(*yyvsp[-2].nint64var),*yyvsp[0].nint64expr)); ;
    break;}
case 48:
#line 660 "parseprg-yacc.yy"
{ yyval.nint64expr=new AssignInt64(*yyvsp[-2].nint64var,*new SubInt64(*new VarToExprInt64(*yyvsp[-2].nint64var),*yyvsp[0].nint64expr)); ;
    break;}
case 49:
#line 661 "parseprg-yacc.yy"
{ yyval.nint64expr=new AssignInt64(*yyvsp[-2].nint64var,*new DivInt64(*new VarToExprInt64(*yyvsp[-2].nint64var),*yyvsp[0].nint64expr)); ;
    break;}
case 50:
#line 662 "parseprg-yacc.yy"
{ yyval.nint64expr=new AssignInt64(*yyvsp[-2].nint64var,*new MulInt64(*new VarToExprInt64(*yyvsp[-2].nint64var),*yyvsp[0].nint64expr)); ;
    break;}
case 51:
#line 663 "parseprg-yacc.yy"
{ yyval.nint64expr=new AssignInt64(*yyvsp[-2].nint64var,*new ShlInt64(*new VarToExprInt64(*yyvsp[-2].nint64var),*yyvsp[0].nint64expr)); ;
    break;}
case 52:
#line 664 "parseprg-yacc.yy"
{ yyval.nint64expr=new AssignInt64(*yyvsp[-2].nint64var,*new ShrInt64(*new VarToExprInt64(*yyvsp[-2].nint64var),*yyvsp[0].nint64expr)); ;
    break;}
case 53:
#line 665 "parseprg-yacc.yy"
{ yyval.nint64expr=new fncTBLcardcnt();      ;
    break;}
case 54:
#line 666 "parseprg-yacc.yy"
{ yyval.nint64expr=new fncTBLcntcnt();       ;
    break;}
case 55:
#line 667 "parseprg-yacc.yy"
{ yyval.nint64expr=new fncTBLgetidx(*yyvsp[-1].nidexpr);    ;
    break;}
case 56:
#line 668 "parseprg-yacc.yy"
{ yyval.nint64expr=new BoolToInt64(*yyvsp[-1].nboolexpr);     ;
    break;}
case 58:
#line 671 "parseprg-yacc.yy"
{ symtabel.setType(yyvsp[0].nnotypevar,ParseProgram::tINT64); yyval.nint64var=yyvsp[0].nnotypevar->value.int64_value; ;
    break;}
case 59:
#line 672 "parseprg-yacc.yy"
{ yyerror("Undeclared variabel"); YYERROR; ;
    break;}
case 60:
#line 673 "parseprg-yacc.yy"
{ yyval.nint64var=new fncTBLgetcnt(*yyvsp[-3].nidexpr,*yyvsp[-1].nint64expr); ;
    break;}
case 61:
#line 675 "parseprg-yacc.yy"
{ yyval.nboolexpr=new VarToExprBool(*yyvsp[0].nboolvar);  ;
    break;}
case 62:
#line 676 "parseprg-yacc.yy"
{ yyval.nboolexpr=new AssignBool(*yyvsp[-2].nboolvar,*yyvsp[0].nboolexpr); ;
    break;}
case 64:
#line 678 "parseprg-yacc.yy"
{ yyval.nboolexpr=new LogAndBool(*yyvsp[-2].nboolexpr,*yyvsp[0].nboolexpr); ;
    break;}
case 65:
#line 679 "parseprg-yacc.yy"
{ yyval.nboolexpr=new LogOrBool(*yyvsp[-2].nboolexpr,*yyvsp[0].nboolexpr);  ;
    break;}
case 66:
#line 680 "parseprg-yacc.yy"
{ yyval.nboolexpr=new LogNotBool(*yyvsp[0].nboolexpr);     ;
    break;}
case 67:
#line 681 "parseprg-yacc.yy"
{ yyval.nboolexpr=yyvsp[-1].nboolexpr;                      ;
    break;}
case 68:
#line 682 "parseprg-yacc.yy"
{ yyval.nboolexpr=new EqMac(*yyvsp[-2].nmacexpr,*yyvsp[0].nmacexpr);      ;
    break;}
case 69:
#line 683 "parseprg-yacc.yy"
{ yyval.nboolexpr=new NeqMac(*yyvsp[-2].nmacexpr,*yyvsp[0].nmacexpr);     ;
    break;}
case 70:
#line 684 "parseprg-yacc.yy"
{ yyval.nboolexpr=new EqIp(*yyvsp[-2].nipexpr,*yyvsp[0].nipexpr);       ;
    break;}
case 71:
#line 685 "parseprg-yacc.yy"
{ yyval.nboolexpr=new NeqIp(*yyvsp[-2].nipexpr,*yyvsp[0].nipexpr);      ;
    break;}
case 72:
#line 686 "parseprg-yacc.yy"
{ yyval.nboolexpr=new EqBool(*yyvsp[-2].nboolexpr,*yyvsp[0].nboolexpr);     ;
    break;}
case 73:
#line 687 "parseprg-yacc.yy"
{ yyval.nboolexpr=new NeqBool(*yyvsp[-2].nboolexpr,*yyvsp[0].nboolexpr);    ;
    break;}
case 74:
#line 688 "parseprg-yacc.yy"
{ yyval.nboolexpr=new EqInt(*yyvsp[-2].nint64expr,*yyvsp[0].nint64expr);     ;
    break;}
case 75:
#line 689 "parseprg-yacc.yy"
{ yyval.nboolexpr=new NeqInt(*yyvsp[-2].nint64expr,*yyvsp[0].nint64expr);    ;
    break;}
case 76:
#line 690 "parseprg-yacc.yy"
{ yyval.nboolexpr=new LessInt(*yyvsp[-2].nint64expr,*yyvsp[0].nint64expr);   ;
    break;}
case 77:
#line 691 "parseprg-yacc.yy"
{ yyval.nboolexpr=new LessEqInt(*yyvsp[-2].nint64expr,*yyvsp[0].nint64expr); ;
    break;}
case 78:
#line 692 "parseprg-yacc.yy"
{ yyval.nboolexpr=new LessInt(*yyvsp[0].nint64expr,*yyvsp[-2].nint64expr);   ;
    break;}
case 79:
#line 693 "parseprg-yacc.yy"
{ yyval.nboolexpr=new LessEqInt(*yyvsp[0].nint64expr,*yyvsp[-2].nint64expr); ;
    break;}
case 80:
#line 694 "parseprg-yacc.yy"
{ yyval.nboolexpr=new Int64ToBool(*yyvsp[-1].nint64expr); ;
    break;}
case 82:
#line 697 "parseprg-yacc.yy"
{ symtabel.setType(yyvsp[0].nnotypevar,ParseProgram::tBOOL); yyval.nboolvar=yyvsp[0].nnotypevar->value.bool_value; ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/share/misc/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 699 "parseprg-yacc.yy"


//------------------------------------------------------------------------------
// Define module interface:

#include <assert.h>

// Compiletime error handling:
int anyerror;
int linestart;
void yyerror(char *s) {
  if(!anyerror) {
    snprintf(errmsg,sizeof(errmsg),"Error in program line %i: %s",yylineno+linestart,s);
    anyerror=1;
  }
  // We ignore all but the first error. This is because this module
  // calls yyerror and afterwards make yacc give this function a standard
  // error message
}

ParseProgram* ParseProgram::instance=0;

ParseProgram::ParseProgram() {
  assert(instance==0); // Only one instance is allowed because of global
                       // variabels.
  instance=this;		      
  
  // Reset variabels:
  symtabel.clear();

  cit=idUNKNOWN;
}

ParseProgram::~ParseProgram() {
  instance=0;
}

char* ParseProgram::setProgram(int ls, char* c) {
  linestart=ls-1;
  
  // Parse program
  yy_scan_string(c);
  anyerror=0;
  if(yyparse()) {
    if(!anyerror) yyerror("Parse error"); // make a default error message
    return errmsg;
  }
  return 0;
}

char* ParseProgram::execProgram() {
  runerror=0;
  iterations=0;
  if(program) program->eval();
  if(!runerror) return 0;
  // Runerror might point to "errmsg":
  char tmp[sizeof(errmsg)];
  snprintf(tmp,sizeof(tmp),"%s",runerror);
  snprintf(errmsg,sizeof(errmsg),"Program runtime error: %s",tmp);
  return errmsg;
}

char* ParseProgram::assert_cit(card_id_type c) {
  if(cit==idUNKNOWN) cit=c;
  
  if(cit!=c) {
    return "A card lookup was used which is not supported by the addressing mode";
  }
  
  return 0;
}
