/**
 * Polynomial.java
 *
 * Created on Jul 10, 2006
 */
package maths;

/**
 * Cette classe implemente un polynome.
 *
 * @author Nicolae
 */
public class Polynomial extends DefaultMap {

	private int deg;
	private double[] re;
	private double[] im;
	private double[] dre;
	private double[] dim;

	/**
	 * Cache le constructeur standard.
	 */
	private Polynomial() {}
	
	/**
	 * Constructeur qui initialise les coefficients.
	 *
	 * @param re vecteur des parties reeles.
	 * @param im vecteur des parties imaginaires.
	 */
	public Polynomial(double re[], double im[]) {
		deg = Math.min(re.length, im.length) - 1;
		while(deg >= 0 && re[deg] == 0 && im[deg] == 0)
			deg --;
		
		if(deg >= 0) {
			this.re = new double[deg + 1];
			this.im = new double[deg + 1];
			
			for (int i = 0; i <= deg; i++) {
				this.re[i] = re[i];
				this.im[i] = im[i];
			}		
		}
	}

	/**
	 * Constructeur de polynome constant <code>(re, im)</code>.
	 *
	 * @param re partie reele.
	 * @param im parite imaginaire.
	 */
	public Polynomial(double re, double im) {
		deg = 0;
		
		this.re = new double[1];
		this.im = new double[1];
		
		this.re[0] = re;
		this.im[0] = im;
	}

	/**
	 * Constructeur de polynome lineaire <code>(re1, im1) * z + (re0, im0)</code>.
	 *
	 * @param re1 partie reele.
	 * @param im1 parite imaginaire.
	 * @param re0 partie reele.
	 * @param im0 parite imaginaire.
	 */
	public Polynomial(double re1, double im1, double re0, double im0) {
		deg = 1;
		
		this.re = new double[2];
		this.im = new double[2];
		
		this.re[0] = re0;
		this.im[0] = im0;
		
		this.re[1] = re1;
		this.im[1] = im1;
	}

	/**
	 * Constructeur de polynome quadratique <code>(re2, im2) * z^2 + (re1, im1) * z + (re0, im0)</code>.
	 *
	 * @param re2 partie reele.
	 * @param im2 parite imaginaire.
	 * @param re1 partie reele.
	 * @param im1 parite imaginaire.
	 * @param re0 partie reele.
	 * @param im0 parite imaginaire.
	 */
	public Polynomial(double re2, double im2, double re1, double im1, double re0, double im0) {
		deg = 2;
		
		this.re = new double[3];
		this.im = new double[3];
		
		this.re[0] = re0;
		this.im[0] = im0;
		
		this.re[1] = re1;
		this.im[1] = im1;
		
		this.re[2] = re2;
		this.im[2] = im2;
	}
	
	/* (non-Javadoc)
	 * @see maths.DefaultMap#apply()
	 */
	protected void apply() {
		fx = 0;
		fy = 0;
		
		if(deg < 0)			
			return;
		
		double xp = 1;
		double yp = 0;
		double txp;
		
		for (int i = 0; i <= deg; i++) {
			fx += re[i] * xp - im[i] * yp;
			fy += re[i] * yp + im[i] * xp;
			
			txp = xp * x - yp * y;
			yp = xp * y + yp * x;
			xp = txp;
		}
	}

	/* (non-Javadoc)
	 * @see maths.Map#inverse()
	 */
	public Map[] inverse() {
		// TODO calculer l'inverse quand cela est possible
		return null;
	}

	protected void compDiff() {
		if(deg < 1) {
			dre = new double[0];
			dim = dre;
		} else {
			dre = new double[deg];
			dim = new double[deg];	
			
			for (int i = 1; i <= deg; i++) {
				dre[i - 1] = i * re[i];
				dim[i - 1] = i * im[i];
			}
		}
		
		der = new Polynomial(dre, dim);
	}	
}
