/************************************************************

Copyright (c) 2000 <Christian.Werner@t-online.de>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

********************************************************/
 
/* THIS IS NOT AN X CONSORTIUM STANDARD */

#define NEED_REPLIES
#include "Xlibint.h"
#include "XJS.h"
#include "xjsstr.h"
#include "Xext.h"
#include "extutil.h"

static XExtensionInfo _xjs_info_data;
static XExtensionInfo *xjs_info = &_xjs_info_data;
static char *xjs_extension_name = XJSNAME;

#define XJSCheckExtension(dpy, i, val) \
  XextCheckExtension (dpy, i, xjs_extension_name, val)

static int close_display();	
static XExtensionHooks xjs_extension_hooks = {
    NULL,				/* create_gc */
    NULL,				/* copy_gc */
    NULL,				/* flush_gc */
    NULL,				/* free_gc */
    NULL,				/* create_font */
    NULL,				/* free_font */
    close_display,			/* close_display */
    NULL,				/* wire_to_event */
    NULL,				/* event_to_wire */
    NULL,				/* error */
    NULL,				/* error_string */
};

static XEXT_GENERATE_FIND_DISPLAY(find_display, xjs_info, xjs_extension_name, 
				  &xjs_extension_hooks, XJSNumberEvents, NULL)
static XEXT_GENERATE_CLOSE_DISPLAY(close_display, xjs_info)

Bool
XJSQueryExtension(dpy)
    Display *dpy;
{
    XExtDisplayInfo *info = find_display(dpy);

    if (XextHasExtension(info)) {
	return True;
    } else {
	return False;
    }
}

Bool
XJSAYT(dpy)
    Display *dpy;
{
    XExtDisplayInfo *info = find_display(dpy);
    xJSAYTReq *req;
    xJSReply rep;

    if (!XextHasExtension(info)) {
	return False;
    }
    LockDisplay(dpy);
    GetReq(JSAYT, req);
    req->reqType = info->codes->major_opcode;
    req->xjsReqType = X_JSAYT;
    req->nargs = 0;
    if (!_XReply(dpy, (xReply *)&rep, 0, xTrue)) {
        UnlockDisplay(dpy);
	SyncHandle();
	return 0;
    }
    UnlockDisplay(dpy);
    SyncHandle();
    return rep.flags ? True : False;
}

int
XJSEval(dpy, expr, data_return, length_return)
    Display *dpy;
    char *expr;
    char **data_return;
    int *length_return;
{
    XExtDisplayInfo *info = find_display(dpy);
    xJSEvalReq *req;
    xJSReply rep;
    int Datalength = 0;
    char *p = expr, *tbuf;

    if (!XextHasExtension(info) || expr == NULL) {
        return -1;
    }
    Datalength = strlen(expr);
    LockDisplay(dpy);
    GetReq(JSEval, req);
    req->reqType = info->codes->major_opcode;
    req->xjsReqType = X_JSEval;
    req->length += (Datalength + 3) >> 2;
    req->nargs = 0;
    if (dpy->bufptr + Datalength > dpy->bufmax) {
    	_XFlush (dpy);
    }
    while (Datalength > 255) {
        BufAlloc(char *, tbuf, 256);
	memcpy(tbuf, p, 256);
	Datalength -= 256;
	p += 256;
    }
    if (Datalength) {
        BufAlloc(char *, tbuf, Datalength);
	memcpy(tbuf, p, Datalength);
    }
    /* Pad request out to a 32-bit boundary */
    if (Datalength &= 3) {
	char *pad;
	int tmpl = 4 - (Datalength & 3);
	BufAlloc (char *, pad, tmpl);
	memset(pad, 0, tmpl);
    }
    if (!_XReply(dpy, (xReply *)&rep, 0, xFalse)) {
        UnlockDisplay(dpy);
	SyncHandle();
	return 0;
    }
    if (rep.size) {
	p = Xmalloc(rep.size);
	_XRead(dpy, p, rep.size);
    }
    if (data_return && length_return) {
        if (p) {
	    *data_return = p;
	} else {
	    *data_return = NULL;
	}
	*length_return = rep.size;
    } else if (p) {
	XFree(p);
    }
    UnlockDisplay(dpy);
    SyncHandle();
    return 1;
}

int
XJSCall(dpy, proc, args, nargs, data_return, length_return)
    Display *dpy;
    char *proc;
    char **args;
    int nargs;
    char **data_return;
    int *length_return;
{
    XExtDisplayInfo *info = find_display(dpy);
    xJSCallReq *req;
    xJSReply rep;
    int Datalength = 0, i, length;
    char *p, *tbuf;

    if (!XextHasExtension(info) || proc == NULL) {
        return -1;
    }
    Datalength += strlen(proc) + 1;
    for (i = 0; i < nargs; i++) {
        if (args[i] == NULL) {
	    return -1;
	}
	Datalength += strlen(args[i]) + 1;
    }
    LockDisplay(dpy);
    GetReq(JSCall, req);
    req->reqType = info->codes->major_opcode;
    req->xjsReqType = X_JSCall;
    req->length += (Datalength + 3) >> 2;
    req->nargs = nargs;
    if (dpy->bufptr + Datalength > dpy->bufmax) {
    	_XFlush (dpy);
    }
    length = strlen(proc);
    p = proc;
    while (length > 255) {
        BufAlloc(char *, tbuf, 256);
	memcpy(tbuf, p, 256);
	length -= 256;
	p += 256;
    }
    if (length) {
        BufAlloc(char *, tbuf, length);
	memcpy(tbuf, p, length);
    }
    BufAlloc(char *, tbuf, 1);
    tbuf[0] = '\0';
    for (i = 0; i < nargs; i++) {
        length = strlen(args[i]);
	p = args[i];
	while (length > 255) {
	    BufAlloc(char *, tbuf, 256);
	    memcpy(tbuf, p, 256);
	    length -= 256;
	    p += 256;
	}
	if (length) {
	    BufAlloc(char *, tbuf, length);
	    memcpy(tbuf, p, length);
	}
	BufAlloc(char *, tbuf, 1);
	tbuf[0] = '\0';
    }
    /* Pad request out to a 32-bit boundary */
    if (Datalength &= 3) {
	char *pad;
	int tmpl = 4 - (Datalength & 3);
	BufAlloc (char *, pad, tmpl);
	memset(pad, 0, tmpl);
    }
    if (!_XReply(dpy, (xReply *)&rep, 0, xFalse)) {
        UnlockDisplay(dpy);
	SyncHandle();
	return 0;
    }
    if (rep.size) {
	p = Xmalloc(rep.size);
	_XRead(dpy, p, rep.size);
    }
    if (data_return && length_return) {
        if (p) {
	    *data_return = p;
	} else {
	    *data_return = NULL;
	}
	*length_return = rep.size;
    } else if (p) {
	XFree(p);
    }
    UnlockDisplay(dpy);
    SyncHandle();
    return 1;
}
