/*
 * Handles HTTP upload of graphics files into the system.
 *
 * Copyright (c) 1996-2011 by the citadel.org team
 *
 * This program is open source software.  You can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "webcit.h"

extern void output_static(const char* What);

void display_graphics_upload(char *filename)
{
	StrBuf *Line;

	Line = NewStrBuf();
	serv_printf("UIMG 0||%s", filename);
	StrBuf_ServGetln(Line);
	if (GetServerStatusMsg(Line, NULL, 1, 2) != 2) {
		display_main_menu();
		return;
	}
	else
	{
		output_headers(1, 0, 0, 0, 1, 0);
		do_template("files_graphicsupload");
		end_burst();
	}
	FreeStrBuf(&Line);
}

void do_graphics_upload(char *filename)
{
	StrBuf *Line;
	const char *MimeType;
	wcsession *WCC = WC;
	char buf[SIZ];
	int bytes_remaining;
	int pos = 0;
	int thisblock;
	bytes_remaining = WCC->upload_length;

	if (havebstr("cancel_button")) {
		AppendImportantMessage(_("Graphics upload has been cancelled."), -1);
		display_main_menu();
		return;
	}

	if (WCC->upload_length == 0) {
		AppendImportantMessage(_("You didn't upload a file."), -1);
		display_main_menu();
		return;
	}
	
	MimeType = GuessMimeType(ChrPtr(WCC->upload), bytes_remaining);
	serv_printf("UIMG 1|%s|%s", MimeType, filename);

	Line = NewStrBuf();
	StrBuf_ServGetln(Line);
	if (GetServerStatusMsg(Line, NULL, 1, 2) != 2) {
		display_main_menu();
		FreeStrBuf(&Line);
		return;
	}
	while (bytes_remaining) {
		thisblock = ((bytes_remaining > 4096) ? 4096 : bytes_remaining);
		serv_printf("WRIT %d", thisblock);
	StrBuf_ServGetln(Line);
	if (GetServerStatusMsg(Line, NULL, 1, 7) != 7) {
			serv_puts("UCLS 0");
			StrBuf_ServGetln(Line);
			display_main_menu();
			FreeStrBuf(&Line);
			return;
		}
		thisblock = extract_int(&buf[4], 0);
		serv_write(&ChrPtr(WCC->upload)[pos], thisblock);
		pos = pos + thisblock;
		bytes_remaining = bytes_remaining - thisblock;
	}

	serv_puts("UCLS 1");
	StrBuf_ServGetln(Line);
	if (*ChrPtr(Line) != 'x') {
		display_success(ChrPtr(Line) + 4);
	
	}
	FreeStrBuf(&Line);

}


void edithellopic(void)    { do_graphics_upload("hello"); }
void editpic(void)         { do_graphics_upload("_userpic_"); }
void editgoodbuyepic(void) { do_graphics_upload("UIMG 1|%s|goodbuye"); }

/* The users photo display / upload facility */
void display_editpic(void) {
	putbstr("__WHICHPIC", NewStrBufPlain(HKEY("_userpic_")));
	putbstr("__PICDESC", NewStrBufPlain(_("your photo"), -1));
	putbstr("__UPLURL", NewStrBufPlain(HKEY("editpic")));
	display_graphics_upload("editpic");
}
/* room picture dispay / upload facility */
void display_editroompic(void) {
	putbstr("__WHICHPIC", NewStrBufPlain(HKEY("_roompic_")));
	putbstr("__PICDESC", NewStrBufPlain(_("the icon for this room"), -1));
	putbstr("__UPLURL", NewStrBufPlain(HKEY("editroompic")));
	display_graphics_upload("editroompic");
}

/* the greetingpage hello pic */
void display_edithello(void) {
	putbstr("__WHICHPIC", NewStrBufPlain(HKEY("hello")));
	putbstr("__PICDESC", NewStrBufPlain(_("the Greetingpicture for the login prompt"), -1));
	putbstr("__UPLURL", NewStrBufPlain(HKEY("edithellopic")));
	display_graphics_upload("edithellopic");
}

/* the logoff banner */
void display_editgoodbyepic(void) {
	putbstr("__WHICHPIC", NewStrBufPlain(HKEY("UIMG 0|%s|goodbuye")));
	putbstr("__PICDESC", NewStrBufPlain(_("the Logoff banner picture"), -1));
	putbstr("__UPLURL", NewStrBufPlain(HKEY("editgoodbuyepic")));
	display_graphics_upload("editgoodbuyepic");
}

void display_editfloorpic(void) {
	StrBuf *PicAction;

	PicAction = NewStrBuf();
	StrBufPrintf(PicAction, "_floorpic_|%s", bstr("which_floor"));
	putbstr("__WHICHPIC", PicAction);
	putbstr("__PICDESC", NewStrBufPlain(_("the icon for this floor"), -1));
	putbstr("__UPLURL", NewStrBufPlain(HKEY("editfloorpic")));
	display_graphics_upload("editfloorpic");
}

void editroompic(void) {
	char buf[SIZ];
	snprintf(buf, SIZ, "_roompic_|%s",
		 bstr("which_room"));
	do_graphics_upload(buf);
}

void editfloorpic(void){
	char buf[SIZ];
	snprintf(buf, SIZ, "_floorpic_|%s",
		 bstr("which_floor"));
	do_graphics_upload(buf);
}

void 
InitModule_GRAPHICS
(void)
{
	WebcitAddUrlHandler(HKEY("display_editpic"), "", 0, display_editpic, 0);
	WebcitAddUrlHandler(HKEY("editpic"), "", 0, editpic, 0);
	WebcitAddUrlHandler(HKEY("display_editroompic"), "", 0, display_editroompic, 0);
	WebcitAddUrlHandler(HKEY("editroompic"), "", 0, editroompic, 0);
	WebcitAddUrlHandler(HKEY("display_edithello"), "", 0, display_edithello, 0);
	WebcitAddUrlHandler(HKEY("edithellopic"), "", 0, edithellopic, 0);
	WebcitAddUrlHandler(HKEY("display_editgoodbuye"), "", 0, display_editgoodbyepic, 0);
	WebcitAddUrlHandler(HKEY("editgoodbuyepic"), "", 0, editgoodbuyepic, 0);
	WebcitAddUrlHandler(HKEY("display_editfloorpic"), "", 0, display_editfloorpic, 0);
	WebcitAddUrlHandler(HKEY("editfloorpic"), "", 0, editfloorpic, 0);
}
