// MAIN.C //////////////////////////////////////////////////////////////
//
// Author:				E^rthW( )rm 2003
// Last Mod:			Friday, September 05 2003
// About:				Program entry point for wp_tray 
// License:			GPL

// includes ////////////////////////////////////////////////////////////
//
#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gnome.h>
#include <glade/glade.h>
#include <sys/types.h>
#include <dirent.h>
#include <gconf/gconf-client.h>
#include "config.h"
#include "../include/eggtrayicon.h"
#include "../include/wp_tray_util.h"
#include "../include/wp_tray_search.h"
#include "../include/wp_tray_about.h"

// globals /////////////////////////////////////////////////////////////
//
// these all need to go before 1.0
char 			sz_home[100];				// where is the users home dir?
char 			sz_wp_dir[100];				// where are we to search for wp?
GladeXML 		* xml;						// pointer for xml interface loading
GtkWidget		* eventbox;					// event box with the icon in it 
GtkTooltips 	* tray_icon_tips;			// mouseover tip widget
GConfClient		* client;					// client for app settings
gint			n_timeout_id;				// needed to kill old timers  :)

// types ///////////////////////////////////////////////////////////////
//
enum
{
   DIR_COLUMN,
   N_COLUMNS
};

// f_set_tooltip ///////////////////////////////////////////////////////
//
// create a tooltip for the tray icon that includes
// the current wallpaper name
void
f_set_tooltip				(GConfClient * client,
		   					 guint        cnxn_id,
		   					 GConfEntry  * entry,
		   					 gpointer     user_data)
{
	const gchar				* sz_wp;
	gchar					sz_tip[100];
	GConfValue  			* value;
	
	// get the new wallpaper string
	value = gconf_entry_get_value (entry);
	sz_wp = gconf_value_get_string(value);
	
	// create tooltip
	snprintf(sz_tip, 100, "Wallpaper Tray %s - %s", VERSION, sz_wp);
	
	// Add the tips
   	gtk_tooltips_set_tip(tray_icon_tips, GTK_WIDGET(user_data),
				 		 sz_tip,
				 		 sz_tip);
}// end f_set_tooltip

// f_thumbnail_icon ////////////////////////////////////////////////////
//
// generate a thumbnail and blit it to the tray icon pixmap
// this is probably slow as hell .:
// * GdkPixbufLoader load and thumbnails on the fly
// * Get the data from nautilus somehow?
void
f_thumbnail_icon			(GConfClient * client,
		   					 guint        cnxn_id,
		   					 GConfEntry  * entry,
		   					 gpointer     p_user_data)
{
	const gchar				*sz_wp;
	GdkPixbuf				*p_pixbuf;
	GdkPixbuf				*p_scale_pixbuf;
	guchar					*ar_pixel_src;
	guchar					*ar_pixel_dst;
	gint					n_width, n_height, n_bps;
	gint					n_stride_src, n_stride_dst;
	gint					n_num_chan_src, n_num_chan_dst;
	gint					i, j;
	
	// get the new wallpaper string
	sz_wp	 = gconf_client_get_string(client, "/desktop/gnome/background/picture_filename", NULL);
	
	// load the wallpaper
	// TO DO: http://developer.gnome.org/doc/API/2.0/gdk-pixbuf/GdkPixbufLoader.html
	p_pixbuf = gdk_pixbuf_new_from_file(sz_wp, NULL);
	
	// sanity
	if(!p_pixbuf)
	{
		printf("f_thumbnail_icon: cannot locate wallpaper to thumbnail, %s .\n", sz_wp);
		return;
	}// end if
	
	if(gdk_pixbuf_get_width(p_pixbuf)  <= 28 || 
	   gdk_pixbuf_get_height(p_pixbuf) <= 22)
	{
		printf("f_thumbnail_icon: image to small to thumbnail, %s .\n", sz_wp);
		return;
	}// end if
	
	// create a thumbnail - GdkPixbufLoader does this at load time  :/
	p_scale_pixbuf = gnome_thumbnail_scale_down_pixbuf(p_pixbuf, 28, 22);
	
	// dump wallpaper load
	gdk_pixbuf_unref(p_pixbuf);
	
	// get tray icon pixmap ...
	p_pixbuf = gtk_image_get_pixbuf(GTK_IMAGE(p_user_data));
	
	// get pointer to internal pixmap
	ar_pixel_src = gdk_pixbuf_get_pixels(p_scale_pixbuf);
	ar_pixel_dst = gdk_pixbuf_get_pixels(p_pixbuf);
	
	// extract image info
	n_width  		= gdk_pixbuf_get_width(p_scale_pixbuf);
	n_height 		= gdk_pixbuf_get_height(p_scale_pixbuf);
	n_num_chan_src	= gdk_pixbuf_get_n_channels(p_scale_pixbuf);
	n_num_chan_dst	= gdk_pixbuf_get_n_channels(p_pixbuf);
	n_bps			= gdk_pixbuf_get_bits_per_sample(p_scale_pixbuf);
	n_stride_src	= gdk_pixbuf_get_rowstride(p_scale_pixbuf);
	n_stride_dst	= gdk_pixbuf_get_rowstride(p_pixbuf);

	// iterate through the pixmap data 
	for(i = 0; i < n_height; i ++)
	{
		gint n_offset_src, n_offset_dst;

		n_offset_src =	n_stride_src * i;
		n_offset_dst =	n_stride_dst * i;
		
		for(j = 0; j < n_width; j ++)
		{
			ar_pixel_dst[(j * n_num_chan_dst) + n_offset_dst + 0] = ar_pixel_src[(j * n_num_chan_src) + n_offset_src + 0];
			ar_pixel_dst[(j * n_num_chan_dst) + n_offset_dst + 1] = ar_pixel_src[(j * n_num_chan_src) + n_offset_src + 1];
			ar_pixel_dst[(j * n_num_chan_dst) + n_offset_dst + 2] = ar_pixel_src[(j * n_num_chan_src) + n_offset_src + 2];
		}// end for
	}// end for
	
	// update the view of the icon
	gtk_widget_queue_draw(GTK_WIDGET(p_user_data));
}// end f_thumbnail_icon

// f_default_settings //////////////////////////////////////////////////
//
// create default settings in users gconf
void
f_default_settings		(GConfClient	* client)
{
	// set settings
	gconf_client_set_list(client, "/apps/wp_tray/dir_list", GCONF_VALUE_STRING, NULL, NULL);
	gconf_client_set_int (client, "/apps/wp_tray/n_timeout", 30, NULL);
	gconf_client_set_bool(client, "/apps/wp_tray/b_timeout", FALSE, NULL);
	gconf_client_set_bool(client, "/apps/wp_tray/b_wp_logon", TRUE, NULL);
	gconf_client_set_bool(client, "/apps/wp_tray/b_img_check", FALSE, NULL);
	gconf_client_set_bool(client, "/apps/wp_tray/b_follow_links", FALSE, NULL);
}// end f_default_settings

// f_rm_wallpaper //////////////////////////////////////////////////////
//
// kill the current wallpaper and select a new one
gboolean
f_rm_wallpaper				(GtkWidget *button, EggTrayIcon *icon)
{
	const gchar				* sz_wp;
	GtkWidget * 			p_dialog;
	gint 					result;
	
	p_dialog = 	gtk_message_dialog_new(NULL,
                                 	   GTK_DIALOG_MODAL,
                                  	   GTK_MESSAGE_QUESTION,
                                  	   GTK_BUTTONS_OK_CANCEL,
                                  	   "Are you sure you want to delete this wallpaper from disk?");
	
	result = gtk_dialog_run(GTK_DIALOG (p_dialog));
  	switch(result)
    {
    	case GTK_RESPONSE_OK:
		{
         	// get gconf client and get the string to the new wp
			client = gconf_client_get_default();	
			sz_wp  = gconf_client_get_string(client, "/desktop/gnome/background/picture_filename", NULL);
	
			// kill the wallpaper
			remove(sz_wp);
	
			// set a new one
			f_set_rand_wallpaper(NULL, NULL);
		}// end case
		break;
      	default:
        {
			// do nothing ...
		}// end case
		break;
    }// end switch
	
  	gtk_widget_destroy(p_dialog);
	
	return TRUE;
}// end f_rm_wallpaper

void
store_filename				(GtkWidget *widget, gpointer user_data)
{
	GtkTreeIter 			it1;
	gint					i;
	GtkWidget				* p_window;
	DIR 					* dir;
	GtkTreeSelection 		* p_tree_sel;
	GtkTreeModel 			* p_tree_model;
	GtkWidget				* p_widget;
	const gchar				* sz_selection;
	gchar					* sz_strip_selection;
	const gchar				* sz_final;
	
	
	// get dialog handle
	p_window = glade_xml_get_widget(xml, "window1");
	
	// get users choice
	sz_selection = gtk_file_selection_get_filename(GTK_FILE_SELECTION(user_data));
	
	// this finds the last '/' in the path
	i = strlen(sz_selection);
	while(sz_selection[i] != '/' && i >= 0)
		i --;
	
	// build a string that excludes any accidental file selection 
	sz_strip_selection = malloc(i + 2);
	strncpy(sz_strip_selection, sz_selection, i);
	strncat(sz_strip_selection, "/\0", i + 2);
	
	// attempt to open the directory 
	if((dir = opendir(sz_selection))       != NULL)
	{
		// all ok, close the directory stream
		closedir(dir);
		
		// use this as the path
		sz_final = sz_selection;
	}// end if
	else
	// attempt to open fail safe path
	if((dir = opendir(sz_strip_selection)) != NULL)
	{
		// all ok, close the directory stream
		closedir(dir);
		
		// use this as the path
		sz_final = sz_strip_selection;
	}// end if 
	else
	{
		// failed (really this time  :)
		GtkWidget * p_dialog = 	gtk_message_dialog_new (GTK_WINDOW(p_window),
                                  						GTK_DIALOG_DESTROY_WITH_PARENT,
                                  						GTK_MESSAGE_ERROR,
                                  						GTK_BUTTONS_CLOSE,
                                  						"Invalid directory selected, please make another selection.");
 		gtk_dialog_run(GTK_DIALOG (p_dialog));
 		gtk_widget_destroy(p_dialog);
		
		// dump allocated string
		free(sz_strip_selection);
		
		// bomb out
		return;
	}// end else
	
	// get tree view widget
	p_widget = glade_xml_get_widget(xml, "treeview_directories");
	
	// get the selection (we don't care, just gets the model)
	p_tree_sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(p_widget));
	// get tree model
	gtk_tree_selection_get_selected(p_tree_sel, &p_tree_model, NULL);
	
	gtk_tree_store_append(GTK_TREE_STORE(p_tree_model), &it1, NULL);

	// set new directory
	gtk_tree_store_set(GTK_TREE_STORE(p_tree_model), &it1, 
					   DIR_COLUMN, sz_final, 
					   -1);
	
	// dump allocated string
	free(sz_strip_selection);
}

void
on_button_add_dir_pressed	(GtkWidget *button, gpointer user_data)
{
	GtkWidget *file_selector;

   	// create the selector
   	file_selector = gtk_file_selection_new ("Please select a directory to add.");
   
   	g_signal_connect(GTK_OBJECT (GTK_FILE_SELECTION (file_selector)->ok_button),
                     "clicked",
                     G_CALLBACK (store_filename),
                     (gpointer) file_selector);
   			   
   	// ensure that the dialog box is destroyed when the user clicks a button
   	g_signal_connect_swapped(GTK_OBJECT (GTK_FILE_SELECTION (file_selector)->ok_button),
                             "clicked",
                             G_CALLBACK (gtk_widget_destroy), 
                             (gpointer) file_selector); 

   	g_signal_connect_swapped(GTK_OBJECT (GTK_FILE_SELECTION (file_selector)->cancel_button),
                             "clicked",
                             G_CALLBACK (gtk_widget_destroy),
                             (gpointer) file_selector); 
   
   	// display that dialog
   	gtk_widget_show (file_selector);
}

void
on_button_rem_dir_pressed	(GtkWidget *button, gpointer user_data)
{
	GtkTreeSelection 		* p_tree_sel;
	GtkWidget				* p_widget;
	GtkTreeModel 			* p_tree_model;
	GtkTreePath				* p_tree_path;
	GtkTreeIter 			tree_iter;
	
	// get tree view widget
	p_widget = glade_xml_get_widget(xml, "treeview_directories");
	
	// get the selection
	p_tree_sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(p_widget));
	
	// get iterator to use on tree data
	if(!gtk_tree_selection_get_selected(p_tree_sel, &p_tree_model, &tree_iter))
	{
		return;	// doh
	}// end if
	
	// get the path of the data item
	p_tree_path = gtk_tree_model_get_path(p_tree_model, &tree_iter);
	
	// get the path and remove the bloody thing
	gtk_tree_model_get_iter(p_tree_model, &tree_iter, p_tree_path);
	gtk_tree_store_remove(GTK_TREE_STORE(p_tree_model), &tree_iter);

	// house work
	gtk_tree_path_free(p_tree_path);
}

void
on_button_apply_pressed		(GtkWidget *button, EggTrayIcon *icon)
{
	GtkWidget				* p_widget;
	GSList					* ls_wp_dir, * ls_wp_dir_iter;
	GtkTreeIter				iter;
	GtkTreeSelection 		* p_tree_sel;
	GtkTreeModel 			* p_tree_model;
	gint					n_timeout;
	gboolean				b_timeout;
	gboolean				b_wp_logon;
	gboolean				b_img_check;
	gboolean				b_follow_links;
	const gchar				* sz_timeout;
	const gchar				* sz_picture_options;
	gboolean 				b_valid;
	
	// get tree view widget
	p_widget = glade_xml_get_widget(xml, "treeview_directories");
	
	// get the selection (we don't care, just gets the model)
	p_tree_sel = gtk_tree_view_get_selection(GTK_TREE_VIEW(p_widget));
	// get tree model
	gtk_tree_selection_get_selected(p_tree_sel, &p_tree_model, NULL);
	
	// to be safe ...
	ls_wp_dir = NULL;
	
	// get the first iter in the list
  	b_valid = gtk_tree_model_get_iter_first (p_tree_model, &iter);

  	while(b_valid)
    {
      	// walk through the list, reading each row
      	gchar 				* str_data;
		
      	gtk_tree_model_get(p_tree_model, &iter, 
                           DIR_COLUMN, &str_data,
                           -1);
		
		// add data to the list
		ls_wp_dir = g_slist_append(ls_wp_dir, str_data);

		// remove the bloody thing
		//gtk_tree_store_remove(GTK_TREE_STORE(p_tree_model), &iter);
		
		// move on
      	b_valid = gtk_tree_model_iter_next(p_tree_model, &iter);
    }// end while
	
	// get timeout entry widget
	p_widget   = glade_xml_get_widget(xml, "entry_time");

	// get the new timeout
	sz_timeout = gtk_entry_get_text(GTK_ENTRY(p_widget));
	n_timeout  = (gint)strtol(sz_timeout, NULL, 10);
	
	// get timeout checkbox widget
	p_widget = glade_xml_get_widget(xml, "checkbutton_timeout");
	
	// get the state
	b_timeout = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(p_widget));
	
	// get logon widget
	p_widget = glade_xml_get_widget(xml, "checkbutton_logon_new");
	
	// get the state
	b_wp_logon = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(p_widget));
	
	// get image check widget
	p_widget = glade_xml_get_widget(xml, "checkbutton_image_check");
	
	// get the state
	b_img_check = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(p_widget));
	
	// get picture options entry 
	p_widget = glade_xml_get_widget(xml, "combo-entry_mode");
	
	// get the new options
	sz_picture_options = gtk_entry_get_text(GTK_ENTRY(p_widget));
	
	// get image check widget
	p_widget = glade_xml_get_widget(xml, "checkbutton_follow_links");
	
	// get the state
	b_follow_links = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(p_widget));
	
	// save settings
	gconf_client_set_list(client, "/apps/wp_tray/dir_list", GCONF_VALUE_STRING, ls_wp_dir, NULL);
	gconf_client_set_int (client, "/apps/wp_tray/n_timeout", n_timeout, NULL);
	gconf_client_set_bool(client, "/apps/wp_tray/b_timeout", b_timeout, NULL);
	gconf_client_set_bool(client, "/apps/wp_tray/b_wp_logon", b_wp_logon, NULL);
	gconf_client_set_bool(client, "/apps/wp_tray/b_img_check", b_img_check, NULL);
	gconf_client_set_bool(client, "/apps/wp_tray/b_follow_links", b_follow_links, NULL);
	
	// also set the wallpaper mode 
	gconf_client_set_string(client, "/desktop/gnome/background/picture_options", sz_picture_options, NULL);
	
	// free directory list
	for(ls_wp_dir_iter = ls_wp_dir; ls_wp_dir_iter != NULL; ls_wp_dir_iter = g_slist_next(ls_wp_dir_iter))
	{
		// free list data ...
		g_free(ls_wp_dir_iter->data);
	}// end for
	
	// kill the list
	g_slist_free(ls_wp_dir);
	
	// get dialog handle
	p_widget = glade_xml_get_widget(xml, "window1");
	
	// set a new wallpaper if all is well
	if(!f_set_rand_wallpaper(button, icon))
	{		
		return;
	}// end if
	
	// kill timer if needed
	if(n_timeout_id)
		g_source_remove(n_timeout_id);
	
	// change wp on timer?
	if(gconf_client_get_bool(client, "/apps/wp_tray/b_timeout", NULL))
	{
		n_timeout_id = g_timeout_add(100000 * n_timeout, (void *)f_set_rand_wallpaper, NULL);
	}// end if
	
	// kill the window and the xml
	gtk_widget_destroy(p_widget);
	g_object_unref(G_OBJECT(xml));
	g_object_unref(G_OBJECT(p_tree_model));
}

void
on_button_close_pressed		(GtkWidget *button, EggTrayIcon *icon)
{
	GtkWidget				* p_widget;
	
	// get dialog handle
	p_widget = glade_xml_get_widget(xml, "window1");
	
	// kill the window and the xml
	gtk_widget_destroy(p_widget);
	g_object_unref(G_OBJECT(xml));
}

static void
on_configuration_activate	(GtkWidget *button, EggTrayIcon *icon)
{
	GtkWidget				* p_widget;
	GtkTreeIter 			iter;
	GtkCellRenderer 		* renderer;
	GtkTreeViewColumn 		* column;
	GtkTreeStore			* tree_store;
	gchar					sz_xml_path[100];
	gchar					sz_timeout[4];
	GSList					* ls_wp_dir, * ls_wp_dir_iter;
	gint					n_timeout;
	gboolean				b_timeout;
	gboolean				b_wp_logon;
	gboolean				b_img_check;
	gboolean				b_follow_links;
	gchar					*sz_picture_options;
	
	// get settings
	ls_wp_dir			= gconf_client_get_list(client, "/apps/wp_tray/dir_list", GCONF_VALUE_STRING, NULL);
	n_timeout			= gconf_client_get_int (client, "/apps/wp_tray/n_timeout", NULL);
	b_timeout			= gconf_client_get_bool(client, "/apps/wp_tray/b_timeout", NULL);
	b_wp_logon			= gconf_client_get_bool(client, "/apps/wp_tray/b_wp_logon", NULL);
	b_img_check			= gconf_client_get_bool(client, "/apps/wp_tray/b_img_check", NULL);
	b_follow_links		= gconf_client_get_bool(client, "/apps/wp_tray/b_follow_links", NULL);
	
	// get picture options
	sz_picture_options 	= gconf_client_get_string(client, "/desktop/gnome/background/picture_options", NULL);
	
	// create ui location string 
	snprintf(sz_xml_path, 100, "%s/wp_tray_conf.glade", PACKAGE_DATA_DIR);
	// load the interface
    xml = glade_xml_new(sz_xml_path, NULL, NULL);
	
	// get list view
	p_widget = glade_xml_get_widget(xml, "treeview_directories");
	
	// make a store to go with it
	tree_store = gtk_tree_store_new(N_COLUMNS,
                                   	G_TYPE_STRING);
									
	// attach the store to the view ...
	gtk_tree_view_set_model(GTK_TREE_VIEW(p_widget), GTK_TREE_MODEL(tree_store));
						
	// set up list view to render new data
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes ("Directory",
                                                   	   renderer,
                                                   	   "text", DIR_COLUMN,
                                                   	   NULL);
	// attach column renderer ...
	gtk_tree_view_append_column(GTK_TREE_VIEW(p_widget), column);
									
	// copy directory list to the store
	for(ls_wp_dir_iter = ls_wp_dir; ls_wp_dir_iter != NULL; ls_wp_dir_iter = g_slist_next(ls_wp_dir_iter))
	{
		gchar				* sz_dir;
		
		// get data
		sz_dir = (gchar *)ls_wp_dir_iter->data;
		
		// add a new row to the model
      	gtk_tree_store_append(tree_store, &iter, NULL);
      	gtk_tree_store_set(tree_store, &iter,
        	               DIR_COLUMN, sz_dir,
                           -1);
		
		// free list data ...
		g_free(sz_dir);
	}// end for
	
	// kill the list
	g_slist_free(ls_wp_dir);
	
	// get timeout entry widget
	p_widget = glade_xml_get_widget(xml, "entry_time");
	
	// create string with timeout
	snprintf(sz_timeout, 4, "%i", n_timeout);
	
	// set the existing timeout
	gtk_entry_set_text(GTK_ENTRY(p_widget), sz_timeout);
	
	// get timeout entry widget
	p_widget = glade_xml_get_widget(xml, "checkbutton_timeout");
	
	// set the state
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(p_widget), b_timeout);
	
	// get timeout entry widget
	p_widget = glade_xml_get_widget(xml, "checkbutton_logon_new");
	
	// set the state
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(p_widget), b_wp_logon);
	
	// get timeout entry widget
	p_widget = glade_xml_get_widget(xml, "checkbutton_image_check");
	
	// set the state
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(p_widget), b_img_check);
	
	// get picture options entry 
	p_widget = glade_xml_get_widget(xml, "combo-entry_mode");
	
	// get the new options
	gtk_entry_set_text(GTK_ENTRY(p_widget), sz_picture_options);
	
	// get timeout entry widget
	p_widget = glade_xml_get_widget(xml, "checkbutton_follow_links");
	
	// set the state
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(p_widget), b_follow_links);
	
	// connect the signals in the interface
    glade_xml_signal_autoconnect(xml);
}

static void
tray_icon_pressed			(GtkWidget *button, GdkEventButton *event, EggTrayIcon *icon)
{
  	static GtkWidget 		* menu = NULL;
	GtkWidget 				* entry;

	if(menu)
	{
		gtk_widget_destroy(menu);
	}

	menu = gtk_menu_new();
	
	// left click now changes the wallpaper
	if(event->button == 1)
	{
		f_set_rand_wallpaper(NULL, NULL);
		return;
	}// end if 
	
	// right click, create a context menu ...
	
	// next wallpaper 
	entry = gtk_image_menu_item_new_with_label(_("Next Wallpaper"));
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), gtk_image_new_from_stock(GTK_STOCK_GO_FORWARD, GTK_ICON_SIZE_MENU));
	g_signal_connect(G_OBJECT(entry), "activate", G_CALLBACK(f_set_rand_wallpaper), NULL);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), entry);
	
	// config dialog 
	entry =  gtk_image_menu_item_new_with_label(_("Configuration"));
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), gtk_image_new_from_stock(GTK_STOCK_PREFERENCES, GTK_ICON_SIZE_MENU));
	g_signal_connect(G_OBJECT(entry), "activate", G_CALLBACK(on_configuration_activate), NULL);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), entry);
	
	// delete wallpaper 
	entry = gtk_image_menu_item_new_with_label(_("Delete Current Wallpaper"));
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), gtk_image_new_from_stock(GTK_STOCK_DELETE, GTK_ICON_SIZE_MENU));
	g_signal_connect(G_OBJECT(entry), "activate", G_CALLBACK(f_rm_wallpaper), NULL);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), entry);
	
	// wallpaper search tool 
	entry = gtk_image_menu_item_new_with_label(_("Wallpaper Search Tool"));
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), gtk_image_new_from_stock(GTK_STOCK_FIND, GTK_ICON_SIZE_MENU));
	g_signal_connect(G_OBJECT(entry), "activate", G_CALLBACK(f_on_wp_search_pressed), NULL);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), entry);
	
	// about box
	entry = gtk_image_menu_item_new_with_label(_("About"));
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), gtk_image_new_from_stock(GNOME_STOCK_ABOUT, GTK_ICON_SIZE_MENU));
	g_signal_connect(G_OBJECT(entry), "activate", G_CALLBACK(f_on_wp_about_pressed), NULL);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), entry);
	
	// program exit
	entry = gtk_image_menu_item_new_with_label(_("Exit"));
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(entry), gtk_image_new_from_stock(GNOME_STOCK_MENU_QUIT, GTK_ICON_SIZE_MENU));
	g_signal_connect(G_OBJECT(entry), "activate", G_CALLBACK(gtk_main_quit), NULL);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), entry);

	gtk_widget_show_all(menu);
	gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, 0, gtk_get_current_event_time());
}

gint
main 						(gint argc, gchar **argv)
{
  	GtkWidget 				* image;
  	EggTrayIcon 			* tray_icon;
	gchar					sz_tip[100];
   
	// initialize all the libraries
    gnome_init ("wp_tray", VERSION, argc, argv);
  	gtk_init (&argc, &argv);
	glade_init();
	gconf_init(argc, argv, NULL);
	
	// create tool tips group for the icon
   	tray_icon_tips = gtk_tooltips_new();
	
	// get the location of the home dir 
	strcpy(sz_home, getenv("HOME"));
	
	// create the tray icon & event box
  	tray_icon 	= egg_tray_icon_new("wallpaper manager");	
	eventbox 	= gtk_event_box_new();
		
  	g_signal_connect (eventbox, "button_press_event",
			    G_CALLBACK (tray_icon_pressed), tray_icon);
  	gtk_container_add (GTK_CONTAINER (tray_icon), eventbox);

	// tray icon image
	image 	=  gtk_image_new_from_pixbuf(gdk_pixbuf_new(GDK_COLORSPACE_RGB,
    							 						FALSE,
								 						8,
    							 						28, 22));
	gtk_container_add (GTK_CONTAINER (eventbox), image);
	
	// get default gconf client
	client = gconf_client_get_default();
	
	// add our directory to the list of directories the GConfClient will
	// watch
	gconf_client_add_dir(client,
			      		 "/desktop/gnome/background",
			      		 GCONF_CLIENT_PRELOAD_NONE,
			      		 NULL);

	// listen to changes to our key
	gconf_client_notify_add(client,
				 			"/desktop/gnome/background/picture_filename",
				 			f_set_tooltip,
				 			eventbox,
				 			NULL,
				 			NULL);
	// listen to changes to our key
	gconf_client_notify_add(client,
				 			"/desktop/gnome/background/picture_filename",
				 			f_thumbnail_icon,
				 			image,
				 			NULL,
				 			NULL);

	// create tooltip with the current wp
	snprintf(sz_tip, 100, "Wallpaper Tray %s - %s", VERSION, gconf_client_get_string(client, "/desktop/gnome/background/picture_filename", NULL));
	
	// add the initial tip
   	gtk_tooltips_set_tip(GTK_TOOLTIPS(tray_icon_tips), GTK_WIDGET(eventbox),
				 		 sz_tip,
				 		 sz_tip);
	
	// all done, show everything
	gtk_widget_show_all(GTK_WIDGET (tray_icon));
	
	// default ...
	n_timeout_id = 0;
	
	// the tray icon will be full of crap, sort it
	f_thumbnail_icon(client, 0, NULL, image);
	
	// 1st run?
	if(!gconf_client_dir_exists(client, "/apps/wp_tray", NULL))
	{
		f_default_settings(client);
		on_configuration_activate(NULL, NULL);
	}// end if
	else
	{
		// change wp at startup?
		if(gconf_client_get_bool(client, "/apps/wp_tray/b_wp_logon", NULL))
		{
			f_set_rand_wallpaper(NULL, NULL);
		}// end if
	
		// change wp on timer?
		if(gconf_client_get_bool(client, "/apps/wp_tray/b_timeout", NULL))
		{
			n_timeout_id = g_timeout_add(100000 * gconf_client_get_int(client, "/apps/wp_tray/n_timeout", NULL), (void *)f_set_rand_wallpaper, NULL);
		}// end if
	}// end else
		
	// start gtk main
  	gtk_main();
	
	// free up the gconf client (i think ...)
	g_object_unref(G_OBJECT(client));
	
	// kill timer if needed
	if(n_timeout_id)
		g_source_remove(n_timeout_id);
  	
  	// all done
  	return 0;
}
