#ifndef ANIMPOINT_H
#define ANIMPOINT_H

#include <QPointF>

class AnimPoint: public QPointF
{
public:
    AnimPoint();
	void operator= ( const AnimPoint & );
	void operator= ( const QPointF & );
	bool operator== ( const QPointF & );
	bool operator== ( AnimPoint  );
	void init();
	void copy(AnimPoint other);
	void setDest (const QPointF &);
	void setAnimated(bool);
	bool isAnimated ();
	void animate();

private:
	QPointF currentPos;
	QPointF destPos;
	qreal n;
    bool animated;

};

#endif
