// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1994
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        chlookup.h
// 
// Purpose:     
// 
// Created:     2 Nov 95   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// 
// </file> 
#ifndef hg_dispatch_chlookup_h
#define hg_dispatch_chlookup_h

#include "libdispatch.h"

#include <hyperg/utils/arrays.h>

#include <sys/types.h>

class ChildHandler ;
class ostream ;

// <class> 
//  
// Name:             DChildHandler
// 
// Purpose:          lookup pid_t -> ChildHandler
// 
// Public Interface: 
// 
// Description:      
// 
// </class> 
class DChildHandler {
public:
   DChildHandler() : handler_(nil), pid_(-1) {}
   DChildHandler (pid_t p, ChildHandler* h) : handler_(h), pid_(p) {}
   DChildHandler (const DChildHandler&) ;

   // for array lookup purposes:
   DChildHandler (pid_t p) : handler_(nil), pid_(p) {}

   DChildHandler& operator = (const DChildHandler&) ;

   boolean operator < (const DChildHandler& ch) const { return pid_ < ch.pid_; }
   boolean operator == (const DChildHandler& ch) const { return pid_ == ch.pid_; }
   boolean operator != (const DChildHandler& ch) const { return !operator==(ch); }

   ChildHandler* handler() const { return handler_; }
   pid_t pid() const { return pid_; }

private:
   ChildHandler* handler_ ;
   pid_t pid_ ;
} ;
inline ostream& operator << (ostream& s, const DChildHandler&) {
   return s ;
}
inline DChildHandler& DChildHandler :: operator = (const DChildHandler& ch) {
   handler_ = ch.handler_ ;
   pid_ = ch.pid_ ;
   return *this ;
}
inline DChildHandler :: DChildHandler (const DChildHandler& ch) {
   operator = (ch) ;
}

#if (!(defined(SUN)&&HG_OSMaj==4))
Arraysdeclare (ChildLookup, DChildHandler) ;
#else
Arraysdeclare (ChildLookupBase, DChildHandler) ;
class ChildLookup : public ChildLookupBase {
public:
   ChildLookup() ;
   ~ChildLookup() ;
   bool insert (const DChildHandler&) ;
   bool remove (const DChildHandler&) ;

   void* operator new (size_t) ;
   void operator delete (void*, size_t) ;
} ;
#endif

#endif
