/*---------------------------------------------------------------------------*\
	vtecho_fp.h
	Echo canceller kernel module using floating point echo canceller
	Author: Ben Kramer
	Date: 	14 February 2006
	
\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

	Copyright (C) 2005 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU General Public License
         as published by the Free Software Foundation; either version 2
         of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         General Public License for more details.

         You should have received a copy of the GNU General Public License
         along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#ifndef __VTECHO_FP_H__
#define __VTECHO_FP_H__

//#define FORCE_ADAPT
#define ADAPT_RATE 1000

#define ECHO_TAPS   128
//#define ECHO_TAPS   256
#define ALPHA     0.02   // short term coeff
#define BETA      0.2   // adap const
#define CUTOFF    130.0  // -48dBm0 Ly adaption cutoff
#define HANGT     600    // echo supp hangover 75ms at Fs=8000Hz
//#define THRESHOLD 0.125  // -18dB echo supressor threshold
#define THRESHOLD 0.03125  // -30 echo supressor threshold
//#define WINDOW    2000   // analysis window size for two path model
#define WINDOW    (4*ECHO_TAPS)   // analysis window size for two path model
#define MINUS3DB  0.71   // -3dB threshold
#define MINUS6DB  0.5   // -6dB threshold


typedef struct {
	float a[ECHO_TAPS];     // fixed echo model
	float a2[ECHO_TAPS];    // adaptive echo model
	float a3[ECHO_TAPS];    // snap-shot of a2 mid way thru WINDOW
	float *echoy;		// input (y) buffer pointer
	float Ly;               // input (y) short term average
	float Le;               // fixed output (e) short average
	float Le2;              // adaptive output (e) short average
	float Le3;              // snap shot of Le2, when a2 is sampled
	float Ls;               // ref (y) short term average
	float memLy[ECHO_TAPS]; // previous Ly values
	int   lyi;              // index into memLy array
	int   hang;             // hangover counter
	int   dt;               // non-zero when Geigel detects doubletalk
	int   sup;              // non-zero when supressor active
	int   adapt;            // zero to disable adaption
	long  adapt_count;	// number of times it has adapted
	float beta;             // adaption constant
	int   ok_count;         // number of ok samples so far in WINDOW
	float Ey;
	float y_oldest;
	unsigned long seed;
} ECHO_SV;

#endif
