#ifndef INCLUDED_VIEW3DS_VIEWPORT_H 
#define INCLUDED_VIEW3DS_VIEWPORT_H 
/*
 * The 3D Studio File Format Library
 * Copyright (C) 1996-2001 by J.E. Hoffmann <je-h@gmx.net>
 * All rights reserved.
 *
 * This program is  free  software;  you can redistribute it and/or modify it
 * under the terms of the  GNU Lesser General Public License  as published by 
 * the  Free Software Foundation;  either version 2.1 of the License,  or (at 
 * your option) any later version.
 *
 * This  program  is  distributed in  the  hope that it will  be useful,  but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or  FITNESS FOR A  PARTICULAR PURPOSE.  See the  GNU Lesser General Public  
 * License for more details.
 *
 * You should  have received  a copy of the GNU Lesser General Public License
 * along with  this program;  if not, write to the  Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: viewport.h,v 1.2 2001/01/15 10:56:12 jeh Exp $
 */

#include "document.h"
#include <qgl.h>

/*!
 * OpenGL viewport widget.
 */
class Viewport : public QGLWidget {
  private:
    Q_OBJECT
    Document *d_doc;
    int d_glWidth;
    int d_glHeight;
  public:
    Viewport(Document *doc, const QGLFormat& f, QWidget *parent=0, const char* name=0);
    virtual ~Viewport();

  protected:
    void initializeGL();
    void resizeGL(int w, int h);
    void renderNode(Lib3dsNode *node);
    void paintGL();
};

#endif // INCLUDED_VIEW3DS_VIEWPORT_H 

