/***************************************************************************
                          dcuserslist.h  -  description
                             -------------------
    begin                : Thu Nov 21 2002
    copyright            : (C) 2002 by François Gannaz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCUSERSLIST_H
#define DCUSERSLIST_H

/**
  *@author François Gannaz
  */

#include <dclib/dcobject.h>

#include "DCDialogUsersList.h"
#include <QMap>
#include <QString>

class QMdiSubWindow;
class QEvent;
class QCloseEvent;
class QResizeEvent;
class QShowEvent;
class CByteArray;

// stupid typedef vs forward declaration
#include "dcfriendobject.h"

class DCUsersList : public QWidget, private Ui::DCDialogUsersList {
Q_OBJECT

public:
	/** construtor */
	DCUsersList( QWidget * parent = 0 );
	/** destructor */
	virtual ~DCUsersList();

	/** Get the MDI sub window we are in */
	QMdiSubWindow * GetMdiSubWindow() { return m_pContainerWindow; } ;
	/** */
	void InitDocument();
	/** */
	void DeInitDocument();

	/** */
	void ShowFriendsList();

	/** */
	void AddFriend( QString name, QString hubname, QString hubhost, QString description );
	/** */
	void DelFriend( QString name );
	/** */
	void UpdateFriend( QString name, QString host, QString description );
	/** */
	bool AddFriendPhoto( QString name, CByteArray * data );
	/** Returns true if the nick is in the friend list */
	bool isNickInList( QString name );
	/** Returns true if the nick is on ignore */
	bool ignoreNick( QString nick );
	/** Sets the ignore status of a nick */
	void setIgnore( QString nick, bool b );

protected:
	/** resize event handler */
	virtual void resizeEvent( QResizeEvent * );
	/** overridden so that the column widths are initialized on first show() */
	virtual void showEvent( QShowEvent * event );
	/** friend event handler */
	virtual void customEvent( QEvent * event );
	/** for removing mdi sub window from mdi area */
	virtual void closeEvent( QCloseEvent * event );

private:
	/** The window containing us, created by the QMdiArea */
	QMdiSubWindow * m_pContainerWindow;
	/** */
	FriendMap m_FriendMap;

	/** */
	void SetAwayMode( DCFriendObject * obj, eUserAwayMode e );
	/** Adjust column sizes preserving user set size ratios */
	void SizeColumnsPreservingRatios();
	/** Last width the friends list was adjusted for */
	int lastFriendsWidth;

private slots:
	/** */
	void slotRightButtonClickedFriendList( const QPoint & );
};

/** */
extern DCUsersList * g_pUsersList;

#endif
