/* errordomain.vala
 *
 * Copyright (C) 2008  Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

using Gee;
using Valadoc.Content;


/**
 * Represents an error domain declaration.
 */
public class Valadoc.Api.ErrorDomain : TypeSymbol {
	public ErrorDomain (Vala.ErrorDomain symbol, Node parent) {
		base (symbol, parent);
	}

	/**
	 * Returns the name of this errordomain as it is used in C.
	 */
	public string? get_cname () {
		return ((Vala.ErrorDomain) symbol).get_cname();
	}

	/**
	 * Returns the dbus-name.
	 */
	public string? get_dbus_name () {
		return Vala.DBusModule.get_dbus_name ((Vala.TypeSymbol) symbol);
	}

	/**
	 * {@inheritDoc}
	 */
	public override NodeType node_type { get { return NodeType.ERROR_DOMAIN; } }

	/**
	 * {@inheritDoc}
	 */
	public override void accept (Visitor visitor) {
		visitor.visit_error_domain (this);
	}

	/**
	 * {@inheritDoc}
	 */
	protected override Inline build_signature () {
		return new SignatureBuilder ()
			.append_keyword (get_accessibility_modifier ())
			.append_keyword ("errordomain")
			.append_symbol (this)
			.get ();
	}
}

