# ###################################################
# Copyright (C) 2011 The Unknown Horizons Team
# team@unknown-horizons.org
# This file is part of Unknown Horizons.
#
# Unknown Horizons is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
# ###################################################

# ###################################################
# WARNING: This file is generated automagically. If
#          you need to update it follow the procedure
#          outlined below.
#
# * Generate a bare version using
#     python development/extract_strings_from_xml.py \
#       horizons/i18n/guitranslations.py
# * Do the manual postprocessing needed, a diff between
#   the versions help figuring out what is needed.
# ###################################################

from horizons.constants import VERSION

text_translations = dict()

def set_translations():
	global text_translations
	text_translations = {
		"stringpreviewwidget.xml" : {
			"headline"                    : _("String Previewer Tool for Scenario files"),
			"hintlbl"                     : _("select a scenario and click on load/reload to update the messages in the captain's log"),
			"load"                        : _("load/reload"),
			},
		"buildtab_increment0.xml" : {
			"companies_label"             : _("Companies"),
			"headline"                    : _("Sailor buildings"),
			"residents_infra_label"       : _("Residents and infrastructure"),
			"services_label"              : _("Services"),
			"church-1"                    : _("Pavilion: Fulfills religious needs of sailors."),
			"fisher-1"                    : _("Fisherman: Fishes the sea, produces food."),
			"hunter-1"                    : _("Hunter: Hunts wild forest animals, produces food."),
			"lighthouse-1"                : _("Signal fire: Allows the player to trade with the free trader."),
			"lumberjack-1"                : _("Lumberjack: Chops down trees and turns them into boards."),
			"main_square-1"               : _("Main square: Supplies citizens with goods."),
			"resident-1"                  : _("Tent: Houses your inhabitants."),
			"store-1"                     : _("Storage: Extends stock and provides collectors."),
			"street-1"                    : _("Trail: Needed for collecting goods."),
			"tree-1"                      : _("Tree"),
			},
		"buildtab_increment1.xml" : {
			"companies_label"             : _("Companies"),
			"fields_label"                : _("Fields"),
			"headline"                    : _("Pioneer buildings"),
			"military_label"              : _("Military"),
			"services_label"              : _("Services"),
			"boat_builder-1"              : _("Boat builder: Builds boats and small ships. Built on coast."),
			"brickyard-1"                 : _("Brickyard: Turns clay into bricks."),
			"clay-pit-1"                  : _("Clay pit: Gets clay from deposit."),
			"distillery-1"                : _("Distillery: Turns sugar into liquor."),
			"herder-1"                    : _("Farm: Grows field crops and raises livestock."),
			"pasture-1"                   : _("Pasture: Raises sheep. Produces wool. Needs a farm."),
			"potatofield-1"               : _("Potato field: Yields food. Needs a farm."),
			"sugarfield-1"                : _("Sugarcane field: Used in liquor production. Needs a farm."),
			"tower-1"                     : _("Wooden tower: Defends your settlement."),
			"villageschool-1"             : _("Village school: Provides education."),
			"weaver-1"                    : _("Weaver: Turns lamb wool into cloth."),
			},
		"buildtab_increment2.xml" : {
			"companies_label"             : _("Companies"),
			"fields_label"                : _("Fields"),
			"headline"                    : _("Settler buildings"),
			"mining_label"                : _("Mining"),
			"services_label"              : _("Services"),
			"butchery-1"                  : _("Butchery: Needs pigs or cattle. Produces food."),
			"cattlerun-1"                 : _("Cattle run: Raises cattle. Needs a farm."),
			"charcoal-burning-1"          : _("Charcoal burning: Burns a lot of boards to charcoal."),
			"iron-mine-1"                 : _("Mine: Gets ores from deposit."),
			"pigsty-1"                    : _("Pigsty: Raises pigs. Needs a farm."),
			"saltponds-1"                 : _("Salt ponds: Evaporates salt. Built on sea coast."),
			"smeltery-1"                  : _("Smeltery: Refines all kind of ores."),
			"tavern-1"                    : _("Tavern: Provides get-together."),
			"tobaccofield-1"              : _("Tobacco field: Produces tobacco. Needs a farm."),
			"tobacconist-1"               : _("Tobacconist: Produces tobaccos out of tobacco."),
			"toolmaker-1"                 : _("Toolmaker: Produces tools out of iron."),
			},
		"buildtab_no_settlement.xml" : {
			"headline"                    : _("Game start"),
			"howto_1_need_bo"             : _("You need to found a settlement before you can construct buildings!"),
			"howto_2_navigate_ship"       : _("Select your ship and approach the coast via right-click."),
			"howto_3_build_bo"            : _("Afterwards, press the large button in the ship overview tab."),
			},
		"place_building.xml" : {
			"headline"                    : _("Build"),
			"running_costs_label"         : _("Running costs:"),
			},
		"city_info.xml" : {
			"city_info_inhabitants"       : _("Inhabitants"),
			"city_name"                   : _("Click to change the name of your settlement."),
			},
		"menu_panel.xml" : {
			"build"                       : _("Build menu"),
			"destroy_tool"                : _("Destroy"),
			"diplomacyButton"             : _("Diplomacy"),
			"gameMenuButton"              : _("Game menu"),
			"logbook"                     : _("Captain's log"),
			},
		"minimap.xml" : {
			"rotateLeft"                  : _("Rotate map counterclockwise"),
			"rotateRight"                 : _("Rotate map clockwise"),
			"speedDown"                   : _("Decrease game speed"),
			"speedUp"                     : _("Increase game speed"),
			"zoomIn"                      : _("Zoom in"),
			"zoomOut"                     : _("Zoom out"),
			},
		"status.xml" : {
			"boards_icon"                 : _("Boards"),
			"bricks_icon"                 : _("Bricks"),
			"food_icon"                   : _("Food"),
			"textiles_icon"               : _("Textiles"),
			"tools_icon"                  : _("Tools"),
			},
		"status_gold.xml" : {
			"gold_icon"                   : _("Gold"),
			},
		"change_name.xml" : {
			"enter_new_name_lbl"          : _("Enter new name:"),
			"headline_change_name"        : _("Change name"),
			"okButton"                    : _("Apply the new name"),
			},
		"chat.xml" : {
			"chat_lbl"                    : _("Enter your message:"),
			"headline"                    : _("Chat"),
			},
		"boatbuilder.xml" : {
			"BB_cancel_build_label"       : _("Cancel building:"),
			"BB_cancel_warning_label"     : _("(lose all resources)"),
			"BB_current_order"            : _("Currently building:"),
			"BB_howto_build_lbl"          : _("To build a boat, click on one of the class tabs, select the desired ship and confirm the order."),
			"BB_progress_label"           : _("Construction progress:"),
			"headline"                    : _("Building overview"),
			"BB_cancel_button"            : _("Cancel all building progress"),
			"toggle_active_active"        : _("Pause"),
			"toggle_active_inactive"      : _("Resume"),
			"running_costs_label"         : _("Running costs"),
			},
		"boatbuilder_trade.xml" : {
			"headline"                    : _("Trade boats"),
			"headline_BB_trade_ship1"     : _("Huker"),
			"BB_build_trade_1"            : _("Build this ship!"),
			},
		"boatbuilder_war1.xml" : {
			"headline"                    : _("War boats"),
			"headline_BB_war1_ship1"      : _("Frigate"),
			"BB_build_war1_1"             : _("Build this ship!"),
			},
		"buysellmenu.xml" : {
			"buy_label"                   : _("Buy resources"),
			"buysell_help_label"          : _("Click on slot icon to toggle mode:"),
			"headline"                    : _("Buy or sell resources"),
			"sell_label"                  : _("Sell resources"),
			},
		"select_trade_resource.xml" : {
			"headline"                    : _("Select resources:"),
			},
		"tab_account.xml" : {
			"buy_expenses_label"          : _("Buying"),
			"headline"                    : _("Account"),
			"headline_balance_label"      : _("Balance:"),
			"headline_expenses_label"     : _("Expenses:"),
			"headline_income_label"       : _("Income:"),
			"running_costs_label"         : _("Running costs"),
			"sell_income_label"           : _("Sale"),
			"taxes_label"                 : _("Taxes"),
			"show_production_overview"    : _("Show resources produced in this settlement"),
			},
		"diplomacy.xml" : {
			"ally_label"                  : _("ally"),
			"enemy_label"                 : _("enemy"),
			"neutral_label"               : _("neutral"),
			},
		"overview_buildrelated.xml" : {
			"headline"                    : _("Build fields"),
			},
		"overview_farm.xml" : {
			"headline"                    : _("Building overview"),
			"capacity_utilisation_label"  : _("capacity utilization"),
			"running_costs_label"         : _("Running costs"),
			"capacity_utilisation"        : _("capacity utilization"),
			"running_costs"               : _("Running costs"),
			},
		"island_inventory.xml" : {
			"headline"                    : _("Settlement inventory"),
			},
		"mainsquare_inhabitants.xml" : {
			"avg_happiness_lbl"           : _("Average happiness:"),
			"headline"                    : _("Settler overview"),
			"most_needed_res_lbl"         : _("Most needed resource:"),
			},
		"mainsquare_pioneers.xml" : {
			"headline"                    : _("Pioneers"),
			"headline_residents_per_house": _("Residents per house"),
			"headline_residents_total"    : _("Summary"),
			"houses"                      : _("houses"),
			"resident_1"                  : _("1 resident"),
			"resident_2"                  : _("2 residents"),
			"resident_3"                  : _("3 residents"),
			"residents"                   : _("residents"),
			"tax_label"                   : _("Taxes:"),
			"upgrades_lbl"                : _("Upgrade permissions:"),
			"paid_taxes_icon"             : _("Paid taxes"),
			"tax_rate_icon"               : _("Tax rate"),
			"tax_val_label"               : _("Tax rate"),
			"taxes"                       : _("Paid taxes"),
			},
		"mainsquare_sailors.xml" : {
			"headline"                    : _("Sailors"),
			"headline_residents_per_house": _("Residents per house"),
			"headline_residents_total"    : _("Summary"),
			"houses"                      : _("houses"),
			"resident_1"                  : _("1 resident"),
			"resident_2"                  : _("2 residents"),
			"residents"                   : _("residents"),
			"tax_label"                   : _("Taxes:"),
			"upgrades_lbl"                : _("Upgrade permissions:"),
			"paid_taxes_icon"             : _("Paid taxes"),
			"tax_rate_icon"               : _("Tax rate"),
			"tax_val_label"               : _("Tax rate"),
			"taxes"                       : _("Paid taxes"),
			},
		"mainsquare_settlers.xml" : {
			"headline"                    : _("Settlers"),
			"headline_residents_per_house": _("Residents per house"),
			"headline_residents_total"    : _("Summary"),
			"houses"                      : _("houses"),
			"resident_1"                  : _("1 resident"),
			"resident_2"                  : _("2 residents"),
			"resident_3"                  : _("3 residents"),
			"resident_4"                  : _("4 residents"),
			"resident_5"                  : _("5 residents"),
			"residents"                   : _("residents"),
			"tax_label"                   : _("Taxes:"),
			"upgrades_lbl"                : _("Upgrade not possible:"),
			"allow_upgrades"              : _("This is the current maximum increment!"),
			"paid_taxes_icon"             : _("Paid taxes"),
			"tax_rate_icon"               : _("Tax rate"),
			"tax_val_label"               : _("Tax rate"),
			"taxes"                       : _("Paid taxes"),
			},
		"overview_branchoffice.xml" : {
			"name_label"                  : _("Name:"),
			"collector_utilisation_label" : _("Collector utilisation:"),
			"running_costs_label"         : _("Running costs"),
			"collector_utilisation"       : _("Collector utilisation:"),
			"running_costs"               : _("Running costs"),
			},
		"overview_enemybranchoffice.xml" : {
			"buying_label"                : _("Buying"),
			"selling_label"               : _("Selling"),
			},
		"overview_groundunit.xml" : {
			"lbl_weapon_storage"          : _("Weapons:"),
			},
		"overview_mainsquare.xml" : {
			"name_label"                  : _("Name:"),
			},
		"overview_productionbuilding.xml" : {
			"headline"                    : _("Building overview"),
			"capacity_utilisation_label"  : _("capacity utilization"),
			"running_costs_label"         : _("Running costs"),
			"capacity_utilisation"        : _("capacity utilization"),
			"running_costs"               : _("Running costs"),
			},
		"overview_resourcedeposit.xml" : {
			"headline"                    : _("Resource deposit"),
			"res_dep_description_lbl"     : _("This is a resource deposit where you can build a mine to dig up resources."),
			"res_dep_description_lbl2"    : _("It contains these resources:"),
			},
		"overview_settler.xml" : {
			"needed_res_label"            : _("Needed resources:"),
			"tax_label"                   : _("Taxes:"),
			"happiness_label"             : _("Happiness"),
			"paid_taxes_label"            : _("Paid taxes"),
			"paid_taxes_label"            : _("Tax rate"),
			"residents_label"             : _("Residents"),
			"inhabitants"                 : _("Residents"),
			"tax_val_label"               : _("Tax rate"),
			"taxes"                       : _("Paid taxes"),
			"happiness"                   : _("Happiness"),
			},
		"overview_ship.xml" : {
			"foundSettlement_label"       : _("Build settlement:"),
			"lbl_weapon_storage"          : _("Weapons:"),
			"name"                        : _("Click to change the name of this ship."),
			"foundSettlement"             : _("Build settlement"),
			},
		"overview_signalfire.xml" : {
			"signal_fire_description_lbl" : _("The signal fire shows the free trader how to reach your settlement in case you want to buy or sell goods."),
			},
		"overview_tradership.xml" : {
			"trader_description_lbl"      : _("This is the free trader's ship. It will visit you from time to time to buy or sell goods."),
			},
		"overviewtab.xml" : {
			"headline"                    : _("Overview"),
			"name_label"                  : _("Name:"),
			},
		"buy_sell_goods.xml" : {
			"buying_label"                : _("Buying"),
			"exchange_label"              : _("Exchange:"),
			"headline"                    : _("Trade"),
			"selling_label"               : _("Selling"),
			"ship_label"                  : _("Ship:"),
			"trade_with_label"            : _("Trade partner:"),
			},
		"exchange_goods.xml" : {
			"exchange_label"              : _("Exchange:"),
			"headline"                    : _("Trade"),
			"ship_label"                  : _("Ship:"),
			"trade_with_label"            : _("Trade partner:"),
			},
		"fighting_ship_inventory.xml" : {
			"configure_route_label"       : _("Configure trading route:"),
			"headline"                    : _("Inventory"),
			"load_unload_label"           : _("Load/Unload:"),
			},
		"ship_inventory.xml" : {
			"configure_route_label"       : _("Configure trading route:"),
			"headline"                    : _("Inventory"),
			"load_unload_label"           : _("Load/Unload:"),
			},
		"overview_farmproductionline.xml" : {
			"toggle_active_active"        : _("Pause production"),
			"toggle_active_inactive"      : _("Start production"),
			},
		"overview_productionline.xml" : {
			"toggle_active_active"        : _("Pause production"),
			"toggle_active_inactive"      : _("Start production"),
			},
		"route_entry.xml" : {
			"delete_bo"                   : _("Delete entry"),
			"move_down"                   : _("Move down"),
			"move_up"                     : _("Move up"),
			},
		"captains_log.xml" : {
			"cancelButton"                : _("Leave Captain's log"),
			"backwardButton"              : _("Read prev. entries"),
			"forwardButton"               : _("Read next entries"),
			},
		"choose_next_scenario.xml" : {
			"head_left"                   : _("Available Scenarios"),
			"head_right"                  : _("Scenario description"),
			"scenario_details"            : _("Details:"),
			"cancelButton"                : _("Continue playing"),
			"choose_scenario"             : _("Choose this scenario"),
			},
		"configure_route.xml" : {
			"lbl_wait_at_load"            : _("Wait at load:"),
			"lbl_wait_at_unload"          : _("Wait at unload:"),
			"cancelButton"                : _("Exit"),
			"add_bo"                      : _("Add to list"),
			"start_route"                 : _("Start route"),
			},
		"healthwidget.xml" : {
			"health_label"                : _("100/100"),
			},
		"island_production.xml" : {
			"cancelButton"                : _("Close"),
			},
		"players_overview.xml" : {
			"building_score"              : _("Buildings"),
			"headline"                    : _("Player scores"),
			"land_score"                  : _("Land"),
			"money_score"                 : _("Money"),
			"player_name"                 : _("Name"),
			"resource_score"              : _("Resources"),
			"settler_score"               : _("Settlers"),
			"total_score"                 : _("Total"),
			"unit_score"                  : _("Units"),
			"cancelButton"                : _("Close"),
			},
		"players_settlements.xml" : {
			"balance"                     : _("Balance"),
			"inhabitants"                 : _("Inhabitants"),
			"running_costs"               : _("Running costs"),
			"settlement_name"             : _("Name"),
			"taxes"                       : _("Taxes"),
			"cancelButton"                : _("Close"),
			},
		"ships_list.xml" : {
			"health"                      : _("Health"),
			"ship_name"                   : _("Name"),
			"ship_type"                   : _("Type"),
			"status"                      : _("Status"),
			"weapons"                     : _("Weapons"),
			"cancelButton"                : _("Close"),
			},
		"stancewidget.xml" : {
			"aggressive"                  : _("Aggressive"),
			"flee"                        : _("Flee"),
			"hold_ground"                 : _("Hold ground"),
			"none"                        : _("None"),
			},
		"help.xml" : {
			"headline"                    : _("Key bindings"),
			"lbl_b"                       : _("{B} = Show build menu"),
			"lbl_c"                       : _("{C} = Chat"),
			"lbl_comma"                   : _("{ , } = Rotate building left"),
			"lbl_down"                    : _("{DOWN} = Scroll down"),
			"lbl_escape"                  : _("{ESC} = Show pause menu"),
			"lbl_f1"                      : _("{F1} = Display help"),
			"lbl_f10"                     : _("{F10} = Toggle console on/off"),
			"lbl_f2"                      : _("{F2} = Show player scores"),
			"lbl_f3"                      : _("{F3} = Show settlement list"),
			"lbl_f4"                      : _("{F4} = Show ship list"),
			"lbl_f5"                      : _("{F5} = Quicksave"),
			"lbl_f9"                      : _("{F9} = Quickload"),
			"lbl_fife_and_uh_team"        : _("The FIFE and Unknown Horizons development teams"),
			"lbl_g"                       : _("{G} = Toggle grid on/off"),
			"lbl_h"                       : _("{H} = Show coordinate values (Debug)"),
			"lbl_have_fun"                : _("Have fun."),
			"lbl_l"                       : _("{L} = Toggle Captain's log"),
			"lbl_left"                    : _("{LEFT} = Scroll left"),
			"lbl_minus"                   : _("{ - } = Decrease game speed"),
			"lbl_p"                       : _("{P} = Pause game"),
			"lbl_period"                  : _("{ . } = Rotate building right"),
			"lbl_plus"                    : _("{ + } = Increase game speed"),
			"lbl_right"                   : _("{RIGHT} = Scroll right"),
			"lbl_s"                       : _("{S} = Screenshot"),
			"lbl_shift"                   : _("{SHIFT} = Hold to place multiple buildings"),
			"lbl_t"                       : _("{T} = Toggle translucency of ambient buildings"),
			"lbl_up"                      : _("{UP} = Scroll up"),
			"lbl_x"                       : _("{X} = Enable destruct mode"),
			"okButton"                    : _("Return"),
			},
		"ingamemenu.xml" : {
			"help"                        : _("Help"),
			"loadgame"                    : _("Load game"),
			"quit"                        : _("Cancel game"),
			"savegame"                    : _("Save game"),
			"settings"                    : _("Settings"),
			"start"                       : _("Return to game"),
			},
		"loadingscreen.xml" : {
			"loading_label"               : _("Loading ..."),
			"version_label"               : VERSION.string(),
			},
		"mainmenu.xml" : {
			"chimebell"                   : _("Attention please!"),
			"credits"                     : _("Credits"),
			"help"                        : _("Help"),
			"loadgame"                    : _("Load game"),
			"quit"                        : _("Quit"),
			"settings"                    : _("Settings"),
			"start"                       : _("Singleplayer"),
			"start_multi"                 : _("Multiplayer"),
			"version_label"               : VERSION.string(),
			},
		"multiplayer_creategame.xml" : {
			"create_game_lbl"             : _("Create game:"),
			"exit_to_mp_menu_lbl"         : _("Back:"),
			"headline"                    : _("Choose a map:"),
			"headline"                    : _("Create game - Multiplayer"),
			"mp_player_limit_lbl"         : _("Player limit:"),
			"create"                      : _("Create this new game"),
			"cancel"                      : _("Exit to multiplayer menu"),
			},
		"multiplayer_gamelobby.xml" : {
			"exit_to_mp_menu_lbl"         : _("Leave:"),
			"game_start_notice"           : _("The game will start as soon as enough players have joined."),
			"headline"                    : _("Chat:"),
			"headline"                    : _("Gamelobby"),
			"startmessage"                : _("Game details:"),
			"cancel"                      : _("Exit gamelobby"),
			},
		"multiplayermenu.xml" : {
			"active_games_lbl"            : _("Active games:"),
			"create_game_lbl"             : _("Create game:"),
			"exit_to_main_menu_lbl"       : _("Main menu:"),
			"game_showonlyownversion"     : _("Show only games with the same version:"),
			"headline_left"               : _("New game - Multiplayer"),
			"join_game_lbl"               : _("Join game"),
			"name_lbl"                    : _("Apply:"),
			"refr_gamelist_lbl"           : _("Refresh list:"),
			"apply_new_nickname"          : _("Apply the new name"),
			"create"                      : _("Create a new game"),
			"join"                        : _("Join the selected game"),
			"cancel"                      : _("Exit to main menu"),
			"refresh"                     : _("Refresh list of active games"),
			},
		"settings.xml" : {
			"autosave_interval_label"     : _("Autosave interval in minutes:"),
			"color_depth_label"           : _("Color depth:"),
			"edge_scrolling_label"        : _("Enable edge scrolling:"),
			"effect_volume_label"         : _("Effects volume:"),
			"headline"                    : _("Settings"),
			"headline_graphics"           : _("Graphics"),
			"headline_language"           : _("Language"),
			"headline_network"            : _("Network"),
			"headline_saving"             : _("Saving"),
			"headline_sound"              : _("Sound"),
			"language_label"              : _("Select language:"),
			"minimap_rotation_label"      : _("Enable minimap rotation:"),
			"music_volume_label"          : _("Music volume:"),
			"network_port_hint_lbl"       : _("(0 means default)"),
			"network_port_lbl"            : _("Network port:"),
			"number_of_autosaves_label"   : _("Number of autosaves:"),
			"number_of_quicksaves_label"  : _("Number of quicksaves:"),
			"screen_fullscreen_text"      : _("Full screen:"),
			"screen_resolution_label"     : _("Screen resolution:"),
			"sound_enable_opt_text"       : _("Enable sound:"),
			"uninterrupted_building_label": _("Uninterrupted building:"),
			"use_renderer_label"          : _("Used renderer:"),
			"warning"                     : _("Please make sure that you know what you do."),
			"okButton"                    : _("Apply"),
			"cancelButton"                : _("Return"),
			"defaultButton"               : _("Reset to default settings"),
			},
		"select_savegame.xml" : {
			"enter_filename_label"        : _("Enter filename:"),
			"headline_details_label"      : _("Details:"),
			"headline_saved_games_label"  : _("Your saved games:"),
			"okButton"                    : _("Start game"),
			"cancelButton"                : _("Exit to main menu"),
			"deleteButton"                : _("Delete selected savegame"),
			},
		"singleplayermenu.xml" : {
			"headline"                    : _("New game - Singleplayer"),
			"main_menu_label"             : _("Main menu:"),
			"start_game_label"            : _("Start game:"),
			"campaign"                    : _("Campaign"),
			"free_maps"                   : _("Free play"),
			"random"                      : _("Random map"),
			"scenario"                    : _("Scenario"),
			"okay"                        : _("Start game"),
			"cancel"                      : _("Exit to main menu"),
			},
		"sp_campaign.xml" : {
			"choose_map_lbl"              : _("Choose a map to play:"),
			},
		"sp_free_maps.xml" : {
			"headline_choose_map_lbl"     : _("Choose a map to play:"),
			},
		"sp_random.xml" : {
			"headline_map_settings_lbl"   : _("Map settings:"),
			},
		"sp_scenario.xml" : {
			"choose_map_lbl"              : _("Choose a map to play:"),
			},
		"aidataselection.xml" : {
			"ai_players_label"            : _("AI players:"),
			},
		"game_settings.xml" : {
			"headline_game_settings_lbl"  : _("Game settings:"),
			"lbl_free_trader"             : _("Free Trader"),
			"lbl_pirates"                 : _("Pirates"),
			},
		"playerdataselection.xml" : {
			"color_label"                 : _("Color:"),
			"player_label"                : _("Player name:"),
			},
	}
