/* unicap
 *
 * Copyright (C) 2004 Arne Caspari ( arne_caspari@users.sourceforge.net )
 *
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __UNICAPGTK_H__
#define __UNICAPGTK_H__

#include <unicapgtk_video_display.h>
#include <unicapgtk_video_format_selection.h>
#include <unicapgtk_device_selection.h>
#include <unicapgtk_device_property.h>
#include <unicapgtk_property_dialog.h>
#include <unicapgtk_version.h>

/**
 * UnicapgtkDeviceStateFlags:
 * @UNICAPGTK_DEVICE_STATE_VIDEO_FORMAT:  
 */
typedef enum
{
   UNICAPGTK_DEVICE_STATE_VIDEO_FORMAT = 1 << 0,
   UNICAPGTK_DEVICE_STATE_PROPERTIES   = 1 << 1,
}UnicapgtkDeviceStateFlags;


gchar *unicapgtk_get_user_config_path( void );
GKeyFile *unicapgtk_save_device_state( unicap_handle_t handle, UnicapgtkDeviceStateFlags flags );
gboolean unicapgtk_load_device_state( unicap_handle_t handle, GKeyFile *keyfile, UnicapgtkDeviceStateFlags flags );
unicap_status_t unicapgtk_check_version( unsigned int major, unsigned int minor, unsigned int micro );

#endif
