
/*
    unicap
    Copyright (C) 2004  Arne Caspari

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __DCAM_PROPERTY_TABLE_H__
#define __DCAM_PROPERTY_TABLE_H__

#include "unicap_cpi_std_struct.h"
#include "dcam.h"
#include "dcam_property.h"

#define N_(x) x

#define PPTY_FLAGS 0
#define PPTY_MASK  0xffffffffffffffffULL


#define DCAM_CAT_VIDEO    N_("Video")
#define DCAM_CAT_EXPOSURE N_("Exposure")
#define DCAM_CAT_LENS     N_("Lens Control")
#define DCAM_CAT_COLOR    N_("Color")
#define DCAM_CAT_DEVICE   N_("Device")
#define DCAM_UNIT_NONE ""
#define DCAM_UNIT_US   "us"

static char *strobe_mode_menu[] = 
{
   N_("constant low"), 
   N_("constant high"), 
   N_("fixed duration"), 
   N_("exposure")
};

static char *strobe_polarity_menu[] = 
{
   N_("active low"), 
   N_("active high")
};

#define STROBE_MODE_DEFAULT_ITEM "exposure"

char *dcam_brightness_relations[] =
{
   "shutter", 
   "gain", 
   "gamma", 
   "iris", 
};

char *dcam_auto_exposure_relations[]= 
{
};

char *dcam_sharpness_relations[] = 
{
};

char *dcam_white_balance_mode_relations[] = 
{
   "white_balance_u", 
   "white_balance_v", 
};

char *dcam_white_balance_u_relations[] = 
{
   "white_balance_v", 
};

char *dcam_white_balance_v_relations[] = 
{
   "white_balance_u", 
};

char *dcam_hue_relations[] = 
{
};

char *dcam_saturation_relations[] = 
{
};

char *dcam_gamma_relations[] =
{
	"brightness", 
};

char *dcam_shutter_relations[] = 
{
	"gain", 
	"brightness", 
	"gamma",
	"iris", 
};

char *dcam_gain_relations[] = 
{
	"shutter", 
	"brightness", 
	"gamma", 
	"iris", 
};

char *dcam_iris_relations[] = 
{
	"shutter", 
	"gain", 
	"brightness", 
	"gamma", 
};

char *dcam_focus_relations[] = 
{
	"zoom", 
};

char *dcam_temperature_relations[] = 
{
};

char *dcam_trigger_mode_relations[] = 
{
};

char *dcam_trigger_modes[]=
{
   N_("free running"), 
   N_("mode 0"),
   N_("mode 1"),
   N_("mode 2"),
   N_("mode 3"),
};

static char *dcam_trigger_polarity[]=
{
   N_("falling edge"), 
   N_("rising edge")
};

   

char *dcam_zoom_relations[] = 
{
	"focus", 
};

char *dcam_pan_relations[] = 
{
	"tilt",
};


char *dcam_tilt_relations[] = 
{
	"pan", 
};

char *dcam_optical_filter_relations[] = 
{
};

char *dcam_capture_quality_relations[] =
{
};

char *dcam_frame_rate_relations[] =
{
};

char *dcam_register_relations[] = 
{
};

char *dcam_timeout_relations[] = 
{
};



struct _dcam_property _dcam_properties[]=
{
	{ id: DCAM_PPTY_BRIGHTNESS, 
	  unicap_property: { identifier: N_("brightness"), 
						 category: DCAM_CAT_EXPOSURE, 
						 unit: DCAM_UNIT_NONE, 
						 relations: dcam_brightness_relations, 
						 relations_count: sizeof( dcam_brightness_relations ) / sizeof( char * ), 
						 { value: 0.0 }, 
						 { range: { min: 0.0, 
									max: 1.0} },  
						 stepping: 0.01, 
						 type: UNICAP_PROPERTY_TYPE_RANGE, 
						 flags: UNICAP_FLAGS_MANUAL, 
						 flags_mask: PPTY_MASK, 
						 property_data: NULL, 
						 property_data_size: 0 }, 
	  register_offset: 0x000, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_BRIGHTNESS, 
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_brightness_property, 
	  feature_hi_mask: 1<<31, 
	  feature_lo_mask: 0,
	},

#if 1
	{ id: DCAM_PPTY_ABS_FOCUS, 
	  unicap_property: { identifier: "abs focus", 
			     category: DCAM_CAT_LENS, 
			     unit: DCAM_UNIT_NONE, 
			     relations: 0, 
			     relations_count: 0, 
			     { value: 300.0 }, 
			     { range: { min: 70.0, 
					max: 620.0} },  
			     stepping: 1.0, 
			     type: UNICAP_PROPERTY_TYPE_RANGE, 
			     flags: UNICAP_FLAGS_MANUAL, 
			     flags_mask: UNICAP_FLAGS_MANUAL, 
			     property_data: NULL, 
			     property_data_size: 0 }, 
	  register_offset: 0xfff970, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_BRIGHTNESS, 
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_rw_register_property, 
	  feature_hi_mask: 1<<31, 
	  feature_lo_mask: 0,
	},
	{ id: DCAM_PPTY_ABS_ZOOM, 
	  unicap_property: { identifier: "abs zoom", 
			     category: DCAM_CAT_LENS, 
			     unit: DCAM_UNIT_NONE, 
			     relations: 0, 
			     relations_count: 0, 
			     { value: 300.0 }, 
			     { range: { min: 10.0, 
					max: 350.0} },  
			     stepping: 1.0, 
			     type: UNICAP_PROPERTY_TYPE_RANGE, 
			     flags: UNICAP_FLAGS_MANUAL, 
			     flags_mask: UNICAP_FLAGS_MANUAL, 
			     property_data: NULL, 
			     property_data_size: 0 }, 
	  register_offset: 0xfff974, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_BRIGHTNESS, 
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_rw_register_property, 
	  feature_hi_mask: 1<<31, 
	  feature_lo_mask: 0,
	},
	{ id: DCAM_PPTY_INIT_LENS, 
	  unicap_property: { identifier: "init lens", 
			     category: DCAM_CAT_LENS, 
			     unit: DCAM_UNIT_NONE, 
			     relations: 0, 
			     relations_count: 0, 
			     { value: 0.0 }, 
			     { range: { min: 0.0, 
					max: 1.0} },  
			     stepping: 1.0, 
			     type: UNICAP_PROPERTY_TYPE_RANGE, 
			     flags: UNICAP_FLAGS_MANUAL, 
			     flags_mask: UNICAP_FLAGS_MANUAL, 
			     property_data: NULL, 
			     property_data_size: 0 }, 
	  register_offset: 0xfff998, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_BRIGHTNESS, 
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_rw_register_property, 
	  feature_hi_mask: 1<<31, 
	  feature_lo_mask: 0,
	},
#endif
	{ id: DCAM_PPTY_STROBE_MODE, 
	  unicap_property: { identifier: N_("strobe_mode"), 
			     category: DCAM_CAT_DEVICE, 
			     unit: DCAM_UNIT_NONE, 
			     relations: 0, 
			     relations_count: 0, 
			     { menu_item: {STROBE_MODE_DEFAULT_ITEM} }, 
			     { menu: { menu_items: strobe_mode_menu,
				       menu_item_count: sizeof( strobe_mode_menu ) / sizeof( char* ) } }, 
			     stepping: 0.0, 
			     type: UNICAP_PROPERTY_TYPE_MENU, 
			     flags: UNICAP_FLAGS_MANUAL, 
			     flags_mask: UNICAP_FLAGS_MANUAL, 
			     property_data: NULL, 
			     property_data_size: 0 },
	  register_offset: 0x3c,
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_BRIGHTNESS, 
	  set_function: dcam_set_strobe_mode_property,
	  get_function: dcam_get_strobe_mode_property,
	  init_function: dcam_init_gpio_property, 
	  feature_hi_mask: 1<<31, 
	  feature_lo_mask: 0,
	},
	{ id: DCAM_PPTY_STROBE_DURATION,
	  unicap_property: { identifier: N_("strobe_duration"), 
			     category: DCAM_CAT_DEVICE, 
			     unit: DCAM_UNIT_US, 
			     relations: 0, 
			     relations_count: 0, 
			     { value: 10.0 }, 
			     { range: { min: 10.0, 
					max: 40000.0 } },  
			     stepping: 10.0, 
			     type: UNICAP_PROPERTY_TYPE_RANGE, 
			     flags: UNICAP_FLAGS_MANUAL, 
			     flags_mask: PPTY_MASK, 
			     property_data: NULL, 
			     property_data_size: 0 },
			     
	  register_offset: 0x3c,
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_BRIGHTNESS, 
	  set_function: dcam_set_strobe_duration_property,
	  get_function: dcam_get_strobe_duration_property,
	  init_function: dcam_init_gpio_property, 
	  feature_hi_mask: 1<<31, 
	  feature_lo_mask: 0,
	},
	{ id: DCAM_PPTY_STROBE_DELAY,
	  unicap_property: { identifier: N_("strobe_delay"), 
			     category: DCAM_CAT_DEVICE, 
			     unit: DCAM_UNIT_US, 
			     relations: 0, 
			     relations_count: 0, 
			     { value: 0.0 }, 
			     { range: { min: -20000.0, 
					max: 20000.0 } },  
			     stepping: 10.0, 
			     type: UNICAP_PROPERTY_TYPE_RANGE, 
			     flags: UNICAP_FLAGS_MANUAL, 
			     flags_mask: PPTY_MASK, 
			     property_data: NULL, 
			     property_data_size: 0 },
			     
	  register_offset: 0x3c,
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_BRIGHTNESS, 
	  set_function: dcam_set_strobe_delay_property,
	  get_function: dcam_get_strobe_delay_property,
	  init_function: dcam_init_gpio_property, 
	  feature_hi_mask: 1<<31, 
	  feature_lo_mask: 0,
	},
	{ id: DCAM_PPTY_STROBE_POLARITY, 
	  unicap_property: { identifier: N_("strobe_polarity"), 
			     category: DCAM_CAT_DEVICE, 
			     unit: DCAM_UNIT_NONE, 
			     relations: 0, 
			     relations_count: 0, 
			     { menu_item: {STROBE_MODE_DEFAULT_ITEM} }, 
			     { menu: { menu_items: strobe_polarity_menu,
				       menu_item_count: sizeof( strobe_polarity_menu ) / sizeof( char* ) } }, 
			     stepping: 0.0, 
			     type: UNICAP_PROPERTY_TYPE_MENU, 
			     flags: UNICAP_FLAGS_MANUAL, 
			     flags_mask: UNICAP_FLAGS_MANUAL, 
			     property_data: NULL, 
			     property_data_size: 0 },
	  register_offset: 0x3c,
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_BRIGHTNESS, 
	  set_function: dcam_set_strobe_polarity_property,
	  get_function: dcam_get_strobe_polarity_property,
	  init_function: dcam_init_gpio_property, 
	  feature_hi_mask: 1<<31, 
	  feature_lo_mask: 0,
	},
	

	{ id: DCAM_PPTY_AUTO_EXPOSURE, 
	  unicap_property: { identifier: N_("auto_exposure"), 
						 category: DCAM_CAT_EXPOSURE, 
						 unit: DCAM_UNIT_NONE, 
						 relations: dcam_auto_exposure_relations, 
						 relations_count: sizeof( dcam_auto_exposure_relations ) / sizeof( char * ),
						 { value: 0.0 }, 
						 { range: { min: 0.0, 
									max: 1.0 } },  
						 stepping: 0.01, 
						 type: UNICAP_PROPERTY_TYPE_RANGE, 
						 flags: UNICAP_FLAGS_MANUAL, 
						 flags_mask: PPTY_MASK, 
						 property_data: NULL, 
						 property_data_size: 0 },
	  register_offset: 0x004, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_BRIGHTNESS,
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_brightness_property, 
	  feature_hi_mask: 1<<30, 
	  feature_lo_mask: 0,
	},

	{ id: DCAM_PPTY_SHARPNESS, 
	  unicap_property: { identifier: N_("sharpness"), 
						 category: DCAM_CAT_VIDEO, 
						 unit: DCAM_UNIT_NONE, 
						 relations: dcam_sharpness_relations, 
						 relations_count: sizeof( dcam_sharpness_relations ) / sizeof( char * ),						  
						 { value: 0.0 }, 
						 { range: { min: -1.0, 
									max: 1.0 } }, 
						 stepping: 0.01, 
						 type: UNICAP_PROPERTY_TYPE_RANGE, 
						 flags: UNICAP_FLAGS_MANUAL, 
						 flags_mask: PPTY_MASK, 
						 property_data: NULL, 
						 property_data_size: 0 }, 
	  register_offset: 0x008, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_BRIGHTNESS,
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_brightness_property, 
	  feature_hi_mask: 1<<29, 
	  feature_lo_mask: 0,
	},
	
	{ id: DCAM_PPTY_WHITE_BALANCE_MODE, 
	  unicap_property: { identifier: N_("white_balance_mode"), 
			     category: DCAM_CAT_COLOR, 
			     unit: DCAM_UNIT_NONE, 
			     relations: dcam_white_balance_mode_relations, 
			     relations_count: sizeof( dcam_white_balance_mode_relations ) / sizeof( char * ), 
			     { value: 0.0 }, 
			     { range: { min: 0.0, 
					max: 0.0 } },  
			     stepping: 0.0, 
			     type: UNICAP_PROPERTY_TYPE_FLAGS, 
			     flags: UNICAP_FLAGS_MANUAL, 
			     flags_mask: PPTY_MASK, 
			     property_data: NULL, 
			     property_data_size: 0 }, 
	  register_offset: 0x00c, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_WHITEBAL_U,
	  set_function: dcam_set_white_balance_mode_property,
	  get_function: dcam_get_white_balance_mode_property,
	  init_function: dcam_init_white_balance_mode_property,
	  feature_hi_mask: 1<<28, 
	  feature_lo_mask: 0,
	}, 
						 
	{ id: DCAM_PPTY_WHITE_BALANCE_U, 
	  unicap_property: { identifier: N_("white_balance_u"), 
						 category: DCAM_CAT_COLOR, 
						 unit: DCAM_UNIT_NONE, 
						 relations: dcam_white_balance_u_relations, 
						 relations_count: sizeof( dcam_white_balance_u_relations ) / sizeof( char * ), 
						 { value: 0.5 }, 
						 { range: { min: 0.0, 
									max: 1.0 } },  
						 stepping: 0.01, 
						 type: UNICAP_PROPERTY_TYPE_RANGE, 
						 flags: UNICAP_FLAGS_MANUAL, 
						 flags_mask: PPTY_MASK, 
						 property_data: NULL, 
						 property_data_size: 0 }, 
	  register_offset: 0x00c, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_WHITEBAL_U,
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_white_balance_property,
	  feature_hi_mask: 1<<28, 
	  feature_lo_mask: 0,
	}, 

	{ id: DCAM_PPTY_WHITE_BALANCE_V, 
	  unicap_property: { identifier: N_("white_balance_v"), 
						 category: DCAM_CAT_COLOR, 
						 unit: DCAM_UNIT_NONE, 
						 relations: dcam_white_balance_v_relations, 
						 relations_count: sizeof( dcam_white_balance_v_relations ) / sizeof( char * ),
						 { value: 0.5 }, 
						 { range: { min: 0.0, 
									max: 1.0 } },  
						 stepping: 0.01, 
						 type: UNICAP_PROPERTY_TYPE_RANGE, 
						 flags: UNICAP_FLAGS_MANUAL, 
						 flags_mask: PPTY_MASK, 
						 property_data: NULL, 
						 property_data_size: 0 }, 
	  register_offset: 0x00c, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_WHITEBAL_V,
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_white_balance_property, 
	  feature_hi_mask: 1<<28, 
	  feature_lo_mask: 0,
	}, 
	
	{ id: DCAM_PPTY_HUE, 
	  unicap_property: { identifier: N_("hue"), 
						 category: DCAM_CAT_COLOR, 
						 unit: DCAM_UNIT_NONE, 
						 relations: dcam_hue_relations, 
						 relations_count: sizeof( dcam_hue_relations ) / sizeof( char * ),						 
						 { value: 0.0 }, 
						 { range: { min: -1.0, 
									max: 1.0 } }, 
						 stepping: 0.01, 
						 type: UNICAP_PROPERTY_TYPE_RANGE, 
						 flags: UNICAP_FLAGS_MANUAL, 
						 flags_mask: PPTY_MASK, 
						 property_data: NULL, 
						 property_data_size: 0 }, 
	  register_offset: 0x010, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_BRIGHTNESS,
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_brightness_property, 
	  feature_hi_mask: 1<<27, 
	  feature_lo_mask: 0,
	},
	
	{ id: DCAM_PPTY_SATURATION, 
	  unicap_property: { identifier: N_("saturation"), 
						 category: DCAM_CAT_COLOR, 
						 unit: DCAM_UNIT_NONE, 
						 relations: dcam_saturation_relations, 
						 relations_count: sizeof( dcam_saturation_relations ) / sizeof( char * ),
						 { value: 0.5 }, 
						 { range: { min: 0.0, 
									max: 1.0 } },  
						 stepping: 0.01, 
						 type: UNICAP_PROPERTY_TYPE_RANGE, 
						 flags: UNICAP_FLAGS_MANUAL, 
						 flags_mask: PPTY_MASK, 
						 property_data: NULL, 
						 property_data_size: 0 }, 
	  register_offset: 0x014, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_BRIGHTNESS,
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_brightness_property, 
	  feature_hi_mask: 1<<26, 
	  feature_lo_mask: 0,
	}, 
	
	{ id: DCAM_PPTY_GAMMA, 
	  unicap_property: { identifier: N_("gamma"), 
						 category: DCAM_CAT_VIDEO, 
						 unit: DCAM_UNIT_NONE, 
						 relations: dcam_gamma_relations, 
						 relations_count: sizeof( dcam_gamma_relations ) / sizeof( char * ),						 
						 { value: 0.0 }, 
						 { range: { min: 0.0, 
									max: 0.0 } },  
						 stepping: 0.0,  
						 type: UNICAP_PROPERTY_TYPE_RANGE, 
						 flags: UNICAP_FLAGS_MANUAL, 
						 flags_mask: PPTY_MASK, 
						 property_data: NULL, 
						 property_data_size: 0 }, 
	  register_offset: 0x018, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_BRIGHTNESS,
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_brightness_property, 
	  feature_hi_mask: 1<<25, 
	  feature_lo_mask: 0,
	},

	{ id: DCAM_PPTY_SHUTTER, 
	  unicap_property: { identifier: N_("shutter"), 
						 category: DCAM_CAT_EXPOSURE, 
						 unit: DCAM_UNIT_NONE, 
						 relations: dcam_shutter_relations, 
						 relations_count: sizeof( dcam_shutter_relations ) / sizeof( char * ),
						 { value: 0.0 }, 
						 { range: { min: 0.0, 
									max: 0.0 } },  
						 stepping: 0.0,  
						 type: UNICAP_PROPERTY_TYPE_RANGE, 
						 flags: UNICAP_FLAGS_MANUAL, 
						 flags_mask: PPTY_MASK, 
						 property_data: NULL, 
						 property_data_size: 0 }, 
	  register_offset: 0x01c, 
	  absolute_offset: 0, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_BRIGHTNESS,
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_shutter_property, 
	  feature_hi_mask: 1<<24, 
	  feature_lo_mask: 0,	  
	},
	
	{ id: DCAM_PPTY_GAIN, 
	  unicap_property: { identifier: N_("gain"), 
						 category: DCAM_CAT_EXPOSURE, 
						 unit: DCAM_UNIT_NONE, 
						 relations: dcam_gain_relations, 
						 relations_count: sizeof( dcam_gain_relations ) / sizeof( char * ),						 
						 { value: 0.0 }, 
						 { range: { min: 0.0, 
									max: 0.0 } },  
						 stepping: 0.0,  
						 type: UNICAP_PROPERTY_TYPE_RANGE, 
						 flags: UNICAP_FLAGS_MANUAL, 
						 flags_mask: PPTY_MASK, 
						 property_data: NULL, 
						 property_data_size: 0 },
	  register_offset: 0x020, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_BRIGHTNESS,
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_brightness_property, 
	  feature_hi_mask: 1<<23, 
	  feature_lo_mask: 0,
	},
	
	{ id: DCAM_PPTY_IRIS, 
	  unicap_property: { identifier: N_("iris"), 
						 category: DCAM_CAT_LENS, 
						 unit: DCAM_UNIT_NONE, 
						 relations: dcam_iris_relations, 
						 relations_count: sizeof( dcam_iris_relations ) / sizeof( char * ),						 
						 { value: 0.0 }, 
						 { range: { min: 0.0, 
									max: 0.0 } },  
						 stepping: 0.0,  
						 type: UNICAP_PROPERTY_TYPE_RANGE, 
						 flags: UNICAP_FLAGS_MANUAL, 
						 flags_mask: PPTY_MASK, 
						 property_data: NULL, 
						 property_data_size: 0 }, 
	  register_offset: 0x024, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  PPTY_TYPE_BRIGHTNESS,
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_brightness_property, 
	  feature_hi_mask: 1<<22, 
	  feature_lo_mask: 0,
	},

	{ id: DCAM_PPTY_FOCUS,
	  unicap_property: { identifier: N_("focus"),
						 category: DCAM_CAT_LENS,
						 unit: DCAM_UNIT_NONE,
						 relations: dcam_focus_relations,
						 relations_count: sizeof( dcam_focus_relations ) / sizeof( char * ),
						 { value: 0.0 },
						 { range: { min: 0.0,
									max: 0.0 } },
						 stepping: 0.0,
						 type: UNICAP_PROPERTY_TYPE_RANGE,
						 flags: UNICAP_FLAGS_MANUAL,
						 flags_mask: PPTY_MASK,
						 property_data: NULL,
						 property_data_size: 0 },
	  register_offset: 0x028,
	  register_inq: 0,
	  register_default: 0,
	  register_value: 0,
	  type: PPTY_TYPE_BRIGHTNESS,
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_brightness_property,
	  feature_hi_mask: 1<<21,
	  feature_lo_mask: 0,
	},

	{ id: DCAM_PPTY_TEMPERATURE, 
	  unicap_property: { identifier: N_("temperature"), 
						 category: DCAM_CAT_VIDEO, 
						 unit: DCAM_UNIT_NONE, 
						 relations: dcam_temperature_relations, 
						 relations_count: sizeof( dcam_temperature_relations ) / sizeof( char * ),
						 { value: 0.0 }, 
						 { range: { min: 0.0, 
									max: 0.0 } },  
						 stepping: 0.0,  
						 type: UNICAP_PROPERTY_TYPE_RANGE, 
						 flags: UNICAP_FLAGS_MANUAL, 
						 flags_mask: PPTY_MASK, 
						 property_data: NULL, 
						 property_data_size: 0 }, 
	  register_offset: 0x02c, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_TEMPERATURE,
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_brightness_property, 
	  feature_hi_mask: 1<<20, 
	  feature_lo_mask: 0,
	},

#if 0
	{ id: DCAM_PPTY_SOFTWARE_TRIGGER, 
	  unicap_property: { identifier: N_("software trigger"), 
						 category: DCAM_CAT_DEVICE, 
						 relations: NULL, 
						 relations_count: 0, 
						 { value: 0.0 }, 
						 { range: { min: 0.0, 
									max: 0.0 } }, 
						 stepping: 1.0, 
						 type: UNICAP_PROPERTY_TYPE_FLAGS, 
						 flags: UNICAP_FLAGS_ONE_PUSH, 
						 flags_mask: UNICAP_FLAGS_ONE_PUSH, 
						 property_data: NULL, 
						 property_data_size: 0 }, 
	  register_offset: 0x54, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_REGISTER, 
	  set_function: dcam_set_software_trigger_property, 
	  get_function: dcam_get_software_trigger_property, 
	  init_function: dcam_init_software_trigger_property, 
	  feature_hi_mask: 0xffffffff, 
	  feature_lo_mask: 0xffffffff,
	},
#endif

	{ id: DCAM_PPTY_TRIGGER_MODE, 
	  unicap_property: { identifier: N_("trigger_mode"), 
						 category: DCAM_CAT_DEVICE, 
						 unit: DCAM_UNIT_NONE, 
						 relations: dcam_trigger_mode_relations, 
						 relations_count: sizeof( dcam_trigger_mode_relations ) / sizeof( char * ),
						 { value: 0.0 }, 
						 { value_list: { values: NULL, 
										 value_count: 0 } },  
						 stepping: 0.0,  
						 type: UNICAP_PROPERTY_TYPE_MENU, 
						 flags: UNICAP_FLAGS_MANUAL, 
						 flags_mask: UNICAP_FLAGS_MANUAL, 
						 property_data: NULL, 
						 property_data_size: 0 }, 
	  register_offset: 0x030, 0, 0, 0, 
	  type: PPTY_TYPE_TRIGGER,
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_trigger_property,
	  feature_hi_mask: 1<<19, 
	  feature_lo_mask: 0,
	}, 

	{ id: DCAM_PPTY_TRIGGER_POLARITY, 
	  unicap_property: { identifier: N_("trigger_polarity"), 
						 category: DCAM_CAT_DEVICE, 
						 unit: DCAM_UNIT_NONE, 
						 relations: dcam_trigger_mode_relations, 
						 relations_count: sizeof( dcam_trigger_mode_relations ) / sizeof( char * ),
						 { value: 0.0 }, 
						 { value_list: { values: NULL, 
										 value_count: 0 } },  
						 stepping: 0.0,  
						 type: UNICAP_PROPERTY_TYPE_MENU, 
						 flags: UNICAP_FLAGS_MANUAL, 
						 flags_mask: UNICAP_FLAGS_MANUAL, 
						 property_data: NULL, 
						 property_data_size: 0 }, 
	  register_offset: 0x030, 0, 0, 0, 
	  type: PPTY_TYPE_TRIGGER_POLARITY,
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_trigger_property,
	  feature_hi_mask: 1<<19, 
	  feature_lo_mask: 0,
	}, 

	{ id: DCAM_PPTY_ZOOM,
	  unicap_property: { identifier: N_("zoom"),
						 category: DCAM_CAT_LENS,
						 unit: DCAM_UNIT_NONE,
						 relations: dcam_zoom_relations,
						 relations_count: sizeof( dcam_zoom_relations ) / sizeof( char * ),
						 { value: 0.0 },
						 { range: { min: 0.0,
									max: 0.0 } },
						 stepping: 0.0,
						 type: UNICAP_PROPERTY_TYPE_RANGE,
						 flags: UNICAP_FLAGS_MANUAL,
						 flags_mask: PPTY_MASK,
						 property_data: NULL,
						 property_data_size: 0 },
	  register_offset: 0x080,
	  register_inq: 0,
	  register_default: 0,
	  register_value: 0,
	  type: PPTY_TYPE_BRIGHTNESS,
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_brightness_property,
	  feature_hi_mask: 0,
	  feature_lo_mask: 1<<31,
	},

	{ id: DCAM_PPTY_PAN, 
	  unicap_property: { identifier: /* TRANSLATORS: Lens pan */
					   N_("pan"), 
						 category: DCAM_CAT_LENS, 
						 unit: DCAM_UNIT_NONE, 
						 relations: dcam_pan_relations, 
						 relations_count: sizeof( dcam_pan_relations ) / sizeof( char * ),
						 { value: 0.0 }, 
						 { range: { min: 0.0, 
									max: 0.0 } },  
						 stepping: 0.0,  
						 type: UNICAP_PROPERTY_TYPE_RANGE, 
						 flags: UNICAP_FLAGS_MANUAL, 
						 flags_mask: PPTY_MASK, 
						 property_data: NULL, 
						 property_data_size: 0 }, 
	  register_offset: 0x084, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_BRIGHTNESS,
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_brightness_property, 
	  feature_hi_mask: 0, 
	  feature_lo_mask: 1<<30,
	},

	{ id: DCAM_PPTY_TILT, 
	  unicap_property: { identifier: /* TRANSLATORS: Lens tilt */
			     N_("tilt"), 
			     category: DCAM_CAT_LENS, 
			     unit: DCAM_UNIT_NONE, 
			     relations: dcam_tilt_relations, 
			     relations_count: sizeof( dcam_tilt_relations ) / sizeof( char * ),						 
			     { value: 0.0 }, 
			     { range: { min: 0.0, 
					max: 0.0 } },  
			     stepping: 0.0,  
			     type: UNICAP_PROPERTY_TYPE_RANGE, 
			     flags: UNICAP_FLAGS_MANUAL, 
			     flags_mask: PPTY_MASK, 
			     property_data: NULL, 
			     property_data_size: 0 }, 
	  register_offset: 0x088, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_BRIGHTNESS,
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_brightness_property, 
	  feature_hi_mask: 0, 
	  feature_lo_mask: 1<<29,
	},
	
	{ id: DCAM_PPTY_OPTICAL_FILTER, 
	  unicap_property: { identifier: N_("optical_filter"),  
						 category: DCAM_CAT_VIDEO, 
						 unit: DCAM_UNIT_NONE, 
						 relations: dcam_optical_filter_relations, 
						 relations_count: sizeof( dcam_optical_filter_relations ) / sizeof( char * ),
						 { value: 0.0 }, 
						 { range: { min: 0.0, 
									max: 0.0 } },  
						 stepping: 0.0,  
						 type: UNICAP_PROPERTY_TYPE_RANGE, 
						 flags: UNICAP_FLAGS_MANUAL, 
						 flags_mask: PPTY_MASK, 
						 property_data: NULL, 
						 property_data_size: 0 }, 
	  register_offset: 0x08c, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_BRIGHTNESS,
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_brightness_property, 
	  feature_hi_mask: 0, 
	  feature_lo_mask: 1<<28,
	},
	
	{ id: DCAM_PPTY_CAPTURE_QUALITY, 
	  unicap_property: { identifier: N_("capture_quality"), 
						 category: DCAM_CAT_VIDEO, 
						 unit: DCAM_UNIT_NONE, 
						 relations: dcam_capture_quality_relations, 
						 relations_count: sizeof( dcam_capture_quality_relations ) / sizeof( char * ),
						 { value: 0.0 }, 
						 { range: { min: 0.0, 
									max: 0.0 } },  
						 stepping: 0.0,  
						 type: UNICAP_PROPERTY_TYPE_RANGE, 
						 flags: UNICAP_FLAGS_MANUAL, 
						 flags_mask: PPTY_MASK, 
						 property_data: NULL, 
						 property_data_size: 0 }, 
	  register_offset: 0x0c4, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_BRIGHTNESS,
	  set_function: dcam_set_property,
	  get_function: dcam_get_property,
	  init_function: dcam_init_brightness_property, 
	  feature_hi_mask: 0, 
	  feature_lo_mask: 1<<15,
	},
	
	{ id: DCAM_PPTY_FRAME_RATE, 
	  unicap_property: { identifier: N_("frame rate"),
						 category: DCAM_CAT_VIDEO, 
						 unit: DCAM_UNIT_NONE, 
						 relations: dcam_frame_rate_relations, 
						 relations_count: sizeof( dcam_frame_rate_relations ) / sizeof( char * ), 
						 { value: 0.0 },
						 { range: { min: 0.0, 
									max: 0.0 } },
						 stepping: 0.0, 
						 type: UNICAP_PROPERTY_TYPE_VALUE_LIST, 
						 flags: UNICAP_FLAGS_MANUAL, 
						 flags_mask: UNICAP_FLAGS_MANUAL, 
						 property_data: NULL, 
						 property_data_size: 0 }, 
	  register_offset: 0, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_FRAMERATE, 
	  set_function: dcam_set_frame_rate_property, 
	  get_function: dcam_get_frame_rate_property, 
	  init_function: dcam_init_frame_rate_property, 
	  feature_hi_mask: 0xffffffff, 
	  feature_lo_mask: 0xffffffff,
	}, 
	
	{ id: DCAM_PPTY_RW_REGISTER, 
	  unicap_property: { identifier: /* TRANSLATORS: Camera
					    hardware register */
			     N_("register"), 
			     category: DCAM_CAT_VIDEO, 
			     unit: DCAM_UNIT_NONE, 
			     relations: dcam_register_relations, 
			     relations_count: sizeof( dcam_register_relations ) / sizeof( char * ), 
			     { value: 0.0 }, 
			     { range: { min: 0.0, 
					max: 0.0 } }, 
			     stepping: 0.0, 
			     type: UNICAP_PROPERTY_TYPE_DATA, 
			     flags: UNICAP_FLAGS_MANUAL, 
			     flags_mask: UNICAP_FLAGS_MANUAL, 
			     property_data: NULL, 
			     property_data_size: 0 }, 
	  register_offset: 0, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_REGISTER, 
	  set_function: dcam_set_property, 
	  get_function: dcam_get_property, 
	  init_function: dcam_init_rw_register_property, 
	  feature_hi_mask: 0xffffffff, 
	  feature_lo_mask: 0xffffffff,
	},		  
	
	{ id: DCAM_PPTY_TIMEOUT, 
	  unicap_property: { identifier: N_("timeout"), 
						 category: DCAM_CAT_DEVICE, 
						 relations: dcam_timeout_relations, 
						 relations_count: sizeof( dcam_timeout_relations ) / sizeof( char * ), 
						 { value: 1.0 }, 
						 { range: { min: 0.0, 
									max: 600.0 } }, 
						 stepping: 1.0, 
						 type: UNICAP_PROPERTY_TYPE_RANGE, 
						 flags: UNICAP_FLAGS_MANUAL, 
						 flags_mask: UNICAP_FLAGS_MANUAL, 
						 property_data: NULL, 
						 property_data_size: 0 }, 
	  register_offset: 0, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_REGISTER, 
	  set_function: dcam_set_timeout_property, 
	  get_function: dcam_get_timeout_property, 
	  init_function: dcam_init_timeout_property, 
	  feature_hi_mask: 0xffffffff, 
	  feature_lo_mask: 0xffffffff,
	},		  
	
	{ id: DCAM_PPTY_GPIO, 
	  unicap_property: { identifier: N_("gpio"), 
						 category: DCAM_CAT_DEVICE, 
						 relations: dcam_timeout_relations, 
						 relations_count: sizeof( dcam_timeout_relations ) / sizeof( char * ), 
						 { value: 0.0 }, 
						 { range: { min: 0.0, 
									max: 0.0 } }, 
						 stepping: 1.0, 
						 type: UNICAP_PROPERTY_TYPE_DATA, 
						 flags: UNICAP_FLAGS_MANUAL, 
						 flags_mask: UNICAP_FLAGS_MANUAL, 
						 property_data: NULL, 
						 property_data_size: 0 }, 
	  register_offset: 0x38, 
	  register_inq: 0, 
	  register_default: 0, 
	  register_value: 0, 
	  type: PPTY_TYPE_REGISTER, 
	  set_function: dcam_set_gpio_property, 
	  get_function: dcam_get_gpio_property, 
	  init_function: dcam_init_gpio_property, 
	  feature_hi_mask: 0xffffffff, 
	  feature_lo_mask: 0xffffffff,
	},

	{
		id: DCAM_PPTY_END
	}
};
	

#endif//__DCAM_PROPERTY_TABLE_H__
