/***************************************************************************
				structCopyList.h
			      --------------------

     Begin        : Thu May 14 2009 16:35 alpha_one_x86
     Project      : Ultracopier
     Email        : ultracopier@first-world.info
     Note         : See README for copyright and developer
     Target       : Define the class struct of copy

****************************************************************************/

#include <QList>
#include <QIcon>
#include <QString>
#include <QStringList>
#include <QFileInfo>
#include <QByteArray>
#include <QLocalSocket>

#ifndef STRUCTDEF_H
#define STRUCTDEF_H

class Main_window;

//the structures
typedef struct {
	quint64		id;
	QFileInfo	source;
	qint64		size;
	QFileInfo	destination;
} copyItemInternal;

typedef struct {
	QList<int>	idsRemove;
	QList<int>	idsAction;
} returnIdsTransaction;

typedef struct {
	QLocalSocket * idSocket;
	QByteArray data;
	qint32 size;
	quint32 copyId;
} composedData;

typedef struct {
	Main_window * window;
	quint32 copyId;
	QLocalSocket * client;
	quint32 protocolVersionOfThisQuery;
} composedCommandId;

typedef struct {
	int		error_code;
	QString		error_file;
	QString		error_string;
	quint64		error_itemId;
} writeThreadError;

typedef struct {
	QString		file;
	QStringList	shortName;
	QString		fullName;
	QIcon		image;
} translatorLang;

#endif // STRUCTDEF_H
