/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifdef _WIN32
// --- source code from pidgin project.
// This is for ATTACH_PARENT_PROCESS
#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x501
#endif

#define _CRT_SECURE_NO_WARNINGS		1
#include <io.h>
#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#endif  // _WIN32


#include <stdlib.h>		// exit(), EXIT_SUCCESS, EXIT_FAILURE
#include <string.h>
#include <signal.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// glib, gtk+
#include <gmodule.h>
#include <gtk/gtk.h>

// uget
#include <ug_utils.h>
#include <ug_ipc.h>
#include <uget.h>

// GStreamer
#if defined (HAVE_GSTREAMER) && HAVE_GSTREAMER == 1
#include <gst/gst.h>
gboolean	gst_inited	= FALSE;
#endif  // HAVE_GSTREAMER

// I18N
#ifndef GETTEXT_PACKAGE
#define GETTEXT_PACKAGE		"uget"
#endif

#include <glib/gi18n.h>

// path
gchar*			uget_path_icons		= NULL;
gchar*			uget_path_locale	= NULL;
gchar*			uget_path_pixmaps	= NULL;
gchar*			uget_path_sounds	= NULL;
// other global data
Uget*			app;
UgIpc			uget_ipc;

#ifdef _WIN32
static void uget_path_init (void)
{
	gchar*		path;
	gchar*		path_prog;
	gunichar2*	path_wcs;
	HMODULE		hmod;

	hmod = GetModuleHandle (NULL);
	// UNICODE
	path_wcs = g_malloc (sizeof (wchar_t) * MAX_PATH);
	GetModuleFileNameW (hmod, path_wcs, MAX_PATH);
	path = g_utf16_to_utf8 (path_wcs, -1, NULL, NULL, NULL);
	g_free (path_wcs);
	path_prog = g_path_get_dirname (path);
	g_free (path);

	uget_path_icons   = g_build_filename (path_prog, "icons",  NULL);
	uget_path_locale  = g_build_filename (path_prog, "locale",  NULL);
	uget_path_pixmaps = g_build_filename (path_prog, "pixmaps", NULL);
	uget_path_sounds  = g_build_filename (path_prog, "sounds",  NULL);
	g_free (path_prog);
}
#else
static void uget_path_init (void)
{
#ifdef DATADIR
	uget_path_icons   = DATADIR "/icons";
	uget_path_locale  = DATADIR "/locale";
	uget_path_pixmaps = DATADIR "/pixmaps";
	uget_path_sounds  = DATADIR "/sounds";
#endif
}
#endif


#if defined (_WIN32) && defined (_WINDOWS)
static void atexit_callback (void)
{
	FreeConsole ();
}

typedef BOOL (CALLBACK* LPFNATTACHCONSOLE)(DWORD);
static	void	win32_create_console ()
{
	LPFNATTACHCONSOLE	MyAttachConsole;
	HMODULE		hmod;

	// --- source code from pidgin project.
	// If stdout hasn't been redirected to a file, alloc a console
	//  (_istty() doesn't work for stuff using the GUI subsystem)
	if (_fileno(stdout) == -1 || _fileno(stdout) == -2) {
		MyAttachConsole = NULL;
#ifdef UNICODE
		if ((hmod = GetModuleHandle(L"kernel32.dll")))
#else
		if ((hmod = GetModuleHandle("kernel32.dll")))
#endif
		{
			MyAttachConsole =
				(LPFNATTACHCONSOLE)
				GetProcAddress(hmod, "AttachConsole");
		}
		if ((MyAttachConsole && MyAttachConsole(ATTACH_PARENT_PROCESS))
				|| AllocConsole())
		{
			freopen("CONOUT$", "w", stdout);
			freopen("CONOUT$", "w", stderr);
			atexit (atexit_callback);
		}
	}
}
#endif	// End of _WIN32 & _WINDOWS

// SIGTERM
static void term_signal_handler (int sig)
{
	// This will quit  gtk_main()  to  main()
	uget_quit (app);
}

int		main (int argc, char* argv[])
{
	GOptionContext*	context;
	GOptionGroup*	group;
	gint			count;
	gint			arg_len;

	// path
	uget_path_init ();

	// I18N
#ifdef LOCALEDIR
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#else
	bindtextdomain (GETTEXT_PACKAGE, uget_path_locale);
#endif
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);

	// glib
	if (g_thread_supported () == FALSE)
		g_thread_init (NULL);
	if (g_module_supported () == FALSE)
		return FALSE;
	// uget library
	if (ug_global_init () == FALSE)
		return EXIT_FAILURE;
	context = g_option_context_new ("[URL]");
	group	= g_option_group_new (NULL, NULL, NULL, NULL, NULL);
	ug_option_set_group (UgOptionMain, group);
	g_option_context_set_main_group (context, group);
	g_option_context_add_group (context, gtk_get_option_group (TRUE));
//	g_option_context_set_ignore_unknown_options (context, TRUE);
//	g_option_context_set_help_enabled (context, TRUE);

	// gtk+
	gtk_init (&argc, &argv);

	// handle help option
	for (count=1; count < argc; count++) {
		// check "--help" & "-?"
		arg_len = strlen (argv[count]);
#ifdef _WIN32
		// Check and remove some character (space,0x20) in tail of argument from command line.
		// This problem only happen in Windows platform.
		ug_str_clear_tail_charset (argv[count], arg_len, " \n");
#endif
		if (arg_len == 2) {
			if (strncmp (argv[count], "-?", 2) != 0)
				continue;
		}
		else if (arg_len >= 6) {
			if (strncmp (argv[count], "--help", 6) != 0)
				continue;
		}
		else
			continue;
#if defined (_WIN32) && defined (_WINDOWS)
		win32_create_console ();
#endif
		g_option_context_parse (context, &argc, &argv, NULL);
//		return EXIT_SUCCESS;	// EXIT_SUCCESS == 0
	}

#if defined(HAVE_GSTREAMER) && HAVE_GSTREAMER == 1
	// initialize the GLib thread system using g_thread_init() before any other GLib functions are called.
	gst_inited = gst_init_check (&argc, &argv, NULL);
#endif

	// IPC
	if (ug_ipc_init_server (&uget_ipc) == FALSE) {
		gboolean	workable;

		// connecting to server if server already exist.
		workable = ug_ipc_init_client (&uget_ipc);
		// try to send command-line options
		for (count=0;  count<3;  count++) {
			if (workable == FALSE) {
				g_usleep (500 *1000);
				workable = ug_ipc_init_client (&uget_ipc);
				continue;
			}
			if (ug_ipc_ping (&uget_ipc) == FALSE) {
				g_usleep (500* 1000);
				continue;
			}
			ug_ipc_send (&uget_ipc, argc, argv);
			return EXIT_SUCCESS;
		}
		ug_ipc_finalize (&uget_ipc);
	}

	// Uget
	app = uget_new (&uget_ipc);
	uget_run (app);
	uget_notification_init ();		// notification
	g_option_context_set_ignore_unknown_options (context, TRUE);
	g_option_context_set_help_enabled (context, FALSE);
	app->option_context = context;
	app->option_group = group;
	if (argc > 1)
		uget_parse_option (app, argc, argv);

	if (app->start_in_tray == FALSE)
		gtk_widget_show (GTK_WIDGET (app->window));

	signal (SIGTERM, term_signal_handler);
	gdk_threads_enter ();
	gtk_main ();
	gdk_threads_leave ();

	uget_notification_finalize ();	// notification
	ug_global_finalize ();

	return EXIT_SUCCESS;		// EXIT_SUCCESS == 0
}


#if defined (_WIN32) && defined (_WINDOWS)

int WINAPI WinMain (HINSTANCE hThisInstance,
                    HINSTANCE hPrevInstance,
                    LPSTR lpszArgument,
                    int nFunsterStil)
{
	return  main (__argc, __argv);
}

#endif	// End of _WIN32 & _WINDOWS

