/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifndef UG_IPC_H
#define UG_IPC_H

#include <glib.h>

#ifdef _WIN32
# include <winsock.h>
#else	// UNIX
# include <sys/un.h>        // struct sockaddr_un
#define SOCKET			int
#endif

#define UGET_SOCKET_PORT		14777
#define UGET_SOCKET_PORT_S		"14777"
#define UGET_SOCKET_NAME		"uget_ipc"
#define UGET_SOCKET_HEADER_S	"UG"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct	UgIpc_			UgIpc;
typedef enum	UgIpcCode_		UgIpcCode;
typedef void	(*UgIpcArgFunc) (gpointer data, int argc, char** argv);

struct UgIpc_ {
	GIOChannel*		channel;

	// server
	UgIpcArgFunc	argument_func;
	gpointer		argument_data;

	// UNIX
	gchar*			filename;
};

enum UgIpcCode_ {
	UG_IPC_ERROR,
	UG_IPC_OK,
	UG_IPC_BUSY,
	UG_IPC_PING,
	UG_IPC_SEND,
};

gboolean	ug_ipc_init_server (UgIpc* ipc);
gboolean	ug_ipc_init_client (UgIpc* ipc);
void		ug_ipc_finalize (UgIpc* ipc);

// client
gboolean	ug_ipc_ping (UgIpc* ipc);
gboolean	ug_ipc_send (UgIpc* ipc, int argc, char** argv);

#endif	// UG_IPC_H

