#ifndef INCLUDED_TIGER_H
#define INCLUDED_TIGER_H
/* vim:ts=4:sw=4:noet
 * (tabspace=4)
 * 
 * Copyright (C) 2004, 2005 Walter Doekes, <walter@djcvt.net>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "types.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/**
 * The Tiger Hash function.
 * Supply an octet-stream as an uint64_t* and the length of the octet stream.
 * The last parameter, res, must be large enough to hold 3 uint64_t's.
 */
void tiger(const uint64_t* str, uint64_t length, uint64_t* res);

/**
 * The Tiger Hash function, modified to prepend the specified byte to the input
 * data. This is useful for the THEX algorithm which prepends a 0x00 to leaf
 * nodes and 0x01 to the hash nodes.
 * (This way we won't have to copy the input data to a new buffer.)
 * See tiger() for details of the other arguments.
 */
void tiger_bp(uint8_t prepend, const uint64_t* str, uint64_t length,
		uint64_t* res);

#ifdef __cplusplus
} /* extern "C" */
#endif /* __cplusplus */

#endif /* INCLUDED_TIGER_H */
