#include <jvmti.h>
#include <tijmp.h>
#include <tag_list.h>

extern jvmtiEnv* jvmti;

jint is_tijmp_class (jlong tag, tag_list* tl) {
    jint i;
    for (i = 0; i < tl->next_pos; i++)
	if (tag == tl->tags[i])
	    return 1;
    return 0;
}

void find_tijmp_classes (JNIEnv* env, tag_list* tijmp_classes) { 
    jvmtiError err;
    jint class_count;
    jclass* classes;
    jclass cls;
    jint i, j;
    jmethodID get_name;
    jsize len;
    jchar tijmp_chars[] = {'t', 'i', 'j', 'm', 'p', '.'};

    cls = (*env)->FindClass (env, "java/lang/Class");
    get_name = (*env)->GetMethodID (env, cls, "getName", 
				    "()Ljava/lang/String;");
    err = (*jvmti)->GetLoadedClasses (jvmti, &class_count, &classes);
    for (i = 0; i < class_count; i++) {
	jstring s = (*env)->CallObjectMethod (env, classes[i], get_name);
	len = (*env)->GetStringLength (env, s);
	if (len > 5) {
	    const jchar* chars = (*env)->GetStringCritical (env, s, NULL);
	    for (j = 0; j < 6; j++) {
		if (chars[j] != tijmp_chars[j])
		    break;
	    }
	    (*env)->ReleaseStringCritical (env, s, chars);
	    if (j == 6) {
		jlong tag;
		err = (*jvmti)->GetTag (jvmti, classes[i], &tag);
		add_tag (tijmp_classes, tag);
	    }
	}
    }
    (*jvmti)->Deallocate (jvmti, (unsigned char*)classes);
}
