#include <stdlib.h>
#include <jni.h>
#include <tijmp_TIJMPController.h>
#include <gc.h>
#include <walk_heap.h>
#include <find_owners.h>
#include <find_child_objects.h>

JNIEXPORT void JNICALL 
TIJMPController_runGC (JNIEnv *env, jclass c) {
    force_gc ();
}

JNIEXPORT void JNICALL 
TIJMPController_walkHeap (JNIEnv *env, jclass c) {
    walk_heap (env);
}

JNIEXPORT void JNICALL 
TIJMPController_showInstances (JNIEnv *env, jclass c, jclass clz) {
    find_all_instances (env, clz);
}

JNIEXPORT void JNICALL 
TIJMPController_showOwners (JNIEnv *env, jclass c, jclass clz) {
    find_and_show_owners (env, clz);
}

JNIEXPORT void JNICALL 
TIJMPController_childObjectsSummary (JNIEnv *env, jclass c, jobject o) {
    find_all_child_objects (env, o);
}

JNIEXPORT jobjectArray JNICALL 
TIJMPController_getObjectsForTags (JNIEnv *env, jclass c, jlongArray la) {
    return get_objects_for_tags (env, la);
}
