#include <stdio.h>
#include <jvmti.h>
#include <tijmp.h>
#include <gc.h>

/* TODO: handle parallell gc, one start per thread? */
static jlong nanos_start;
extern jvmtiEnv *jvmti;

void JNICALL gc_start (jvmtiEnv *jvmti_env) {
    jvmtiError err;
    err = (*jvmti)->GetTime(jvmti, &nanos_start);
}

void JNICALL gc_finish (jvmtiEnv *jvmti_env) {
    jvmtiError err;
    jlong nanos_end;
    jlong diff;
    jdouble millis;

    err = (*jvmti)->GetTime(jvmti, &nanos_end);
    diff = nanos_end - nanos_start;
    millis = ((jdouble)diff) / 1000000;
    fprintf (stdout, "tijmp: gc took: %0.5f millis\n", millis);
}

void JNICALL force_gc (void) {
    jvmtiError err;
    err = (*jvmti)->ForceGarbageCollection (jvmti);
    if (err != JVMTI_ERROR_NONE) {
	handle_global_error (err);
	/* TODO: do we want to throw an exception? */
    }
}
