C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=SMFLUS,SSI=0
C
                     SUBROUTINE SMFLUS
C                    *****************
C
C     ---------------------------------------------------
     *( NCOUPS,VCOUPS,NFLUSS,VFLUSS,NECHS,VECHS,
     *  NRESCS,VRESCS,
     *  NRAYTS,VRAYTS,NBRAYS,
     *  NRAYIS,VRAYIS,NBRAIS,
     *  TMPSA,B,NODEUS,COORDS,SURFUS, 
     *  NPOINS,NELEMS,NDIM,NELEUS,NDMASS,
     *  NBCOUS,NBFLUS,NBECHS,NBRESS,
     *  TRAV,TRAV4,DIAG,TRAV2,WCT )
C     ---------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     CALCUL DU SECOND MEMBRE                           *
C                    PRISE EN COMPTE DES FLUX DE BORD                  *
C                                                                      *
C      Les flux au bord du solide sont de trois types:                 *
C          Flux dus au couplage thermique fluide -solide               *
C          Flux imposes par l'utilisateur                              *
C          Flux ayant pour origine un coefficient d'echange            *
C          Flux ayant pour origine une resitance de contact            *
C          Flux ayant pour origine un rayonnement                      *
C                                                                      *
C          Le flux est impose sur les noeuds definis par l'utilisateur *
C                                                                      *
C     Deux options sont envisageables :                                *
C          une option implicite (qui ameliore le traitement en temps)  *
C          une option explicite (qui ameliore le traitement en espace) *
C                                                                      *
C      En 2D:                                                          *
C      ------              /                                           *
C                 B = B + /     q .  Phj  dS                           *
C                        /                                             *
C                 q est discretise  en iso-P2                          *
C                 dS element de longueur                               *
C                 Phj fonction de base iso-P2                          *
C                                                                      *
C      En 3D:                                                          *
C      ------              /                                           *
C                 B = B + /     q .  Phj  dS                           *
C                        /                                             *
C                 q est discretises en iso-P2                          *
C                 dS element de surface                                *
C                 Phj fonction de base iso-P2                          *
C                                                                      *
C  Rq : Lorsque le flux n'est pas defini, cela revient a dire          *
C       implicitement que ce flux est nul.                             *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   NCOUPS  !  TR  ! D  ! NUMERO DES POINTS DE COUPLAGE            !
C   !   VCOUPS  !  TR  ! D  ! VALEUR DU FLUX AU POINT DE COUPLAGE      !
C   !   NFLUSS  !  TR  ! D  ! NUMERO DES POINTS DE FLUX SURFACIQUE     !
C   !   VFLUSS  !  TR  ! D  ! VALEUR DU FLUX AU POINT DE FLUX          !
C   !   NECHS   !  TR  ! D  ! NUMERO DES POINTS DE COEF D'ECHANGE      !
C   !   VECHS   !  TR  ! D  ! VALEUR POUR LES POINTS A COEF D'ECHANGE  !
C   !           !  TR  ! D  !     VECHS(n,1) = Temperature exterieure  !
C   !           !  TR  ! D  !     VECHS(n,2) = Coef d'echange          !
C   !   B       !  TR  ! R  ! SECOND MEMBRE                            !
C   !   NODEUS  !  TE  ! D  ! NOEUDS DE BORD( LOCALE 2D --> GLOBALE 3D)!
C   !   SURFUS  !  TR  ! D  ! EN 3D SURFACE DU TRIANGLE DE BORD (flux) !
C   !           !      !    ! EN 2D LONGUEUR DU SEGMENT DE BORD (flux) !
C   !   COORDS  !  TR  ! D  ! COORDONNEES DES NOEUDS DU MAILLAGE       !
C   !   TRAV    !  TR  ! R  ! TABLEAU DE TRAVAIL (npmxs)               !
C   !   W1...W6 !  TR  ! M  ! TABLEAUX DE TRAVAIL. ATTENTION On utilise!
C   !           !      !    ! uniquement les NELEBS premieres cases    !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ????
C                                     ????
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : ????
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "rayonn.h"
#include "syrth.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NPOINS,NELEMS,NDIM,NELEUS,NDMASS
      INTEGER NBCOUS,NBFLUS,NBECHS,NBRESS,NBRAYS
      INTEGER NCOUPS(NBCOUS),NFLUSS(NBFLUS),NECHS(NBECHS)
      INTEGER NODEUS(NELEUS,NDMASS)
      INTEGER NRESCS(NBRESS,2),NRAYTS(NBRAYS)
      INTEGER NBRAIS,NRAYIS(NBRAIS)
      DOUBLE PRECISION VRAYIS(NBRAIS,2)
      DOUBLE PRECISION VCOUPS(NBCOUS,2),VFLUSS(NBFLUS),VECHS(NBECHS,2)
      DOUBLE PRECISION VRESCS(NBRESS,2),VRAYTS(NBRAYS,2)
      DOUBLE PRECISION B(NPOINS),TRAV(NPOINS),TRAV4(NPOINS)
      DOUBLE PRECISION DIAG(NPOINS),TRAV2(NPOINS)
      DOUBLE PRECISION COORDS(NPOINS,NDIM),TMPSA(NPOINS)
      DOUBLE PRECISION WCT(NELEMS,NDMASS)
      DOUBLE PRECISION SURFUS(NELEUS)   
C
C..Variables internes
      DOUBLE PRECISION R1,R2
      DOUBLE PRECISION F1,F2,F3,F4,F5,F6
      INTEGER I,INODE,NCA
      INTEGER N1,N2,N3,N4,N5,N6
      DOUBLE PRECISION S48,SV48,S12,SV12
      DOUBLE PRECISION ZERO
      DOUBLE PRECISION HRAYI,HRAYT
C
C***********************************************************************
C
C     1- INITIALISATIONS
C     ==================
      IF (NBCOUS
     *   .EQ.0 .AND. .NOT. LSYRTH)
     *    NBCOUS = NPOINS
C
      ZERO   = 0.D0
      IF (IAXISY.EQ.1) THEN
         NCA=2
      ELSE
         NCA=1
      ENDIF
C
      CALL OV ( 'X=C     ',TRAV,TRAV,TRAV,ZERO,NPOINS )
      CALL OV ( 'X=C     ',TRAV2,TRAV2,TRAV2,ZERO,NPOINS )
C
C     Coefficients
      S48 = 1.D0 / 48.D0
      S12  = 1.D0 / 12.D0
C
C     2- CALCUL DES CONDITIONS SUR LES POINTS DE BORD CONCERNES
C     =========================================================
C
C
C     2.1 Prise en compte explicite
C     -----------------------------
      IF ( LCLEXP ) THEN
C
          DO 211 I=1,NBCOUS
             INODE = NCOUPS(I)
             TRAV(INODE) = TRAV(INODE) + 
     &                     VCOUPS(I,2)*(VCOUPS(I,1)-TMPSA(INODE))
  211     CONTINUE
C
          DO 212 I=1,NBFLUS
             INODE = NFLUSS(I)
             TRAV(INODE) = TRAV(INODE) + VFLUSS(I)
  212     CONTINUE          
C
          DO 213 I=1,NBECHS
             INODE = NECHS(I)
             TRAV(INODE) = TRAV(INODE) + 
     &                     VECHS(I,2) * (VECHS(I,1)-TMPSA(INODE))
  213     CONTINUE
C
C         NRESCS(I,1) contient le numero global du noeud
C
          DO 214 I=1,NBRESS
             INODE = NRESCS(I,1)
             TRAV(INODE) = TRAV(INODE) + 
     &                     VRESCS(I,2) * (VRESCS(I,1)-TMPSA(INODE))
  214     CONTINUE
C
C         
          DO 215 I=1,NBRAIS
             INODE = NRAYIS(I)
             HRAYI = VRAYIS(I,2)*SIGMA*
     &              (TMPSA(INODE)+VRAYIS(I,1)+2*TKEL)*
     &              ((TMPSA(INODE)+TKEL) * (TMPSA(INODE)+TKEL) +
     &               (VRAYIS(I,1)+TKEL)  * (VRAYIS(I,1)+TKEL) )
             TRAV(INODE) = TRAV(INODE) + 
     &                      HRAYI * (VRAYIS(I,1)-TMPSA(INODE))
  215     CONTINUE
C 
C         
          DO 216 I=1,NBRAYS
             INODE = NRAYTS(I)
             HRAYT = VRAYTS(I,2)*SIGMA*
     &               (TMPSA(INODE)+VRAYTS(I,1)+2*TKEL)*
     &               ((TMPSA(INODE)+TKEL) * (TMPSA(INODE)+TKEL) + 
     &                (VRAYTS(I,1) +TKEL) * (VRAYTS(I,1)+TKEL) )
             TRAV(INODE) = TRAV(INODE) + 
     &                      HRAYT * (VRAYTS(I,1)-TMPSA(INODE))
  216     CONTINUE
C
C
C     2.2 Prise en compte implicite des conditions d'echange
C     ------------------------------------------------------
      ELSE
C
Cessai       CALL OV ( 'X=C     ',TRAV,TRAV,TRAV,TMPSA,NPOINS )
C
        DO 221 I=1,NBCOUS
            INODE = NCOUPS(I)
            TRAV(INODE) = VCOUPS(I,1)
  221   CONTINUE
C
        DO 223 I=1,NBECHS
            INODE = NECHS(I)
            TRAV(INODE) = VECHS(I,1)
  223   CONTINUE
C
C
        DO 224 I=1,NBRESS
            INODE = NRESCS(I,1)
            TRAV(INODE) =  VRESCS(I,1)
  224   CONTINUE
C
C         
        DO 225 I=1,NBRAIS
            INODE = NRAYIS(I)
c            HRAYI = VRAYIS(I,2)*SIGMA*
c     &              (TMPSA(INODE)+VRAYIS(I,1)+2*TKEL)*
c     &              ((TMPSA(INODE)+TKEL) * (TMPSA(INODE)+TKEL) +
c     &               (VRAYIS(I,1)+TKEL)  * (VRAYIS(I,1)+TKEL) )
            TRAV2(INODE) = VRAYIS(I,1)
  225   CONTINUE
C 
C         
        DO 226 I=1,NBRAYS
            INODE = NRAYTS(I)
c            HRAYT = VRAYTS(I,2)*SIGMA*
c     &               (TMPSA(INODE)+VRAYTS(I,1)+2*TKEL)*
c     &               ((TMPSA(INODE)+TKEL) * (TMPSA(INODE)+TKEL) + 
c     &                (VRAYTS(I,1) +TKEL) * (VRAYTS(I,1)+TKEL) )
            TRAV2(INODE) = VRAYTS(I,1)
  226   CONTINUE
C 
C
        DO 227 I=1,NPOINS
            B(I) = B(I) + TRAV4(I) * TRAV(I) + DIAG(I) * TRAV2(I)
  227   CONTINUE
C
      IF ( NBLBLA.EQ.12 ) THEN
        WRITE(NFECRA,2228)
        DO 2229 I=1,NPOINS
          WRITE(NFECRA,2230) I,B(I),TRAV4(I)*TRAV(I),DIAG(I)*TRAV2(I)
 2229   CONTINUE
      ENDIF
C
C       2.3.1- Prise en compte des flux exterieurs 
C       ----------------------------------------
C
        CALL OV ( 'X=C     ',TRAV,TRAV,TRAV,ZERO,NPOINS )
        DO 231 I=1,NBFLUS
            TRAV(NFLUSS(I)) = VFLUSS(I)
  231   CONTINUE          
C
C         
      ENDIF
C
C               
C     3- CALCUL DU VECTEUR ELEMENTAIRE 
C     ================================
      IF (  LCLEXP .OR. NBFLUS.GT.0 ) THEN
C
C         3.1- Cas 2D
C         -----------
          IF ( NDIM .EQ. 2 ) THEN
C
C             3.1.1- Cas cartesien
C             --------------------
              IF  (IAXISY.EQ.0)  THEN
C
                   DO 311 I=1,NELEUS
C
                     N1 = NODEUS(I,1)
                     N2 = NODEUS(I,2)
                     N3 = NODEUS(I,3)
C
                     SV12 = S12 * SURFUS(I)      
C
                     F1  = TRAV(N1) * SV12
                     F2  = TRAV(N2) * SV12
                     F3  = TRAV(N3) * SV12
C                  
                     WCT(I,1) = F3+2*F1
                     WCT(I,2) = F3+2*F2
                     WCT(I,3) = 4*F3+F1+F2               
  311              CONTINUE
C
C             3.1.2- Cas axisymetrique
C             ------------------------
              ELSE
              
                   DO 312 I=1,NELEUS
C
C                    Calcul des indices globaux
                     N1 = NODEUS(I,1)
                     N2 = NODEUS(I,2)
                     N3 = NODEUS(I,3)
C
                     SV48 = S48 * SURFUS(I)
C
                     R1 = ABS( COORDS(N1,NCA) )
                     R2 = ABS( COORDS(N2,NCA) )        
C
                     F1  = TRAV(N1) * SV48
                     F2  = TRAV(N2) * SV48
                     F3  = TRAV(N3) * SV48
C                  
                     WCT(I,1) = R2*F3+R2*F1+3*R1*F3+7*R1*F1 
                     WCT(I,2) = 3*R2*F3+7*R2*F2+R1*F3+R1*F2 
                     WCT(I,3) = 8*R2*F3+R2*F1+8*R1*F3+3*R1*F1
     &                       +3*R2*F2+R1*F2 
C   
  312              CONTINUE
C              
              ENDIF
C                         
C         3.2- Cas 3D
C         -----------          
          ELSE
                   DO 320 I=1,NELEUS
C
                   N1 = NODEUS(I,1)
                   N2 = NODEUS(I,2)
                   N3 = NODEUS(I,3)
                   N4 = NODEUS(I,4)
                   N5 = NODEUS(I,5)
                   N6 = NODEUS(I,6)
C
                   SV48 = S48 * SURFUS(I)                      
C            
                   F1  = TRAV(N1) * SV48
                   F2  = TRAV(N2) * SV48
                   F3  = TRAV(N3) * SV48
                   F4  = TRAV(N4) * SV48
                   F5  = TRAV(N5) * SV48
                   F6  = TRAV(N6) * SV48          
C
C
                   WCT(I,1) =  2 * F1 + F4 + F6 
                   WCT(I,2) =  2 * F2 + F4 + F5 
                   WCT(I,3) =  2 * F3 + F5 + F6 
                   WCT(I,4) =  F1 + F2 + 6 * F4 + 2 * F5 + 2 * F6
                   WCT(I,5) =  F2 + F3 + 2 * F4 + 6 * F5 + 2 * F6
                   WCT(I,6) =  F1 + F3 + 2 * F4 + 2 * F5 + 6 * F6
C
  320 CONTINUE
C
          ENDIF
C
          CALL OV ( 'X=C     ',TRAV,TRAV,TRAV,ZERO,NPOINS )
          CALL ASSEUS ( TRAV,NODEUS,NELEMS,NELEUS,NPOINS,NDMASS,
     &                  NDIM,WCT)
C
C
C     4- MISE A JOUR DU SECOND MEMBRE
C     =============================== 
C
      DO 400 I=1,NPOINS
          B(I) = B(I) + TRAV(I)
  400 CONTINUE
C  
C
      ENDIF
C
C     5- IMPRESSIONS POUR CONTROLE
C     ============================
C
      IF ( NBLBLA.GE.11 ) THEN
        WRITE(NFECRA,5000)
        DO 500 I=1,NPOINS
          WRITE(NFECRA,5010) I,B(I),TRAV(I)
  500   CONTINUE
      ENDIF
C
C--------
C FORMATS
C--------
 2228 FORMAT(/,' *** SMFLUS : SECOND MEMBRE (PARTIE IMPLICITE)',/,
     &         '        NOEUD       SECOND MEMBRE     ECHANGE   ',
     &           '       RAYONNEMENT')
 2230 FORMAT(7X,I6,5X,G10.4,5X,G10.4,5X,G10.4)
 5000 FORMAT(/,' *** SMFLUS : SECOND MEMBRE (PARTIE FLUX)',/,
     &         '        NOEUD       SECOND MEMBRE     FLUX AJOUTE   ',
     &           '       CL ECHANGE IMPLI')
 5010 FORMAT(7X,I6,5X,G10.4,5X,G10.4)
C                             
      END
