C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE PASRAY
C                       *****************
C
C      ---------------------------------------------------------
     * (MODE,
     *  NDIM,NPOINR,NBRAYS,NRAYTS,VRAYTS,NBRAF,NRAPF,VRAPF,NRFRAY,
     *  ITYFAR,NELRAY,NODRAY,NELRAF,NDMASF,NELERA,NDMASS,NODERA,
     *  NODRAF,NNSRAY,NNFRAY,NFCFRA,NGFPEF,NCSRAY,NCFRAY,
     *  NCFIN,NCGROS,BARYGR,NCFINF,NCGROF,BARYFR,BARYFF,BARYFS,
     *  TEMRAY,FIRAY,ERAYEQ,TRAYEQ,PHFRAF,TRAYEN,ERAYEN,SUFRAY,
     *  ITRAV,TRAV,TRAV3,TRAV4)
C      ---------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            PASSAGE DES DONNEES ENTRE LE RAYONNEMENT ET               *
C              - le fluide                                             *
C              - le solide                                             *
C            EN DIMENSION 3                                            *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  MODE     !  E ! D  ! SENS DE L'INTERPOLATION                      !
C !           !    !    !   = 1 PASSAGE SOLIDE --> FLUIDE              !
C !           !    !    !   = 2 PASSAGE FLUIDE --> SOLIDE              !
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME                        !
C !  NBCOUF   !  E ! D  ! NOMBRE DE NOEUDS FLUIDES COUPLES             !
C !  VCOUPF   ! TR !D M ! VALEUR AUX NOEUDS FLUIDES COUPLES            !
C !  NBCOUS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES COUPLES             !
C !  VCOUPS   ! TR !D M ! VALEUR AUX NOEUDS SOLIDES COUPLES            !
C !  NELESF   !  E ! D  ! NOMBRE D'ELEMENTS FLUIDES COUPLES            !
C !  NDMASF   !  E ! D  ! NOMBRE DE NOEUDS DES ELEMENTS FLUIDES + RAYO !
C !  NODRAF   ! TE ! D  ! TABLE DES ELEMENTS FLUIDES + RAYON (NUM LOC) !
C !  NELESS   !  E ! D  ! NOMBRE D'ELEMENTS SOLIDES COUPLES            !
C !  NDMASS   !  E ! D  ! NOMBRE DE NOEUDS DES ELEMENTS SOLIDES COUPLES!
C !  NODESS   ! TE ! D  ! TABLE DES ELEMENTS SOLIDES COUPLES (NUM LOC) !
C !  NBICOR   !  E ! D  ! NOMBRE D'INFO SUR LES CORRSPONDANTS (1 ou 2) !
C !  BARYF    ! TR ! D  ! COORD BARY DES CORRESPONDANTS DES NOEUDS     !
C !           !    !    ! FLUIDES DANS LES ELTS SOLIDES                !
C !  NCBORF   ! TE ! D  ! NUMERO DE L'ELEMENT SOLIDE CORRESPONDANT     !
C !  BARYS    ! TR ! D  ! CCORD BARY DES CORRESPONDANTS DES NOEUDS     !
C !           !    !    ! SOLIDES DANS LES ELTS FLUIDES                !
C !  NCBORS   ! TE ! D  ! NUMERO DE L'ELEMENT FLUIDE CORRESPONDANT     !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "nlofes.h"
#include "optct.h"
#include "xrefer.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER MODE,NDIM,NBRAYS,NBRAF,NELRAY,NELRAF,NDMASF,NELERA,NDMASS
      INTEGER NNSRAY,NNFRAY,NPOINR
      INTEGER NFCFRA,NGFPEF(NFCFRA)
      INTEGER NRAYTS(NBRAYS),NRAPF(NBRAF,2),NODRAY(NELRAY,NDIM)
      INTEGER NCSRAY(NNSRAY),NCFRAY(NNFRAY),NRFRAY(NELRAY)
      INTEGER NODRAF(NELRAF,NDMASF),NODERA(NELERA,NDMASS)
      INTEGER NCFIN(NBRAYS),NCGROS(NNSRAY,2)
      INTEGER NCFINF(NBRAF),NCGROF(NNFRAY,2),ITYFAR(NELRAY)
      INTEGER ITRAV(NELRAY)
      DOUBLE PRECISION BARYGR(NNSRAY,NDIM),BARYFR(NNFRAY,NDIM)
      DOUBLE PRECISION BARYFF(NBRAF,NDIM),BARYFS(NBRAYS,NDIM)
      DOUBLE PRECISION VRAYTS(NBRAYS,2),VRAPF(NBRAF,2)
      DOUBLE PRECISION TEMRAY(NELRAY),FIRAY(NELRAY,NBANDE)
      DOUBLE PRECISION ERAYEQ(NELRAY),TRAYEQ(NELRAY),PHFRAF(NFCFRA,4)
      DOUBLE PRECISION ERAYEN(NPOINR),TRAYEN(NPOINR)
      DOUBLE PRECISION SUFRAY(NELRAY),TRAV(NPOINR)
      DOUBLE PRECISION TRAV3(NELRAY),TRAV4(NELRAY)
C
C..Variables internes
      INTEGER NUMEL,NUMTRI,NUMSEG,N1,N2,N3,N,NN(3),M
      DOUBLE PRECISION XL1,XL2,XL3,TIERS,TT(3),XH(3)
C
C***********************************************************************
C
C     ++++++++++++++
C     ++++++++++++++
C     I. DIMENSION 2
C     ++++++++++++++
C     ++++++++++++++
      IF (NDIM.EQ.2) THEN
C
      IF (MODE.EQ.1) THEN
C
C      1- PASSAGE DU SOLIDE VERS LE RAYONNEMENT
C      ========================================
C
       DO N=1,NELRAY
         ITRAV(N) = 0
       ENDDO
       DO N=1,NNSRAY
         ITRAV(NCSRAY(N)) = N
       ENDDO

C
       DO 100 N=1,NELRAY
C
        IF (ITYFAR(N).EQ.1) THEN
C
         NN(1) = NODRAY(N,1)
         NN(2) = NODRAY(N,2)
C
         DO 110 M=1,2
C
          IF (ITRAV(NN(M)).EQ.0) THEN
            GOTO 110
C
          ELSE
C
            NUMEL = NCGROS(itrav(NN(M)),1)
            NUMSEG = NCGROS(itrav(NN(M)),2)
C
            IF (NUMSEG .EQ. 0) THEN
                N1 = NODERA(NUMEL,1)
                N2 = NODERA(NUMEL,2)
            ELSEIF (NUMSEG .EQ. 1) THEN
                N1 = NODERA(NUMEL,1)
                N2 = NODERA(NUMEL,3)
            ELSE
                N1 = NODERA(NUMEL,2)
                N2 = NODERA(NUMEL,3)
            ENDIF
C
            XL1 = BARYGR(itrav(NN(M)),1)
            XL2 = BARYGR(itrav(NN(M)),2)
C
            TT(M) =  VRAYTS(N1,1)*XL1 + VRAYTS(N2,1)*XL2
C
          ENDIF
C
  110    CONTINUE
C
        TEMRAY(N) = (TT(1)+TT(2)) * 0.5
C
       ENDIF
C
  100  CONTINUE
C
C
C       1.2 Impressions pour controle
C       -----------------------------
        IF (NBLBLR.GE.10) THEN
          WRITE(NFECRA,1020)
          DO 120 N=1,NELRAY
             WRITE(NFECRA,1021) N,TEMRAY(N)
  120     CONTINUE
        ENDIF
C
C
      ELSEIF (MODE.EQ.2) THEN
C
C     2- PASSAGE DU RAYONNEMENT VERS LE SOLIDE 
C     ========================================
C
       CALL PRRFVN (NDIM,NPOINR,NELRAY,NODRAY,SUFRAY, 
     *              TRAYEQ,TRAYEN,TRAV)
       CALL PRRFVN (NDIM,NPOINR,NELRAY,NODRAY,SUFRAY, 
     *              ERAYEQ,ERAYEN,TRAV)
C
       DO 200 N=1,NBRAYS
C
        NUMEL = NCFIN(N)
C
        N1 = NODRAY(NUMEL,1)
        N2 = NODRAY(NUMEL,2)
C
        XL1 = BARYFS(N,1)
        XL2 = BARYFS(N,2)
C
        VRAYTS(N,1)= TRAYEN(N1)*XL1 + TRAYEN(N2)*XL2
        VRAYTS(N,2)= ERAYEN(N1)*XL1 + ERAYEN(N2)*XL2
C
  200 CONTINUE
C
C       2.1- Impression pour controle
C       -----------------------------
        IF (NBLBLR.GE.10) THEN
          WRITE(NFECRA,2030)
          DO N=1,NBRAYS
             WRITE(NFECRA,2031) N,NRAYTS(N),VRAYTS(N,1),VRAYTS(N,2)
          ENDDO
        ENDIF
C
C
      ELSEIF (MODE.EQ.3) THEN
C
C     3- PASSAGE DU RAYONNEMENT VERS LE FLUIDE
C     ========================================
C
       CALL PRRFVN (NDIM,NPOINR,NELRAY,NODRAY,SUFRAY, 
     *              TEMRAY,TRAYEN,TRAV)

       DO 320 N=1,NBRAF
C
        NUMEL = NCFINF(N)
C
        N1 = NODRAY(NUMEL,1)
        N2 = NODRAY(NUMEL,2)
C
        XL1 = BARYFF(N,1)
        XL2 = BARYFF(N,2)
C
        VRAPF(N,1) = TRAYEN(N1)*XL1 + TRAYEN(N2)*XL2
C
  320 CONTINUE
C
C
C       3.1- Impression pour controle
C       -----------------------------
        IF (NBRAF .GE. 1 .AND. NBLBLR.GE.10) THEN
          WRITE(NFECRA,3040)
          DO N=1,NBRAF
             WRITE(NFECRA,3041) N,NRAPF(N,1),VRAPF(N,1)
          ENDDO
        ENDIF
C
C
      ELSEIF (MODE.EQ.4) THEN
C
C      4- PASSAGE DU FLUIDE VERS LE RAYONNEMENT
C      ========================================
C
       DO N=1,NELRAY
         ITRAV(N)=0
         TRAV3(N)=0.
         TRAV4(N)=0.
       ENDDO
C
       DO N=1,NNFRAY
         ITRAV(NCFRAY(N)) = N
       ENDDO
C
       DO 400 N=1,NELRAY
C
        IF (ITYFAR(N).EQ.4 .OR. ITYFAR(N).EQ.5) THEN
C
         NN(1) = NODRAY(N,1)
         NN(2) = NODRAY(N,2)
C
         DO 410 M=1,2
C
          IF (ITRAV(NN(M)).EQ.0) THEN
            GOTO 410
C
          ELSE 
C
            NUMEL = NCGROF(ITRAV(NN(M)),1)
C
            NUMSEG = NCGROF(ITRAV(NN(M)),2)
C
            IF (NUMSEG .EQ. 0) THEN
                N1 = NODRAF(NUMEL,1)
                N2 = NODRAF(NUMEL,2)
            ELSEIF (NUMSEG .EQ. 1) THEN
                N1 = NODRAF(NUMEL,1)
                N2 = NODRAF(NUMEL,3)
            ELSE
                N1 = NODRAF(NUMEL,2)
                N2 = NODRAF(NUMEL,3)
            ENDIF
C
            XL1 = BARYFR(ITRAV(NN(M)),1)
            XL2 = BARYFR(ITRAV(NN(M)),2)
C
            TT(M) =  VRAPF(N1,1)*XL1 + VRAPF(N2,1)*XL2
            XH(M) =  VRAPF(N1,2)*XL1 + VRAPF(N2,2)*XL2
C
          ENDIF
C
  410    CONTINUE
C
        TRAV3(N) = (TT(1)+TT(2)) * 0.5
        TRAV4(N) = (XH(1)+XH(2)) * 0.5
C
        ENDIF
C
  400  CONTINUE
C
C       1.2 Impressions pour controle
C       -----------------------------
        IF (NBLBLR.GE.10) THEN
          WRITE(NFECRA,4020)
          DO N=1,NELRAY
             WRITE(NFECRA,4021) N,TRAV3(N),TRAV4(N)
          ENDDO
        ENDIF
C
C     3- SORTIE EN ERREUR
C     ===================
      ELSE
C
        WRITE(NFECRA,3000)
        STOP
C
      ENDIF
C
C
C     +++++++++++++++
C     +++++++++++++++
C     II. DIMENSION 3
C     +++++++++++++++
C     +++++++++++++++
      ELSE
C
C     0- INITIALISATIONS
C     ==================
C
      TIERS = 1./3.
C
      IF (MODE.EQ.1) THEN
C
C      1- PASSAGE DU SOLIDE VERS LE RAYONNEMENT
C      ========================================
C
       DO N=1,NNSRAY
         ITRAV(NCSRAY(N)) = N
       ENDDO

C
       DO 500 N=1,NELRAY
C
        IF (ITYFAR(N).EQ.1) THEN

          NN(1) = NODRAY(N,1)
           NN(2) = NODRAY(N,2)
          NN(3) = NODRAY(N,3)
C
          DO 510 M=1,3
C
           IF (ITRAV(NN(M)).EQ.0) THEN
            GOTO 510
C
           ELSE 
C
            NUMEL = NCGROS(itrav(NN(M)),1)
            NUMTRI = NCGROS(itrav(NN(M)),2)
C
            IF (NUMTRI .EQ. 0) THEN
                N1 = NODERA(NUMEL,1)
                N2 = NODERA(NUMEL,2)
                N3 = NODERA(NUMEL,3)
            ELSEIF (NUMTRI .EQ. 1) THEN
                N1 = NODERA(NUMEL,1)
                N2 = NODERA(NUMEL,4)
                N3 = NODERA(NUMEL,6)
            ELSEIF (NUMTRI .EQ. 2) THEN
                N1 = NODERA(NUMEL,4)
                N2 = NODERA(NUMEL,5)
                N3 = NODERA(NUMEL,6)
            ELSEIF (NUMTRI .EQ. 3) THEN
                N1 = NODERA(NUMEL,2)
                N2 = NODERA(NUMEL,4)
                N3 = NODERA(NUMEL,5)
            ELSE
                N1 = NODERA(NUMEL,3)
                N2 = NODERA(NUMEL,5)
                N3 = NODERA(NUMEL,6)
            ENDIF
C
            XL1 = BARYGR(itrav(NN(M)),1)
            XL2 = BARYGR(itrav(NN(M)),2)
            XL3 = BARYGR(itrav(NN(M)),3)
C
            TT(M) =  VRAYTS(N1,1)*XL1 + VRAYTS(N2,1)*XL2
     *             + VRAYTS(N3,1)*XL3 
C
           ENDIF
C
  510    CONTINUE
C
         TEMRAY(N) = (TT(1)+TT(2)+TT(3)) * TIERS
C
        ENDIF
C
  500  CONTINUE
C
C
C       1.2 Impressions pour controle
C       -----------------------------
        IF (NBLBLR.GE.10) THEN
          WRITE(NFECRA,1020)
          DO 520 N=1,NELRAY
             WRITE(NFECRA,1021) N,TEMRAY(N)
  520     CONTINUE
        ENDIF
C
C
      ELSEIF (MODE.EQ.2) THEN
C
C     2- PASSAGE DU RAYONNEMENT VERS LE SOLIDE 
C     ========================================
C
       CALL PRRFVN (NDIM,NPOINR,NELRAY,NODRAY,SUFRAY, 
     *              TRAYEQ,TRAYEN,TRAV)
       CALL PRRFVN (NDIM,NPOINR,NELRAY,NODRAY,SUFRAY, 
     *              ERAYEQ,ERAYEN,TRAV)
C
       DO 600 N=1,NBRAYS
C
        NUMEL = NCFIN(N)
        N1 = NODRAY(NUMEL,1)
        N2 = NODRAY(NUMEL,2)
        N3 = NODRAY(NUMEL,3)
C
        XL1 = BARYFS(N,1)
        XL2 = BARYFS(N,2)
        XL3 = BARYFS(N,3)
C
        VRAYTS(N,1)= TRAYEN(N1)*XL1 + TRAYEN(N2)*XL2
     &              +TRAYEN(N3)*XL3
        VRAYTS(N,2)= ERAYEN(N1)*XL1 + ERAYEN(N2)*XL2
     &              +ERAYEN(N3)*XL3
C
  600 CONTINUE
C
C       2.1- Impression pour controle
C       -----------------------------
        IF (NBLBLR.GE.10) THEN
          WRITE(NFECRA,2030)
          DO 630 N=1,NBRAYS
             WRITE(NFECRA,2031) N,NRAYTS(N),VRAYTS(N,1),VRAYTS(N,2)
 630      CONTINUE
        ENDIF
C
C
      ELSEIF (MODE.EQ.3) THEN
C
C     3- PASSAGE DU RAYONNEMENT VERS LE FLUIDE
C     ========================================
C
       CALL PRRFVN (NDIM,NPOINR,NELRAY,NODRAY,SUFRAY, 
     *              TEMRAY,TRAYEN,TRAV)
          
       DO 720 N=1,NBRAF
C
        NUMEL = NCFINF(N)
C
        N1 = NODRAY(NUMEL,1)
        N2 = NODRAY(NUMEL,2)
        N3 = NODRAY(NUMEL,3)
C
        XL1 = BARYFF(N,1)
        XL2 = BARYFF(N,2)
        XL3 = BARYFF(N,3)
C
        VRAPF(N,1)= TRAYEN(N1)*XL1 + TRAYEN(N2)*XL2
     &             +TRAYEN(N3)*XL3
C
  720 CONTINUE
C
C       3.1- Impression pour controle
C       -----------------------------
        IF (NBRAF .GE. 1 .AND. NBLBLR.GE.10) THEN
          WRITE(NFECRA,3040)
          DO N=1,NBRAF
             WRITE(NFECRA,3041) N,NRAPF(N,1),VRAPF(N,1)
          ENDDO
        ENDIF
C
      ELSEIF (MODE.EQ.4) THEN
C
C      4- PASSAGE DU FLUIDE VERS LE RAYONNEMENT
C      ========================================
C
       DO N=1,NELRAY
         ITRAV(N)=0
         TRAV3(N)=0.
         TRAV4(N)=0.
       ENDDO
C
       DO  N=1,NNFRAY
         ITRAV(NCFRAY(N)) = N
       ENDDO
C
       DO 800 N=1,NELRAY
C
        IF (ITYFAR(N).EQ.4 .OR. ITYFAR(N).EQ.5) THEN

         NN(1) = NODRAY(N,1)
         NN(2) = NODRAY(N,2)
         NN(3) = NODRAY(N,3)
C
         DO 810 M=1,3
C
          IF (ITRAV(NN(M)).EQ.0) THEN
            GOTO 810
C
          ELSE 
C
            NUMEL = NCGROF(itrav(NN(M)),1)
C
            NUMTRI = NCGROF(itrav(NN(M)),2)
C
            IF (NUMTRI .EQ. 0) THEN
                N1 = NODRAF(NUMEL,1)
                N2 = NODRAF(NUMEL,2)
                N3 = NODRAF(NUMEL,3)
            ELSEIF (NUMTRI .EQ. 1) THEN
                N1 = NODRAF(NUMEL,1)
                N2 = NODRAF(NUMEL,4)
                N3 = NODRAF(NUMEL,6)
            ELSEIF (NUMTRI .EQ. 2) THEN
                N1 = NODRAF(NUMEL,4)
                N2 = NODRAF(NUMEL,5)
                N3 = NODRAF(NUMEL,6)
            ELSEIF (NUMTRI .EQ. 3) THEN
                N1 = NODRAF(NUMEL,2)
                N2 = NODRAF(NUMEL,4)
                N3 = NODRAF(NUMEL,5)
            ELSE
                N1 = NODRAF(NUMEL,3)
                N2 = NODRAF(NUMEL,5)
                N3 = NODRAF(NUMEL,6)
            ENDIF
C
            XL1 = BARYFR(itrav(NN(M)),1)
            XL2 = BARYFR(itrav(NN(M)),2)
            XL3 = BARYFR(itrav(NN(M)),3)
C
            TT(M) =  VRAPF(N1,1)*XL1 + VRAPF(N2,1)*XL2
     *             + VRAPF(N3,1)*XL3 
            XH(M) =  VRAPF(N1,2)*XL1 + VRAPF(N2,2)*XL2
     *             + VRAPF(N3,2)*XL3 
C
          ENDIF
C
  810    CONTINUE
C
         TRAV3(N) = (TT(1)+TT(2)+TT(3)) * TIERS
         TRAV4(N) = (XH(1)+XH(2)+XH(3)) * TIERS
C
        ENDIF
C
  800  CONTINUE
C
C
C       6.2 Impressions pour controle
C       -----------------------------
        IF (NBLBLR.GE.10) THEN
          WRITE(NFECRA,4020)
          DO N=1,NELRAY
             WRITE(NFECRA,4021) N,TRAV3(N),TRAV4(N)
          ENDDO
        ENDIF
C
C
C
C     3- SORTIE EN ERREUR
C     ===================
      ELSE
C
        WRITE(NFECRA,3000)
        STOP
C
      ENDIF
C
C     +++++++++++++++
C     +++++++++++++++
      ENDIF
C
C-------
C FORMAT
C-------
C
 1020 FORMAT(/,' *** PASRAY : PASSAGE DES DONNEES VERS LE',
     &         ' RAYONNEMENT',/,
     &          5X,'Face de rayonnement         T ')
 1021 FORMAT(5X,3X,I7,14X,G13.7)
 2030 FORMAT(/,' *** PASRAY : PASSAGE DES DONNEES DU RAYONNEMENT',
     &         ' VERS LE SOLIDE',/,
     &          5X,'N solide   N_global    T equiv   Emis equiv')
 2031 FORMAT(5X,3X,I7,2X,I7,3X,G10.4,3X,G10.4,3X,G10.4)
 3040 FORMAT(/,' *** PASRAY : PASSAGE DES DONNEES DU RAYONNEMENT',
     &         ' VERS LE FLUIDE',/,
     &          5X,'Num fluide local    Num fluide global   T fluide')
 3041 FORMAT(5X,I7,10X,I7,10X,G10.4)
 3000 FORMAT(/,'  %% ERREUR PASRAY : OPTION DE PASSAGE INCORRECTE ')
 4020 FORMAT(/,' *** PASRAY : PASSAGE DES DONNEES FLUIDES VERS LE',
     &         ' RAYONNEMENT',/,
     &          5X,'Face de rayonnement         T fluide     h fluide')
 4021 FORMAT(5X,3X,I7,14X,G13.7,3X,G13.7)
C
C----
C FIN
C----
      END
          
