C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LFRAY1
C                       *****************
C
C      ---------------------------------------------------------------
     * (NELRAY,NRFRAY,NFCFRA,NFCSRA,NFTIRA,NFFIRA,NFPERA,NFMST,NFMSTE)
C      ---------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C      NOMBRES DE FACES POUR LE MAILLAGE RAYONNEMENT                   *
C          - Faces couplees avec le solide                             *
C          - Faces couplee avec le fluide (traitement paroi equivalent)*
C          - Faces a temperature imposee                               *
C          - Faces a flux impose                                       *
C          - Face de type paroi equivalente                            *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME (3     )               !
C !  NELRAY   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE RAYONNEMENT        !
C !  NRFRAY   ! TE ! R  ! TABLEAU DES REFERENCES ELTS MAILLAGE RAYT    !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /OPTCT/   !    !    !                                              !
C ! /DIVCT/   !    !    !                                              !
C ! /NLOFES/  !    !    !                                              !
C ! /NLOFCT/  !    !    !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --- 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
       IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "nlofct.h"
#include "xrefer.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NELRAY,NFCFRA,NFCSRA,NFTIRA,NFFIRA,NFPERA,NFMST,NFMSTE
      INTEGER NRFRAY(NELRAY)
C
C.. Variables internes
      INTEGER N,M,NF
C
C***********************************************************************
C
C     1- INITIALISATION 
C     =================
C
C
C 
C     2- MARQUAGE DES NOEUDS
C     ======================
C
      DO 200 N=1,NELRAY
C
        NF = NRFRAY(N)
C
        DO 210 M=1,NRFMAX
C
          IF (IRERCS(M).NE.0 .AND. NF.EQ.M) NFCSRA = NFCSRA + 1
          IF (IRERCF(M).NE.0 .AND. NF.EQ.M) NFCFRA = NFCFRA + 1
          IF (IRERTI(M).NE.0 .AND. NF.EQ.M) NFTIRA = NFTIRA + 1 
          IF (IRERFI(M).NE.0 .AND. NF.EQ.M) NFFIRA = NFFIRA + 1
          IF (IRERPE(M).NE.0 .AND. NF.EQ.M) NFPERA = NFPERA + 1
          IF (IRESTE(M).NE.0 .AND. NF.EQ.M) NFMSTE = NFMSTE + 1
          IF ((IRESTF(M).NE.0 .OR. IRESTE(M).NE.0 .OR.
     *         IRESTS(M).NE.0 .OR. IRESTB(M).NE.0 )
     *          .AND. NF.EQ.M) NFMST  = NFMST + 1
C
  210   CONTINUE
C
  200 CONTINUE
C
C
C--------
C FORMATS
C--------
C
C
      END
