C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C
                        SUBROUTINE LECID3
C                       *****************
C
C      -----------------------------------------------------
     * (NDIM,NDIELE,NPOINS,NELEMS,NFBIDA,NDMATS,NODES,NREFS,
     *  NREFE,COORDS,NBFACE,NREFAC)
C      -----------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             LECTURE DU MAILLAGE ELEMENTS FINIS                       *
C                  STRUCTURE DE DONNEE ISSUE DE IDEAS                  *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME (2 OU 3)               !
C !  NDIELE   !  E ! D  ! DIMENSION DES ELTS DU PB (2 OU 3)            !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !  NELEMS   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE VOL SOLIDE         !
C !  NDMATS   !  E ! D  ! NOMBRE DE NOEUDS DES ELTS VOL SOLIDES        !
C !  NODES    ! TE ! R  ! TABLE DES ELEMENTS DU MAILLAGE SOLIDE        !
C !  NREFS    ! TE ! R  ! REFERENCES DES NOEUDS DU MAILLAGE SOLIDE     !
C !  COORDS   ! TR ! R  ! COORD DES NOEUDS DU MAILLAGE SOLIDE          !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /GEOCOQ/  !    ! D  !                                              !
C ! /GEOEF/   !    ! D  !                                              !
C ! /GENECT/  !    ! D  !                                              !
C ! /PORTAG/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --- 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
       IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "nlofct.h"
#include "mobil.h"
C
C***********************************************************************
C
      INTEGER NELEMS,NDMATS,NPOINS,NDIM,NDIELE,NBFACE
      INTEGER NODES(NELEMS,NDMATS), NREFS(NPOINS),NREFE(NELEMS)
      INTEGER NREFAC(NELEMS,NBFACE)
      DOUBLE PRECISION  COORDS(NPOINS,NDIM)
C
      INTEGER N,I,J
      INTEGER NUM,ID,N1,N2,N3,NBNO,NDSDE,NUMMAX
      INTEGER ITRIA6(6),ITET10(10)
C
      INTEGER NFBIDA,ICFA,NSF1,NSF2,NSF3
      CHARACTER*80 CH
C***********************************************************************
C
      DATA ITRIA6 / 1,4,2,5,3,6 /
      DATA ITET10 / 1,8,4,9,2,5,7,10,6,3 /
C
C     1- INITIALISATION DES TABLEAUX D'INDICATEURS
C     ============================================
C
      DO 2 I=1,NPOINS
        NREFS(I) = 0
    2 CONTINUE
C
C   
C
C     2- LECTURE DE LA TABLE DES NOEUDS
C     =================================
C
C     2.1- Recherche de la section contenant la table des noeuds
C     ----------------------------------------------------------
      CALL SECIDE(NFSGCT,2411)
C
C     2.2- Coordonnees et references
C     ------------------------------
      DO 220 N=1,NBNMA1
        READ(NFSGCT,2200) N1,N2,N3,NREFS(N)
        READ(NFSGCT,2210) (COORDS(N,J),J=1,NDIM)
  220 CONTINUE
C
C
C
C     3- TABLE DES ELEMENTS
C     =====================
C
C     3.1- Recherche de la section contenant la table des elements
C     ------------------------------------------------------------
      CALL SECIDE(NFSGCT,2412)
C
C     3.2- Lecture des elements
C     -------------------------
C
      IF (NDIELE.EQ.2) THEN
         DO N=1,NBEMA1
            READ(NFSGCT,3200) NUM,ID,N1,N2,NREFE(N),NBNO
            READ(NFSGCT,3201) (NODES(N,ITRIA6(I)),I=1,NBNO)
         ENDDO
         DO N=1,NFBIDA
            READ(NFSGCT,4200,ERR=28,END=28) NUM,ID,N1,N2,ICFA,NBNO
            IF (NDIELE.EQ.2 .AND. ID.EQ.24) THEN
               READ(NFSGCT,4223) CH
               READ(NFSGCT,4224) NSF1,NSF3,NSF2
               CALL AFECTF(NSF1,NSF2,NSF3,ICFA,
     *              NDIM,NDIELE,NELEMS,NBNO,NBFACE,NODES,
     *              NREFAC,NPOINS,NREFS)
            ENDIF
         ENDDO
 28      CONTINUE
C     
      ELSE
         DO N=1,NBEMA1
            READ(NFSGCT,3200) NUM,ID,N1,N2,NREFE(N),NBNO
            READ(NFSGCT,3201) (NODES(N,ITET10(I)),I=1,NBNO)
         ENDDO
         DO N=1,NFBIDA
            READ(NFSGCT,4200,ERR=29,END=29) NUM,ID,N1,N2,ICFA,NBNO
            IF (NDIELE.EQ.3 .AND. ID.EQ.92) THEN
               READ(NFSGCT,4201,ERR=29,END=29) 
     &              NSF1,N1,NSF2,N1,NSF3,N1  
               CALL AFECTF(NSF1,NSF2,NSF3,ICFA,
     *              NDIM,NDIELE,NELEMS,NBNO,NBFACE,NODES,
     *              NREFAC,NPOINS,NREFS)
            ENDIF
         ENDDO
 29      CONTINUE
C     
      ENDIF
C
C
      NUMMAX=0
      DO N=1,NELEMS
        DO I=1,NDMATS
          NUMMAX=MAX(NUMMAX,NODES(N,I))
        ENDDO
      ENDDO
      IF (NUMMAX.GT.NPOINS) THEN
         WRITE(NFECRA,6000)
         STOP
      ENDIF
C
C     4- IMPRESSION SUR LISTING
C     =========================
C
      IF (NBLBLA.GT.0) THEN
        WRITE(NFECRA,4000)
        WRITE(NFECRA,4010) NDIM,NBNMA1,NBEMA1 
      ENDIF
C
C
C     5- VERIFICATION DU MAILLAGE LU
C     ==============================
C
      IF (NBLBLA.GE.2) THEN
C
      WRITE(NFECRA,5000) 
      WRITE(NFECRA,5010)
ccc      DO 100 I=1,NBNMA1
      DO 100 I=1,10
        WRITE(NFECRA,5011) I,(COORDS(I,J),J=1,NDIM)
  100 CONTINUE
C
      WRITE(NFECRA,5020)
ccc      DO 110 I=1,NBEMA1
      DO 110 I=1,10
        WRITE(NFECRA,5012) I,(NODES(I,J),J=1,NDMATS)
 110  CONTINUE
C
      WRITE(NFECRA,5030)
ccc      DO 120 I=1,NBNMA1
      DO 120 I=1,10
         WRITE(NFECRA,5013) I,NREFS(I)
 120  CONTINUE   
C
      IF (NDPROP.GT.1) THEN
        WRITE(NFECRA,5031)
        DO 121 I=1,10
           WRITE(NFECRA,5013) I,NREFE(I)
 121    CONTINUE   
      ENDIF
C
      ENDIF  
C
C--------
C FORMATS
C--------
C
 2200 FORMAT(4I10)
 2210 FORMAT(1P3D25.16)
 3200 FORMAT(6I10)
 3201 FORMAT(8I10)
C
 4000 FORMAT(//,' *** LECID2 : MAILLAGE ELEMENTS FINIS DU SOLIDE :')
 4010 FORMAT(8X,'- Dimension du maillage            : ',I6,/,
     &       8X,'- Nombre total de noeuds           : ',I8,/,
     &       8X,'- Nombre d''elements                : ',I8)
 4200 FORMAT(6I10)
 4201 FORMAT(8I10)
 4223 FORMAT(A80)
 4224 FORMAT(3I10)
C
 5000 FORMAT(/,' *** LECID2 : Verification du maillage solide',/)
 5010 FORMAT(/,14X,'Coordonnees des 10 premiers noeuds :',/)
 5020 FORMAT(/,14X,'Table des 10 premiers elements :',/)
 5030 FORMAT(/,14X,'References des 10 premiers noeuds :',/)
 5031 FORMAT(/,14X,'References des 10 premiers elements :',/)
 5011 FORMAT(14X,'N=',I2,'   COORDS : ',3E12.5)
 5012 FORMAT(14X,'N=',I2,'   NOEUDS : ',10I8)
 5013 FORMAT(14X,'N=',I2,'   REFERENCE : ',I3)
C
 6000 FORMAT(/,' %% ERREUR LECID3 : LA NUMEROTATION DES NOEUDS DU',
     * ' MAILLAGE POUR LE SOLIDE',/,
     *         '                    COMPORTE DES TROUS',/,
     *         '                    VEUILLEZ RENUMEROTER VOTRE',
     * ' MAILLAGE POUR AVOIR UNE NUMEROTATION CONTINUE')
C
      END
