C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE INIMST
C                       *****************
C
C     -------------------------------------------------------------
     * (NELRAY,EMISSI,TEMRAY,FDFRAY,FDFNP1,SUFRAY,RADIOS)
C     -------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C
C FONCTION :
C ----------
C     INITIALISATIONDE MSTS 
C
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !___________!____!____!______________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C ! /OPTCT/   !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C     TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C            L (LOGIQUE)   .. ET TYPES COMPOSES (EX : TR TABLEAU REEL)
C     MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (AUXILIAIRE MODIFIE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME APPELANT     :  
C
C     SOUS PROGRAMME(S) APPELE(S) :
C***********************************************************************
C
      IMPLICIT NONE        
C
C***********************************************************************
C     DONNEES EN COMMON 
C **********************************************************************
C
#include "divct.h"
#include "optct.h"
#include "nlofes.h"
#include "nlofct.h"
#include "fichct.h"
#include "syrth.h"
#include "rayonn.h"
C
C **********************************************************************
C
C.. Variables externes
      INTEGER NELRAY
      DOUBLE PRECISION FDFRAY(NELRAY*(NELRAY+1)/2)
      DOUBLE PRECISION SUFRAY(NELRAY),FDFNP1(NELRAY),TEMRAY(NELRAY)
      DOUBLE PRECISION EMISSI(NELRAY,2,NBANDE),RADIOS(NELRAY,NBANDE)
C
C.. Variables internes
      INTEGER N,NBF,NBB,NUMBS,I
      CHARACTER*80 CH
      DOUBLE PRECISION C2,X1,X2,V,W1,W2,XJ
C
C **********************************************************************
C
C     1- Suite de calcul
C     ==================
      IF (LSUISO) THEN
C
        REWIND (NFSMRA)
        READ(NFSMRA,1000) NBF,NBB
        IF (NBF.NE.NELRAY .OR. NBB.NE.NBANDE) THEN
          WRITE(NFECRA,2000) NBF,NBB,NELRAY,NBANDE
          STOP
        ENDIF
        READ(NFSMRA,1010) CH
        READ(NFSMRA,1010) CH
        READ(NFSMRA,1020) (TEMRAY(I),I=1,NELRAY)
        DO N=1,NBANDE
          READ(NFSMRA,1010) CH
          READ(NFSMRA,1010) CH
          READ(NFSMRA,1020) (RADIOS(I,N),I=1,NELRAY)
        ENDDO
C
      ELSE
C
        IF (NBANDE.EQ.1) THEN
          DO N=1,NELRAY
            RADIOS(N,1)=SIGMA*EMISSI(N,1,1)*(TEMRAY(N)+TKEL)**4 
          ENDDO
          IF (LROUVR) THEN
            XJ = SIGMA  * (TEMINF+TKEL)**4 
            DO N=1,NELRAY
              RADIOS(N,1) = RADIOS(N,1) +
     *                   (1.-EMISSI(N,1,1))*FDFNP1(N)*XJ
            ENDDO
          ENDIF
C
        ELSE
          C2 = 1.4388E-2
          DO NUMBS=1,NBANDE
             X1 = C2/SPECTL(NUMBS,1)
             X2 = C2/SPECTL(NUMBS,2)
             DO N=1,NELRAY
               V = X1/(TEMRAY(N)+TKEL)
               CALL WIEBEL(V,W1)
               V = X2/(TEMRAY(N)+TKEL)
               CALL WIEBEL(V,W2)
               RADIOS(N,NUMBS) = SIGMA * EMISSI(N,1,NUMBS) 
     *                    * (TEMRAY(N)+TKEL)**4 * (W2-W1)
             ENDDO
             IF (LROUVR) THEN
                V = X1/(TEMINF+TKEL)
                CALL WIEBEL(V,W1)
                V = X2/(TEMINF+TKEL)
                CALL WIEBEL(V,W2)
                DO N=1,NELRAY
                   RADIOS(N,NUMBS) =  RADIOS(N,NUMBS) + 
     *                   (1.-EMISSI(N,1,NUMBS)) * FDFNP1(N)
     *                  * SIGMA 
     *                  * (TEMINF+TKEL)**4 * (W2-W1)
                ENDDO
             ENDIF
          ENDDO
        ENDIF
C
      ENDIF    

C           
C--------
C FORMATS
C--------
C
 1000 FORMAT(9X,I7,9X,I4)
 1010 FORMAT(A80)
 1020 FORMAT(6E13.7)
C
 2000 FORMAT(/,'  %% ERREUR INIMST : FICHIER SUITE INCOHERENT',/,
     &         '        On lit :',I7,' facettes et ',I4,' bandes',/,
     &         '  On attendait :',I7,' facettes et ',I4,' bandes')

C----
C FIN
C----
C
      END


