C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=CORESC,SSI=0
                        SUBROUTINE CORESC
C                       *****************
C
C      ----------------------------------
     * (NDIM,NPOINS,NBRESS,NRESCS,COORDS)
C      ----------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            ETABLISSEMENT DE LA TABLE DE CORRESPONDANCE ENTRE LES     *
C            NOEUDS MUNIS DE RESISTANCES DE CONTACT                    *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME                        !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE VOL SOLIDE      !
C !  NBRESS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES COUPLES             !
C !  NRESCS   ! TE ! M  ! TABLE DES NOEUDS AVEC RESISTANCE             !
C !           !    !    ! (.,1) : numero global du noeud               !
C !           !    !    ! (.,2) : numero local de son correspondant    !
C !  COORDS   ! TR ! D  ! COORDONNEES DES NOEUDS DU MAILLAGE SOLIDE    !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ----
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : INISOL
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON 
C***********************************************************************
C
#include "nlofes.h"
#include "optct.h"
#include "mobil.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NPOINS,NBRESS,NRESCS(NBRESS,2)
      DOUBLE PRECISION COORDS(NPOINS,NDIM)
C
C.. Variables internes
      INTEGER N,M,NG,MG,NLMIN
      DOUBLE PRECISION X,Y,Z,XC,YC,ZC,D2,DMIN,DMAX
C
C***********************************************************************
C
C     0.1- INITIALISATIONS
C     ====================
C
      DO 1 N=1,NBRESS
        NRESCS(N,2) = 0
    1 CONTINUE
C
      DMAX = 0
C
C     0.2- VERIFICATION DE BASE
C     =========================
C
      IF (MOD(NBRESS,2).NE.0) THEN
        WRITE(NFECRA,999) 
        STOP
      ENDIF
C
C     1- CORRESPONDANCE EN 2D
C     =======================
C
      IF (NDIM .EQ. 2) THEN
C
C
       IF (NBLBLA.GT.0) WRITE(NFECRA,1000)
C
C      1.1- Pour chaque noeud avec resistance
C      --------------------------------------
       DO 100 N=1,NBRESS
C
         DMIN = 1.D6
         NLMIN = 0
C
         NG = NRESCS(N,1)
C
         XC = COORDS(NG,1)
         YC = COORDS(NG,2)
C    
C
         DO 110 M=1,NBRESS
C
          IF (M.NE.N) THEN  

            MG = NRESCS(M,1)
C
C           Coordonnees du noeud
            X = COORDS(MG,1)
            Y = COORDS(MG,2)
C
            D2 = (X-XC)*(X-XC) + (Y-YC)*(Y-YC)
C 
            IF (D2.LT.DMIN) THEN
              DMIN = D2
              NLMIN = M
            ENDIF
C
          ENDIF
  110    CONTINUE
C
C       1.2- Mise a jour des correspondants
C       -----------------------------------
        IF (NLMIN.NE.0) THEN
          NRESCS(N,2) = NLMIN
          IF (DMIN.GT.DMAX) DMAX = DMIN
          IF (LSDEPL .AND. DMIN.GT.D1MAXS) NRESCS(N,2) = -1
        ELSE
          WRITE(NFECRA,1200) NG
        ENDIF
C
C
  100 CONTINUE     
C
C
C     2- CORRESPONDANCE FLUIDE-->SOLIDE EN DIMENSION 3
C     ================================================
C
      ELSEIF (NDIM .EQ. 3) THEN
C
C
       IF (NBLBLA.GT.0) WRITE(NFECRA,1000)
C
C      2.1- Pour chaque noeud avec resistance
C      --------------------------------------
       DO 200 N=1,NBRESS
C
         DMIN = 1.D6
         NLMIN = 0
C
         NG = NRESCS(N,1)
C
         XC = COORDS(NG,1)
         YC = COORDS(NG,2)
         ZC = COORDS(NG,3)
C    
C
         DO 210 M=1,NBRESS
C
          IF (M.NE.N) THEN  

            MG = NRESCS(M,1)
C
            X = COORDS(MG,1)
            Y = COORDS(MG,2)
            Z = COORDS(MG,3)
C
            D2 = (X-XC)*(X-XC) + (Y-YC)*(Y-YC) + (Z-ZC)*(Z-ZC)
C 
            IF (D2.LT.DMIN) THEN
              DMIN = D2
              NLMIN = M
            ENDIF
C
          ENDIF
  210    CONTINUE
C
C       2.2- Mise a jour des correspondants
C       -----------------------------------
        IF (NLMIN.NE.0) THEN
          NRESCS(N,2) = NLMIN
          IF (DMIN.GT.DMAX) DMAX = DMIN
          IF (LSDEPL .AND. DMIN.GT.D1MAXS) NRESCS(N,2) = -1
        ELSE
          WRITE(NFECRA,1200) NG
        ENDIF
C
  200 CONTINUE     
C
C 
      ENDIF
C
C     3- IMPRESSIONS DE CONTROLE
C     ==========================
C
      IF (NBLBLA.GT.0) WRITE(NFECRA,3200) DMAX
C
      IF (NBLBLA.GE.10) THEN
        WRITE (NFECRA,3000)
        DO 300 N=1,NBRESS
          WRITE(NFECRA,3010) N,NRESCS(NRESCS(N,2),1)
  300   CONTINUE
      ENDIF
C
C--------
C FORMATS
C--------
C
  999 FORMAT(/,' %% ERREUR CORESC : le nombre de noeuds avec ',
     &         'resistance de contact',/,
     &         '    est impair ==> ils ne peuvent se correspondre',
     &         ' 2 a 2 ! ')
 1000 FORMAT(/,' *** CORESC : Recherche des couples de noeuds avec ',
     &         'resistance de contact')
 1200 FORMAT(' %% ERREUR CORESC : LA RECHERCHE DU CORRESPONDANT DU ',
     &       ' NOEUD AVEC RESIATNCE ',I6,' A ECHOUEE')
C
 3000 FORMAT(/,' *** CORESC : couples de noeuds avec resistance de',
     &         ' contact :')
 3010 FORMAT(4X,' Noeud :',I6,'  Correspondant : ',I6)
 3200 FORMAT('              Distance maximale entre 2 noeuds ',
     &         'coincidents : ',E12.5)
C----
C FIN
C----
      END
               
