#
# Copyright (C) 2000 Stephen Davies
# Copyright (C) 2000 Stefan Seefeld
# All rights reserved.
# Licensed to the public under the terms of the GNU LGPL (>= 2),
# see the file COPYING for details.
#

from Synopsis.Processor import Parameter
from Synopsis.Formatters.HTML.View import View, Format
from Synopsis.Formatters.HTML.Tags import *

import os

class FramesFormat(Format):

   def view_header(self, os, title, body, headextra, view):

      os.write('<?xml version="1.0"?>\n')
      os.write('<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Frameset//EN"\n')
      os.write('    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd">\n')
      os.write('<html xmlns="http://www.w3.org/1999/xhtml" lang="en">')
      os.write('<!-- ' + view.filename() + ' -->\n')
      os.write('<!-- this view was generated by ' + view.__class__.__name__ + ' -->\n')
      os.write("<head>\n")
      os.write('<meta content="text/html; charset=iso-8859-1" http-equiv="Content-Type"/>')
      os.write(entity('title','Synopsis - '+ title) + '\n')
      css = self.prefix + 'style.css'
      os.write(solotag('link', type='text/css', rel='stylesheet', href=css) + '\n')
      os.write(headextra)
      os.write("</head>\n%s\n"%body)

class FramesIndex(View):
   """A class that creates an index with frames"""

   template = Parameter(FramesFormat(), 'the object that provides the html template for the view')

   def register(self, processor):

      View.register(self, processor)
      processor.set_main_view(self.filename())

   def filename(self): return self.processor.file_layout.index()

   def title(self): return self.processor.title

   def process(self, start):
      """Creates a frames index file"""

      me = self.filename()
      # TODO use project name..
      self.start_file(body='')
      fcontents = rel(me, self.processor.contents_view)
      findex = rel(me, self.processor.index_view)
      # Find something to link to
      fglobal = findex
      decls = [start]
      while decls:
         decl = decls.pop(0)
         entry = self.processor.toc[decl.name()]
         if entry:
            fglobal = rel(me, entry.link)
            break
         if hasattr(decl, 'declarations'):
            # Depth-first search
            decls = decl.declarations() + decls
      frame1 = solotag('frame', name='contents', src=fcontents)
      frame2 = solotag('frame', name='index', src=findex)
      frame3 = solotag('frame', name='main', src=fglobal)
      frameset1 = entity('frameset', frame1+frame2, rows="30%,*")
      noframes = 'This document was configured to use frames.'
      noframes = noframes + '<ul>'
      noframes = noframes + entity('li', href(fcontents, 'The default Contents frame'))
      noframes = noframes + entity('li', href(findex, 'The default Index frame'))
      noframes = noframes + entity('li', href(fglobal, 'The default Main frame'))
      noframes = noframes + '</ul>'
      noframes = entity('body', noframes + 'Generated by Synopsis.')
      noframes = entity('noframes', noframes)
      frameset2 = entity('frameset', frameset1+frame3+noframes, cols="200,*")
      self.write(frameset2)
      self.end_file(body='')
