// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory.
// Licensed under the GNU GPL Version 2, or (at your option) any later version.

#ifndef UTILITIES_IS_INCLUDED
#define UTILITIES_IS_INCLUDED

#include <string>

#include <ginac/ginac.h>

#include "containers.h"

namespace SyFi
{

	// dirac delta function
	int dirac(unsigned int i, unsigned int j);

	// string utilities
	std::string int2string(int i);

	std::string istr(const std::string & a, int b);

	std::string istr(const std::string & a, int b, int c);

	std::string lst2string(GiNaC::lst& l);
	//std::string lst2string(GiNaC::exvector& v);

	//GiNaC::lst compute_functions(GiNaC::lst& equations, GiNaC::lst& variables, GiNaC::lst& space);

	// print functions
	#ifndef SWIG
	void print(GiNaC::exvector& v);
	void print(GiNaC::lst& l);
	void print(GiNaC::exmap m);
	void print(ex_int_map m);
	void print(std::map<std::pair<unsigned int,unsigned int>, GiNaC::ex> & A);
	#endif

}								 // namespace SyFi
#endif
