/*--------------------------------------------------------------*
 *                                                              *
 *           =  Suffx Array Υƥȸ =                *
 *                    Perl Module                             *
 *                                                              *
 *                                     written by T.Nakayama    *
 *                                                T.Kumagai     *
 *                                                T.Yamashita   *
 *                                                T.Imamura     *
 *--------------------------------------------------------------*/
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "sufary.h"

SUFARY *SUFARYs[256];
char *BUF = NULL;
/*----------------------------------------------------------*
 * ⥸塼
 *----------------------------------------------------------*/
MODULE = SUFARY PACKAGE = SUFARY

int
suf_openfile(i,s,t)
int i
char *	s
char *	t
CODE:
{
    SUFARYs[i] = sa_openfiles(s,t);
    if (SUFARYs[i] == NULL) {
	RETVAL = 0;
    } else {
	RETVAL = 1;
    }
}
OUTPUT:
RETVAL

void
suf_closefile(i)
int i
CODE:
  {
      SUFARY* ary = SUFARYs[i];
      sa_closefiles(ary);
  }

void
suf_search(i,s)
int i
char *	s
PPCODE:
{
    int ret;
    long top, buttom;
    
    SUFARY* ary = SUFARYs[i];
    ret = sa_sel(ary,s);
    
    if (ret == 0) {
	EXTEND(sp, 2);
	PUSHs(sv_2mortal(newSVnv(ary->left)));
	PUSHs(sv_2mortal(newSVnv(ary->right)));
    } else {
    }
}

char *
suf_getline(i,pos)
int i
long pos
CODE:
  {
  SUFARY* ary = SUFARYs[i];

  free(BUF);
  BUF = sa_getline(ary, pos);

  RETVAL = BUF;
}
OUTPUT:
RETVAL

char *
suf_getstr(i,from,size)
int i
long from
long size
CODE:
  {
  SUFARY* ary = SUFARYs[i];

  free(BUF);
  BUF = sa_getstr(ary, from, size);

  RETVAL = BUF;
}
OUTPUT:
RETVAL

char *
suf_block(i,pos,d1,d2)
int i
long pos
char * d1
char * d2
CODE:
{
  SUFARY* ary = SUFARYs[i];

  free(BUF);
  BUF = sa_getblock(ary, pos, d1, d2);

  RETVAL = BUF;
}
OUTPUT:
RETVAL

void
suf_init(i)
int i
CODE:
{
    SUFARY* ary = SUFARYs[i];
    sa_reset(ary);
}

long
suf_top(i)
int i
CODE:
{
    SUFARY* ary = SUFARYs[i];

    RETVAL = ary->right;
}
OUTPUT:
RETVAL

long
suf_bottom(i)
int i
CODE:
{
    SUFARY* ary = SUFARYs[i];

    RETVAL = ary->left;
}
OUTPUT:
RETVAL

long
suf_aidx2tidx(i,pos)
int i
long pos
CODE:
{
    SUFARY* ary = SUFARYs[i];

    RETVAL = sa_aryidx2txtidx(ary, pos);
}
OUTPUT:
RETVAL

int
suf_line_top_id(id,pos)
int id
long pos
CODE:
{
  long i,j;
  SUFARY* ary = SUFARYs[id];
  
  i = pos;
  if((*(ary->txtmap+pos) == '\n')) {i--; if(i < 0) i = 0;}

  while(1){
    if((*(ary->txtmap+i) == '\n')) {i++;break;}
    if(i == 0) break;
    i--;
  }
  RETVAL = i;
}
OUTPUT:
RETVAL

void
suf_common_prefix_search(i,key,sep)
int i
char * key
char sep
PPCODE:
{
    static long *ret = NULL;
    long top, buttom;
    long j;
    
    SUFARY* ary = SUFARYs[i];
    
    free(ret);
    ret = sa_common_prefix_search(ary,key,sep);
    
    if (*ret != 0) {
	EXTEND(sp, *ret);
	for (j = 1; j <= *ret; j++) {
	    PUSHs(sv_2mortal(newSVnv(ret[j])));
	}
    } else {
    }
}
