/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */
#ifndef _SC_ITEM_FINDER_H
#define _SC_ITEM_FINDER_H

// sc
#include "Item.h"

namespace wcview
{

class ItemFinder
{
public:
  ItemFinder (const Item* root);

  Item* find (const sc::String& name);

private:
  bool isDirectChild (const sc::String& name);
  Item* getDirectChild (const sc::String& name);
  Item* getNestedChild (const sc::String& name);
  sc::String getDirectChildDirName (const sc::String& name);

private:
  const Item* _root;
};

} // namespace

#endif //  _SC_ITEM_FINDER_H
